package com.chenyang.nse;

import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.data.mongo.MongoDataAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;


@SpringBootApplication(
        exclude = {MongoAutoConfiguration.class, MongoDataAutoConfiguration.class}
)
@EnableTransactionManagement(
        proxyTargetClass = true
)
@EnableAsync
@EnableScheduling
@ComponentScan(basePackages = {"com.chenyang.nse.bussiness"})
public class NseApplication {

    public static void main(String[] args) {
        SpringApplication.run(NseApplication.class, args);
    }

    // 启动后执行，打印所有 Bean 名称
//    @Bean
//    public CommandLineRunner commandLineRunner(ApplicationContext ctx) {
//        return args -> {
//            System.out.println("所有注册的 Spring Bean：");
//            String[] beanNames = ctx.getBeanDefinitionNames();
//            for (String beanName : beanNames) {
//                System.out.println(beanName);
//            }
//        };
//    }
}
