package com.chenyang.nse.bussiness.bean;

import com.ghca.fastjson.JSONArray;
import com.ghca.fastjson.JSONObject;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.service.core.impl.DataSystemServiceImpl;
import com.chenyang.nse.bussiness.tools.es.ElasticSearchUtil;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import com.chenyang.nse.bussiness.tools.utils.GHCAUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.frameworkset.elasticsearch.client.ClientInterface;

public class CacheElasticSearchThread implements Runnable {
   private final DataSystemServiceImpl dataSystemService;
   private final TCoreDatasystem coreDataSystem;
   private final CountDownLatch countDownLatch;

   public CacheElasticSearchThread(DataSystemServiceImpl dataSystemService, TCoreDatasystem coreDataSystem, CountDownLatch countDownLatch) {
      this.dataSystemService = dataSystemService;
      this.coreDataSystem = coreDataSystem;
      this.countDownLatch = countDownLatch;
   }

   public void run() {
      DataBase dataBase = new DataBase();
      dataBase.setDatasystemid(this.coreDataSystem.getId());
      dataBase.setDbType(this.coreDataSystem.getDbtype());
      dataBase.setIp_port(this.coreDataSystem.getDbip() + ":" + this.coreDataSystem.getDbport());
      boolean exist = false;

      for(DataBase base : DataCache.dataList) {
         if (base.getDatasystemid().equals(this.coreDataSystem.getId())) {
            exist = true;
            dataBase = base;
            break;
         }
      }

      if (!exist) {
         DataCache.dataList.add(dataBase);
      }

      ClientInterface clientInterface = GHCAUtils.getInstance().connectToES(this.coreDataSystem.getDbip(), this.coreDataSystem.getDbport(), this.coreDataSystem.getUsername(), AesTool.decrypt(this.coreDataSystem.getPassword(), "ghca"));

      try {
         String indices = ElasticSearchUtil.getIndices(clientInterface);
         JSONArray jsonArray = JSONObject.parseArray(indices);
         Iterator<Object> iterator = jsonArray.iterator();
         List<Schema> schemaList = new ArrayList();

         while(iterator.hasNext()) {
            JSONObject jsonObject = (JSONObject)iterator.next();
            String index = jsonObject.getString("index");
            Schema schema = new Schema(index);
            schemaList.add(schema);
            String mapping = ElasticSearchUtil.getMapping(clientInterface, index);
            JSONObject jsonObjectMapping = JSONObject.parseObject(mapping);
            JSONObject jsonObjectType = jsonObjectMapping.getJSONObject(index).getJSONObject("mappings");
            Set<String> keySet = jsonObjectType.keySet();
            List<Table> tableList = new ArrayList();
            schema.setTableList(tableList);

            for(String tableName : keySet) {
               Table table = new Table(tableName, index);
               tableList.add(table);
               Set<String> fields = ElasticSearchUtil.getFields(clientInterface, index, tableName);
               List<Column> columnList = new ArrayList();
               table.setColumnList(columnList);
               Column column = new Column("_id", index, tableName);
               column.setPrimarykey("1");
               columnList.add(column);

               for(String field : fields) {
                  Column columnTemp = new Column(field, index, tableName);
                  columnList.add(columnTemp);
               }
            }
         }

         dataBase.setSchemaList(schemaList);
         dataBase.easyCache = new DBEasyCache(dataBase);
         dataBase.easyCache.init();
      } finally {
         clientInterface.getClient().close();
      }

   }
}
