package com.chenyang.nse.bussiness.ccore;

public class CcoreSDF {
   public static final long SGD_SM1_ECB = 257L;
   public static final long SGD_SM1_CBC = 258L;
   public static final long SGD_SM1_CFB = 260L;
   public static final long SGD_SM1_OFB = 264L;
   public static final long SGD_SM1_MAC = 272L;
   public static final long SGD_SSF33_ECB = 513L;
   public static final long SGD_SSF33_CBC = 514L;
   public static final long SGD_SSF33_CFB = 516L;
   public static final long SGD_SSF33_OFB = 520L;
   public static final long SGD_SSF33_MAC = 528L;
   public static final long SGD_SMS4_ECB = 1025L;
   public static final long SGD_SMS4_CBC = 1026L;
   public static final long SGD_SMS4_CFB = 1028L;
   public static final long SGD_SMS4_OFB = 1032L;
   public static final long SGD_SMS4_MAC = 1040L;
   public static final long SGD_SM6_ECB = 1537L;
   public static final long SGD_SM6_CBC = 1538L;
   public static final long SGD_SM6_CFB = 1540L;
   public static final long SGD_SM6_OFB = 1544L;
   public static final long SGD_SM6_MAC = 1552L;
   public static final long SGD_RSA = 65536L;
   public static final long SGD_SM2_1 = 131328L;
   public static final long SGD_SM2_2 = 131584L;
   public static final long SGD_SM2_3 = 133120L;
   public static final long SGD_SM3 = 1L;
   public static final long SGD_SHA1 = 2L;
   public static final long SGD_SHA256 = 4L;

   public static native long OpenDevice(long[] phDeviceHandle);

   public static native long CloseDevice(long hDeviceHandle);

   public static native long OpenSession(long hDeviceHandle, long[] phSessionHandle);

   public static native long CloseSession(long hSessionHandle);

   public static native long GetDeviceInfo(long hSessionHandle, DeviceInfo ObjDevInfo);

   public static native long GenerateRandom(long hSessionHandle, long uiLength, byte[] pucRandom);

   public static native long GetPrivateKeyAccessRight(long hSessionHandle, long uiKeyIndex, String pucPassword, long uiPwdLength);

   public static native long ReleasePrivateKeyAccessRight(long hSessionHandle, long uiKeyIndex);

   public static native long ExportSignPublicKey_RSA(long hSessionHandle, long uiKeyIndex, RSArefPublicKey pucPublicKey);

   public static native long ExportEncPublicKey_RSA(long hSessionHandle, long uiKeyIndex, RSArefPublicKey pucPublicKey);

   public static native long GenerateKeyPair_RSA(long hSessionHandle, long uiKeyBits, RSArefPublicKey pucPublicKey, RSArefPrivateKey pucPrivateKey);

   public static native long GenerateKeyWithIPK_RSA(long hSessionHandle, long uiIPKIndex, long uiKeyBits, byte[] pucKey, long[] puiKeyLength, long[] phKeyHandle);

   public static native long GenerateKeyWithEPK_RSA(long hSessionHandle, long uiKeyBits, RSArefPublicKey pucPublicKey, byte[] pucKey, long[] puiKeyLength, long[] phKeyHandle);

   public static native long ImportKeyWithISK_RSA(long hSessionHandle, long uiISKIndex, byte[] pucKey, long puiKeyLength, long[] phKeyHandle);

   public static native long ExchangeDigitEnvelopeBaseOnRSA(long hSessionHandle, long uiKeyIndex, RSArefPublicKey pucPublicKey, byte[] pucDEInput, long uiDELength, byte[] pucDEOutput, long[] puiDELength);

   public static native long ExportSignPublicKey_ECC(long hSessionHandle, long uiKeyIndex, ECCrefPublicKey pucPublicKey);

   public static native long ExportEncPublicKey_ECC(long hSessionHandle, long uiKeyIndex, ECCrefPublicKey pucPublicKey);

   public static native long GenerateKeyPair_ECC(long hSessionHandle, long uiAlgID, long uiKeyBits, ECCrefPublicKey pucPublicKey, ECCrefPrivateKey pucPrivateKey);

   public static native long GenerateKeyWithIPK_ECC(long hSessionHandle, long uiIPKIndex, long uiKeyBits, ECCCipher pucKey, long[] phKeyHandle);

   public static native long GenerateKeyWithEPK_ECC(long hSessionHandle, long uiKeyBits, long uiAlgID, ECCrefPublicKey pucPublicKey, ECCCipher pucKey, long[] phKeyHandle);

   public static native long ImportKeyWithISK_ECC(long hSessionHandle, long uiISKIndex, ECCCipher pucKey, long[] phKeyHandle);

   public static native long GenerateAgreementDataWithECC(long hSessionHandle, long uiISKIndex, long uiKeyBits, byte[] pucSponsorID, long uiSponsorIDLength, ECCrefPublicKey pucSponsorPublicKey, ECCrefPublicKey pucSponsorTmpPublicKey, long[] phAgreementHandle);

   public static native long GenerateKeyWithECC(long hSessionHandle, byte[] pucResponseID, long uiResponseIDLength, ECCrefPublicKey pucResponsePublicKey, ECCrefPublicKey pucResponseTmpPublicKey, long hAgreementHandle, long[] phKeyHandle);

   public static native long GenerateAgreementDataAndKeyWithECC(long hSessionHandle, long uiISKIndex, long uiKeyBits, byte[] pucResponseID, long uiResponseIDLength, byte[] pucSponsorID, long uiSponsorIDLength, ECCrefPublicKey pucSponsorPublicKey, ECCrefPublicKey pucSponsorTmpPublicKey, ECCrefPublicKey pucResponsePublicKey, ECCrefPublicKey pucResponseTmpPublicKey, long[] phKeyHandle);

   public static native long ExchangeDigitEnvelopeBaseOnECC(long hSessionHandle, long uiKeyIndex, long uiAlgID, ECCrefPublicKey pucPublicKey, ECCCipher pucEncDataIn, ECCCipher pucEncDataOut);

   public static native long GenerateKeyWithKEK(long hSessionHandle, long uiKeyBits, long uiAlgID, long uiKEKIndex, byte[] pucKey, long[] puiKeyLength, long[] phKeyHandle);

   public static native long ImportKeyWithKEK(long hSessionHandle, long uiAlgID, long uiKEKIndex, byte[] pucKey, long puiKeyLength, long[] phKeyHandle);

   public static native long ImportKey(long hSessionHandle, byte[] pucKey, long uiKeyLength, long[] phKeyHandle);

   public static native long DestroyKey(long hSessionHandle, long hKeyHandle);

   public static native long ExternalPublicKeyOperation_RSA(long hSessionHandle, RSArefPublicKey pucPublicKey, byte[] pucDataInput, long uiInputLength, byte[] pucDataOutput, long[] puiOutputLength);

   public static native long ExternalPrivateKeyOperation_RSA(long hSessionHandle, RSArefPrivateKey pucPrivateKey, byte[] pucDataInput, long uiInputLength, byte[] pucDataOutput, long[] puiOutputLength);

   public static native long InternalPublicKeyOperation_RSA(long hSessionHandle, long uiKeyIndex, byte[] pucDataInput, long uiInputLength, byte[] pucDataOutput, long[] puiOutputLength);

   public static native long InternalPrivateKeyOperation_RSA(long hSessionHandle, long uiKeyIndex, byte[] pucDataInput, long uiInputLength, byte[] pucDataOutput, long[] puiOutputLength);

   public static native long ExternalSign_ECC(long hSessionHandle, long uiAlgID, ECCrefPrivateKey pucPrivateKey, byte[] pucData, long uiDataLength, ECCSignature pucSignature);

   public static native long ExternalVerify_ECC(long hSessionHandle, long uiAlgID, ECCrefPublicKey pucPublicKey, byte[] pucDataInput, long uiInputLength, ECCSignature pucSignature);

   public static native long InternalSign_ECC(long hSessionHandle, long uiISKIndex, byte[] pucData, long uiDataLength, ECCSignature pucSignature);

   public static native long InternalVerify_ECC(long hSessionHandle, long uiISKIndex, byte[] pucData, long uiDataLength, ECCSignature pucSignature);

   public static native long ExternalEncrypt_ECC(long hSessionHandle, long uiAlgID, ECCrefPublicKey pucPublicKey, byte[] pucData, long uiDataLength, ECCCipher pucEncData);

   public static native long ExternalDecrypt_ECC(long hSessionHandle, long uiAlgID, ECCrefPrivateKey pucPrivateKey, ECCCipher pucEncData, byte[] pucData, long[] puiDataLength);

   public static native long Encrypt(long hSessionHandle, long hKeyHandle, long uiAlgID, byte[] pucIV, byte[] pucData, long uiDataLength, byte[] pucEncData, long[] puiEncDataLength);

   public static native long Decrypt(long hSessionHandle, long hKeyHandle, long uiAlgID, byte[] pucIV, byte[] pucEncData, long uiEncDataLength, byte[] pucData, long[] puiDataLength);

   public static native long CalculateMAC(long hSessionHandle, long hKeyHandle, long uiAlgID, byte[] pucIV, byte[] pucData, long uiDataLength, byte[] pucMAC, long[] puiMACLength);

   public static native long HashInit(long hSessionHandle, long uiAlgID, ECCrefPublicKey pucPublicKey, byte[] pucID, long uiIDLength);

   public static native long HashUpdate(long hSessionHandle, byte[] pucData, long uiDataLength);

   public static native long HashFinal(long hSessionHandle, byte[] pucHash, long[] puiHashLength);

   public static native long CreateFile(long hSessionHandle, String pucFileName, long uiNameLen, long uiFileSize);

   public static native long ReadFile(long hSessionHandle, String pucFileName, long uiNameLen, long uiOffset, long[] puiFileLength, byte[] pucBuffer);

   public static native long WriteFile(long hSessionHandle, String pucFileName, long uiNameLen, long uiOffset, long uiFileLength, byte[] pucBuffer);

   public static native long DeleteFile(long hSessionHandle, String pucFileName, long uiNameLen);

   static {
      System.loadLibrary("com_ccore_CcoreSDF");
   }

   public static class DeviceInfo {
      public String IssuerName;
      public String DeviceName;
      public String DeviceSerial;
      public long DeviceVersion;
      public long StandardVersion;
      public long[] AsymAlgAbility = new long[2];
      public long SymAlgAbility;
      public long HashAlgAbility;
      public long BufferSize;
   }

   public static class RSArefPublicKey {
      public long bits;
      public byte[] m = new byte[256];
      public byte[] e = new byte[256];
   }

   public static class RSArefPrivateKey {
      public long bits;
      public byte[] m = new byte[256];
      public byte[] e = new byte[256];
      public byte[] d = new byte[256];
      public byte[][] prime = new byte[2][128];
      public byte[][] pexp = new byte[2][128];
      public byte[] coef = new byte[128];
   }

   public static class ECCrefPublicKey {
      public long bits;
      public byte[] x = new byte[64];
      public byte[] y = new byte[64];
   }

   public static class ECCrefPrivateKey {
      public long bits;
      public byte[] K = new byte[64];
   }

   public static class ECCCipher {
      public long bits;
      public byte[] x = new byte[64];
      public byte[] y = new byte[64];
      public byte[] M = new byte[32];
      public long L;
      public byte[] C;
   }

   public static class ECCSignature {
      public long bits;
      public byte[] r = new byte[64];
      public byte[] s = new byte[64];
   }
}
