package com.chenyang.nse.bussiness.controller.console;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationDataTargetfield;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationDatamapping;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataMappingFlag;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataMappingType;
import com.chenyang.nse.bussiness.service.console.DesensitizationDataMappingService;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/console/desensitizationdatamapping"})
public class DesensitizationDataMappingController {
   @Autowired
   private DesensitizationDataMappingService desensitizationdataMappingService;

   @RequestMapping({"", "/"})
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "/core/desensitizationdatamapping";
   }

   @RequestMapping({"/getdatatype"})
   @ResponseBody
   public List<ComboboxVO> getdatatype() {
      List<ComboboxVO> list = new ArrayList();

      for(EdataMappingType em : EdataMappingType.values()) {
         ComboboxVO vo = new ComboboxVO(em.getFlag(), em.getName());
         list.add(vo);
      }

      return list;
   }

   @RequestMapping({"/getpwcdatatype"})
   @ResponseBody
   public List<ComboboxVO> getpwcdatatype() {
      List<ComboboxVO> list = new ArrayList();
      ComboboxVO vo = new ComboboxVO("10", "powercenter");
      list.add(vo);
      return list;
   }

   @RequestMapping({"/getdataflag"})
   @ResponseBody
   public List<ComboboxVO> getdataflag() {
      List<ComboboxVO> list = new ArrayList();

      for(EdataMappingFlag em : EdataMappingFlag.values()) {
         ComboboxVO vo = new ComboboxVO(em.getFlag(), em.getName());
         list.add(vo);
      }

      return list;
   }

   @RequestMapping({"/getdatamappinginfo"})
   @ResponseBody
   public DataGridVO<Map<String, String>> getdatamappinginfo(PageInfo pageinfo, Integer page, Integer rows, String sourcesystemtype, String targetsystemtype) {
      pageinfo.setPageno(page);
      pageinfo.setPagesize(rows);
      BigInteger count = this.desensitizationdataMappingService.getDatamappingCount(sourcesystemtype, targetsystemtype);
      pageinfo.setCount(count.longValue());
      return new DataGridVO<Map<String, String>>(pageinfo.getCount(), this.desensitizationdataMappingService.getDatamappingInfo1(pageinfo, sourcesystemtype, targetsystemtype));
   }

   @RequestMapping({"/getdatamappinginfo1"})
   @ResponseBody
   public DataGridVO<DesensitizationDatamapping> getdatamappinginfo(PageInfo pageinfo, String filterRules, Integer page, Integer rows, HttpServletRequest request, HttpServletResponse response, Model model, String sourcesystemtype, String targetsystemtype) {
      pageinfo.setPageno(page);
      pageinfo.setPagesize(rows);
      return this.desensitizationdataMappingService.selectDatamappingInfo(pageinfo, sourcesystemtype, targetsystemtype);
   }

   @RequestMapping({"/gettargetfield"})
   @ResponseBody
   public List<ComboboxVO> gettargetfield(String datasystemtype) {
      List<DesensitizationDataTargetfield> list = this.desensitizationdataMappingService.getTargetFieldByType(datasystemtype);
      List<ComboboxVO> volist = new ArrayList();

      for(DesensitizationDataTargetfield item : list) {
         ComboboxVO vo = new ComboboxVO(item.getId(), item.getFieldname());
         volist.add(vo);
      }

      return volist;
   }

   @RequestMapping({"/deletedatainfo"})
   @ResponseBody
   public void deletedatainfo(String mappingid, String sourceid) {
      this.desensitizationdataMappingService.deletedatainfo(mappingid, sourceid);
   }

   @RequestMapping({"/modifydatainfo"})
   @ResponseBody
   public void modifydatainfo(@RequestParam Map<String, String> map) {
      this.desensitizationdataMappingService.modifyDataInfo(map);
   }

   @RequestMapping({"/insertdatainfo"})
   @ResponseBody
   public void insertdatainfo(@RequestParam Map<String, String> map) {
      this.desensitizationdataMappingService.insertDataInfo(map);
   }

   @RequestMapping({"/removedatainfo"})
   @ResponseBody
   public void removedatainfo(String sourcefieldid) {
      this.desensitizationdataMappingService.removedatainfo(sourcefieldid);
   }
}
