package com.chenyang.nse.bussiness.controller.console;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleFastManage;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataMappingType;
import com.chenyang.nse.bussiness.service.console.FastManageService;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/console/fastmanage"})
public class FastManageController {
   @Autowired
   private FastManageService fastManageService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "console/fastmanage";
   }

   @RequestMapping({"/query"})
   @ResponseBody
   public DataGridVO<TConsoleFastManage> query(Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TConsoleFastManage> list = this.fastManageService.query(pageInfo);
      DataGridVO<TConsoleFastManage> vo = new DataGridVO<TConsoleFastManage>(pageInfo.getCount(), list);
      return vo;
   }

   @RequestMapping({"/add"})
   @ResponseBody
   public void add(HttpServletRequest request, HttpServletResponse response, String datatype, Integer isfastimport, Integer isfastexport) {
      TConsoleFastManage tConsoleFastManage = new TConsoleFastManage();
      tConsoleFastManage.setDatabasetype(datatype);
      tConsoleFastManage.setFastexport(isfastexport);
      tConsoleFastManage.setFastimport(isfastimport);
      this.fastManageService.save(tConsoleFastManage);
   }

   @RequestMapping({"/modify"})
   @ResponseBody
   public void modify(HttpServletRequest request, HttpServletResponse response, String id, String datatype, Integer isfastimport, Integer isfastexport) {
      TConsoleFastManage tConsoleFastManage = new TConsoleFastManage();
      tConsoleFastManage.setId(id);
      tConsoleFastManage.setDatabasetype(datatype);
      tConsoleFastManage.setFastexport(isfastexport);
      tConsoleFastManage.setFastimport(isfastimport);
      this.fastManageService.update(tConsoleFastManage);
   }

   @RequestMapping({"/remove"})
   @ResponseBody
   public void remove(HttpServletRequest request, HttpServletResponse response, String id) {
      this.fastManageService.remove(id);
   }

   @RequestMapping({"/getdatatype"})
   @ResponseBody
   public List<ComboboxVO> getdatatype() {
      List<ComboboxVO> list = new ArrayList();

      for(EdataMappingType em : EdataMappingType.values()) {
         ComboboxVO vo = new ComboboxVO(em.getName(), em.getName());
         list.add(vo);
      }

      return list;
   }
}
