package com.chenyang.nse.bussiness.controller.console;

import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseResource;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.MenuGridVO;
import com.chenyang.nse.bussiness.entity.vo.ResourcesVO;
import com.chenyang.nse.bussiness.service.console.ResourceService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/console/resources"})
public class ResourcesController {
   @Autowired
   private ResourceService resourceService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "console/resources";
   }

   @RequestMapping({"/query"})
   @ResponseBody
   public DataGridVO<ResourcesVO> query(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<ResourcesVO> list = this.resourceService.queryAll();
      DataGridVO<ResourcesVO> vo = new DataGridVO<ResourcesVO>();
      vo.setRows(list);
      return vo;
   }

   @RequestMapping({"/queryMenuGrid"})
   @ResponseBody
   public List<MenuGridVO> queryMenuGrid(String flag, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<MenuGridVO> list = null;
      if (flag != null && !"".equals(flag)) {
         list = this.resourceService.queryMenuGridByFlag(flag);
      } else {
         list = this.resourceService.queryMenuGrid();
      }

      return list;
   }

   @RequestMapping({"/queryMenuNames"})
   @ResponseBody
   public List<ComboboxVO> queryMenuNames(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<ComboboxVO> list = this.resourceService.queryMenuNames();
      if (list != null) {
         list.add(0, new ComboboxVO("全部"));
      }

      return list;
   }

   @RequestMapping({"/querySubMenuNames"})
   @ResponseBody
   public List<ComboboxVO> querySubMenu(String parentId, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<ComboboxVO> list;
      if (parentId != null) {
         list = this.resourceService.querySubMenuNamesByParentId(parentId);
      } else {
         list = this.resourceService.querySubMenuNames();
      }

      if (list != null) {
         list.add(0, new ComboboxVO("全部"));
      }

      return list;
   }

   @RequestMapping({"/add"})
   public void add(TBaseResource resources, String menuid, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.resourceService.addResource(resources, menuid);
   }

   @RequestMapping({"/remove"})
   public void remove(@RequestParam("idlist[]") List<String> idlist, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.resourceService.remove(idlist);
   }
}
