package com.chenyang.nse.bussiness.controller.console;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.setting.GroupedMap;
import cn.hutool.setting.Setting;
import cn.hutool.setting.SettingLoader;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleSystemSetting;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.service.console.SystemSettingService;
import com.chenyang.nse.bussiness.tools.datatime.DateTimeTool;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/console/systemSetting"})
public class SystemSettingController {
   @Autowired
   private SystemSettingService systemSettingService;

   @GetMapping({"/queryAll"})
   @ResponseBody
   public Response<GroupedMap> queryAll(HttpServletRequest request, HttpServletResponse response, Model model) {
      String fileName = "config.properties";
      Setting setting = new Setting(fileName, CharsetUtil.CHARSET_UTF_8, false);
      GroupedMap groupedMap = setting.getGroupedMap();
      return RespHelper.<GroupedMap>successResp(groupedMap);
   }

   @PostMapping({"/update"})
   @ResponseBody
   public Response<GroupedMap> updateParam(@RequestBody GroupedMap groupedMap, HttpServletRequest request, HttpServletResponse response, Model model) {
      String fileName = "config.properties";
      SettingLoader settingLoader = new SettingLoader(groupedMap, CharsetUtil.CHARSET_UTF_8, false);
      settingLoader.store(fileName);
      return RespHelper.<GroupedMap>successResp(groupedMap);
   }

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "console/systemSetting/systemSetting";
   }

   @RequestMapping({"/querySystemSetting"})
   @ResponseBody
   public DataGridVO<Map<String, Object>> querysystemSetting(Integer page, Integer rows) {
      PageInfo pageInfo = new PageInfo();
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<Map<String, Object>> list = this.systemSettingService.querySystemSetting(pageInfo);
      return new DataGridVO<Map<String, Object>>(pageInfo.getCount(), list);
   }

   @RequestMapping({"/updateSystemSetting"})
   @ResponseBody
   public String updateSwitchState(String id, String value) {
      TConsoleSystemSetting tss = this.systemSettingService.updateSwitchState(id, value);
      return DateTimeTool.formatDate(tss.getUpdatetime(), "");
   }
}
