package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseMenu;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseRole;
import com.chenyang.nse.bussiness.enumeration.EroleFlag;
import com.chenyang.nse.bussiness.service.core.CoreService;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core"})
public class CoreController {
   @Autowired
   private CoreService coreService;

   @RequestMapping({"/index"})
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
      Object obj = request.getSession().getAttribute("loginUser");
      if (null == obj) {
         response.setContentType("text/html");
         PrintWriter out = response.getWriter();
         String ser = request.getServletPath();
         String url = request.getRequestURL().toString();
         String s = url.split(ser)[0];
         String js = "<script type=\"text/javascript\">top.location.href='" + s + "';</script>";
         out.println(js);
      }

      return "core/core_index";
   }

   @RequestMapping({"/top"})
   public String top(HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
      return "include/core_top";
   }

   @RequestMapping({"/bottom"})
   public String bottom(HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
      return "include/core_bottom";
   }

   @RequestMapping({"/navigation"})
   public String navigation(HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      List<TBaseRole> roles = loginUser.getTrole();
      EroleFlag ef = EroleFlag.getEroleFlagByFlag(((TBaseRole)roles.get(0)).getFlag());
      loginUser.setFlag(ef.getFlag());
      loginUser.setPrefix(ef.getCode());
      if (ef == EroleFlag.USER) {
         List<TBaseMenu> menus = loginUser.getMenus();
         model.addAttribute("menus", menus);
      }

      return "include/core_navigation";
   }

   @RequestMapping({"/datasystemreport"})
   @ResponseBody
   public List<Map> datasystemreport(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<Map> list = this.coreService.datasystemreport();
      return list;
   }

   @RequestMapping({"/sensitivedatareport"})
   @ResponseBody
   public List<Map> sensitivedatareport(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<Map> list = this.coreService.sensitivedatareport();
      return list;
   }

   @RequestMapping({"/maskingefficiencyreport"})
   @ResponseBody
   public Map maskingefficiencyreport(HttpServletRequest request, HttpServletResponse response, Model model) {
      Map map = this.coreService.maskingefficiencyreport();
      return map;
   }

   @RequestMapping({"/maskingrulereport"})
   @ResponseBody
   public List<Map> maskingrulereport(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<Map> list = this.coreService.maskingrulereport();
      return list;
   }
}
