package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngine;
import com.chenyang.nse.bussiness.entity.orm.table.core.pwdFolder.TCorePwdFolder;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.service.core.CreatePwcFolderService;
import com.chenyang.nse.bussiness.service.info.InfoService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/createpwcfolder"})
public class CreatePwcFolderController {
   private static Logger logger = LoggerFactory.getLogger(CreatePwcFolderController.class);
   @Autowired
   private InfoService infoService;
   @Autowired
   private CreatePwcFolderService createPwcFolderService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      logger.info(">>>>>>>>>>>>>>>>>>>>创建powercenter文件列表页面 start>>>>>>>>>>>>>>>>>>>>>>>>>");
      List<TCoreEngine> engineList = this.createPwcFolderService.queryMaskingEngine();
      String engineid = "";
      if (engineList.size() > 0) {
         engineid = ((TCoreEngine)engineList.get(0)).getId();
      }

      model.addAttribute("engineid", engineid);
      return "core/pwcfolder/pwcfolder";
   }

   @RequestMapping({"/queryFolderLst"})
   @ResponseBody
   public DataGridVO<TCorePwdFolder> queryFolderLst(String engineid, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      if (engineid != null && !"".equals(engineid)) {
         pageInfo.setPageno(page);
         pageInfo.setPagesize(rows);
         Integer fromRow = (page - 1) * rows;
         Integer toRow = page * rows;
         List<String> list = this.infoService.queryFolderList(engineid);
         List<TCorePwdFolder> tpfList = new ArrayList();
         TCorePwdFolder tpf = null;

         for(int i = 0; i < list.size(); ++i) {
            if (i >= fromRow && i < toRow) {
               tpf = new TCorePwdFolder();
               tpf.setFoldername((String)list.get(i));
               tpfList.add(tpf);
            }
         }

         Collections.sort(tpfList);
         pageInfo.setCount((long)list.size());
         DataGridVO<TCorePwdFolder> vo = new DataGridVO<TCorePwdFolder>(pageInfo.getCount(), tpfList);
         return vo;
      } else {
         return null;
      }
   }

   @RequestMapping({"/createFolder"})
   public String createFolder(String engineid, HttpServletRequest request, HttpServletResponse response, Model model) {
      model.addAttribute("engineid", engineid);
      return "core/pwcfolder/createpwcfolder";
   }

   @RequestMapping({"/isFolderExist"})
   @ResponseBody
   public String isFolderExist(String engineid, String foldername, HttpServletRequest request, HttpServletResponse response, Model model) {
      String reFlg = "0";
      if (this.infoService.isFolderExist(engineid, foldername)) {
         reFlg = "1";
      }

      return reFlg;
   }

   @RequestMapping({"/saveFolder"})
   public void saveFolder(String engineid, String foldername, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.infoService.createFolderInEngine(engineid, foldername);
   }
}
