package com.chenyang.nse.bussiness.controller.core;

import com.alibaba.fastjson.JSON;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.engine.infa.InfoProperty;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngine;
import com.chenyang.nse.bussiness.entity.orm.table.core.batchmanage.BatchManage;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationselftask.DesensitizationSelfTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationDataTargetfield;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationFile;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationMonitor;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationTable;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.DesensitizationTablecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationsource;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationtarget;
import com.chenyang.nse.bussiness.entity.orm.table.core.desensitizationtask.Desensitizationtask;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TCoreFieldSensitiveMemory;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoverySensitivecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructure;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurecolumn;
import com.chenyang.nse.bussiness.entity.redis.TCoreMaskingTaskTableInfo;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DBTableVO;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.entity.vo.file.TCoreFileStructurecolumnVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.CompareInfoVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.enumeration.EmaskingTaskType;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataMappingType;
import com.chenyang.nse.bussiness.service.console.DesensitizationDataMappingService;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.console.SearchRegexService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.DesensitizationselftaskService;
import com.chenyang.nse.bussiness.service.core.FileSystemService;
import com.chenyang.nse.bussiness.service.core.ImportMaskingRuleService;
import com.chenyang.nse.bussiness.service.core.MaskingTaskService;
import com.chenyang.nse.bussiness.service.core.TCoreMonitorTmporaryService;
import com.chenyang.nse.bussiness.service.core.TdataProjectService;
import com.chenyang.nse.bussiness.service.info.InfoService;
import com.chenyang.nse.bussiness.service.info.db.DatabaseTool;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import com.chenyang.nse.bussiness.thread.ExecuteParam;
import com.chenyang.nse.bussiness.tools.datatime.DateTimeTool;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import transdbf.transdbf;

@EnableAsync
@Controller
@RequestMapping({"/core/desensitizationselftask"})
public class DesensitizationSelfTaskController {
   private static Logger logger = LoggerFactory.getLogger(DesensitizationSelfTaskController.class);
   private static final String Link_character = "_";
   public static final String DB_pwc_FILE_batchwrite_DB = "DBtoDB,normal,batchwrite";
   public static final String DB_batchread_FILE_pwc_DB = "DBtoDB,batchread,normal";
   public static final String DB_batchread_FILE_pwc_FILE_batchwrite_DB = "DBtoDB,batchread,batchwrite";
   public static final String DB_pwc_DB = "DBtoDB,normal,normal";
   public static final String DB_pwc_FILE = "DBtoFILE,normal";
   public static final String DB_batchread_FILE_pwc_FILE = "DBtoFILE,batchread";
   public static final String FILE_pwc_FILE_batchwrite_DB = "FILEtoDB,batchwrite";
   public static final String FILE_pwc_DB = "FILEtoDB,normal";
   public static final String FILE_pwc_FILE = "FILEtoFILE";
   public static final String HIVE_batchread_FILE_pwc_FILE_batchwrite_HIVE = "HIVEtoHIVE,batchread,batchwrite";
   @Autowired
   private ImportMaskingRuleService importMaskingRuleService;
   @Autowired
   private DesensitizationselftaskService desensitizationSelfTaskService;
   @Autowired
   private InfoService infoService;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private SearchRegexService searchRegexService;
   @Autowired
   private MaskingTaskService maskingTaskService;
   @Autowired
   private DesensitizationDataMappingService desensitizationdataMappingService;
   @Autowired
   private OperationService operationService;
   @Autowired
   private ThreadPoolTaskExecutor taskExecutor;
   @Autowired
   private FileSystemService fileSystemService;
   @Autowired
   private HttpServletRequest request;
   @Autowired
   private RedisService redisService;
   @Autowired
   private TCoreMonitorTmporaryService tCoreMonitorTmporaryService;
   @Autowired
   private TdataProjectService tdataProjectService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) {
      String crud = request.getParameter("crud");
      if (pageCurr != null) {
         model.addAttribute("toPageCurr", pageCurr);
      } else {
         model.addAttribute("toPageCurr", 1);
      }

      String projectid = (String)request.getSession().getAttribute("projectid");
      model.addAttribute("projectid", projectid);
      model.addAttribute("crud", crud);
      return "core/desensitizationselftask/desensitizationselftasklist";
   }

   @ResponseBody
   @RequestMapping({"/querymaskingengine"})
   public List<TCoreEngine> querymaskingengine(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreEngine> list = this.importMaskingRuleService.queryMaskingEngine();
      return list;
   }

   @RequestMapping({"/querytask"})
   @ResponseBody
   public DataGridVO<DesensitizationSelfTask> querytask(String isstart, String engineid, String taskname, String projectid, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<DesensitizationSelfTask> list = this.desensitizationSelfTaskService.queryTask(projectid, taskname, pageInfo);
      if (isstart != null) {
         for(DesensitizationSelfTask desensitizationSelfTask : list) {
            String tasknamereal = desensitizationSelfTask.getTasknamereal();
            if (!"0".equals(desensitizationSelfTask.getSave_state())) {
               if ("1".equals(desensitizationSelfTask.getSave_state())) {
                  desensitizationSelfTask.setCount_exe("");
               } else {
                  desensitizationSelfTask.setCount_exe("100%");
                  String removePercent = (String)this.redisService.get("removePercent_" + tasknamereal);
                  if (removePercent != null) {
                     desensitizationSelfTask.setRemovePercent(removePercent);
                  }
               }

               this.redisService.remove(tasknamereal + "_zcount");
               this.redisService.remove(tasknamereal + "_ncount");
            } else {
               String time_exe = (String)this.redisService.get(tasknamereal + "_ntime");
               String count_exe = (String)this.redisService.get(tasknamereal + "_zcount");
               String ncount_exe = (String)this.redisService.get(tasknamereal + "_ncount");
               long ncount_exe_num = 0L;
               long count_exe_num = 1L;

               try {
                  if (ncount_exe == null) {
                     ncount_exe = "0";
                  }

                  if (count_exe == null) {
                     count_exe = "1";
                  }

                  ncount_exe_num = new Long(ncount_exe);
                  count_exe_num = new Long(count_exe);
               } catch (Exception var24) {
               }

               NumberFormat numberFormat = NumberFormat.getInstance();
               numberFormat.setMaximumFractionDigits(2);
               String result = numberFormat.format((double)ncount_exe_num / (double)count_exe_num * (double)100.0F);
               desensitizationSelfTask.setCount_exe(result + "%");
            }

            if ("0".equals(desensitizationSelfTask.getSave_state())) {
               desensitizationSelfTask.setExecuteStatus("0");
            } else {
               desensitizationSelfTask.setExecuteStatus("1");
            }
         }
      }

      DataGridVO<DesensitizationSelfTask> vo = new DataGridVO<DesensitizationSelfTask>(pageInfo.getCount(), list);
      return vo;
   }

   @RequestMapping({"/getbatchmanage"})
   @ResponseBody
   public Map<String, String> getbatchmanage(String taskid, String tasknamereal, @RequestParam Map<String, String> map, HttpServletResponse response, Model model) {
      Map<String, String> parammap = new HashMap();
      String batchmanage = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
      String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
      String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
      parammap.put("batchmanage", batchmanage);
      parammap.put("tableprefix", tableprefix);
      parammap.put("tablesuffix", tablesuffix);
      return parammap;
   }

   @RequestMapping({"/createtask"})
   public String createtask(String taskid, String step, @RequestParam Map<String, String> map, HttpServletResponse response, Model model) {
      map.put("tasknamereal", (String)this.request.getSession().getAttribute("tasknamereal"));
      if (step == null) {
         step = (String)this.request.getSession().getAttribute((String)map.get("pageparamkey"));
      }

      if (map.get("pageparamkey") != null) {
         this.request.getSession().setAttribute((String)map.get("pageparamkey"), map.get("pageparamvalue"));
      }

      switch (step) {
         case "desensitizationselftask_one":
            this.desensitizationselftask_one(map, model);
            break;
         case "desensitizationselftask_two":
            this.desensitizationselftask_two(map, model);
            break;
         case "desensitizationselftask_three":
            this.desensitizationselftask_three(map, model);
            break;
         case "desensitizationselftask_four":
            this.request.getSession().setAttribute("page_four", map.get("pageparam"));
            model.addAttribute("inserttype", map.get("inserttype"));
      }

      return "core/desensitizationselftask/" + step;
   }

   @RequestMapping({"/exportway"})
   @ResponseBody
   public String exportway(String database, HttpServletRequest request, HttpServletResponse response, Model model) throws InstantiationException, IllegalAccessException {
      String radio = "";
      TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(database);

      try {
         Class c = Class.forName("com.chenyang.nse.bussiness.service.info.db." + tCoreDatasystem.getDbtype());
         DatabaseTool base = (DatabaseTool)c.newInstance();
         radio = base.ExportMethod();
      } catch (ClassNotFoundException e) {
         e.printStackTrace();
      }

      return radio;
   }

   @RequestMapping({"/importway"})
   @ResponseBody
   public String importway(String database, HttpServletRequest request, HttpServletResponse response, Model model) throws InstantiationException, IllegalAccessException {
      String radio = "";
      TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(database);

      try {
         Class c = Class.forName("com.chenyang.nse.bussiness.service.info.db." + tCoreDatasystem.getDbtype());
         DatabaseTool base = (DatabaseTool)c.newInstance();
         radio = base.ImportMethod();
      } catch (ClassNotFoundException e) {
         e.printStackTrace();
      }

      return radio;
   }

   @RequestMapping({"/targetparam"})
   @ResponseBody
   public Map<String, String> targetparam(String database, String execution_type, HttpServletRequest request, HttpServletResponse response, Model model) throws InstantiationException, IllegalAccessException {
      Map<String, String> targetparam = new HashMap();
      TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(database);

      try {
         Class c = Class.forName("com.chenyang.nse.bussiness.service.info.db." + tCoreDatasystem.getDbtype());
         DatabaseTool base = (DatabaseTool)c.newInstance();
         if ("normal".equals(execution_type)) {
            targetparam = base.TargetParameter_normal();
         } else {
            targetparam = base.TargetParameter_notNormal();
         }
      } catch (ClassNotFoundException e) {
         e.printStackTrace();
      }

      return targetparam;
   }

   public void desensitizationselftask_one(Map<String, String> map, Model model) {
      String newtask = (String)map.get("newtask");
      String tasknamereal = (String)map.get("tasknamereal");
      String masking_engine_type = "";

      try {
         masking_engine_type = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("masking_engine_type");
      } catch (IOException e) {
         e.printStackTrace();
      }

      model.addAttribute("maskingenginetype", masking_engine_type);
      if (newtask != null) {
         model.addAttribute("state", "checked");
      } else {
         DesensitizationSelfTask desensitizationSelfTask = new DesensitizationSelfTask();
         desensitizationSelfTask = (DesensitizationSelfTask)this.redisService.get(tasknamereal + "_" + desensitizationSelfTask.getClass().getSimpleName());
         if (desensitizationSelfTask != null) {
            model.addAttribute("taskname", desensitizationSelfTask.getTaskname());
            model.addAttribute("folder", desensitizationSelfTask.getFoldername());
            model.addAttribute("tasknote", desensitizationSelfTask.getRemark());
         }
      }

   }

   public void desensitizationselftask_two(Map<String, String> map, Model model) {
      DesensitizationSelfTask desensitizationSelfTask = new DesensitizationSelfTask();
      if (((String)map.get("way")).equals("prev")) {
         String tasknamereal = (String)map.get("tasknamereal");
         Desensitizationsource desensitizationsource = new Desensitizationsource();
         desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
         if (desensitizationsource != null) {
            model.addAttribute("dataschema", desensitizationsource.getDataschema());
            model.addAttribute("datasourceid", desensitizationsource.getDatasourceid());
            model.addAttribute("execution_type", desensitizationsource.getExecution_type());
         }

         Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
         desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
         if (desensitizationtarget != null) {
            model.addAttribute("dataschema", desensitizationtarget.getDataschema());
            model.addAttribute("datasourceid", desensitizationtarget.getDatasourceid());
            model.addAttribute("execution_type", desensitizationtarget.getExecution_type());
            model.addAttribute("inserttype", desensitizationtarget.getInserttype());
            model.addAttribute("isclear", desensitizationtarget.getIsclear());
            model.addAttribute("isindex", desensitizationtarget.getIsindex());
            model.addAttribute("isprimary", desensitizationtarget.getIsprimary());
            model.addAttribute("isrebuild", desensitizationtarget.getIsrebuild());
            model.addAttribute("loadscripttype", desensitizationtarget.getLoadscripttype());
         }

         desensitizationSelfTask.setTasknamereal(tasknamereal);
      } else if (((String)map.get("way")).equals("next")) {
         desensitizationSelfTask.setFoldername((String)map.get("folder"));
         desensitizationSelfTask.setTaskname((String)map.get("taskname"));
         desensitizationSelfTask.setUserid((String)map.get("userid"));
         desensitizationSelfTask.setUsername((String)map.get("username"));
         String stamp = DateTimeTool.formatDate(new Date(), "yyMMddHHmmss");
         desensitizationSelfTask.setRemark((String)map.get("tasknote"));
         desensitizationSelfTask.setTasknamereal(stamp + "_" + StringTool.hanziToPinyinFirst((String)map.get("taskname")));
         this.redisService.set(desensitizationSelfTask.getTasknamereal() + "_" + desensitizationSelfTask.getClass().getSimpleName(), desensitizationSelfTask);
         this.request.getSession().setAttribute("isrecoverState", map.get("isrecover") == null ? "0" : map.get("isrecover"));
         this.request.getSession().setAttribute("tasknamereal", desensitizationSelfTask.getTasknamereal());
         String masking_engine_type = "";

         try {
            masking_engine_type = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("masking_engine_type");
         } catch (IOException e) {
            e.printStackTrace();
         }

         model.addAttribute("maskingenginetype", masking_engine_type);
      } else if ("1".equals(map.get("hadoop"))) {
         model.addAttribute("hadoop", map.get("hadoop"));
         this.request.getSession().setAttribute("hadoop_s", "1");
      } else {
         model.addAttribute("hadoop", "0");
         this.request.getSession().setAttribute("hadoop_s", "0");
      }

   }

   public void desensitizationselftask_three(Map<String, String> map, Model model) {
      String tasknamereal = (String)map.get("tasknamereal");
      if (((String)map.get("way")).equals("prev")) {
         model.addAttribute("way", "prev");
         new Desensitizationsource();
         Desensitizationsource desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + "Desensitizationsource");
         if (desensitizationsource != null) {
            model.addAttribute("group", desensitizationsource.getDataschema());
         }

         new Desensitizationtarget();
         Desensitizationtarget filterMap = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + "Desensitizationtarget");
         if (filterMap != null) {
            model.addAttribute("group", filterMap.getDataschema());
         }

         if (desensitizationsource.getDatasourceid() != null && !desensitizationsource.getDatasourceid().equals("")) {
            TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
            TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(filterMap.getDatasourceid());
            if (null != tCoreDatasystemSource && null != tCoreDatasystemTarget) {
               if (!tCoreDatasystemSource.getDbtype().equals(tCoreDatasystemTarget.getDbtype()) && tCoreDatasystemSource.getFlag().equals("1")) {
                  model.addAttribute("mappingEditFlag", "dbsystem_diff");
               } else {
                  model.addAttribute("mappingEditFlag", "dbsystem");
               }
            } else {
               model.addAttribute("mappingEditFlag", "dbsystem");
            }
         } else {
            model.addAttribute("mappingEditFlag", "dbsystem");
         }

         String batchmanage = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
         String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
         String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
         if (batchmanage != null) {
            this.redisService.set(tasknamereal + "_" + BatchManage.class.getSimpleName(), "");
            model.addAttribute("batchmanage", batchmanage);
         }

         if (tableprefix != null) {
            this.redisService.set(tasknamereal + "_" + "tableprefix", "");
            model.addAttribute("tableprefix", tableprefix);
         }

         if (tablesuffix != null) {
            this.redisService.set(tasknamereal + "_" + "tablesuffix", "");
            model.addAttribute("tablesuffix", tablesuffix);
         }

         model.addAttribute("inserttype", map.get("inserttype"));
         model.addAttribute("isshow", "1");
      } else if (((String)map.get("way")).equals("next")) {
         Desensitizationsource desensitizationsource = new Desensitizationsource();
         desensitizationsource.setDataschema((String)map.get("dataschema"));
         desensitizationsource.setDatasourceid((String)map.get("datasourceid"));
         desensitizationsource.setExecution_type("normal");
         this.redisService.set(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName(), desensitizationsource);
         Map<String, String> filterMap = new HashMap();
         this.request.getSession().setAttribute(tasknamereal + "_" + "filterConditions", filterMap);
         new Desensitizationsource();
         desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + "Desensitizationsource");
         List<Map<String, String>> tableList = new ArrayList();
         if (desensitizationsource.getDatasourceid() != null && !this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid()).getFlag().equals("2")) {
            for(DBTableVO dbTableVO : this.dataSystemService.queryTablename(desensitizationsource.getDatasourceid(), desensitizationsource.getDataschema(), "")) {
               Map<String, String> tableMap = new HashMap();
               tableMap.put("tableName", dbTableVO.getTablename());
               tableMap.put("status", "0");
               tableList.add(tableMap);
            }
         } else {
            for(TCoreFileStructure dbTableVO : this.fileSystemService.queryStructureByGroup(desensitizationsource.getDataschema(), "")) {
               Map<String, String> tableMap = new HashMap();
               tableMap.put("tableName", dbTableVO.getFilestructurename());
               tableMap.put("structureid", dbTableVO.getId());
               tableMap.put("filedir", "");
               tableMap.put("filename", "");
               tableMap.put("extension", "");
               tableMap.put("status", "0");
               tableList.add(tableMap);
            }
         }

         this.request.getSession().setAttribute("tableList_" + tasknamereal, tableList);
         Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
         desensitizationtarget.setDataschema((String)map.get("dataschema"));
         desensitizationtarget.setDatasourceid((String)map.get("datasourceid"));
         desensitizationtarget.setExecution_type("normal");
         desensitizationtarget.setInserttype((String)map.get("inserttype"));
         desensitizationtarget.setLoadscripttype((String)map.get("loadscripttype"));
         this.redisService.set(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName(), desensitizationtarget);
         if (desensitizationsource.getDatasourceid() != null && !desensitizationsource.getDatasourceid().equals("")) {
            TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
            TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById((String)map.get("datasourceid"));
            if (!tCoreDatasystemSource.getDbtype().equals(tCoreDatasystemTarget.getDbtype()) && tCoreDatasystemSource.getFlag().equals("1")) {
               model.addAttribute("mappingEditFlag", "dbsystem_diff");
            } else {
               model.addAttribute("mappingEditFlag", "dbsystem");
            }
         } else {
            model.addAttribute("mappingEditFlag", "dbsystem");
         }

         model.addAttribute("inserttype", map.get("inserttype"));
         model.addAttribute("isshow", "0");
         String projectid = (String)this.request.getSession().getAttribute("projectid");
         model.addAttribute("projectid", projectid);
      }

   }

   @RequestMapping({"/querytasktype"})
   @ResponseBody
   public List<ComboboxVO> querytasktype(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<ComboboxVO> list = new ArrayList();

      for(EmaskingTaskType e : EmaskingTaskType.values()) {
         ComboboxVO c = new ComboboxVO(e.getFlag(), e.getMaskingtype());
         list.add(c);
      }

      return list;
   }

   @ResponseBody
   @RequestMapping({"/queryfolder"})
   public List<Map<String, String>> queryfolder(String engineid, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<String> folder = this.infoService.queryFolderList(engineid);
      List<Map<String, String>> list = new ArrayList();

      for(String item : folder) {
         Map<String, String> map = new HashMap();
         map.put("id", item);
         map.put("text", item);
         map.put("iconCls", "icon-folder");
         list.add(map);
      }

      return list;
   }

   @ResponseBody
   @RequestMapping({"/querysensitivegroups"})
   public List<ComboboxVO> querysensitivegroups(HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.searchRegexService.querySensitiveGroups();
   }

   @RequestMapping({"/executepubtask"})
   public String executepubtask(String taskid, String engineid, String flag, HttpServletRequest request, HttpServletResponse response, Model model) {
      if ("1".equals(flag)) {
         model.addAttribute("taskid", taskid);
         model.addAttribute("engineid", engineid);
         return "core/monitor/monitorrun";
      } else if ("2".equals(flag)) {
         model.addAttribute("taskid", taskid);
         model.addAttribute("engineid", engineid);
         return "core/monitor/monitorimptask";
      } else if ("3".equals(flag)) {
         model.addAttribute("taskid", taskid);
         model.addAttribute("engineid", engineid);
         return "core/monitor/monitorsubtask";
      } else {
         return "";
      }
   }

   @ResponseBody
   @RequestMapping({"/savetask"})
   public Map<String, String> savetask(HttpServletRequest request, HttpServletResponse response, Model model) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      String projectId = (String)request.getSession().getAttribute("projectid");
      Map<String, String> map = new HashMap();
      if (tasknamereal == null) {
         map.put("state", "1");
      } else {
         String taskid = this.desensitizationSelfTaskService.gettaskBytasknamereal(tasknamereal, projectId);
         map.put("state", taskid);
      }

      return map;
   }

   @RequestMapping({"/savetask_info"})
   public String savetask_info(String state, HttpServletRequest request, HttpServletResponse response, Model model) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      String projectid = (String)request.getSession().getAttribute("projectid");
      Map<String, Object> map = new HashMap();
      Object obj = request.getSession().getAttribute("loginUser");
      Map<String, String> map_table_filterConditions = (Map)request.getSession().getAttribute(tasknamereal + "_" + "filterConditions");
      map.put("state", state);
      map.put("loginUser", obj);
      map.put("map_table_filterConditions", map_table_filterConditions);
      map.put("tableList", request.getSession().getAttribute("tableList_" + tasknamereal));
      map.put("projectid", projectid);
      if (!state.equals("1")) {
         String masking_engine_type = "";

         try {
            masking_engine_type = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("masking_engine_type");
         } catch (IOException e) {
            e.printStackTrace();
         }

         Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
         desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
         if ("1".equals(masking_engine_type) && !"update".equals(desensitizationtarget.getInserttype())) {
            this.desensitizationSelfTaskService.saveSameDBtask_info(tasknamereal, map);
         } else {
            this.desensitizationSelfTaskService.savetask_info(tasknamereal, map);
         }
      }

      request.getSession().removeAttribute("tableList_" + tasknamereal);
      request.getSession().removeAttribute("tasknamereal");
      model.addAttribute("toPageCurr", 1);
      return "core/desensitizationselftask/desensitizationselftasklist";
   }

   @ResponseBody
   @RequestMapping({"/querytaskdetail"})
   public Map<String, Object> querytaskdetail(String taskid, String type, HttpServletRequest request, HttpServletResponse response, Model model) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      Map<String, Object> map = new HashMap();
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      DesensitizationSelfTask desensitizationSelfTask = new DesensitizationSelfTask();
      DesensitizationSelfTask desensitizationSelfTask_replace = new DesensitizationSelfTask();
      desensitizationSelfTask = (DesensitizationSelfTask)this.redisService.get(tasknamereal + "_" + desensitizationSelfTask.getClass().getSimpleName());
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
      if (!"1".equals(type) && !"2".equals(type)) {
         String batchmanage = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
         String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
         String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
         if (batchmanage != null) {
            desensitizationSelfTask_replace.setBatchnumber(batchmanage);
         }

         if (tableprefix != null && !"".equals(tableprefix)) {
            desensitizationSelfTask_replace.setTableprefix(tableprefix);
         } else {
            desensitizationSelfTask_replace.setTableprefix("无");
         }

         if (tablesuffix != null && !"".equals(tablesuffix)) {
            desensitizationSelfTask_replace.setTablesuffix(tablesuffix);
         } else {
            desensitizationSelfTask_replace.setTablesuffix("无");
         }
      } else {
         desensitizationSelfTask = this.desensitizationSelfTaskService.queryTaskById(taskid);
         desensitizationsource = this.desensitizationSelfTaskService.querySourceInfo(taskid);
         desensitizationtarget = this.desensitizationSelfTaskService.queryTargetById(taskid);
         desensitizationSelfTask_replace.setBatchnumber(desensitizationSelfTask.getBatchnumber());
         desensitizationSelfTask_replace.setTableprefix(!"".equals(desensitizationSelfTask.getTableprefix()) && desensitizationSelfTask.getTableprefix() != null ? desensitizationSelfTask.getTableprefix() : "无");
         desensitizationSelfTask_replace.setTablesuffix(!"".equals(desensitizationSelfTask.getTablesuffix()) && desensitizationSelfTask.getTablesuffix() != null ? desensitizationSelfTask.getTablesuffix() : "无");
         if ("2".equals(type)) {
            String batchmanage = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
            String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
            String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
            if (batchmanage != null) {
               desensitizationSelfTask_replace.setBatchnumber(batchmanage);
            }

            if (tableprefix != null && !"".equals(tableprefix)) {
               desensitizationSelfTask_replace.setTableprefix(tableprefix);
            } else {
               desensitizationSelfTask_replace.setTableprefix("无");
            }

            if (tablesuffix != null && !"".equals(tablesuffix)) {
               desensitizationSelfTask_replace.setTablesuffix(tablesuffix);
            } else {
               desensitizationSelfTask_replace.setTablesuffix("无");
            }
         }
      }

      desensitizationSelfTask_replace.setTaskname(desensitizationSelfTask.getTaskname());
      desensitizationSelfTask_replace.setFoldername(desensitizationSelfTask.getFoldername());
      desensitizationSelfTask_replace.setFastexecution(desensitizationSelfTask.getFastexecution());
      map.put("desensitizationtask", desensitizationSelfTask_replace);
      map.put("desensitizationsource", desensitizationsource);
      map.put("desensitizationtarget", desensitizationsource);
      TCoreDatasystem tCoreDatasystem_source = null;
      TCoreDatasystem tCoreDatasystem_target = null;
      if (desensitizationsource.getDatasourceid() != null && !"".equals(desensitizationsource.getDatasourceid())) {
         tCoreDatasystem_source = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
         map.put("tCoreDatasystem_source", tCoreDatasystem_source);
      }

      tCoreDatasystem_target = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
      map.put("tCoreDatasystem_target", tCoreDatasystem_target);
      if (!"".equals(desensitizationsource.getDatasourceid()) && desensitizationsource.getDatasourceid() != null && !"".equals(desensitizationtarget.getDatasourceid()) && desensitizationtarget.getDatasourceid() != null && !tCoreDatasystem_source.getDbtype().equals(tCoreDatasystem_target.getDbtype())) {
         map.put("isSameDb", "1");
      } else {
         map.put("isSameDb", "0");
      }

      if ("".equals(desensitizationsource.getDatasourceid()) || desensitizationsource.getDatasourceid() == null || "".equals(desensitizationtarget.getDatasourceid()) || desensitizationtarget.getDatasourceid() == null) {
         map.put("isSameDb", "0");
      }

      String sourcetype = "1";
      String datasourceid_source = desensitizationsource.getDatasourceid();
      if (datasourceid_source != null && !datasourceid_source.equals("")) {
         TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid_source);
         String dbtype = tCoreDatasystem.getDbtype();
         if (dbtype.equals("FTP")) {
            sourcetype = "2";
         } else if (dbtype.equals("SFTP")) {
            sourcetype = "3";
         } else {
            sourcetype = "0";
         }
      }

      map.put("sourcetype", sourcetype);
      String targettype = "0";
      map.put("targettype", targettype);
      if (targettype.equals("1") || targettype.equals("2") || targettype.equals("3")) {
         DesensitizationFile desensitizationfile = new DesensitizationFile();
         if (!"1".equals(type) && !"2".equals(type)) {
            desensitizationfile = (DesensitizationFile)this.redisService.get(tasknamereal + "_" + desensitizationfile.getClass().getSimpleName());
         } else {
            desensitizationfile = this.desensitizationSelfTaskService.queryDesensitizationfileBytaskid(taskid);
         }

         map.put("desensitizationfile", desensitizationfile);
      }

      new ArrayList();
      List<Map<String, String>> var35;
      if ("1".equals(type)) {
         var35 = new ArrayList();

         for(DesensitizationTable desensitizationTable : this.desensitizationSelfTaskService.queryTableList(taskid)) {
            Map<String, String> desensitizationTablemap = new HashMap();
            desensitizationTablemap.put("tableName", desensitizationTable.getTablename());
            ((List)var35).add(desensitizationTablemap);
         }
      } else {
         var35 = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         if (var35 != null) {
            var35 = (var35).stream().filter((s) -> "1".equals(s.get("status")) || "3".equals(s.get("status"))).collect(Collectors.toList());
         }
      }

      map.put("tCoreMaskingTaskTableList", var35);
      return map;
   }

   @RequestMapping({"/inittasktable"})
   @ResponseBody
   public DataGridVO<DBTableVO> inittabledg(HttpServletRequest request, String tableNamePattern, Model model, String status) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      List<DBTableVO> list = new ArrayList();
      List<Map<String, String>> tableList = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
      if ("0".equals(status)) {
         for(Map<String, String> map : tableList) {
            DBTableVO dbTableVO = new DBTableVO();
            dbTableVO.setTablename((String)map.get("tableName"));
            dbTableVO.setStatus((String)map.get("status"));
            list.add(dbTableVO);
         }
      } else {
         for(Map<String, String> map : tableList) {
            DBTableVO dbTableVO = new DBTableVO();
            if (!status.equals("1") || !"0".equals(map.get("status")) && !"1".equals(map.get("status"))) {
               if (!status.equals("2") || !"2".equals(map.get("status")) && !"3".equals(map.get("status"))) {
                  if (!status.equals("3") || !"0".equals(map.get("status")) && !"2".equals(map.get("status"))) {
                     if (status.equals("4") && ("1".equals(map.get("status")) || "3".equals(map.get("status")))) {
                        dbTableVO.setTablename((String)map.get("tableName"));
                        dbTableVO.setStatus((String)map.get("status"));
                        list.add(dbTableVO);
                     }
                  } else {
                     dbTableVO.setTablename((String)map.get("tableName"));
                     dbTableVO.setStatus((String)map.get("status"));
                     list.add(dbTableVO);
                  }
               } else {
                  dbTableVO.setTablename((String)map.get("tableName"));
                  dbTableVO.setStatus((String)map.get("status"));
                  list.add(dbTableVO);
               }
            } else {
               dbTableVO.setTablename((String)map.get("tableName"));
               dbTableVO.setStatus((String)map.get("status"));
               list.add(dbTableVO);
            }
         }
      }

      String[] table_List = tableNamePattern.trim().split("\\,");
      if (table_List.length < 2) {
         if (!"".equals(tableNamePattern.trim())) {
            List<DBTableVO> tableSearchList = new ArrayList();

            for(DBTableVO dbTableVO : list) {
               if (dbTableVO.getTablename().toLowerCase().indexOf(tableNamePattern.toLowerCase()) != -1) {
                  tableSearchList.add(dbTableVO);
               }
            }

            return new DataGridVO<DBTableVO>((long)tableSearchList.size(), tableSearchList);
         } else {
            return new DataGridVO<DBTableVO>((long)list.size(), list);
         }
      } else {
         List<DBTableVO> tableSearchList = new ArrayList();
         List<String> table_List_name = new ArrayList();

         for(String string : table_List) {
            table_List_name.add(string.toLowerCase());
         }

         if (!"".equals(tableNamePattern.trim())) {
            tableSearchList = (List)list.parallelStream().filter((item) -> table_List_name.contains(item.getTablename().toLowerCase())).collect(Collectors.toList());
         }

         return new DataGridVO<DBTableVO>((long)tableSearchList.size(), tableSearchList);
      }
   }

   @RequestMapping({"/inputtable"})
   public String inputmulti(String flag, String title, String multivalue, String version, String inserttype, HttpServletRequest request, HttpServletResponse response, Model model) {
      String tableName = title;
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      String projectid = (String)request.getSession().getAttribute("projectid");
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      if (desensitizationsource == null) {
         String taskid = (String)request.getSession().getAttribute(tasknamereal + "_taskid");
         desensitizationsource = this.desensitizationSelfTaskService.querySourceInfo(taskid);
      }

      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
      if (desensitizationtarget == null) {
         String taskid = (String)request.getSession().getAttribute(tasknamereal + "_taskid");
         desensitizationtarget = this.desensitizationSelfTaskService.queryTargetById(taskid);
      }

      String filedir = desensitizationsource.getSourcefiledir();
      String filename = "";
      String extension = ".txt";
      String t_tableName = title;

      List<Map<String, String>> listNew = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
      for(Map<String, String> map : listNew) {
         if (tableName.equals(map.get("tableName"))) {
            if (((String)map.get("status")).equals("1")) {
               filedir = (String)map.get("filedir");
               filename = (String)map.get("filename");
               extension = (String)map.get("extension");
            }

            t_tableName = map.get("t_tableName") != null && !"".equals(map.get("t_tableName")) ? (String)map.get("t_tableName") : title;
            break;
         }
      }

      model.addAttribute("title", title);
      model.addAttribute("multivalue", multivalue);
      model.addAttribute("datasourceid", desensitizationsource.getDatasourceid());
      model.addAttribute("isfile", desensitizationsource.getDatasourceid() == null);
      model.addAttribute("dataschema", desensitizationsource.getDataschema());
      model.addAttribute("filedir", filedir);
      model.addAttribute("filename", filename);
      model.addAttribute("extension", extension);
      model.addAttribute("t_tableName", t_tableName);
      model.addAttribute("targettitle", desensitizationtarget.getDataschema() != null ? "目标表名:" : "目标文件名:");
      model.addAttribute("projectid", projectid);
      model.addAttribute("version", version);
      String sqlFilter = "";
      Map map = (Map)request.getSession().getAttribute(tasknamereal + "_" + "filterConditions");
      if (map != null) {
         if (!"".equals((String)map.get(multivalue)) && (String)map.get(multivalue) != null) {
            sqlFilter = ((String)map.get(multivalue)).replaceAll("'", "\\\\'");
         } else {
            sqlFilter = (String)map.get(multivalue);
         }
      }

      model.addAttribute("sqlFilter", sqlFilter);
      model.addAttribute("inserttype", inserttype);
      return "core/desensitizationselftask/" + flag;
   }

   @ResponseBody
   @RequestMapping({"/checkWhereStatement"})
   public ResultVO checkWhereStatement(String dataSystemId, String schema, String whereStatements, HttpServletRequest request, HttpServletResponse response, Model model) {
      TCoreDatasystem datasystem = this.dataSystemService.queryDataSystemById(dataSystemId);
      this.iskeberos(datasystem);
      Connection conn = JdbcTool.getConnection(datasystem);
      String[] tempArr = whereStatements.split(":");
      if (tempArr.length != 2) {
         return new ResultVO("过滤条件格式不正确！", false);
      } else {
         String sql = MessageFormat.format("select * from {0}.{1} where {2}", schema, tempArr[0], tempArr[1]);

         try {
            PreparedStatement statement = conn.prepareStatement(sql);
            ResultSet resultSet = statement.executeQuery();
            resultSet.close();
            statement.close();
         } catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return new ResultVO(tempArr[0] + ": " + e.getMessage(), false);
         }

         try {
            conn.close();
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return new ResultVO((String)null, true);
      }
   }

   @RequestMapping({"/querycolumninfo"})
   @ResponseBody
   public List<ColumnInfoVO> querycolumninfo(String id, String schema, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      String datasystemid = id.replace(tablename, "");
      return this.queryColumnInfo(datasystemid, schema, tablename);
   }

   @RequestMapping({"/querycolumninfodiff"})
   @ResponseBody
   public List<ColumnInfoVO> querycolumninfodiff(String id, String schema, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
      if (desensitizationtarget == null) {
         return null;
      } else {
         String datasystemid = id.replace(tablename, "");
         TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(datasystemid);
         if (tCoreDatasystemSource == null) {
            return null;
         } else {
            TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
            String dbSourceFlag = EdataMappingType.getFlagByName(tCoreDatasystemSource.getDbtype().toUpperCase());
            String dbTargetFlag = EdataMappingType.getFlagByName(tCoreDatasystemTarget.getDbtype().toUpperCase());
            List<DesensitizationDataTargetfield> desensitizationDataTargetfieldList = this.desensitizationdataMappingService.getTargetFieldByType("10");
            List<Map<String, String>> map_s = this.desensitizationdataMappingService.getDatamappingInfo(dbSourceFlag, "10");
            List<Map<String, String>> map_t = this.desensitizationdataMappingService.getDatamappingInfo(dbTargetFlag, "10");
            Map<String, String> targetFieldNameMap = new HashMap();

            for(DesensitizationDataTargetfield desensitizationDataTargetfield : desensitizationDataTargetfieldList) {
               String targetName = "";
               String fieldname = desensitizationDataTargetfield.getFieldname();

               for(Map<String, String> map : map_t) {
                  if (fieldname.equalsIgnoreCase((String)map.get("targetfieldname")) && "1".equals(map.get("isdefault"))) {
                     targetName = ((String)map.get("sourcefieldname")).toLowerCase();
                     break;
                  }
               }

               targetFieldNameMap.put(fieldname, targetName);
            }

            Connection conn = this.maskingTaskService.getConnectionByDataSystemId(datasystemid);
            List<ColumnInfoVO> list = JdbcTool.getColumnInfoVO(conn, schema, tablename);
            List<ColumnInfoVO> list1 = new ArrayList();
            if (tCoreDatasystemSource.getDbtype().equals("SYBASE_IQ")) {
               for(ColumnInfoVO civ : list) {
                  if (civ.getTypename().equals("varchar") || civ.getTypename().equals("char")) {
                     civ.setDecimaldigits("");
                  }

                  list1.add(civ);
               }

               if (this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + tablename)) {
                  new ArrayList();
                  List<TCoreMaskingTaskTableInfo> var32 = (List)this.redisService.get(tasknamereal + "_TCoreMaskingTaskTableInfo_" + tablename);
                  if (var32 != null) {
                     for(ColumnInfoVO civ : list1) {
                        for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : var32) {
                           if (civ.getColumnname().equals(tCoreMaskingTaskTableInfo.getColumnName())) {
                              civ.setTargettypename(tCoreMaskingTaskTableInfo.getTargetType());
                              break;
                           }
                        }
                     }
                  }
               } else {
                  for(ColumnInfoVO civ : list1) {
                     for(Map<String, String> map : map_s) {
                        if (this.delparentheses(civ.getTypename().toLowerCase()).equals(((String)map.get("sourcefieldname")).toLowerCase()) && "1".equals(map.get("sourcedefault"))) {
                           civ.setTargettypename((String)targetFieldNameMap.get(map.get("targetfieldname")));
                           break;
                        }
                     }
                  }
               }
            } else if (this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + tablename)) {
               new ArrayList();
               List<TCoreMaskingTaskTableInfo> var34 = (List)this.redisService.get(tasknamereal + "_TCoreMaskingTaskTableInfo_" + tablename);
               if (var34 != null) {
                  for(ColumnInfoVO civ : list) {
                     for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : var34) {
                        if (this.delparentheses(civ.getColumnname()).equals(tCoreMaskingTaskTableInfo.getColumnName())) {
                           civ.setTargettypename(tCoreMaskingTaskTableInfo.getTargetType());
                           break;
                        }
                     }
                  }
               }
            } else {
               for(ColumnInfoVO civ : list) {
                  for(Map<String, String> map : map_s) {
                     if (this.delparentheses(civ.getTypename().toLowerCase()).equals(((String)map.get("sourcefieldname")).toLowerCase()) && "1".equals(map.get("sourcedefault"))) {
                        civ.setTargettypename((String)targetFieldNameMap.get(map.get("targetfieldname")));
                        break;
                     }
                  }
               }
            }

            try {
               if (conn != null) {
                  conn.close();
               }
            } catch (SQLException e) {
               e.printStackTrace();
            }

            if (tCoreDatasystemSource.getDbtype().equals("SYBASE_IQ")) {
               return list1;
            } else {
               return list;
            }
         }
      }
   }

   @RequestMapping({"/querycolumntypediff"})
   @ResponseBody
   public List<ComboboxVO> querycolumntype(HttpServletRequest request, HttpServletResponse response, Model model, String sourceColumnType) {
      List<ComboboxVO> list = new ArrayList();
      sourceColumnType = this.delparentheses(sourceColumnType);
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      if (desensitizationsource == null) {
         return null;
      } else {
         desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
         if (desensitizationtarget == null) {
            return null;
         } else {
            TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
            TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
            String dbSourceFlag = EdataMappingType.getFlagByName(tCoreDatasystemSource.getDbtype().toUpperCase());
            String dbTargetFlag = EdataMappingType.getFlagByName(tCoreDatasystemTarget.getDbtype().toUpperCase());
            List<Map<String, String>> map_s = this.desensitizationdataMappingService.getDatamappingInfo(dbSourceFlag, "10");
            List<Map<String, String>> map_t = this.desensitizationdataMappingService.getDatamappingInfo(dbTargetFlag, "10");
            String fieldName = "";

            for(Map<String, String> map : map_s) {
               if (sourceColumnType.toLowerCase().equals(((String)map.get("sourcefieldname")).toLowerCase()) && "1".equals(map.get("sourcedefault"))) {
                  fieldName = (String)map.get("targetfieldname");
               }
            }

            List<String> targetFieldNameList = new ArrayList();

            for(Map<String, String> map : map_t) {
               if (fieldName.equals(map.get("targetfieldname"))) {
                  targetFieldNameList.add(((String)map.get("sourcefieldname")).toLowerCase());
               }
            }

            for(String string : targetFieldNameList) {
               ComboboxVO c = new ComboboxVO(string);
               list.add(c);
            }

            return list;
         }
      }
   }

   @RequestMapping({"/querycolumnfileinfo"})
   @ResponseBody
   public List<ColumnInfoVO> querycolumnfileinfo(String id, String schema, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      String datasystemid = id.replace(tablename, "");
      return this.queryColumnInfo(datasystemid, schema, tablename);
   }

   @RequestMapping({"/queryfilecolumnbyid"})
   @ResponseBody
   public List<TCoreFileStructurecolumnVO> queryfilecolumnbyid(String structureid) {
      List<TCoreFileStructurecolumn> list = this.fileSystemService.queryFileStructureColumn(structureid);
      List<TCoreFileStructurecolumnVO> volist = null;

      try {
         volist = ObjectTool.listConvert(list, TCoreFileStructurecolumnVO.class);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return volist;
   }

   @RequestMapping({"/savetableinfo"})
   @ResponseBody
   public boolean savetableinfo(HttpServletRequest request, @RequestParam Map<String, String> tableInfoMap, String filterConditions) {
      String tableName = (String)tableInfoMap.get("tableInfoMap[tableName]");
      String t_tableName = (String)tableInfoMap.get("tableInfoMap[t_tableName]");
      String version = (String)tableInfoMap.get("version");
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      this.redisService.set(tasknamereal + "_" + "version", version);
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      filterConditions = null == filterConditions ? "" : filterConditions;
      if (request.getSession().getAttribute(tasknamereal + "_" + "filterConditions") == null) {
         Map<String, String> map = new HashMap();
         map.put(tableName, filterConditions);
         request.getSession().setAttribute(tasknamereal + "_" + "filterConditions", map);
      } else {
         ((Map)request.getSession().getAttribute(tasknamereal + "_" + "filterConditions")).put(tableName, filterConditions);
      }

      if (desensitizationsource == null) {
         return false;
      } else {
         List<ColumnInfoVO> queryColumnInfo = this.queryColumnInfo(desensitizationsource.getDatasourceid(), desensitizationsource.getDataschema(), tableName);
         List<TCoreMaskingTaskTableInfo> tCoreMaskingTaskTableInfoList = new ArrayList();

         for(int j = 0; j < queryColumnInfo.size(); ++j) {
            String string = (String)tableInfoMap.get("tableInfoMap[rows][" + j + "][canshuname]");
            Map<String, String> parameterlist = new HashMap();
            if (string != null && string != "") {
               String[] split = string.split(",");

               for(String s : split) {
                  parameterlist.put(s, tableInfoMap.get("tableInfoMap[rows][" + j + "][" + s + "]"));
               }
            }

            TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo = new TCoreMaskingTaskTableInfo();
            tCoreMaskingTaskTableInfo.setIsPrimaryKey((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][primarykey]"));
            tCoreMaskingTaskTableInfo.setIsForeignKey((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][foreignkey]"));
            tCoreMaskingTaskTableInfo.setColumnName((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columnname]"));
            tCoreMaskingTaskTableInfo.setRemark((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][remarks]"));
            tCoreMaskingTaskTableInfo.setSearchType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][regextype]"));
            tCoreMaskingTaskTableInfo.setSourceType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][typename]"));
            tCoreMaskingTaskTableInfo.setTargetType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][targettypename]"));
            tCoreMaskingTaskTableInfo.setColumnLength((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columnsize]"));
            tCoreMaskingTaskTableInfo.setColumnPrecision((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][decimaldigits]"));
            tCoreMaskingTaskTableInfo.setRegexRuleId((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][maskingruleid]"));
            tCoreMaskingTaskTableInfo.setRegexRuleName((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][maskingrulename]"));
            tCoreMaskingTaskTableInfo.setRegexType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][regextype]"));
            tCoreMaskingTaskTableInfo.setParameterlist(parameterlist);
            tCoreMaskingTaskTableInfo.setDatadomainId((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][datadomainId]"));
            tCoreMaskingTaskTableInfo.setDatadomainName((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][datadomainName]"));
            tCoreMaskingTaskTableInfoList.add(tCoreMaskingTaskTableInfo);
         }

         this.redisService.set(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)tableInfoMap.get("tableInfoMap[tableName]"), tCoreMaskingTaskTableInfoList);

         List<Map<String, String>> listNew = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         for(Map<String, String> map : listNew) {
            if (tableName.equals(map.get("tableName"))) {
               map.put("t_tableName", t_tableName);
               if (((String)map.get("status")).equals("0")) {
                  map.put("status", "2");
               } else if (((String)map.get("status")).equals("1")) {
                  map.put("status", "3");
               }
            }
         }

         return true;
      }
   }

   public List<ColumnInfoVO> queryColumnInfo(String structureid) {
      List<TCoreFileStructurecolumn> listFile = this.fileSystemService.queryFileStructureColumn(structureid);
      List<ColumnInfoVO> list = new ArrayList();

      for(TCoreFileStructurecolumn tCoreFileStructurecolumn : listFile) {
         ColumnInfoVO columnInfoVO = new ColumnInfoVO();
         columnInfoVO.setColumnname(tCoreFileStructurecolumn.getColumnname());
         columnInfoVO.setColumnsize(tCoreFileStructurecolumn.getColumnaccuracy());
         columnInfoVO.setTargettypename(tCoreFileStructurecolumn.getColumntype());
         columnInfoVO.setTypename(tCoreFileStructurecolumn.getColumntype());
         columnInfoVO.setDecimaldigits(tCoreFileStructurecolumn.getColumndecimal());
         list.add(columnInfoVO);
      }

      return list;
   }

   public List<ColumnInfoVO> queryColumnInfo(String datasystemid, String schema, String tableName) {
      TCoreDatasystem datasystem = this.dataSystemService.queryDataSystemById(datasystemid);
      if (datasystem == null) {
         return null;
      } else {
         Connection conn = this.maskingTaskService.getConnectionByDataSystemId(datasystemid);
         List<ColumnInfoVO> list = JdbcTool.getColumnInfoVO(conn, schema, tableName);
         List<ColumnInfoVO> list1 = new ArrayList();
         if (datasystem.getDbtype().equals("SYBASE_IQ")) {
            for(ColumnInfoVO civ : list) {
               if (civ.getTypename().equals("varchar") || civ.getTypename().equals("char")) {
                  civ.setDecimaldigits("");
               }

               list1.add(civ);
            }
         }

         try {
            if (conn != null) {
               conn.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return datasystem.getDbtype().equals("SYBASE_IQ") ? list1 : list;
      }
   }

   @RequestMapping({"/savefiletableinfo"})
   @ResponseBody
   public boolean savefiletableinfo(HttpServletRequest request, @RequestParam Map<String, String> tableInfoMap) {
      String structureid = (String)tableInfoMap.get("tableInfoMap[structureid]");
      String filedir = (String)tableInfoMap.get("tableInfoMap[filedir]");
      String filename = (String)tableInfoMap.get("tableInfoMap[filename]");
      String extension = (String)tableInfoMap.get("tableInfoMap[extension]");
      String tableName = (String)tableInfoMap.get("tableInfoMap[tableName]");
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      if (desensitizationsource == null) {
         return false;
      } else {
         List<TCoreFileStructurecolumn> queryColumnInfo = this.fileSystemService.queryFileStructureColumn(structureid);
         List<TCoreMaskingTaskTableInfo> tCoreMaskingTaskTableInfoList = new ArrayList();

         for(int j = 0; j < queryColumnInfo.size(); ++j) {
            TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo = new TCoreMaskingTaskTableInfo();
            tCoreMaskingTaskTableInfo.setIsPrimaryKey((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][keytype]"));
            tCoreMaskingTaskTableInfo.setIsForeignKey((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][foreignkey]"));
            tCoreMaskingTaskTableInfo.setColumnName((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columnname]"));
            tCoreMaskingTaskTableInfo.setRemark((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][remarks]"));
            tCoreMaskingTaskTableInfo.setSearchType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][regextype]"));
            tCoreMaskingTaskTableInfo.setSourceType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columntype]"));
            tCoreMaskingTaskTableInfo.setColumnLength((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columnaccuracy]"));
            tCoreMaskingTaskTableInfo.setColumnPrecision((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columndecimal]"));
            tCoreMaskingTaskTableInfo.setRegexRuleId((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][maskingruleid]"));
            tCoreMaskingTaskTableInfo.setRegexRuleName((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][maskingrulename]"));
            tCoreMaskingTaskTableInfo.setRegexType((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][regextype]"));
            tCoreMaskingTaskTableInfo.setColumnformat((String)tableInfoMap.get("tableInfoMap[rows][" + j + "][columnformat]"));
            tCoreMaskingTaskTableInfoList.add(tCoreMaskingTaskTableInfo);
         }

         this.redisService.set(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)tableInfoMap.get("tableInfoMap[tableName]"), tCoreMaskingTaskTableInfoList);

         List<Map<String, String>> listNew = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         for(Map<String, String> map : listNew) {
            if (tableName.equals(map.get("tableName"))) {
               map.put("filedir", filedir);
               map.put("filename", filename);
               map.put("extension", extension);
               map.put("status", "1");
            }
         }

         return true;
      }
   }

   @RequestMapping({"/savechoosetable"})
   @ResponseBody
   public boolean saveChooseTable(String tableName, String chooseType, HttpServletRequest request) {
      try {
         String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
         new ArrayList();
         List<Map<String, String>> list = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         if ("onCheck".equals(chooseType)) {
            for(Map<String, String> map : list) {
               if (tableName.equals(map.get("tableName")) && this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName"))) {
                  map.put("status", "3");
               } else if (tableName.equals(map.get("tableName")) && !this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName"))) {
                  map.put("status", "1");
               }
            }
         } else if ("onUnCheck".equals(chooseType)) {
            for(Map<String, String> map : list) {
               if (tableName.equals(map.get("tableName")) && this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName"))) {
                  map.put("status", "2");
               } else if (tableName.equals(map.get("tableName")) && !this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName"))) {
                  map.put("status", "0");
               }
            }
         } else if ("onCheckAll".equals(chooseType)) {
            if (!"".equals(tableName) && tableName != null) {
               String[] tableNameArr = tableName.split(",");
               if (tableNameArr.length > 0) {
                  for(Map<String, String> map : list) {
                     if (this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName")) && Arrays.asList(tableNameArr).contains(map.get("tableName"))) {
                        map.put("status", "3");
                     } else if (!this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName")) && Arrays.asList(tableNameArr).contains(map.get("tableName"))) {
                        map.put("status", "1");
                     }
                  }
               }
            }
         } else if ("onUnCheckAll".equals(chooseType)) {
            for(Map<String, String> map : list) {
               if (this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName"))) {
                  map.put("status", "2");
               } else if (!this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + (String)map.get("tableName"))) {
                  map.put("status", "0");
               }
            }
         }

         request.getSession().setAttribute("tableList_" + tasknamereal, list);
         return true;
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }
   }

   @ResponseBody
   @RequestMapping(
      value = {"/getTableColumnSensitiveRule"},
      method = {RequestMethod.GET}
   )
   public void getSensitiveByIdBySchema(@RequestParam Map<String, Object> parameter, HttpServletRequest request, HttpServletResponse response) {
      PrintWriter writer = null;
      String schema = (String)parameter.get("schema");
      String table = (String)parameter.get("table");
      String version = (String)parameter.get("version");
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      List<TcoreDiscoverySensitivecolumn> list = new ArrayList();
      if (this.redisService.exists(tasknamereal + "_TCoreMaskingTaskTableInfo_" + table)) {
         new ArrayList();
         List<TCoreMaskingTaskTableInfo> e = (List)this.redisService.get(tasknamereal + "_TCoreMaskingTaskTableInfo_" + table);
         if (e != null) {
            for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : e) {
               TcoreDiscoverySensitivecolumn tcoreDiscoverySensitivecolumn = new TcoreDiscoverySensitivecolumn();
               tcoreDiscoverySensitivecolumn.setColumnname(tCoreMaskingTaskTableInfo.getColumnName());
               tcoreDiscoverySensitivecolumn.setRegextype(tCoreMaskingTaskTableInfo.getRegexRuleName());
               tcoreDiscoverySensitivecolumn.setRuleid(tCoreMaskingTaskTableInfo.getRegexRuleId());
               tcoreDiscoverySensitivecolumn.setDatadomainId(tCoreMaskingTaskTableInfo.getDatadomainId());
               tcoreDiscoverySensitivecolumn.setDatadomainName(tCoreMaskingTaskTableInfo.getDatadomainName());
               list.add(tcoreDiscoverySensitivecolumn);
            }
         }
      } else {
         new ArrayList();
         List<TCoreFieldSensitiveMemory> var16 = (List)this.redisService.get(table + "+" + schema);
         if (var16 != null) {
            for(int i = 0; i < var16.size(); ++i) {
               TcoreDiscoverySensitivecolumn tcoreDiscoverySensitivecolumn = new TcoreDiscoverySensitivecolumn();
               tcoreDiscoverySensitivecolumn.setColumnname(((TCoreFieldSensitiveMemory)var16.get(i)).getColumnname());
               tcoreDiscoverySensitivecolumn.setRegextype(((TCoreFieldSensitiveMemory)var16.get(i)).getRegextype());
               tcoreDiscoverySensitivecolumn.setRuleid(((TCoreFieldSensitiveMemory)var16.get(i)).getRuleid());
               list.add(tcoreDiscoverySensitivecolumn);
            }
         }
      }

      try {
         request.setCharacterEncoding("utf8");
         response.setCharacterEncoding("utf8");
         response.setContentType("text/json; charset=utf-8");
         writer = response.getWriter();
         writer.print(JSON.toJSON(list));
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @ResponseBody
   @RequestMapping({"/resetTableInfo"})
   public boolean resetTableInfo(HttpServletRequest request, String tableName) {
      try {
         String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
         this.redisService.remove(tasknamereal + "_TCoreMaskingTaskTableInfo_" + tableName);

         List<Map<String, String>> listNew = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         for(Map<String, String> map : listNew) {
            if (tableName.equals(map.get("tableName"))) {
               if (((String)map.get("status")).equals("2")) {
                  map.put("status", "0");
               } else if (((String)map.get("status")).equals("3")) {
                  map.put("status", "1");
               }
            }
         }

         return true;
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }
   }

   @ResponseBody
   @RequestMapping({"/resetTableInfoAll"})
   public boolean resetTableInfoAll(HttpServletRequest request, String tableName) {
      try {
         String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
         this.redisService.removePattern(tasknamereal + "_TCoreMaskingTaskTableInfo_*");

         List<Map<String, String>> listNew = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         for(Map<String, String> map : listNew) {
            if (tableName.equals(map.get("tableName"))) {
               map.put("status", "0");
            }
         }

         return true;
      } catch (Exception e) {
         e.printStackTrace();
         return false;
      }
   }

   @RequestMapping({"/editDesensitizationTask"})
   public String editDesensitizationTask(HttpServletRequest request, Model model, String taskid, Integer pageCurr, String edit) {
      model.addAttribute("taskid", taskid);
      model.addAttribute("pageCurr", pageCurr);
      DesensitizationSelfTask desensitizationtask = this.desensitizationSelfTaskService.queryTaskById(taskid);
      String tasktype = desensitizationtask.getTasktype();
      String tasknamereal = desensitizationtask.getTasknamereal();
      String sourcetype = tasktype.split("to")[0];
      String path = "";
      model.addAttribute("tasknamereal", desensitizationtask.getTasknamereal());
      request.getSession().setAttribute("tasknamereal", desensitizationtask.getTasknamereal());
      request.getSession().setAttribute(desensitizationtask.getTasknamereal() + "_taskid", taskid);
      Desensitizationsource desensitizationsource = this.desensitizationSelfTaskService.querySourceInfo(taskid);
      Desensitizationtarget desensitizationtarget = this.desensitizationSelfTaskService.queryTargetInfo(taskid);
      List<Map<String, String>> tableList = new ArrayList();
      if (!"DB".equals(sourcetype) && !"HIVE".equals(sourcetype)) {
         if ("LOCALFILE".equals(sourcetype) || "FILE".equals(sourcetype)) {
            List<TCoreFileStructure> list = this.fileSystemService.queryStructureByGroup(desensitizationsource.getDataschema(), "");
            List<DesensitizationTable> desensitizationTablelist = this.desensitizationSelfTaskService.queryTableList(taskid);
            Map<String, DesensitizationTable> maptable = new HashMap();

            for(DesensitizationTable desensitizationTable : desensitizationTablelist) {
               maptable.put(desensitizationTable.getTablename(), desensitizationTable);
            }

            for(TCoreFileStructure dbTableVO : list) {
               Map<String, String> tableMap = new HashMap();
               tableMap.put("tableName", dbTableVO.getFilestructurename());
               tableMap.put("structureid", dbTableVO.getId());
               tableMap.put("filedir", maptable.get(dbTableVO.getFilestructurename()) == null ? "" : ((DesensitizationTable)maptable.get(dbTableVO.getFilestructurename())).getFilepath());
               tableMap.put("filename", maptable.get(dbTableVO.getFilestructurename()) == null ? "" : ((DesensitizationTable)maptable.get(dbTableVO.getFilestructurename())).getFilename().split("\\.")[0]);
               tableMap.put("extension", maptable.get(dbTableVO.getFilestructurename()) == null ? "" : "." + ((DesensitizationTable)maptable.get(dbTableVO.getFilestructurename())).getFilename().split("\\.")[1]);
               tableMap.put("status", maptable.get(dbTableVO.getFilestructurename()) == null ? "0" : ((DesensitizationTable)maptable.get(dbTableVO.getFilestructurename())).getStatus());
               tableList.add(tableMap);
            }

            request.getSession().setAttribute("tableList_" + desensitizationtask.getTasknamereal(), tableList);
            model.addAttribute("isshow", "1");
            model.addAttribute("taskid", taskid);
            model.addAttribute("tasknamereal", desensitizationtask.getTasknamereal());
            String version = (String)this.redisService.get(tasknamereal + "_" + "version");
            String batchnumber = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
            String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
            String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
            if (edit == null) {
               if (version == null) {
                  version = desensitizationtask.getVersion();
               }

               batchnumber = desensitizationtask.getBatchnumber();
               tablesuffix = desensitizationtask.getTablesuffix();
               tableprefix = desensitizationtask.getTableprefix();
            }

            this.redisService.set(desensitizationtask.getTasknamereal() + "_" + BatchManage.class.getSimpleName(), desensitizationtask.getBatchnumber());
            this.redisService.set(desensitizationtask.getTasknamereal() + "_" + "tableprefix", desensitizationtask.getTableprefix());
            this.redisService.set(desensitizationtask.getTasknamereal() + "_" + "tablesuffix", desensitizationtask.getTablesuffix());
            model.addAttribute("version", version);
            model.addAttribute("inserttype", desensitizationtarget.getInserttype());
            path = "core/desensitizationselftask/taskedit/desensitizationtask_edit_file";
         }
      } else {
         Map<String, String> allTable = this.dataSystemService.queryTableName(desensitizationsource.getDatasourceid(), desensitizationsource.getDataschema(), "");
         List<DesensitizationTable> desensitizationTableList = this.desensitizationSelfTaskService.queryTableList(taskid);
         Map<String, String> sqlFiterMap = new HashMap();
         Map<String, String> t_tableNameMap = new HashMap();

         for(DesensitizationTable desensitizationTable : desensitizationTableList) {
            allTable.put(desensitizationTable.getTablename(), desensitizationTable.getStatus());
            sqlFiterMap.put(desensitizationTable.getTablename(), desensitizationTable.getSqlFilter());
            t_tableNameMap.put(desensitizationTable.getTablename(), desensitizationTable.getT_tablename());
         }

         List<DBTableVO> list = new ArrayList();

         for(String key : allTable.keySet()) {
            DBTableVO dbTableVO = new DBTableVO();
            dbTableVO.setTablename(key);
            dbTableVO.setStatus((String)allTable.get(key));
            list.add(dbTableVO);
         }

         Collections.sort(list);

         for(DBTableVO dbTableVO : list) {
            Map<String, String> map = new HashMap();
            map.put("tableName", dbTableVO.getTablename());
            map.put("status", dbTableVO.getStatus());
            map.put("t_tableName", t_tableNameMap.get(dbTableVO.getTablename()));
            tableList.add(map);
         }

         request.getSession().setAttribute(desensitizationtask.getTasknamereal() + "_" + "filterConditions", sqlFiterMap);
         request.getSession().setAttribute(desensitizationtask.getTasknamereal() + "_" + "filterConditions", sqlFiterMap);
         TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
         TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
         if (tCoreDatasystemTarget != null && !tCoreDatasystemSource.getDbtype().equals(tCoreDatasystemTarget.getDbtype())) {
            model.addAttribute("mappingEditFlag", "dbsystem_diff");
         } else {
            model.addAttribute("mappingEditFlag", "dbsystem");
         }

         this.redisService.set(desensitizationtask.getTasknamereal() + "_" + BatchManage.class.getSimpleName(), desensitizationtask.getBatchnumber() == null ? "" : desensitizationtask.getBatchnumber());
         this.redisService.set(desensitizationtask.getTasknamereal() + "_" + "tableprefix", desensitizationtask.getTableprefix() == null ? "" : desensitizationtask.getTableprefix());
         this.redisService.set(desensitizationtask.getTasknamereal() + "_" + "tablesuffix", desensitizationtask.getTablesuffix() == null ? "" : desensitizationtask.getTablesuffix());
         request.getSession().setAttribute("tableList_" + desensitizationtask.getTasknamereal(), tableList);
         String version = (String)this.redisService.get(tasknamereal + "_" + "version");
         String batchnumber = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
         String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
         String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
         if (edit == null) {
            if (version == null) {
               version = desensitizationtask.getVersion();
            }

            batchnumber = desensitizationtask.getBatchnumber();
            tablesuffix = desensitizationtask.getTablesuffix();
            tableprefix = desensitizationtask.getTableprefix();
         }

         this.redisService.set(desensitizationtask.getTasknamereal() + "_" + BatchManage.class.getSimpleName(), batchnumber);
         this.redisService.set(desensitizationtask.getTasknamereal() + "_" + "tableprefix", tableprefix);
         this.redisService.set(desensitizationtask.getTasknamereal() + "_" + "tablesuffix", tablesuffix);
         model.addAttribute("version", version);
         model.addAttribute("inserttype", desensitizationtarget.getInserttype());
         path = "core/desensitizationselftask/taskedit/desensitizationtask_edit";
      }

      return path;
   }

   @RequestMapping({"/showDesensitizationTask"})
   public String showDesensitizationTask(HttpServletRequest request, Model model, String taskid, Integer pageCurr) {
      model.addAttribute("pageCurr", pageCurr);
      model.addAttribute("taskid", taskid);
      return "core/desensitizationselftask/taskedit/desensitizationtask_show";
   }

   @RequestMapping({"/querymultitable"})
   @ResponseBody
   public List<ColumnInfoVO> querymultitable(String structureid, String taskid, String type, String table, HttpServletRequest request) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      String version = (String)this.redisService.get(tasknamereal + "_" + "version");
      List<ColumnInfoVO> queryColumnInfo = new ArrayList();
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      if (!"1".equals(type) && !"2".equals(type)) {
         desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      } else {
         desensitizationsource = this.desensitizationSelfTaskService.querySourceInfo(taskid);
      }

      new ArrayList();
      List<TCoreMaskingTaskTableInfo> tCoreMaskingTaskTableInfoList = (List)this.redisService.get(tasknamereal + "_" + "TCoreMaskingTaskTableInfo_" + table);
      HashMap<String, String> map = new HashMap();
      if ("1".equals(type)) {
         for(DesensitizationTablecolumn desensitizationTablecolumn : this.desensitizationSelfTaskService.queryColumInfo(taskid, table)) {
            ColumnInfoVO columnInfo = new ColumnInfoVO();
            columnInfo.setColumnname(desensitizationTablecolumn.getColumnname());
            columnInfo.setColumnsize(desensitizationTablecolumn.getColumnlength());
            columnInfo.setDecimaldigits(desensitizationTablecolumn.getColumnscale());
            columnInfo.setTypename(desensitizationTablecolumn.getColumntype());
            columnInfo.setRegextype("点击设置脱敏规则".equals(desensitizationTablecolumn.getRulename()) ? "无" : desensitizationTablecolumn.getRulename());
            columnInfo.setSecretkeyName(desensitizationTablecolumn.getSecretkeyName());
            queryColumnInfo.add(columnInfo);
         }
      } else {
         if (tCoreMaskingTaskTableInfoList != null) {
            for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : tCoreMaskingTaskTableInfoList) {
               map.put(tCoreMaskingTaskTableInfo.getColumnName(), tCoreMaskingTaskTableInfo.getRegexRuleName());
            }
         } else {
            String sourceid = desensitizationsource.getDatasourceid();
            if (sourceid != null) {
               TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(sourceid);
               String soucreType = tCoreDatasystem.getFlag();
               if (soucreType.equals("2")) {
                  queryColumnInfo = this.queryColumnInfo(structureid);
               } else {
                  queryColumnInfo = this.queryColumnInfo(desensitizationsource.getDatasourceid(), desensitizationsource.getDataschema(), table);
               }
            }

            if (version != null && !"".equals(version)) {
               Properties props = new Properties();

               try {
                  props = PropertiesLoaderUtils.loadAllProperties("config.properties");
               } catch (IOException e) {
                  e.printStackTrace();
               }

               String filepath = "";
               String ver = version.split("/")[0];
               if ("AllVersion".equals(ver)) {
                  File file = new File(props.getProperty("AllVersion"));
                  if (file.listFiles() != null && file.listFiles().length > 0) {
                     filepath = props.getProperty("AllVersion") + file.listFiles()[0].getName();
                  }
               } else if ("ProjectVersion".equals(ver)) {
                  File file = new File(props.getProperty("ProjectVersion") + version.split("/")[1]);
                  if (file.listFiles() != null && file.listFiles().length > 0) {
                     filepath = props.getProperty("ProjectVersion") + version.split("/")[1] + File.separator + file.listFiles()[0].getName();
                  }
               } else if ("TaskVersion".equals(ver)) {
                  filepath = props.getProperty("TaskVersion") + version.split("/")[1] + "/" + version.split("/")[2];
               }

               System.out.println("filepath:" + filepath + "," + version);
               new ArrayList();
               map = this.versionMap(filepath, queryColumnInfo, desensitizationsource.getDataschema(), table);
            }
         }

         if (tCoreMaskingTaskTableInfoList != null) {
            for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : tCoreMaskingTaskTableInfoList) {
               ColumnInfoVO columnInfo = new ColumnInfoVO();
               columnInfo.setColumnname(tCoreMaskingTaskTableInfo.getColumnName());
               columnInfo.setColumnsize(tCoreMaskingTaskTableInfo.getColumnLength());
               columnInfo.setDecimaldigits(tCoreMaskingTaskTableInfo.getColumnPrecision());
               columnInfo.setTypename(tCoreMaskingTaskTableInfo.getSourceType());
               columnInfo.setSecretkeyName(tCoreMaskingTaskTableInfo.getSecretkeyName());
               queryColumnInfo.add(columnInfo);
            }
         }

         for(ColumnInfoVO columnInfo : queryColumnInfo) {
            columnInfo.setRegextype(map.get(columnInfo.getColumnname()) != null && !((String)map.get(columnInfo.getColumnname())).equals("点击设置脱敏规则") ? (String)map.get(columnInfo.getColumnname()) : "无");
         }
      }

      return queryColumnInfo;
   }

   public HashMap<String, String> versionMap(String filepath, List<ColumnInfoVO> columnlist, String schema, String table) {
      HashMap<String, String> map = new HashMap();
      if (!FileTool.isFileExit(filepath)) {
         return map;
      } else {
         InputStreamReader newRead = null;

         try {
            newRead = new InputStreamReader(new FileInputStream(filepath), "GBK");
         } catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
         } catch (FileNotFoundException e1) {
            e1.printStackTrace();
         }

         BufferedReader newBufferedReader = new BufferedReader(newRead);
         String newInformationLine = "";
         String[] str = null;

         try {
            while((newInformationLine = newBufferedReader.readLine()) != null) {
               str = newInformationLine.split(",", -1);
               TcoreDiscoverySensitivecolumn tcoreDiscoverySensitivecolumn = new TcoreDiscoverySensitivecolumn();
               if (schema.equals(str[0]) && table.equals(str[1])) {
                  for(int i = 0; i < columnlist.size(); ++i) {
                     if (((ColumnInfoVO)columnlist.get(i)).getColumnname().equals(str[2])) {
                        tcoreDiscoverySensitivecolumn.setColumnname(str[2]);
                        tcoreDiscoverySensitivecolumn.setRegextype(str[6]);
                        tcoreDiscoverySensitivecolumn.setRuleid(str[5]);
                        map.put(str[2], str[6]);
                     }
                  }
               }
            }
         } catch (IOException e) {
            e.printStackTrace();
         } finally {
            a(newBufferedReader, newRead);
         }

         return map;
      }
   }

   private static void a(Closeable... closeables) {
      if (closeables != null) {
         try {
            for(Closeable closeable : closeables) {
               if (closeable != null) {
                  closeable.close();
               }
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

   }

   @RequestMapping({"/querymultitablediff"})
   @ResponseBody
   public List<ColumnInfoVO> querymultitablediff(String taskid, String type, String table, HttpServletRequest request) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      List<ColumnInfoVO> queryColumnInfo = new ArrayList();
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      if (!"1".equals(type) && !"2".equals(type)) {
         desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
         desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
      } else {
         desensitizationsource = this.desensitizationSelfTaskService.querySourceInfo(taskid);
         desensitizationtarget = this.desensitizationSelfTaskService.queryTargetInfo(taskid);
      }

      TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
      TCoreDatasystem tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
      String dbSourceFlag = EdataMappingType.getFlagByName(tCoreDatasystemSource.getDbtype().toUpperCase());
      String dbTargetFlag = EdataMappingType.getFlagByName(tCoreDatasystemTarget.getDbtype().toUpperCase());
      List<DesensitizationDataTargetfield> desensitizationDataTargetfieldList = this.desensitizationdataMappingService.getTargetFieldByType("10");
      List<Map<String, String>> map_s = this.desensitizationdataMappingService.getDatamappingInfo(dbSourceFlag, "10");
      List<Map<String, String>> map_t = this.desensitizationdataMappingService.getDatamappingInfo(dbTargetFlag, "10");
      Map<String, String> targetFieldNameMap = new HashMap();

      for(DesensitizationDataTargetfield desensitizationDataTargetfield : desensitizationDataTargetfieldList) {
         String targetName = "";
         String fieldname = desensitizationDataTargetfield.getFieldname();

         for(Map<String, String> map : map_t) {
            if (fieldname.equalsIgnoreCase((String)map.get("targetfieldname")) && "1".equals(map.get("isdefault"))) {
               targetName = ((String)map.get("sourcefieldname")).toLowerCase();
               break;
            }
         }

         targetFieldNameMap.put(fieldname, targetName);
      }

      new ArrayList();
      List<TCoreMaskingTaskTableInfo> var25 = (List)this.redisService.get(tasknamereal + "_" + "TCoreMaskingTaskTableInfo_" + table);
      HashMap<String, String> map = new HashMap();
      if ("1".equals(type)) {
         for(DesensitizationTablecolumn desensitizationTablecolumn : this.desensitizationSelfTaskService.queryColumInfo(taskid, table)) {
            ColumnInfoVO columnInfo = new ColumnInfoVO();
            columnInfo.setColumnname(desensitizationTablecolumn.getColumnname());
            columnInfo.setColumnsize(desensitizationTablecolumn.getColumnlength());
            columnInfo.setDecimaldigits(desensitizationTablecolumn.getColumnscale());
            columnInfo.setTypename(desensitizationTablecolumn.getColumntype());
            columnInfo.setRegextype("点击设置脱敏规则".equals(desensitizationTablecolumn.getRegextype()) ? "无" : desensitizationTablecolumn.getRegextype());
            columnInfo.setTargettypename(desensitizationTablecolumn.getColumntartype());
            queryColumnInfo.add(columnInfo);
         }
      } else {
         if (var25 != null) {
            for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : var25) {
               map.put(tCoreMaskingTaskTableInfo.getColumnName(), tCoreMaskingTaskTableInfo.getRegexRuleName());
            }
         } else {
            queryColumnInfo = this.queryColumnInfo(desensitizationsource.getDatasourceid(), desensitizationsource.getDataschema(), table);
            if (this.redisService.exists(table + "+" + desensitizationsource.getDataschema())) {
               new ArrayList();
               List<TCoreFieldSensitiveMemory> var28 = (List)this.redisService.get(table + "+" + desensitizationsource.getDataschema());
               if (var28 != null) {
                  for(TCoreFieldSensitiveMemory tCoreFieldSensitiveMemory : var28) {
                     map.put(tCoreFieldSensitiveMemory.getColumnname(), tCoreFieldSensitiveMemory.getRuie());
                  }
               }
            }
         }

         if (var25 != null) {
            for(TCoreMaskingTaskTableInfo tCoreMaskingTaskTableInfo : var25) {
               ColumnInfoVO columnInfo = new ColumnInfoVO();
               columnInfo.setColumnname(tCoreMaskingTaskTableInfo.getColumnName());
               columnInfo.setColumnsize(tCoreMaskingTaskTableInfo.getColumnLength());
               columnInfo.setDecimaldigits(tCoreMaskingTaskTableInfo.getColumnPrecision());
               columnInfo.setTypename(tCoreMaskingTaskTableInfo.getSourceType());
               columnInfo.setTargettypename(tCoreMaskingTaskTableInfo.getTargetType());
               queryColumnInfo.add(columnInfo);
            }
         } else {
            for(ColumnInfoVO columnInfo : queryColumnInfo) {
               columnInfo.setRegextype(map.get(columnInfo.getColumnname()) != null && !((String)map.get(columnInfo.getColumnname())).equals("点击设置脱敏规则") ? (String)map.get(columnInfo.getColumnname()) : "无");

               for(Map<String, String> map1 : map_s) {
                  if (this.delparentheses(columnInfo.getTypename().toLowerCase()).equals(((String)map1.get("sourcefieldname")).toLowerCase()) && "1".equals(map1.get("sourcedefault"))) {
                     columnInfo.setTargettypename((String)targetFieldNameMap.get(map1.get("targetfieldname")));
                     break;
                  }
               }
            }
         }
      }

      return queryColumnInfo;
   }

   @ResponseBody
   @RequestMapping({"/querysqlFilter"})
   public Map<String, Object> querysqlFilter(String taskid, String type, String table, HttpServletRequest request) {
      String sqlFilter = "";
      String t_tablename = "";
      Map<String, Object> map = new HashMap();
      this.desensitizationSelfTaskService.queryTaskById(taskid);
      if ("1".equals(type)) {
         DesensitizationTable desensitizationTable = this.desensitizationSelfTaskService.queryTableByTableName(taskid, table);
         sqlFilter = desensitizationTable.getSqlFilter() == null ? "" : desensitizationTable.getSqlFilter();
         map.put("filename", desensitizationTable.getFilename() == null ? "" : desensitizationTable.getFilename());
         map.put("filepath", desensitizationTable.getFilepath() == null ? "" : desensitizationTable.getFilepath());
         t_tablename = desensitizationTable.getT_tablename();
      } else {
         String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
         Map filterMap = (Map)request.getSession().getAttribute(tasknamereal + "_" + "filterConditions");
         if (filterMap != null) {
            if (!"".equals((String)filterMap.get(table)) && (String)filterMap.get(table) != null) {
               sqlFilter = ((String)filterMap.get(table)).replaceAll("'", "\\\\'");
            } else {
               sqlFilter = (String)filterMap.get(table);
            }
         }

         new ArrayList();
         List<Map<String, String>> tCoreMaskingTaskTablemapList = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         tCoreMaskingTaskTablemapList = (List)tCoreMaskingTaskTablemapList.stream().filter((s) -> table.equals(s.get("tableName"))).collect(Collectors.toList());
         System.out.println(tCoreMaskingTaskTablemapList.size());
         String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
         if (tableprefix == null) {
            tableprefix = "";
         }

         String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
         if (tablesuffix == null) {
            tablesuffix = "";
         }

         if (tCoreMaskingTaskTablemapList != null && tCoreMaskingTaskTablemapList.size() > 0) {
            Map<String, String> maptable = (Map)tCoreMaskingTaskTablemapList.get(0);
            t_tablename = tableprefix + (maptable.get("t_tableName") != null ? (String)maptable.get("t_tableName") : table);
            t_tablename = t_tablename + tablesuffix;
         } else {
            t_tablename = "";
         }
      }

      map.put("t_tableName", t_tablename);
      map.put("sqlFilter", sqlFilter);
      return map;
   }

   @RequestMapping(
      value = {"/removetask"},
      method = {RequestMethod.POST}
   )
   @ResponseBody
   public void removetask(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      DesensitizationSelfTask desensitizationSelfTask = this.desensitizationSelfTaskService.queryTaskById(taskid);
      desensitizationSelfTask.setTaskstatus("2");
      this.redisService.set("removePercent_" + desensitizationSelfTask.getTasknamereal(), "0", new Long(86400L));
      this.desensitizationSelfTaskService.updateTask(desensitizationSelfTask);
      this.desensitizationSelfTaskService.removeTask(taskid);
      TConsoleLog record = new TConsoleLog();
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      String username = loginUser.getTsysUser().getUsername();
      record.setModule("数据脱敏");
      record.setOperationtime(new Date());
      record.setUser(username);
      record.setLogmessage("删除数据脱敏任务");
      this.operationService.add(record);
   }

   @RequestMapping({"/executeDesensitizationTask"})
   public String executeDesensitizationTask(HttpServletRequest request, Model model, String taskid, Integer pageCurr) {
      try {
         Desensitizationsource desensitizationsource = this.desensitizationSelfTaskService.querySourceInfo(taskid);
         Desensitizationtarget desensitizationtarget = this.desensitizationSelfTaskService.queryTargetById(taskid);
         DesensitizationSelfTask desensitizationSelfTask = this.desensitizationSelfTaskService.queryTaskById(taskid);
         TCoreDatasystem tCoreDatasystemSource = new TCoreDatasystem();
         TCoreDatasystem tCoreDatasystemTarget = new TCoreDatasystem();
         if (desensitizationsource.getDatasourceid() != null && !"".equals(desensitizationsource.getDatasourceid())) {
            tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
         } else {
            tCoreDatasystemSource.setDbtype("FILE");
         }

         if (desensitizationtarget.getDatasourceid() != null && !"".equals(desensitizationtarget.getDatasourceid())) {
            tCoreDatasystemTarget = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
         } else {
            tCoreDatasystemTarget.setDbtype("FILE");
         }

         String type = JdbcTool.returnType(desensitizationsource.getExecution_type(), desensitizationtarget.getExecution_type(), desensitizationSelfTask.getTasktype());
         InfoProperty infoProperty = this.desensitizationSelfTaskService.getInfoProperty();
         long groupId = (new Date()).getTime();
         ExecuteParam executeParam = new ExecuteParam();
         executeParam.setSourceDataSystem(tCoreDatasystemSource);
         executeParam.setTargetDataSystem(tCoreDatasystemTarget);
         executeParam.setInfoProperty(infoProperty);
         executeParam.setDataSourceId(desensitizationsource.getDatasourceid());
         executeParam.setDataTargetId(desensitizationtarget.getDatasourceid());
         executeParam.setFolderName(desensitizationSelfTask.getFoldername());
         executeParam.setSourceSchemaName(desensitizationsource.getDataschema());
         executeParam.setTargetSchemaName(desensitizationtarget.getDataschema());
         executeParam.setIsPrimary(desensitizationtarget.getIsprimary());
         executeParam.setIsIndex(desensitizationtarget.getIsindex());
         executeParam.setTaskid(taskid);
         executeParam.setSourceFileDir(desensitizationsource.getSourcefiledir());
         executeParam.setTaskNameReal(desensitizationSelfTask.getTasknamereal());
         executeParam.setSourcetype(desensitizationsource.getExecution_type());
         executeParam.setTargettype(desensitizationtarget.getExecution_type());
         executeParam.setLoadscripttype(desensitizationtarget.getLoadscripttype());
         executeParam.setDesensitizationtarget(desensitizationtarget);
         String taskType = JdbcTool.returnTaskType(desensitizationSelfTask.getTasktype());
         List<DesensitizationTable> tableList = this.desensitizationSelfTaskService.queryTableList(taskid);
         Map<String, String> tableMap = new HashMap();
         StringBuilder batchInserSql = new StringBuilder();
         List<String> list_table = JdbcTool.sql_insert_q(new DesensitizationMonitor());
         list_table.add("id");
         String sqlBase = JdbcTool.sql_insert_z(list_table, "desensitization_monitor");
         batchInserSql.append(sqlBase);

         for(DesensitizationTable desensitizationTable : tableList) {
            String id = UUID.randomUUID().toString();
            tableMap.put(desensitizationTable.getTablename(), id);
            executeParam.setGroupId(groupId);
            this.desensitizationSelfTaskService.createMonitor(executeParam, desensitizationTable.getTablename(), tableMap);
         }

         executeParam.setTableMap(tableMap);
         switch (type) {
            case "DBtoDB,normal,batchwrite":
               this.desensitizationSelfTaskService.executeDB_pwc_FILE_batchwrite_DB(executeParam);
               break;
            case "FILEtoDB,batchwrite":
               this.desensitizationSelfTaskService.executeFILE_pwc_FILE_batchwrite_DB(executeParam);
               break;
            case "DBtoDB,batchread,batchwrite":
               this.desensitizationSelfTaskService.executeDB_batchread_FILE_pwc_FILE_batchwrite_DB(executeParam);
               break;
            case "DBtoFILE,batchread":
               this.desensitizationSelfTaskService.executeDB_batchread_FILE_pwc_FILE(executeParam);
               break;
            case "DBtoDB,batchread,normal":
               this.desensitizationSelfTaskService.executeDB_batchread_FILE_pwc_DB(executeParam);
               break;
            default:
               if (desensitizationSelfTask.getTasktype().contains("HIVE")) {
                  this.desensitizationSelfTaskService.executeTask(executeParam);
               } else {
                  this.desensitizationSelfTaskService.executeTaskNormal(executeParam);
               }
         }

         model.addAttribute("taskid", taskid);
         model.addAttribute("pageCurr", pageCurr);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return "/core/desensitizationmonitor/monitortaskselflog";
   }

   @RequestMapping({"/detail"})
   public String detail(String taskid, String tasktype, HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) throws SQLException {
      model.addAttribute("taskid", taskid);
      model.addAttribute("pageCurr", pageCurr);
      return "core/desensitizationselftask/desensitizationtask_details";
   }

   @RequestMapping({"/isrun"})
   @ResponseBody
   public boolean isrun(String taskid, HttpServletRequest request, @RequestParam Map<String, String> tableInfoMap) {
      long num_exeing = this.desensitizationSelfTaskService.getExeTaskNum();
      long num_table = this.desensitizationSelfTaskService.getTableNum(taskid);
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      long num_thread = new Long(props.getProperty("threadPool.queueCapacity"));
      return num_exeing + num_table < num_thread;
   }

   @RequestMapping({"/checksystem"})
   @ResponseBody
   public Map<String, Object> checksystem(String taskid, HttpServletRequest request, @RequestParam Map<String, String> tableInfoMap) {
      Map<String, Object> map = new HashMap();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      Float sys_Alert_Threshold = new Float(props.getProperty("Sys_Alert_Threshold"));
      sys_Alert_Threshold = sys_Alert_Threshold * 100.0F;
      map.put("flag", false);
      return map;
   }

   public String source_type(Map<String, String> map) {
      String sourceType = "";
      String tasknamereal = (String)map.get("tasknamereal");
      new Desensitizationsource();
      Desensitizationsource desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + "Desensitizationsource");
      if (desensitizationsource != null) {
         String datasourceid = desensitizationsource.getDatasourceid();
         if (datasourceid != null && !"".equals(datasourceid)) {
            TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid);
            String dbtype = tCoreDatasystem.getDbtype();
            if (!dbtype.equals("FTP") && !dbtype.equals("SFTP")) {
               sourceType = "db";
            } else {
               sourceType = "file";
            }
         } else {
            sourceType = "file";
         }
      }

      return sourceType;
   }

   @RequestMapping({"/structure/querystructurebygroup"})
   @ResponseBody
   public DataGridVO<DBTableVO> querystructurebygroup(String groupname, String tableNamePattern) {
      String tasknamereal = (String)this.request.getSession().getAttribute("tasknamereal");
      List<DBTableVO> list = new ArrayList();

      List<Map<String, String>> listNew = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
      for(Map<String, String> map : listNew) {
         DBTableVO dbTableVO = new DBTableVO();
         if ("0".equals(map.get("status")) || "1".equals(map.get("status"))) {
            dbTableVO.setTablename((String)map.get("tableName"));
            dbTableVO.setStatus((String)map.get("status"));
            dbTableVO.setDatasystemid((String)map.get("structureid"));
            list.add(dbTableVO);
         }
      }

      if (!"".equals(tableNamePattern.trim())) {
         List<DBTableVO> tableSearchList = new ArrayList();

         for(DBTableVO dbTableVO : list) {
            if (dbTableVO.getTablename().indexOf(tableNamePattern) != -1) {
               tableSearchList.add(dbTableVO);
            }
         }

         return new DataGridVO<DBTableVO>((long)tableSearchList.size(), tableSearchList);
      } else {
         return new DataGridVO<DBTableVO>((long)list.size(), list);
      }
   }

   @RequestMapping({"/getFileContent"})
   @ResponseBody
   public Map<String, Object> getFileContent(@RequestParam("file") MultipartFile file, String charset) {
      System.out.println("开始");
      String path = "D:\\";
      String uuid = UUID.randomUUID().toString();
      File dbffile = new File(path + uuid + ".dbf");

      try {
         dbffile.createNewFile();
         file.transferTo(dbffile);
      } catch (Exception e) {
         e.printStackTrace();
      }

      Map<String, String> map = transdbf.selectdbf(charset, dbffile, ",");
      Map<String, Object> map_list = new HashMap();
      String content = (String)map.get("content");
      String[] a = content.split("\\\n");
      List<String> list = new ArrayList();

      for(String string : a) {
         list.add(string);
      }

      map_list.put("list", list);
      map_list.put("title", map.get("fieldtitle"));
      return map_list;
   }

   @RequestMapping({"/source_isnull"})
   @ResponseBody
   public boolean source_isnull(String taskid, String tableNamePattern) {
      boolean isnull = true;
      Desensitizationsource desensitizationsource = this.desensitizationSelfTaskService.querySourceInfo(taskid);
      if (desensitizationsource.getDatasourceid() != null) {
         TCoreDatasystem tCoreDatasystemSource = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
         if (tCoreDatasystemSource == null) {
            isnull = false;
         } else {
            isnull = this.testConnect(tCoreDatasystemSource);
         }
      }

      return isnull;
   }

   @RequestMapping({"/isrepeatname"})
   @ResponseBody
   public boolean isrepeatname(String taskname) {
      if (taskname != null && !"".equals(taskname)) {
         String projectid = (String)this.request.getSession().getAttribute("projectid");
         DesensitizationSelfTask desensitizationSelfTask = this.desensitizationSelfTaskService.queryTaskByName(taskname, projectid);
         return desensitizationSelfTask == null;
      } else {
         return true;
      }
   }

   @RequestMapping({"/saveparamvalue"})
   @ResponseBody
   public void saveparamvalue(String paramvalue, String tasknamereal, String tableprefix, String tablesuffix, String version) {
      this.redisService.set(tasknamereal + "_" + "tableprefix", tableprefix == null ? "" : tableprefix);
      this.redisService.set(tasknamereal + "_" + "tablesuffix", tablesuffix == null ? "" : tablesuffix);
      this.redisService.set(tasknamereal + "_" + BatchManage.class.getSimpleName(), paramvalue);
      this.redisService.set(tasknamereal + "_" + "version", version);
   }

   public boolean testConnect(TCoreDatasystem datasource) {
      boolean isnull = true;
      String url = "";
      String driver = EdbType.getEdbTypeByDbcode(datasource.getDbtype()).getDbdriver();
      switch (datasource.getDbtype()) {
         case "INFORMIX":
            url = EdbType.getUrlByEdbcode(datasource.getDbtype(), datasource.getDbip(), datasource.getDbport(), datasource.getDbservername(), datasource.getServername());
            break;
         case "AS400":
            url = EdbType.getUrlByEdbcode(datasource.getDbtype(), datasource.getDbip(), datasource.getDbservername(), datasource.getServername());
            break;
         default:
            url = EdbType.getUrlByEdbcode(datasource.getDbtype(), datasource.getDbip(), datasource.getDbport(), datasource.getDbservername());
      }

      String password = AesTool.decrypt(datasource.getPassword(), "ghca");
      ResultVO resultvo = JdbcTool.testConnect(url, driver, datasource.getUsername(), password);
      isnull = resultvo.getResult();
      return isnull;
   }

   public String delparentheses(String type) {
      if (type.indexOf("(") == -1) {
         return type;
      } else {
         type = type.indexOf("(") == -1 ? type : type.substring(0, type.indexOf("(")) + type.substring(type.indexOf(")") + 1, type.length());
         return this.delparentheses(type);
      }
   }

   public void iskeberos(TCoreDatasystem datasystem) {
      if ("HIVE".equals(datasystem.getDbtype()) && "on".equals(datasystem.getIskerberos())) {
         System.setProperty("java.security.krb5.conf", datasystem.getXmlpath() + "/krb5.conf");
      }

   }

   @ResponseBody
   @RequestMapping({"/queryversion"})
   public List<ComboboxVO> queryversion(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<ComboboxVO> list = new ArrayList();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      File taskfile = new File(props.getProperty("TaskVersion"));
      File projectfile = new File(props.getProperty("ProjectVersion"));
      File allfile = new File(props.getProperty("AllVersion"));
      if (taskfile.listFiles() != null && taskfile.listFiles().length > 0) {
         ComboboxVO taskbox = new ComboboxVO();
         taskbox.setText("任务版本");
         list.add(taskbox);
      }

      if (projectfile.listFiles() != null && projectfile.listFiles().length > 0) {
         ComboboxVO probox = new ComboboxVO();
         probox.setText("项目版本");
         list.add(probox);
      }

      if (allfile.listFiles() != null && allfile.listFiles().length > 0) {
         ComboboxVO allbox = new ComboboxVO();
         allbox.setText("全局版本");
         list.add(allbox);
      }

      ComboboxVO allbox = new ComboboxVO();
      allbox.setText("无版本");
      list.add(allbox);
      return list;
   }

   @ResponseBody
   @RequestMapping({"/queryProVersion"})
   public List<ComboboxVO> queryProVersion(String projectid, HttpServletRequest request, HttpServletResponse response, Model model) {
      new ArrayList();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      File projectfile = new File(props.getProperty("ProjectVersion"));
      StringBuffer str = new StringBuffer();
      File[] f = projectfile.listFiles();

      for(int i = 0; i < f.length; ++i) {
         str.append("'" + f[i].getName() + "'" + ',');
      }

      List<ComboboxVO> list = this.tdataProjectService.queryProjectList(str.substring(0, str.length() - 1));
      list = (List)list.stream().filter((s) -> s.getValue().equals(projectid)).collect(Collectors.toList());
      return list;
   }

   @ResponseBody
   @RequestMapping({"/queryTaskVersion"})
   public List<HashMap<String, String>> queryTaskVersion(HttpServletRequest request, HttpServletResponse response, Model model, String taskid) {
      List<HashMap<String, String>> list = new ArrayList();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      File taskfile = new File(props.getProperty("TaskVersion") + taskid);
      File[] f = taskfile.listFiles();

      for(int i = 0; i < f.length; ++i) {
         HashMap<String, String> map = new HashMap();
         map.put("value", f[i].getName());
         String text = f[i].getName().split("\\_")[0];
         String sd = this.TimeStamp2Date(text, (String)null);
         map.put("text", sd);
         list.add(map);
      }

      return list;
   }

   public String TimeStamp2Date(String timestampString, String formats) {
      if (TextUtils.isEmpty(formats)) {
         formats = "yyyy-MM-dd HH:mm:ss";
      }

      Long timestamp = Long.parseLong(timestampString) * 1000L;
      String date = (new SimpleDateFormat(formats, Locale.CHINA)).format(new Date(timestamp));
      return date;
   }

   @RequestMapping({"/compare"})
   public String compare(String taskid, String tasktype, HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) throws SQLException {
      model.addAttribute("taskid", taskid);
      model.addAttribute("pageCurr", pageCurr);
      return "core/desensitizationselftask/desensitizationselftask_resultcompare";
   }

   @RequestMapping({"/lastmasking"})
   public String lastmasking(String taskid, String tasktype, HttpServletRequest request, HttpServletResponse response, Model model, Integer pageCurr) throws SQLException {
      model.addAttribute("taskid", taskid);
      model.addAttribute("pageCurr", pageCurr);
      return "core/desensitizationselftask/desensitizationselftask_resultlastmasking";
   }

   @ResponseBody
   @RequestMapping({"/compareMaskingResult"})
   public Map<String, Object> compareMaskingResult(String tablename, String taskid, String type, HttpServletRequest request, HttpServletResponse response, Model model) {
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      Map<String, Object> map = new HashMap();
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      DesensitizationSelfTask desensitizationtask = new DesensitizationSelfTask();
      Desensitizationtask desensitizationtask_replace = new Desensitizationtask();
      desensitizationtask = (DesensitizationSelfTask)this.redisService.get(tasknamereal + "_" + desensitizationtask.getClass().getSimpleName());
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
      if (!"1".equals(type) && !"2".equals(type)) {
         String batchmanage = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
         String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
         String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
         if (batchmanage != null) {
            desensitizationtask_replace.setBatchnumber(batchmanage);
         }

         if (tableprefix != null && !"".equals(tableprefix)) {
            desensitizationtask_replace.setTableprefix(tableprefix);
         } else {
            desensitizationtask_replace.setTableprefix("无");
         }

         if (tablesuffix != null && !"".equals(tablesuffix)) {
            desensitizationtask_replace.setTablesuffix(tablesuffix);
         } else {
            desensitizationtask_replace.setTablesuffix("无");
         }
      } else {
         desensitizationtask = this.desensitizationSelfTaskService.queryTaskById1(taskid);
         desensitizationsource = this.desensitizationSelfTaskService.querySourceInfo(taskid);
         desensitizationtarget = this.desensitizationSelfTaskService.queryTargetById(taskid);
         desensitizationtask_replace.setBatchnumber(desensitizationtask.getBatchnumber());
         desensitizationtask_replace.setTableprefix(!"".equals(desensitizationtask.getTableprefix()) && desensitizationtask.getTableprefix() != null ? desensitizationtask.getTableprefix() : "无");
         desensitizationtask_replace.setTablesuffix(!"".equals(desensitizationtask.getTablesuffix()) && desensitizationtask.getTablesuffix() != null ? desensitizationtask.getTablesuffix() : "无");
         if ("2".equals(type)) {
            String batchmanage = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
            String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
            String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
            if (batchmanage != null) {
               desensitizationtask_replace.setBatchnumber(batchmanage);
            }

            if (tableprefix != null && !"".equals(tableprefix)) {
               desensitizationtask_replace.setTableprefix(tableprefix);
            } else {
               desensitizationtask_replace.setTableprefix("无");
            }

            if (tablesuffix != null && !"".equals(tablesuffix)) {
               desensitizationtask_replace.setTablesuffix(tablesuffix);
            } else {
               desensitizationtask_replace.setTablesuffix("无");
            }
         }
      }

      desensitizationtask_replace.setTaskname(desensitizationtask.getTaskname());
      desensitizationtask_replace.setFoldername(desensitizationtask.getFoldername());
      desensitizationtask_replace.setFastexecution(desensitizationtask.getFastexecution());
      if ("1".equals(desensitizationsource.getIsdmpfile())) {
         desensitizationsource.setDataschema("");
         desensitizationtarget.setInserttype("");
      }

      map.put("desensitizationtask", desensitizationtask_replace);
      map.put("desensitizationsource", desensitizationsource);
      map.put("desensitizationtarget", desensitizationtarget);
      TCoreDatasystem tCoreDatasystem_source = null;
      TCoreDatasystem tCoreDatasystem_target = null;
      if (desensitizationsource.getDatasourceid() != null && !"".equals(desensitizationsource.getDatasourceid())) {
         tCoreDatasystem_source = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
         map.put("tCoreDatasystem_source", tCoreDatasystem_source);
      }

      if (desensitizationtarget.getDatasourceid() != null && !"".equals(desensitizationtarget.getDatasourceid())) {
         tCoreDatasystem_target = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
         map.put("tCoreDatasystem_target", tCoreDatasystem_target);
      }

      if (!"".equals(desensitizationsource.getDatasourceid()) && desensitizationsource.getDatasourceid() != null && !"".equals(desensitizationtarget.getDatasourceid()) && desensitizationtarget.getDatasourceid() != null && !tCoreDatasystem_source.getDbtype().equals(tCoreDatasystem_target.getDbtype())) {
         map.put("isSameDb", "1");
      } else {
         map.put("isSameDb", "0");
      }

      if ("".equals(desensitizationsource.getDatasourceid()) || desensitizationsource.getDatasourceid() == null || "".equals(desensitizationtarget.getDatasourceid()) || desensitizationtarget.getDatasourceid() == null) {
         map.put("isSameDb", "0");
      }

      String sourcetype = "1";
      String datasourceid_source = desensitizationsource.getDatasourceid();
      if (datasourceid_source != null && !datasourceid_source.equals("")) {
         TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid_source);
         String dbtype = tCoreDatasystem.getDbtype();
         if (dbtype.equals("FTP")) {
            sourcetype = "2";
         } else if (dbtype.equals("SFTP")) {
            sourcetype = "3";
         } else {
            sourcetype = "0";
         }
      }

      map.put("sourcetype", sourcetype);
      String targettype = "1";
      String datasourceid_target = desensitizationtarget.getDatasourceid();
      if (datasourceid_target != null && !datasourceid_target.equals("")) {
         TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid_target);
         String dbtype = tCoreDatasystem.getDbtype();
         if (dbtype.equals("FTP")) {
            targettype = "2";
         } else if (dbtype.equals("SFTP")) {
            targettype = "3";
         } else {
            targettype = "0";
         }
      }

      if ("1".equals(desensitizationsource.getIsdmpfile())) {
         String dmpImportFlg = desensitizationtarget.getDmpimport();
         if ("1".equals(dmpImportFlg)) {
            tCoreDatasystem_target = new TCoreDatasystem();
            tCoreDatasystem_target.setSysname("DMP系统");
            desensitizationtarget.setDataschema("无");
            map.put("tCoreDatasystem_target", tCoreDatasystem_target);
            targettype = "0";
         }
      }

      map.put("targettype", targettype);
      if (targettype.equals("1") || targettype.equals("2") || targettype.equals("3")) {
         DesensitizationFile desensitizationfile = new DesensitizationFile();
         if (!"1".equals(type) && !"2".equals(type)) {
            desensitizationfile = (DesensitizationFile)this.redisService.get(tasknamereal + "_" + desensitizationfile.getClass().getSimpleName());
         } else {
            desensitizationfile = this.desensitizationSelfTaskService.queryDesensitizationfileBytaskid(taskid);
         }

         map.put("desensitizationfile", desensitizationfile);
      }

      new ArrayList();
      List<Map<String ,String>> var39;
      if ("1".equals(type)) {
         if (!"".equals(tablename) && tablename != null) {
            var39 = new ArrayList();

            for(DesensitizationTable desensitizationTable : this.desensitizationSelfTaskService.queryTableList(taskid)) {
               Map<String, String> desensitizationTablemap = new HashMap();
               desensitizationTablemap.put("tableName", desensitizationTable.getTablename());
               if (desensitizationTable.getTablename().toUpperCase().contains(tablename.toUpperCase())) {
                  ((List)var39).add(desensitizationTablemap);
               }
            }
         } else {
            var39 = new ArrayList();

            for(DesensitizationTable desensitizationTable : this.desensitizationSelfTaskService.queryTableList(taskid)) {
               Map<String, String> desensitizationTablemap = new HashMap();
               desensitizationTablemap.put("tableName", desensitizationTable.getTablename());
               ((List)var39).add(desensitizationTablemap);
            }
         }
      } else {
         var39 = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         if (var39 != null) {
            var39 = (var39).stream().filter((s) -> "1".equals(s.get("status")) || "3".equals(s.get("status"))).collect(Collectors.toList());
         }
      }

      map.put("tCoreMaskingTaskTableList", var39);
      return map;
   }

   @RequestMapping({"/queryMaskingDataCompare"})
   @ResponseBody
   public List<CompareInfoVO> queryMaskingDataCompare(String taskid, String type, int curPage, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<CompareInfoVO> compareDataList = null;
      if (tablename != null && !"".equals(tablename)) {
         if (curPage > 10) {
            curPage = 10;
         }

         Integer total = 10;
         new HashMap();
         List sourceValueList = new ArrayList();
         List targetValueList = new ArrayList();
         List couumnname = new ArrayList();
         List regex = new ArrayList();
         new ArrayList();
         Desensitizationsource desensitizationsource = this.desensitizationSelfTaskService.querySourceInfo(taskid);
         Desensitizationtarget desensitizationtarget = this.desensitizationSelfTaskService.queryTargetInfo(taskid);
         String schemasource = desensitizationsource.getDataschema();
         String schematarget = desensitizationtarget.getDataschema();
         this.queryConnInfo(taskid, type, tablename, request, response, model);
         String structureid = "";
         List<ColumnInfoVO> columnInfo = this.querymultitable(structureid, taskid, type, tablename, request);
         int cnt = 0;

         for(int i = 0; i < columnInfo.size(); ++i) {
            couumnname.add(((ColumnInfoVO)columnInfo.get(i)).getColumnname());
            regex.add(((ColumnInfoVO)columnInfo.get(i)).getRegextype() != null && !"".equals(((ColumnInfoVO)columnInfo.get(i)).getRegextype()) ? ((ColumnInfoVO)columnInfo.get(i)).getRegextype() : "无");
         }

         String datacomparedir = null;

         try {
            datacomparedir = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("datacomparedir");
         } catch (IOException e1) {
            e1.printStackTrace();
         }

         String tasknamereal = this.desensitizationSelfTaskService.getTasknamereal(taskid) + "_1";
         String soupath = datacomparedir + tasknamereal + "/source/";
         String tarpath = datacomparedir + tasknamereal + "/target/";
         File soufile = new File(soupath + tablename + ".txt");
         File tarfile = new File(tarpath + tablename + ".txt");
         if (soufile.isFile() && soufile.exists()) {
            BufferedReader br = null;

            try {
               InputStreamReader isr = new InputStreamReader(new FileInputStream(soufile), "UTF-8");
               br = new BufferedReader(isr);
               String lineTxt = null;
               cnt = 0;

               while((lineTxt = br.readLine()) != null) {
                  ++cnt;
                  String[] sourcedata = lineTxt.split("~!~");
                  if (cnt == curPage) {
                     for(int j = 0; j < sourcedata.length; ++j) {
                        String onesourcedata = sourcedata[j];
                        sourceValueList.add(onesourcedata);
                     }
                     break;
                  }
               }

               br.close();
            } catch (Exception e) {
               e.printStackTrace();
            }
         } else {
            System.out.println("文件不存在!");
         }

         if (tarfile.isFile() && tarfile.exists()) {
            BufferedReader br = null;

            try {
               InputStreamReader isr = new InputStreamReader(new FileInputStream(tarfile), "UTF-8");
               br = new BufferedReader(isr);
               String lineTxt = null;
               cnt = 0;

               while((lineTxt = br.readLine()) != null) {
                  ++cnt;
                  if (cnt == curPage) {
                     String[] targetdata = lineTxt.split("~!~");

                     for(int j = 0; j < targetdata.length; ++j) {
                        String onetargetdata = targetdata[j];
                        targetValueList.add(onetargetdata);
                     }
                  }
               }

               if (cnt < total) {
                  total = cnt;
               }

               br.close();
            } catch (Exception e) {
               e.printStackTrace();
            }
         } else {
            System.out.println("文件不存在!");
         }

         CompareInfoVO compareInfoVO = null;
         if (cnt == 0) {
            compareDataList = new ArrayList();
         } else {
            compareDataList = new ArrayList();

            for(int i = 0; i < couumnname.size(); ++i) {
               compareInfoVO = new CompareInfoVO();
               compareInfoVO.setColumnname(couumnname.get(i));
               compareInfoVO.setMaskingrulename(regex.get(i));
               compareInfoVO.setSourcedata(sourceValueList.get(i));
               compareInfoVO.setTargetdata(targetValueList.get(i));
               compareInfoVO.setTotal((long)total);
               compareDataList.add(compareInfoVO);
            }
         }

         return compareDataList;
      } else {
         return null;
      }
   }

   @ResponseBody
   @RequestMapping({"/queryConnInfo"})
   public List<TCoreDatasystem> queryConnInfo(String taskid, String type, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreDatasystem> connInfo = new ArrayList();
      String tasknamereal = (String)request.getSession().getAttribute("tasknamereal");
      Desensitizationtarget desensitizationtarget = new Desensitizationtarget();
      Desensitizationsource desensitizationsource = new Desensitizationsource();
      DesensitizationSelfTask desensitizationtask = new DesensitizationSelfTask();
      Desensitizationtask desensitizationtask_replace = new Desensitizationtask();
      desensitizationtask = (DesensitizationSelfTask)this.redisService.get(tasknamereal + "_" + desensitizationtask.getClass().getSimpleName());
      desensitizationsource = (Desensitizationsource)this.redisService.get(tasknamereal + "_" + desensitizationsource.getClass().getSimpleName());
      desensitizationtarget = (Desensitizationtarget)this.redisService.get(tasknamereal + "_" + desensitizationtarget.getClass().getSimpleName());
      if (!"1".equals(type) && !"2".equals(type)) {
         String batchmanage = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
         String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
         String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
         if (batchmanage != null) {
            desensitizationtask_replace.setBatchnumber(batchmanage);
         }

         if (tableprefix != null && !"".equals(tableprefix)) {
            desensitizationtask_replace.setTableprefix(tableprefix);
         } else {
            desensitizationtask_replace.setTableprefix("无");
         }

         if (tablesuffix != null && !"".equals(tablesuffix)) {
            desensitizationtask_replace.setTablesuffix(tablesuffix);
         } else {
            desensitizationtask_replace.setTablesuffix("无");
         }
      } else {
         desensitizationtask = this.desensitizationSelfTaskService.queryTaskById1(taskid);
         desensitizationsource = this.desensitizationSelfTaskService.querySourceInfo(taskid);
         desensitizationtarget = this.desensitizationSelfTaskService.queryTargetById(taskid);
         desensitizationtask_replace.setBatchnumber(desensitizationtask.getBatchnumber());
         desensitizationtask_replace.setTableprefix(!"".equals(desensitizationtask.getTableprefix()) && desensitizationtask.getTableprefix() != null ? desensitizationtask.getTableprefix() : "无");
         desensitizationtask_replace.setTablesuffix(!"".equals(desensitizationtask.getTablesuffix()) && desensitizationtask.getTablesuffix() != null ? desensitizationtask.getTablesuffix() : "无");
         if ("2".equals(type)) {
            String batchmanage = (String)this.redisService.get(tasknamereal + "_" + BatchManage.class.getSimpleName());
            String tableprefix = (String)this.redisService.get(tasknamereal + "_" + "tableprefix");
            String tablesuffix = (String)this.redisService.get(tasknamereal + "_" + "tablesuffix");
            if (batchmanage != null) {
               desensitizationtask_replace.setBatchnumber(batchmanage);
            }

            if (tableprefix != null && !"".equals(tableprefix)) {
               desensitizationtask_replace.setTableprefix(tableprefix);
            } else {
               desensitizationtask_replace.setTableprefix("无");
            }

            if (tablesuffix != null && !"".equals(tablesuffix)) {
               desensitizationtask_replace.setTablesuffix(tablesuffix);
            } else {
               desensitizationtask_replace.setTablesuffix("无");
            }
         }
      }

      desensitizationtask_replace.setTaskname(desensitizationtask.getTaskname());
      desensitizationtask_replace.setFoldername(desensitizationtask.getFoldername());
      desensitizationtask_replace.setFastexecution(desensitizationtask.getFastexecution());
      if ("1".equals(desensitizationsource.getIsdmpfile())) {
         desensitizationsource.setDataschema("");
         desensitizationtarget.setInserttype("");
      }

      TCoreDatasystem tCoreDatasystem_source = null;
      TCoreDatasystem tCoreDatasystem_target = null;
      if (desensitizationsource.getDatasourceid() != null && !"".equals(desensitizationsource.getDatasourceid())) {
         tCoreDatasystem_source = this.dataSystemService.queryDataSystemById(desensitizationsource.getDatasourceid());
         connInfo.add(tCoreDatasystem_source);
      }

      if (desensitizationtarget.getDatasourceid() != null && !"".equals(desensitizationtarget.getDatasourceid())) {
         tCoreDatasystem_target = this.dataSystemService.queryDataSystemById(desensitizationtarget.getDatasourceid());
         connInfo.add(tCoreDatasystem_target);
      }

      String sourcetype = "1";
      String datasourceid_source = desensitizationsource.getDatasourceid();
      if (datasourceid_source != null && !datasourceid_source.equals("")) {
         TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid_source);
         String dbtype = tCoreDatasystem.getDbtype();
         if (dbtype.equals("FTP")) {
            sourcetype = "2";
         } else if (dbtype.equals("SFTP")) {
            sourcetype = "3";
         } else {
            sourcetype = "0";
         }
      }

      String targettype = "1";
      String datasourceid_target = desensitizationtarget.getDatasourceid();
      if (datasourceid_target != null && !datasourceid_target.equals("")) {
         TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemById(datasourceid_target);
         String dbtype = tCoreDatasystem.getDbtype();
         if (dbtype.equals("FTP")) {
            targettype = "2";
         } else if (dbtype.equals("SFTP")) {
            targettype = "3";
         } else {
            targettype = "0";
         }
      }

      if ("1".equals(desensitizationsource.getIsdmpfile())) {
         String dmpImportFlg = desensitizationtarget.getDmpimport();
         if ("1".equals(dmpImportFlg)) {
            tCoreDatasystem_target = new TCoreDatasystem();
            tCoreDatasystem_target.setSysname("DMP系统");
            desensitizationtarget.setDataschema("无");
            targettype = "0";
         }
      }

      if (targettype.equals("1") || targettype.equals("2") || targettype.equals("3")) {
         DesensitizationFile desensitizationfile = new DesensitizationFile();
         if (!"1".equals(type) && !"2".equals(type)) {
            desensitizationfile = (DesensitizationFile)this.redisService.get(tasknamereal + "_" + desensitizationfile.getClass().getSimpleName());
         } else {
            this.desensitizationSelfTaskService.queryDesensitizationfileBytaskid(taskid);
         }
      }

      new ArrayList();
      if ("1".equals(type)) {
         if (!"".equals(tablename) && tablename != null) {
            List<Map<String, String>> var45 = new ArrayList();

            for(DesensitizationTable desensitizationTable : this.desensitizationSelfTaskService.queryTableList(taskid)) {
               Map<String, String> desensitizationTablemap = new HashMap();
               desensitizationTablemap.put("tableName", desensitizationTable.getTablename());
               if (desensitizationTable.getTablename().toUpperCase().contains(tablename.toUpperCase())) {
                  var45.add(desensitizationTablemap);
               }
            }
         } else {
            List<Map<String, String>> var44 = new ArrayList();

            for(DesensitizationTable desensitizationTable : this.desensitizationSelfTaskService.queryTableList(taskid)) {
               Map<String, String> desensitizationTablemap = new HashMap();
               desensitizationTablemap.put("tableName", desensitizationTable.getTablename());
               var44.add(desensitizationTablemap);
            }
         }
      } else {
         List<Map<String, String>> var46 = (List)request.getSession().getAttribute("tableList_" + tasknamereal);
         if (var46 != null) {
            var46 = (List)var46.stream().filter((s) -> "1".equals(s.get("status")) || "3".equals(s.get("status"))).collect(Collectors.toList());
         }
      }

      return connInfo;
   }

   @RequestMapping({"/queryMaskingCouumnName"})
   @ResponseBody
   public List<String> queryMaskingCouumnName(String taskid, String type, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      if (tablename != null && !"".equals(tablename)) {
         List couumnname = new ArrayList();
         String structureid = "";
         List<ColumnInfoVO> columnInfo = this.querymultitable(structureid, taskid, type, tablename, request);
         int cnt = 0;

         for(int i = 0; i < columnInfo.size(); ++i) {
            couumnname.add(((ColumnInfoVO)columnInfo.get(i)).getColumnname());
         }

         return couumnname;
      } else {
         return null;
      }
   }

   @RequestMapping({"/queryMaskingDataLastMasking"})
   @ResponseBody
   public DataGridVO<JSONArray> queryMaskingDataLastMasking(String taskid, String type, Integer page, Integer rows, PageInfo pageInfo, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<String> compareDataList = null;
      if (tablename != null && !"".equals(tablename)) {
         new HashMap();
         new ArrayList();
         List couumnname = new ArrayList();
         new ArrayList();
         new ArrayList();
         Desensitizationsource desensitizationsource = this.desensitizationSelfTaskService.querySourceInfo(taskid);
         Desensitizationtarget desensitizationtarget = this.desensitizationSelfTaskService.queryTargetInfo(taskid);
         DesensitizationSelfTask desensitizationtask = this.desensitizationSelfTaskService.queryTaskById1(taskid);
         String schemasource = desensitizationsource.getDataschema();
         String schematarget = desensitizationtarget.getDataschema();
         this.queryConnInfo(taskid, type, tablename, request, response, model);
         String structureid = "";
         List<ColumnInfoVO> columnInfo = this.querymultitable(structureid, taskid, type, tablename, request);

         for(int i = 0; i < columnInfo.size(); ++i) {
            couumnname.add(((ColumnInfoVO)columnInfo.get(i)).getColumnname());
         }

         String lastmaskingdir = null;

         try {
            lastmaskingdir = PropertiesLoaderUtils.loadAllProperties("config.properties").getProperty("lastmaskingdir");
         } catch (IOException e1) {
            e1.printStackTrace();
         }

         String soupath = lastmaskingdir + desensitizationtask.getTasknamereal();
         File soufile = new File(soupath + "/" + tablename + ".txt");
         StringBuilder sb = new StringBuilder();
         sb.append("{\"column\":[");
         if (soufile.isFile() && soufile.exists()) {
            BufferedReader br = null;

            try {
               InputStreamReader isr = new InputStreamReader(new FileInputStream(soufile), "UTF-8");
               br = new BufferedReader(isr);
               String lineTxt = null;

               while((lineTxt = br.readLine()) != null) {
                  sb.append("{");
                  String[] sourcedata = lineTxt.split("~!~");

                  for(int j = 0; j < sourcedata.length; ++j) {
                     String onesourcedata = sourcedata[j];
                     if (j == couumnname.size() - 1) {
                        sb.append("\"" + couumnname.get(j) + "\":").append("\"" + onesourcedata + "\"");
                     } else {
                        sb.append("\"" + couumnname.get(j) + "\":").append("\"" + onesourcedata + "\",");
                     }
                  }

                  sb.append("},");
               }

               br.close();
            } catch (Exception e) {
               e.printStackTrace();
            }
         } else {
            System.out.println("文件不存在!");
         }

         sb.append("]}");
         JSONObject param = JSONObject.fromObject(sb.toString());
         JSONArray jsonArray = param.getJSONArray("column");
         JSONArray reultJsonArray = new JSONArray();

         for(int i = rows * (page - 1); i < jsonArray.size() && i <= rows * page - 1; ++i) {
            reultJsonArray.add(jsonArray.get(i));
         }

         DataGridVO<JSONArray> reult = new DataGridVO<JSONArray>((long)jsonArray.size(), reultJsonArray);
         return reult;
      } else {
         return null;
      }
   }
}
