package com.chenyang.nse.bussiness.controller.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.StringUtil;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUser;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleSearchregex;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivegroup;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitiverelation;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivetablelog;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TCoreFieldSensitiveMemory;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryCondition;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryResultsRecord;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoverySensitivecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryVersrion;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreTaskFindrule;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.project.TCoreProjectInfo;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DBTableVO;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.ProgressInfo;
import com.chenyang.nse.bussiness.entity.vo.RegexTypeColorVO;
import com.chenyang.nse.bussiness.entity.vo.Releasecolumn;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.entity.vo.SensitiveColumn;
import com.chenyang.nse.bussiness.entity.vo.SenstiveColumnRelationVO;
import com.chenyang.nse.bussiness.entity.vo.TreeGridRegexVO;
import com.chenyang.nse.bussiness.entity.vo.TreeGridSensitiveDataVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreDataFileGroupVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreProjectFindruleVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.DataSystemProjectVO;
import com.chenyang.nse.bussiness.entity.vo.searchinfo.SearchRegexVO;
import com.chenyang.nse.bussiness.entity.vo.searchinfo.SearchinfoVO;
import com.chenyang.nse.bussiness.service.console.DictionaryService;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.console.SearchRegexService;
import com.chenyang.nse.bussiness.service.core.CoreProjectService;
import com.chenyang.nse.bussiness.service.core.CurrencyService;
import com.chenyang.nse.bussiness.service.core.DataScopeService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.DiscoveryConditionService;
import com.chenyang.nse.bussiness.service.core.DiscoveryResultsRecordService;
import com.chenyang.nse.bussiness.service.core.DiscoverySensitivecolumnService;
import com.chenyang.nse.bussiness.service.core.DiscoveryVersrionService;
import com.chenyang.nse.bussiness.service.core.ImportMaskingRuleService;
import com.chenyang.nse.bussiness.service.core.MaskingRuleService;
import com.chenyang.nse.bussiness.service.core.SensitiveColumnService;
import com.chenyang.nse.bussiness.service.core.TdataDiscoveryService;
import com.chenyang.nse.bussiness.service.core.dataproject.DiscoverytaskService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import com.chenyang.nse.bussiness.tools.datatime.DateTimeTool;
import com.chenyang.nse.bussiness.tools.dmp.DmpDpTool;
import com.chenyang.nse.bussiness.tools.dmp.DmpTool;
import com.chenyang.nse.bussiness.tools.dmp.MultipleDmpDpTool;
import com.chenyang.nse.bussiness.tools.dmp.MultipleDmpTool;
import com.chenyang.nse.bussiness.tools.dmp.TableStructureInfo;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.object.JsonTool;
import com.chenyang.nse.bussiness.tools.office.ExcelTool;
import com.chenyang.nse.bussiness.tools.other.PageTool;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping({"/core/searchsensitivedata"})
public class SearchSensitiveDataController {
   @Autowired
   private SensitiveColumnService sensitiveColumnService;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private SearchRegexService searchRegexService;
   @Autowired
   private DictionaryService dictionaryService;
   @Autowired
   private CurrencyService currencyService;
   @Autowired
   private ImportMaskingRuleService maskingRuleService;
   @Autowired
   private MaskingRuleService ruleService;
   @Autowired
   private DiscoveryConditionService discoveryConditionService;
   @Autowired
   private DiscoverytaskService discoverytaskService;
   @Autowired
   private DiscoverySensitivecolumnService discoverySensitivecolumnService;
   @Autowired
   private DiscoveryVersrionService discoveryVersrionService;
   @Autowired
   private DiscoveryResultsRecordService discoveryResultsRecordService;
   @Autowired
   private OperationService operationService;
   @Autowired
   private RedisService redisService;
   @Autowired
   private CoreProjectService coreProjectService;
   @Autowired
   private TdataDiscoveryService tdataDiscoveryService;
   @Autowired
   private DataScopeService dataScopeService;
   private static final String Link_character = "_";
   public static List<String> typelist_buffer = null;
   public static List<String> namelist_buffer = null;
   public static List<String> regexlist_buffer = null;

   @RequestMapping
   public String index(String groupid, HttpServletRequest request, HttpServletResponse response, Model model) {
      model.addAttribute("groupid", groupid);
      String groupName = "";
      if (StringUtils.isNotBlank(groupid)) {
         groupName = this.sensitiveColumnService.getGroupNameByID(groupid);
      }

      model.addAttribute("groupName", groupName);
      return "core/searchsensitivedata/searchsensitivedata";
   }

   @RequestMapping({"/cesi"})
   public String cesi(String groupid, HttpServletRequest request, HttpServletResponse response, Model model) {
      model.addAttribute("groupid", groupid);
      return "core/searchsensitivedata/searchsensitivedata2";
   }

   @RequestMapping({"/searchByName"})
   @ResponseBody
   public String searchByName(String samplingtype, String aifind, String jiegou, String groupId, String datasystemid, @RequestParam("schemas[]") List<String> schemas, @RequestParam("typelist[]") List<String> typelist, @RequestParam("namelist[]") List<String> namelist, @RequestParam("regexlist[]") List<String> regexlist, HttpServletRequest request, HttpServletResponse response, Model model) {
      long startTime = System.currentTimeMillis();
      HttpSession session = request.getSession();
      if (session == null) {
         return "1";
      } else {
         ProgressInfo progressInfo = new ProgressInfo(-1L);
         session.setAttribute("progressInfo", progressInfo);
         session.setAttribute("datasystemid", datasystemid);
         session.setAttribute("schemas", schemas);
         session.setAttribute("namelist", namelist);
         session.setAttribute("typelist", typelist);
         session.setAttribute("regexlist", regexlist);
         session.setAttribute("type", "name");
         session.setAttribute("jiegou", jiegou);
         session.setAttribute("samplingtype", samplingtype);
         session.setAttribute("aifind", aifind);
         TCoreDatasystem datasystem = this.dataSystemService.queryDataSystemById(datasystemid);
         List<TConsoleSearchregex> searchRegexList = this.transformSearchRegex(typelist, namelist, regexlist);
         this.searchRegexService.setYearNow();
         int queren = 0;
         this.searchRegexService.init();
         new HashMap();
         Map tableColumns;
         if (datasystem.getFlag().equals("2")) {
            tableColumns = this.searchRegexService.getAllFileColumnsByName(jiegou, datasystem, schemas, searchRegexList, progressInfo);
         } else {
            tableColumns = this.searchRegexService.getAllTableColumnsByName(queren, samplingtype, aifind, datasystem, schemas, searchRegexList, progressInfo);
         }

         session.setAttribute("queren", queren);
         List<TreeGridSensitiveDataVO> result = this.transformSearchResult(session, groupId, datasystemid, tableColumns);
         int listCount = 1;
         String s = request.getSession().getId();
         request.getSession().setAttribute("sensitiveFlag", s);
         String setKey = "";
         this.redisService.remove("sensitive:" + s);
         long id = 1L;
         List<Map<String, String>> schameTableList = new ArrayList();

         for(TreeGridSensitiveDataVO treeGridSensitiveDataVO : result) {
            Map<String, String> map = new HashMap();
            map.put("id", id++ + "");
            map.put("text", treeGridSensitiveDataVO.getSchema() + "-" + treeGridSensitiveDataVO.getName());
            schameTableList.add(map);
            setKey = treeGridSensitiveDataVO.getSchema() + "-" + treeGridSensitiveDataVO.getName();

            try {
               this.redisService.set(setKey, treeGridSensitiveDataVO, new Long(86400L));
               this.redisService.zAdd("sensitive:" + s, setKey, (double)(listCount++), new Long(86400L));
            } catch (Exception e) {
               e.printStackTrace();
            }
         }

         request.getSession().setAttribute("schameTable", JsonTool.toJsonString(schameTableList));
         new SearchinfoVO();
         SearchinfoVO var34 = (SearchinfoVO)this.redisService.get("searchinfoVO");
         long endTime = System.currentTimeMillis();
         String search_run_time = DateTimeTool.formatDuring(endTime - startTime);
         var34.setSearch_run_time(search_run_time);
         this.redisService.set("searchinfoVO", var34);
         return "0";
      }
   }

   @RequestMapping({"/querySaveRateOfProgress"})
   @ResponseBody
   public Object querySaveRateOfProgress(boolean complete, HttpServletRequest request, HttpServletResponse response, Model model) {
      HttpSession session = request.getSession();
      if (complete) {
         session.setAttribute("saveProgressInfo", null);
         return "1";
      } else {
         return session.getAttribute("saveProgressInfo");
      }
   }

   @RequestMapping({"/queryRateOfProgress"})
   @ResponseBody
   public Object queryRateOfProgress(boolean complete, HttpServletRequest request, HttpServletResponse response, Model model) {
      HttpSession session = request.getSession();
      if (complete) {
         session.setAttribute("progressInfo", null);
         return "1";
      } else {
         return session.getAttribute("progressInfo");
      }
   }

   @RequestMapping({"/searchByContent"})
   @ResponseBody
   public String searchByContent(String multiDempFile, String samplingtype, String aifind, String jiegou, String groupId, long maxRowCount, double rate, String datasystemid, @RequestParam("schemas[]") List<String> schemas, @RequestParam("typelist[]") List<String> typelist, @RequestParam("namelist[]") List<String> namelist, @RequestParam("regexlist[]") List<String> regexlist, @RequestParam("isdmpFlag") String isdmpFlag, @RequestParam("dmptype") String dmptype, HttpServletRequest request, HttpServletResponse response, Model model) {
      request.getSession().removeAttribute("releasecolumnrightlist");
      long startTime = System.currentTimeMillis();
      HttpSession session = request.getSession();
      new ArrayList();
      if (session == null) {
         return "1";
      } else {
         ProgressInfo progressInfo = new ProgressInfo(-1L);
         session.setAttribute("progressInfo", progressInfo);
         session.setAttribute("maxRowCount", String.valueOf(maxRowCount));
         session.setAttribute("rate", String.valueOf(rate));
         session.setAttribute("datasystemid", datasystemid);
         session.setAttribute("schemas", schemas);
         session.setAttribute("namelist", namelist);
         session.setAttribute("typelist", typelist);
         session.setAttribute("regexlist", regexlist);
         session.setAttribute("type", "content");
         session.setAttribute("jiegou", jiegou);
         session.setAttribute("samplingtype", samplingtype);
         session.setAttribute("aifind", aifind);
         TCoreDatasystem datasystem;
         if (isdmpFlag.equals("1")) {
            datasystem = new TCoreDatasystem();
            datasystem.setDbtype("ORCLE-DMP");
            datasystem.setFlag("4");
         } else {
            datasystem = this.dataSystemService.queryDataSystemById(datasystemid);
         }

         List<TConsoleSearchregex> searchRegexList = this.transformSearchRegex(typelist, namelist, regexlist);
         this.searchRegexService.setYearNow();
         this.searchRegexService.init();
         int queren = 0;
         new HashMap();
         Map tableColumns;
         if (datasystem.getFlag().equals("2")) {
            tableColumns = this.searchRegexService.getAllFileColumnsByContent(jiegou, datasystem, schemas, maxRowCount, rate, searchRegexList, progressInfo);
         } else if (datasystem.getFlag().equals("4")) {
            tableColumns = this.searchRegexService.getAlldmpTableColumnsByContent(multiDempFile, queren, samplingtype, aifind, datasystem, schemas, maxRowCount, rate, searchRegexList, progressInfo, datasystemid, dmptype);
         } else {
            tableColumns = this.searchRegexService.getAllTableColumnsByContent(queren, samplingtype, aifind, datasystem, schemas, maxRowCount, rate, searchRegexList, progressInfo, datasystemid);
         }

         session.setAttribute("queren", queren);
         List<TreeGridSensitiveDataVO> result = this.transformSearchResult(session, groupId, datasystemid, tableColumns);
         int listCount = 1;
         String s = request.getSession().getId();
         request.getSession().setAttribute("sensitiveFlag", s);
         String setKey = "";
         this.redisService.remove("sensitive:" + s);
         long id = 1L;
         List<Map<String, String>> schameTableList = new ArrayList();

         for(TreeGridSensitiveDataVO treeGridSensitiveDataVO : result) {
            Map<String, String> map = new HashMap();
            map.put("id", id++ + "");
            map.put("text", treeGridSensitiveDataVO.getSchema() + "-" + treeGridSensitiveDataVO.getName());
            schameTableList.add(map);
            setKey = treeGridSensitiveDataVO.getSchema() + "-" + treeGridSensitiveDataVO.getName();

            try {
               this.redisService.set(setKey, treeGridSensitiveDataVO, new Long(86400L));
               this.redisService.zAdd("sensitive:" + s, setKey, (double)(listCount++), new Long(86400L));
               if (isdmpFlag.equals("1")) {
                  this.redisService.set(groupId + "_" + "findisdmpFlag", isdmpFlag);
                  this.redisService.set(groupId + "_" + "finddmptype", dmptype);
                  this.redisService.set(groupId + "_" + "findmultidmptype", multiDempFile);
               }
            } catch (Exception e) {
               e.printStackTrace();
            }
         }

         request.getSession().setAttribute("schameTable", JsonTool.toJsonString(schameTableList));
         new SearchinfoVO();
         SearchinfoVO var42 = (SearchinfoVO)this.redisService.get("searchinfoVO");
         long endTime = System.currentTimeMillis();
         String search_run_time = DateTimeTool.formatDuring(endTime - startTime);
         var42.setSearch_run_time(search_run_time);
         this.redisService.set("searchinfoVO", var42);
         return "0";
      }
   }

   @RequestMapping({"/searchByGroup"})
   @ResponseBody
   public String searchByGroup(String multiDempFile, String groupId, String aifind, HttpServletRequest request, HttpServletResponse response, Model model) {
      long startTime = System.currentTimeMillis();
      List<TcoreDiscoveryCondition> list = this.discoveryConditionService.queryDiscoveryConditionByTaskId(groupId);
      String issmart = "";
      String samplingtype = "";
      String datasystemid = "";
      String type = "";
      long maxRowCount = 0L;
      double rate = (double)0.0F;
      String jiegou = "";
      List<String> schemas = new ArrayList();
      List<String> typelist = new ArrayList();
      List<String> namelist = new ArrayList();
      List<String> regexlist = new ArrayList();

      for(TcoreDiscoveryCondition log : list) {
         switch (log.getParameterid()) {
            case 1:
               datasystemid = log.getParametercontent();
               break;
            case 2:
               schemas.add(log.getParametercontent());
               break;
            case 3:
               try {
                  maxRowCount = Long.parseLong(log.getParametercontent());
               } catch (Exception var41) {
                  maxRowCount = 1000L;
               }
               break;
            case 4:
               try {
                  rate = Double.parseDouble(log.getParametercontent());
               } catch (Exception var40) {
                  rate = (double)80.0F;
               }
               break;
            case 5:
               typelist.add(log.getParametercontent());
               break;
            case 6:
               namelist.add(log.getParametercontent());
               break;
            case 7:
               regexlist.add(log.getParametercontent());
               break;
            case 8:
               type = log.getParametercontent();
               break;
            case 9:
               jiegou = log.getParametercontent();
               break;
            case 10:
               issmart = log.getParametercontent();
               break;
            case 11:
               samplingtype = log.getParametercontent();
         }
      }

      HttpSession session = request.getSession();
      if (session == null) {
         return "1";
      } else {
         ProgressInfo progressInfo = new ProgressInfo(-1L);
         session.setAttribute("progressInfo", progressInfo);
         session.setAttribute("maxRowCount", maxRowCount);
         session.setAttribute("rate", rate);
         session.setAttribute("datasystemid", datasystemid);
         session.setAttribute("schemas", schemas);
         session.setAttribute("namelist", namelist);
         session.setAttribute("typelist", typelist);
         session.setAttribute("regexlist", regexlist);
         session.setAttribute("type", type);
         session.setAttribute("jiegou", jiegou);
         session.setAttribute("samplingtype", samplingtype);
         session.setAttribute("aifind", aifind);
         TCoreDatasystem datasystem;
         if ("1".equals(this.discoverytaskService.get(groupId).getIsdmpflag())) {
            datasystem = new TCoreDatasystem();
            datasystem.setDbtype("ORCLE-DMP");
            datasystem.setFlag("4");
         } else {
            datasystem = this.dataSystemService.queryDataSystemById(datasystemid);
         }

         List<TConsoleSearchregex> searchRegexList = this.transformSearchRegex(typelist, namelist, regexlist);
         this.searchRegexService.setYearNow();
         this.searchRegexService.init();
         Map<String, List<SensitiveColumn>> tableColumns = new HashMap();
         int queren = 0;
         if (type.equals("content")) {
            if (datasystem.getFlag().equals("2")) {
               tableColumns = this.searchRegexService.getAllFileColumnsByContent(jiegou, datasystem, schemas, maxRowCount, rate, searchRegexList, progressInfo);
            } else if (datasystem.getFlag().equals("4")) {
               tableColumns = this.searchRegexService.getAlldmpTableColumnsByContent(this.discoverytaskService.get(groupId).getMultidmptype(), queren, samplingtype, aifind, datasystem, schemas, maxRowCount, rate, searchRegexList, progressInfo, datasystemid, this.discoverytaskService.get(groupId).getDmptype());
            } else {
               tableColumns = this.searchRegexService.getAllTableColumnsByContent(queren, samplingtype, aifind, datasystem, schemas, maxRowCount, rate, searchRegexList, progressInfo, datasystemid);
            }
         } else if (type.equals("name")) {
            if (datasystem.getFlag().equals("2")) {
               tableColumns = this.searchRegexService.getAllFileColumnsByName(jiegou, datasystem, schemas, searchRegexList, progressInfo);
            } else {
               tableColumns = this.searchRegexService.getAllTableColumnsByName(queren, samplingtype, aifind, datasystem, schemas, searchRegexList, progressInfo);
            }
         }

         session.setAttribute("queren", queren);
         List<TreeGridSensitiveDataVO> result = this.transformSearchResult(session, groupId, datasystemid, tableColumns);
         int listCount = 1;
         String s = request.getSession().getId();
         request.getSession().setAttribute("sensitiveFlag", s);
         String setKey = "";
         this.redisService.remove("sensitive:" + s);
         long id = 1L;
         List<Map<String, String>> schameTableList = new ArrayList();

         for(TreeGridSensitiveDataVO treeGridSensitiveDataVO : result) {
            Map<String, String> map = new HashMap();
            map.put("id", id++ + "");
            map.put("text", treeGridSensitiveDataVO.getSchema() + "-" + treeGridSensitiveDataVO.getName());
            schameTableList.add(map);
            setKey = treeGridSensitiveDataVO.getSchema() + "-" + treeGridSensitiveDataVO.getName();
            this.redisService.set(setKey, treeGridSensitiveDataVO, new Long(86400L));
            this.redisService.zAdd("sensitive:" + s, setKey, (double)(listCount++), new Long(86400L));
         }

         request.getSession().setAttribute("schameTable", JsonTool.toJsonString(schameTableList));
         new SearchinfoVO();
         SearchinfoVO var46 = (SearchinfoVO)this.redisService.get("searchinfoVO");
         long endTime = System.currentTimeMillis();
         String search_run_time = DateTimeTool.formatDuring(endTime - startTime);
         var46.setSearch_run_time(search_run_time);
         this.redisService.set("searchinfoVO", var46);
         return "0";
      }
   }

   private List<TConsoleSearchregex> transformSearchRegex(List<String> typelist, List<String> namelist, List<String> regexlist) {
      List<TConsoleSearchregex> searchRegexList = new ArrayList();

      for(int i = 0; i < typelist.size(); ++i) {
         searchRegexList.add(new TConsoleSearchregex((String)typelist.get(i), (String)namelist.get(i), ((String)regexlist.get(i)).replace("，", ",")));
      }

      return searchRegexList;
   }

   private List<TreeGridSensitiveDataVO> transformSearchResult(HttpSession session, String groupId, String datasystemid, Map<String, List<SensitiveColumn>> tableColumns) {
      String datatime = String.valueOf(System.currentTimeMillis());
      List<TCoreMaskingRule> tcoreMaskingRule = this.ruleService.queryRuleByFlag();
      HashMap<String, String> hname = new HashMap();
      HashMap<String, String> hid = new HashMap();

      for(int i = 0; i < tcoreMaskingRule.size(); ++i) {
         hid.put(((TCoreMaskingRule)tcoreMaskingRule.get(i)).getRulegroupname(), ((TCoreMaskingRule)tcoreMaskingRule.get(i)).getId());
         hname.put(((TCoreMaskingRule)tcoreMaskingRule.get(i)).getRulegroupname(), ((TCoreMaskingRule)tcoreMaskingRule.get(i)).getRulename());
      }

      hid.put("确认非敏感字段", "确认非敏感字段");
      hname.put("确认非敏感字段", "确认非敏感字段");
      List<TreeGridSensitiveDataVO> sensitiveDataList = new ArrayList();
      List<TreeGridSensitiveDataVO> partSensitiveDataList = new ArrayList();
      List<TreeGridSensitiveDataVO> partCheckedDataList = new ArrayList();
      List<TreeGridSensitiveDataVO> allCheckedDataList = new ArrayList();
      List<TreeGridSensitiveDataVO> notSensitiveDataList = new ArrayList();
      new HashMap();
      List<TcoreDiscoverySensitivecolumn> list = new ArrayList();
      if (groupId != null && !"".equals(groupId)) {
         TcoreDiscoveryTask task = this.discoverytaskService.get(groupId);
         String version = task.getCurversion();
         list = this.discoverySensitivecolumnService.querySensitiveColumnsByGroupIdByVersionByCheck(groupId, version, "1");
      }

      HashMap<String, String> querenstate = new HashMap();

      for(TcoreDiscoverySensitivecolumn tcoreDiscoverySensitivecolumn : list) {
         String key = tcoreDiscoverySensitivecolumn.getTschema() + tcoreDiscoverySensitivecolumn.getTablename() + tcoreDiscoverySensitivecolumn.getColumnname();
         querenstate.put(key, "1");
      }

      long sensitiveColumnCountall = 0L;
      long columnCountall = 0L;
      long search_sensitive_number = 0L;
      long sure_sensitive_number = 0L;

      for(Map.Entry<String, List<SensitiveColumn>> entry : tableColumns.entrySet()) {
         String tableName = "";
         if (null != entry.getKey() && ((String)entry.getKey()).split("#_#").length > 0 && ((String)entry.getKey()).contains("#_#")) {
            tableName = ((String)entry.getKey()).split("#_#")[1];
         } else {
            tableName = (String)entry.getKey();
         }

         TreeGridSensitiveDataVO table = new TreeGridSensitiveDataVO(tableName, "closed", new ArrayList());
         List<TreeGridSensitiveDataVO> sensitiveColumns = new ArrayList();
         List<TreeGridSensitiveDataVO> partSensitiveColumns = new ArrayList();
         List<TreeGridSensitiveDataVO> notSensitiveColumns = new ArrayList();
         List<TreeGridSensitiveDataVO> checkedSensitiveColumns = new ArrayList();
         List<TreeGridSensitiveDataVO> checkedColumns = new ArrayList();
         SensitiveColumn firstColumn = (SensitiveColumn)((List)entry.getValue()).get(0);
         table.setDatasourceid(firstColumn.getDatasourceid());
         table.setDatasourcename(firstColumn.getDatasourcename());
         table.setSchema(firstColumn.getSchema());
         table.setIsfile(firstColumn.getIsfile());
         long sensitiveColumnCount = 0L;

         List<SensitiveColumn> listNew = (List)entry.getValue();
         for(SensitiveColumn column : listNew) {
            ++columnCountall;
            TCoreSensitivecolumn oldColumn = null;
            String columnname = column.getColumnName();
            String tablename = table.getName();
            String state = "open";
            String regexType = column.getRegexType() == null ? "" : column.getRegexType();
            String regexName = column.getRegexName();
            String columnId = null;
            String ruleId = column.getRuleId() == null ? (String)hid.get(column.getRegexType()) : column.getRuleId();
            String ruleName = column.getRuleName() == null ? (String)hname.get(column.getRegexType()) : column.getRuleName();
            String isIntelligent = column.getIsIntelligent();
            String columnChecked = querenstate.get(column.getSchema() + column.getTableName() + column.getColumnName()) == null ? "0" : "1";
            if ("1".equals(columnChecked)) {
               ++sure_sensitive_number;
            }

            String datasourceid = column.getDatasourceid();
            long totalCount = column.getTotalCount();
            long validCount = column.getValidCount();
            long matchCount = column.getMatchCount();
            long distinctCount = column.getDistinctCount();
            TreeGridSensitiveDataVO child = new TreeGridSensitiveDataVO(columnname, tablename, state, regexType, columnId, ruleId, ruleName, regexName, columnChecked, totalCount, validCount, matchCount, distinctCount, column.getMatchValues(), column.getNotMatchValues());
            child.setIsIntelligent(column.getIsIntelligent());
            child.setKey(datatime);
            child.setIsshowdata(column.getIsshowdata());
            child.setDatasourceid(datasourceid);
            if (ruleId != null && !ruleId.equals("") && !ruleId.equals("确认非敏感字段")) {
               sensitiveColumns.add(child);
               ++sensitiveColumnCount;
               ++sensitiveColumnCountall;
            } else if (column.getMatchCount() > 0L) {
               child.setMatchCount("0");
               matchCount = 0L;
               child.setMatchRate("0");
               partSensitiveColumns.add(child);
            } else {
               notSensitiveColumns.add(child);
            }
         }

         Collections.sort(sensitiveColumns);
         Collections.sort(partSensitiveColumns);
         Collections.sort(checkedSensitiveColumns);
         Collections.sort(checkedColumns);
         Collections.sort(notSensitiveColumns);
         if (sensitiveColumns.size() > 0) {
            sensitiveDataList.add(table);
            table.setState("open");
         } else if (partSensitiveColumns.size() > 0) {
            partSensitiveDataList.add(table);
            table.setState("open");
            table.setRegexType("存在匹配数据");
         } else if (checkedSensitiveColumns.size() <= 0 && checkedColumns.size() <= 0) {
            notSensitiveDataList.add(table);
         } else {
            if (notSensitiveColumns.size() > 0) {
               partCheckedDataList.add(table);
            } else {
               allCheckedDataList.add(table);
            }

            table.setState("open");
         }

         if (sensitiveColumnCount > 0L) {
            ++search_sensitive_number;
            table.setRegexType(sensitiveColumnCount + "个敏感字段");
         }

         sensitiveColumns.addAll(partSensitiveColumns);
         sensitiveColumns.addAll(notSensitiveColumns);
         sensitiveColumns.addAll(checkedSensitiveColumns);
         sensitiveColumns.addAll(checkedColumns);
         table.getChildren().addAll(sensitiveColumns);
      }

      Collections.sort(sensitiveDataList);
      Collections.sort(partSensitiveDataList);
      Collections.sort(partCheckedDataList);
      Collections.sort(allCheckedDataList);
      Collections.sort(notSensitiveDataList);
      sensitiveDataList.addAll(partSensitiveDataList);
      sensitiveDataList.addAll(partCheckedDataList);
      sensitiveDataList.addAll(allCheckedDataList);
      sensitiveDataList.addAll(notSensitiveDataList);
      long parentId = 1L;

      for(TreeGridSensitiveDataVO parent : sensitiveDataList) {
         parent.setId(String.valueOf(parentId++));
         long childId = 1L;

         for(TreeGridSensitiveDataVO child : parent.getChildren()) {
            child.setId(parent.getId() + "_" + childId++);
            child.setParentid(parent.getId());
         }
      }

      SearchinfoVO searchinfoVO = new SearchinfoVO();
      searchinfoVO.setSearch_all_colum_number(columnCountall);
      searchinfoVO.setSearch_all_number((long)tableColumns.entrySet().size());
      searchinfoVO.setSearch_all_sensitive_colum_number(sensitiveColumnCountall);
      searchinfoVO.setSearch_sensitive_number(search_sensitive_number);
      searchinfoVO.setSure_colum_number(sure_sensitive_number);
      this.redisService.set("searchinfoVO", searchinfoVO, new Long(86400L));
      return sensitiveDataList;
   }

   @RequestMapping({"/save"})
   @ResponseBody
   public String save(String key, String jiegouid, boolean saveChecked, String groupId, String groupName, @RequestParam("sensitiveColumns[]") List<String> sensitiveColumns, HttpServletRequest request) {
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      if (loginUser == null) {
         return "1";
      } else {
         String version = "1";
         Object isdmpFlag = this.redisService.get(groupId + "_" + "findisdmpFlag");
         Object dmptype = this.redisService.get(groupId + "_" + "finddmptype");
         Object multidmptype = this.redisService.get(groupId + "_" + "findmultidmptype");
         if (StringUtil.isBlank(groupId)) {
            groupId = this.discoverytaskService.savediscoverytask(groupName);
            if (isdmpFlag != null && "1".equals(isdmpFlag.toString())) {
               this.discoverytaskService.get(groupId).setIsdmpflag(isdmpFlag.toString());
               this.discoverytaskService.get(groupId).setDmptype(dmptype.toString());
               this.discoverytaskService.get(groupId).setMultidmptype(multidmptype.toString());
               this.redisService.set(groupId + "_" + "findisdmpFlag", isdmpFlag.toString());
               this.redisService.set(groupId + "_" + "finddmptype", dmptype.toString());
               this.redisService.set(groupId + "_" + "findmultidmptype", multidmptype.toString());
               this.redisService.remove("_findisdmpFlag");
               this.redisService.remove("_finddmptype");
               this.redisService.remove("_findmultidmptype");
            }
         } else {
            version = this.discoverytaskService.updatetask(groupId, groupName);
         }

         TBaseUser user = loginUser.getTsysUser();
         String admin = user.getUsername();
         Date date = new Date();
         int index = 1;
         int confirmfield = 0;
         int sensitivefieldnum = 0;
         this.discoveryConditionService.delDiscoveryConditiontablelog(groupId);
         int tablenum = 0;
         this.discoverytaskService.deleteDiscoverytaskByGroupid(groupId);
         HttpSession session = request.getSession();
         TcoreDiscoveryVersrion tcoreDiscoveryVersrion = new TcoreDiscoveryVersrion();
         List<TcoreDiscoveryCondition> tcoreSensitivesearchloglist = new ArrayList();
         TcoreDiscoveryCondition tcoreSensitivesearchlog = new TcoreDiscoveryCondition();
         tcoreSensitivesearchlog.setCreatetime(new Date());
         tcoreSensitivesearchlog.setGroupid(groupId);
         String maxRowCount = String.valueOf(session.getAttribute("maxRowCount"));
         String rate = String.valueOf(session.getAttribute("rate"));
         String datasystemid = (String)session.getAttribute("datasystemid");
         String type = (String)session.getAttribute("type");
         String jiegou = (String)session.getAttribute("jiegou");
         String samplingtype = (String)session.getAttribute("samplingtype");
         String aifind = (String)session.getAttribute("aifind");
         int queren = (Integer)session.getAttribute("queren");
         List<String> schemas = (List)session.getAttribute("schemas");
         List<String> typelist = (List)session.getAttribute("typelist");
         List<String> namelist = (List)session.getAttribute("namelist");
         List<String> regexlist = (List)session.getAttribute("regexlist");
         tcoreDiscoveryVersrion.setConfirmfield(confirmfield);
         tcoreDiscoveryVersrion.setIsIntelligent(aifind);
         tcoreDiscoveryVersrion.setSensitivefieldnum(sensitivefieldnum);
         tcoreDiscoveryVersrion.setCreatetime(date);
         tcoreDiscoveryVersrion.setIntelligentNum(queren);
         tcoreDiscoveryVersrion.setTableNum(tablenum);
         tcoreDiscoveryVersrion.setSensitivefieldnum(sensitivefieldnum);
         tcoreDiscoveryVersrion.setUserid(user.getId());
         tcoreDiscoveryVersrion.setUsername(user.getUsername());
         tcoreDiscoveryVersrion.setTaskversion(version);
         tcoreDiscoveryVersrion.setTaskid(groupId);
         tcoreDiscoveryVersrion.setUpdatetime(date);
         this.discoveryVersrionService.save(tcoreDiscoveryVersrion);
         tcoreSensitivesearchlog.setCreatetime(new Date());
         tcoreSensitivesearchlog.setGroupid(groupId);
         tcoreSensitivesearchlog.setParametercontent(String.valueOf(maxRowCount));
         tcoreSensitivesearchlog.setParameterid(3);
         tcoreSensitivesearchloglist.add(tcoreSensitivesearchlog);
         tcoreSensitivesearchlog = new TcoreDiscoveryCondition();
         tcoreSensitivesearchlog.setCreatetime(new Date());
         tcoreSensitivesearchlog.setGroupid(groupId);
         tcoreSensitivesearchlog.setParametercontent(datasystemid);
         tcoreSensitivesearchlog.setParameterid(1);
         tcoreSensitivesearchloglist.add(tcoreSensitivesearchlog);
         tcoreSensitivesearchlog = new TcoreDiscoveryCondition();
         tcoreSensitivesearchlog.setCreatetime(new Date());
         tcoreSensitivesearchlog.setGroupid(groupId);
         tcoreSensitivesearchlog.setParametercontent(String.valueOf(rate));
         tcoreSensitivesearchlog.setParameterid(4);
         tcoreSensitivesearchloglist.add(tcoreSensitivesearchlog);
         tcoreSensitivesearchlog = new TcoreDiscoveryCondition();
         tcoreSensitivesearchlog.setCreatetime(new Date());
         tcoreSensitivesearchlog.setGroupid(groupId);
         tcoreSensitivesearchlog.setParametercontent(type);
         tcoreSensitivesearchlog.setParameterid(8);
         tcoreSensitivesearchloglist.add(tcoreSensitivesearchlog);
         tcoreSensitivesearchlog = new TcoreDiscoveryCondition();
         tcoreSensitivesearchlog.setCreatetime(new Date());
         tcoreSensitivesearchlog.setGroupid(groupId);
         tcoreSensitivesearchlog.setParametercontent(jiegou);
         tcoreSensitivesearchlog.setParameterid(9);
         tcoreSensitivesearchloglist.add(tcoreSensitivesearchlog);
         tcoreSensitivesearchlog = new TcoreDiscoveryCondition();
         tcoreSensitivesearchlog.setCreatetime(new Date());
         tcoreSensitivesearchlog.setGroupid(groupId);
         tcoreSensitivesearchlog.setParametercontent(aifind);
         tcoreSensitivesearchlog.setParameterid(10);
         tcoreSensitivesearchloglist.add(tcoreSensitivesearchlog);
         tcoreSensitivesearchlog = new TcoreDiscoveryCondition();
         tcoreSensitivesearchlog.setCreatetime(new Date());
         tcoreSensitivesearchlog.setGroupid(groupId);
         tcoreSensitivesearchlog.setParametercontent(samplingtype);
         tcoreSensitivesearchlog.setParameterid(11);
         tcoreSensitivesearchloglist.add(tcoreSensitivesearchlog);

         for(String string : schemas) {
            tcoreSensitivesearchlog = new TcoreDiscoveryCondition();
            tcoreSensitivesearchlog.setCreatetime(new Date());
            tcoreSensitivesearchlog.setGroupid(groupId);
            tcoreSensitivesearchlog.setParametercontent(string);
            tcoreSensitivesearchlog.setParameterid(2);
            tcoreSensitivesearchloglist.add(tcoreSensitivesearchlog);
         }

         for(String string : typelist) {
            tcoreSensitivesearchlog = new TcoreDiscoveryCondition();
            tcoreSensitivesearchlog.setCreatetime(new Date());
            tcoreSensitivesearchlog.setGroupid(groupId);
            tcoreSensitivesearchlog.setParametercontent(string);
            tcoreSensitivesearchlog.setParameterid(5);
            tcoreSensitivesearchloglist.add(tcoreSensitivesearchlog);
         }

         for(String string : namelist) {
            tcoreSensitivesearchlog = new TcoreDiscoveryCondition();
            tcoreSensitivesearchlog.setCreatetime(new Date());
            tcoreSensitivesearchlog.setGroupid(groupId);
            tcoreSensitivesearchlog.setParametercontent(string);
            tcoreSensitivesearchlog.setParameterid(6);
            tcoreSensitivesearchloglist.add(tcoreSensitivesearchlog);
         }

         for(String string : regexlist) {
            tcoreSensitivesearchlog = new TcoreDiscoveryCondition();
            tcoreSensitivesearchlog.setCreatetime(new Date());
            tcoreSensitivesearchlog.setGroupid(groupId);
            tcoreSensitivesearchlog.setParametercontent(string);
            tcoreSensitivesearchlog.setParameterid(7);
            tcoreSensitivesearchloglist.add(tcoreSensitivesearchlog);
         }

         this.discoveryConditionService.saveDiscoveryConditionParamter(tcoreSensitivesearchloglist, groupId);
         Set<Object> zrange = this.redisService.range("sensitive:" + session.getId(), 0, -1);
         ProgressInfo saveProgressInfo = new ProgressInfo((long)zrange.size());
         session.setAttribute("saveProgressInfo", saveProgressInfo);
         int count = zrange.size();
         StringBuilder sqlstr = new StringBuilder("insert into t_core_discovery_sensitivecolumn(id,note,checked,columnname,createtime,datasourceid,etsampling,groupid,isIntelligent,mate,materatio,regextype,ruleid,rulename,sampling,tablename,taskversion,tschema,updatetime) values ");

         for(Object tablekeyobj : zrange) {
            String tablekey = (String)tablekeyobj;
            --count;
            String tablename = tablekey.split("\\-")[1];
            String schema = tablekey.split("\\-")[0];
            new TreeGridSensitiveDataVO();
            TreeGridSensitiveDataVO treeGridSensitiveDataVO = (TreeGridSensitiveDataVO)this.redisService.get(tablekey);
            if (treeGridSensitiveDataVO != null) {
               List<TCoreFieldSensitiveMemory> memory = new ArrayList();

               for(int i = 0; i < treeGridSensitiveDataVO.getChildren().size(); ++i) {
                  TreeGridSensitiveDataVO treeGridSensitiveDataVOchildren = (TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i);
                  sqlstr.append("('");
                  sqlstr.append(UUID.randomUUID());
                  sqlstr.append("','");
                  if ("1".equals((isdmpFlag = isdmpFlag == null ? "" : isdmpFlag).toString())) {
                     if ("0".equals((dmptype = dmptype == null ? "" : dmptype).toString())) {
                        sqlstr.append("DP-DMP");
                     } else {
                        sqlstr.append("DMP");
                     }
                  } else {
                     sqlstr.append(treeGridSensitiveDataVO.getDatasourcename());
                  }

                  sqlstr.append("','");
                  sqlstr.append(treeGridSensitiveDataVOchildren.getColumnChecked());
                  sqlstr.append("','");
                  sqlstr.append(treeGridSensitiveDataVOchildren.getName());
                  sqlstr.append("',now()");
                  sqlstr.append(",'");
                  sqlstr.append(treeGridSensitiveDataVO.getDatasourceid());
                  sqlstr.append("','");
                  sqlstr.append(treeGridSensitiveDataVOchildren.getValidCount());
                  sqlstr.append("','");
                  sqlstr.append(groupId);
                  sqlstr.append("','");
                  sqlstr.append(treeGridSensitiveDataVOchildren.getIsIntelligent());
                  sqlstr.append("','");
                  sqlstr.append(treeGridSensitiveDataVOchildren.getMatchCount());
                  sqlstr.append("','");
                  sqlstr.append(treeGridSensitiveDataVOchildren.getMatchRate());
                  sqlstr.append("','");
                  sqlstr.append(treeGridSensitiveDataVOchildren.getRegexType());
                  sqlstr.append("','");
                  sqlstr.append(treeGridSensitiveDataVOchildren.getRuleId() == null ? "" : treeGridSensitiveDataVOchildren.getRuleId());
                  sqlstr.append("','");
                  sqlstr.append(treeGridSensitiveDataVOchildren.getRuleName() == null ? "" : treeGridSensitiveDataVOchildren.getRuleName());
                  sqlstr.append("','");
                  sqlstr.append(treeGridSensitiveDataVOchildren.getTotalCount());
                  sqlstr.append("','");
                  sqlstr.append(tablename);
                  sqlstr.append("','");
                  sqlstr.append(version);
                  sqlstr.append("','");
                  sqlstr.append(treeGridSensitiveDataVO.getSchema());
                  sqlstr.append("',now()");
                  if (i == treeGridSensitiveDataVO.getChildren().size() - 1 && count == 0) {
                     sqlstr.append(")");
                  } else {
                     sqlstr.append("),");
                  }

                  TcoreDiscoverySensitivecolumn scolum = new TcoreDiscoverySensitivecolumn();
                  scolum.setChecked(treeGridSensitiveDataVOchildren.getColumnChecked());
                  scolum.setIsIntelligent(treeGridSensitiveDataVOchildren.getIsIntelligent());
                  scolum.setColumnname(treeGridSensitiveDataVOchildren.getName());
                  scolum.setCreatetime(new Date());
                  scolum.setDatasourceid(treeGridSensitiveDataVO.getDatasourceid());
                  scolum.setEtsampling(treeGridSensitiveDataVO.getValidCount());
                  scolum.setSampling(treeGridSensitiveDataVOchildren.getTotalCount());
                  if ("1".equals(isdmpFlag.toString())) {
                     if ("0".equals(dmptype.toString())) {
                        scolum.setNote("DP-DMP");
                     } else {
                        scolum.setNote("DMP");
                     }
                  } else {
                     scolum.setNote(treeGridSensitiveDataVO.getDatasourcename());
                  }

                  scolum.setGroupid(groupId);
                  scolum.setMate(treeGridSensitiveDataVOchildren.getMatchCount());
                  scolum.setMateratio(treeGridSensitiveDataVOchildren.getMatchRate());
                  scolum.setRegextype(treeGridSensitiveDataVOchildren.getRegexType());
                  scolum.setRuleid(treeGridSensitiveDataVOchildren.getRuleId());
                  scolum.setRulename(treeGridSensitiveDataVOchildren.getRuleName());
                  scolum.setTablename(tablename);
                  scolum.setTschema(treeGridSensitiveDataVO.getSchema());
                  scolum.setUpdatetime(new Date());
                  scolum.setTaskversion(version);
                  scolum.setCreatetime(date);
                  if (scolum.getChecked().equals("1")) {
                     TCoreFieldSensitiveMemory me = new TCoreFieldSensitiveMemory();
                     me.setId(scolum.getTschema() + scolum.getTablename() + scolum.getColumnname());
                     me.setUpdatetime(date);
                     me.setColumnname(scolum.getColumnname());
                     me.setCreatetime(date);
                     me.setDatasourceid(scolum.getDatasourceid());
                     me.setEtsampling(scolum.getEtsampling());
                     me.setMate(scolum.getMate());
                     me.setMateratio(scolum.getMateratio());
                     me.setRegextype(scolum.getRegextype());
                     me.setRuie(scolum.getRulename());
                     me.setRuleid(scolum.getRuleid());
                     me.setSampling(scolum.getSampling());
                     me.setTablename(scolum.getTablename());
                     me.setTschema(scolum.getTschema());
                     memory.add(me);
                     ++confirmfield;
                  }
               }

               if (memory != null) {
                  this.redisService.set(tablename + "+" + schema, memory);
               }
            }

            saveProgressInfo.setCurrent((long)index);
            saveProgressInfo.setCurrentTable(tablename);
            ++index;
            ++tablenum;
         }

         this.discoverySensitivecolumnService.saveTcoreDiscoverySensitivecolumn(sqlstr);
         TConsoleLog record = new TConsoleLog();
         record.setLogmessage("保存敏感数据发现结果");
         record.setModule("敏感数据发现");
         record.setUser(admin);
         record.setOperationtime(date);
         this.operationService.add(record);
         return groupId;
      }
   }

   public void saveSensitiveColumnHis(HashMap<String, HashMap<String, TcoreDiscoverySensitivecolumn>> maptable) {
      TcoreDiscoveryResultsRecord tcoreDiscoveryResultsRecord = null;

      for(Map.Entry<String, HashMap<String, TcoreDiscoverySensitivecolumn>> tableentry : maptable.entrySet()) {
         HashMap<String, TcoreDiscoverySensitivecolumn> colum = (HashMap)tableentry.getValue();

         for(Map.Entry<String, TcoreDiscoverySensitivecolumn> columentry : colum.entrySet()) {
            tcoreDiscoveryResultsRecord = new TcoreDiscoveryResultsRecord();
            TcoreDiscoverySensitivecolumn tree = (TcoreDiscoverySensitivecolumn)columentry.getValue();
            tcoreDiscoveryResultsRecord.setGroupid(tree.getGroupid());
            tcoreDiscoveryResultsRecord.setTaskversion(tree.getTaskversion());
            tcoreDiscoveryResultsRecord.setChecked(tree.getChecked());
            tcoreDiscoveryResultsRecord.setDatasourceid(tree.getDatasourceid());
            tcoreDiscoveryResultsRecord.setTschema(tree.getTschema());
            tcoreDiscoveryResultsRecord.setTablename(tree.getTablename());
            tcoreDiscoveryResultsRecord.setColumnname(tree.getColumnname());
            tcoreDiscoveryResultsRecord.setIsIntelligent(tree.getIsIntelligent());
            tcoreDiscoveryResultsRecord.setSampling(tree.getSampling());
            tcoreDiscoveryResultsRecord.setEtsampling(tree.getEtsampling());
            tcoreDiscoveryResultsRecord.setMate(tree.getMate());
            tcoreDiscoveryResultsRecord.setMateratio(tree.getMateratio());
            tcoreDiscoveryResultsRecord.setRegextype(tree.getRegextype());
            tcoreDiscoveryResultsRecord.setRuleid(tree.getRuleid());
            tcoreDiscoveryResultsRecord.setRulename(tree.getRulename());
            tcoreDiscoveryResultsRecord.setCreatetime(new Date());
            tcoreDiscoveryResultsRecord.setUpdatetime(new Date());
            this.discoveryResultsRecordService.save(tcoreDiscoveryResultsRecord);
         }
      }

   }

   @RequestMapping({"/isTaskNameExistsCheck"})
   @ResponseBody
   public String isTaskNameExistsCheck(String groupName, HttpServletRequest request, HttpServletResponse response, Model model) {
      String existFlg = "0";
      existFlg = this.discoverytaskService.isTaskNameExistsCheck(groupName);
      return existFlg;
   }

   @ResponseBody
   @RequestMapping({"/querydatasystem"})
   public Response querydatasource(HttpServletRequest request, HttpServletResponse response, Model model, @RequestBody DataSystemProjectVO vo) {
      LoginUser loginUser = vo.getLoginUser();
      String userid = loginUser.getTsysUser().getId();
      List<Map<String, String>> list = this.dataSystemService.querydatasource(vo.getProjectid(), vo.getDiscoverytype(), userid);
      return RespHelper.successResp(list);
   }

   @ResponseBody
   @RequestMapping({"/queryShemas"})
   public Response<List<ComboboxVO>> queryShemas(@RequestBody Map<String, String> map) {
      String schemaname = map.get("schemaname");
      String dbType = map.get("dbType");
      String dataSystemId = map.get("dataSystemId");
      List<ComboboxVO> result = new ArrayList<>();
      try {
         return RespHelper.successResp(result);
      } catch (Exception e) {
         return RespHelper.successResp(result);
      } finally{ Exception exception = null;
         List<ComboboxVO> queryresult = new ArrayList<>();
         if (schemaname != null && !schemaname.equals("")) {
            ComboboxVO schemaValue = null;
            for (int i = 0; i < result.size(); i++) {
               schemaValue = result.get(i);
               if (schemaValue.getValue().toLowerCase().contains(schemaname.toLowerCase())) {
                  queryresult.add(schemaValue);
               }
            }
            return RespHelper.successResp(queryresult);
         }
      }
   }

   @ResponseBody
   @RequestMapping({"/queryTable"})
   public List<DBTableVO> queryTable(String tablename, String value, String dataSystemId, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<DBTableVO> list = this.dataSystemService.queryTablename(dataSystemId, value);
      if (tablename != null && !tablename.equals("")) {
         String[] table_List = tablename.trim().split("\\,");
         List<DBTableVO> tableSearchList = new ArrayList();
         List<String> table_List_name = Arrays.asList(table_List);

         for(DBTableVO dbTableVO : list) {
            for(String string : table_List_name) {
               if (tableNameLikeMethod(dbTableVO.getTablename(), string)) {
                  tableSearchList.add(dbTableVO);
               }
            }
         }

         List<DBTableVO> temporaryList = new ArrayList();
         HashMap<String, Integer> hash = new HashMap();

         for(DBTableVO dbTableVO2 : tableSearchList) {
            if (hash.get(dbTableVO2.getTablename()) == null) {
               temporaryList.add(dbTableVO2);
               hash.put(dbTableVO2.getTablename(), 1);
            }
         }

         return temporaryList;
      } else {
         return list;
      }
   }

   @ResponseBody
   @RequestMapping({"/querydmpTable"})
   public List<Map<String, String>> querydmpTable(String multiDempFile, String tableName, String sourcefiledname, String dmptype, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<Map<String, String>> showTableNameList = new ArrayList();
      List<String> list = new ArrayList();
      List<String> listfiledir = new ArrayList();
      if ("1".equals(multiDempFile)) {
         String[] dmpfiles = sourcefiledname.split(",");

         for(String dmpfile : dmpfiles) {
            listfiledir.add(dmpfile);
         }

         if ("0".equals(dmptype)) {
            Map<String, Object> tableInfoMap = null;
            tableInfoMap = (Map)this.redisService.get(sourcefiledname + "multiDmpdp_tableInfoMap");
            if (null == tableInfoMap) {
               tableInfoMap = MultipleDmpDpTool.getAllTableinfo(listfiledir);
            }

            this.redisService.set(sourcefiledname + "multiDmpdp_tableInfoMap", tableInfoMap);
            if (tableInfoMap.size() > 0) {
               List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");

               for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                  list.add(((TableStructureInfo)tableStructureInfoList.get(i)).getTablename());
               }
            }
         } else {
            Map<String, Object> tableInfoMap = null;
            tableInfoMap = (Map)this.redisService.get(sourcefiledname + "multiDmp_tableInfoMap");
            if (null == tableInfoMap) {
               tableInfoMap = MultipleDmpTool.getAllTableinfo(listfiledir);
            }

            this.redisService.set(sourcefiledname + "multiDmp_tableInfoMap", tableInfoMap);
            if (tableInfoMap.size() > 0) {
               List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");

               for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                  list.add(((TableStructureInfo)tableStructureInfoList.get(i)).getTablename());
               }
            }
         }
      } else if ("0".equals(dmptype)) {
         Map<String, Object> tableInfoMap = null;
         tableInfoMap = (Map)this.redisService.get(sourcefiledname + "Dmpdp_tableInfoMap");
         if (null == tableInfoMap) {
            tableInfoMap = DmpDpTool.getAllTableinfo(sourcefiledname);
         }

         this.redisService.set(sourcefiledname + "Dmpdp_tableInfoMap", tableInfoMap);
         if (tableInfoMap.size() > 0) {
            List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");

            for(int i = 0; i < tableStructureInfoList.size(); ++i) {
               list.add(((TableStructureInfo)tableStructureInfoList.get(i)).getTablename());
            }
         }
      } else {
         Map<String, Object> tableInfoMap = null;
         tableInfoMap = (Map)this.redisService.get(sourcefiledname + "Dmp_tableInfoMap");
         if (null == tableInfoMap) {
            tableInfoMap = DmpTool.getAllTableinfo(sourcefiledname);
         }

         this.redisService.set(sourcefiledname + "Dmp_tableInfoMap", tableInfoMap);
         if (tableInfoMap.size() > 0) {
            List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");

            for(int i = 0; i < tableStructureInfoList.size(); ++i) {
               list.add(((TableStructureInfo)tableStructureInfoList.get(i)).getTablename());
            }
         }
      }

      for(int i = 0; i < list.size(); ++i) {
         if ("".equals(tableName)) {
            Map<String, String> map = new HashMap();
            map.put("tablename", list.get(i));
            showTableNameList.add(map);
         } else if (tableName.equals(list.get(i))) {
            Map<String, String> map = new HashMap();
            map.put("tablename", list.get(i));
            showTableNameList.add(map);
         }
      }

      return showTableNameList;
   }

   @RequestMapping({"/querydmpfilename"})
   @ResponseBody
   public List<Map<String, String>> querydmpfilename(String fileName, String sourcefiledname, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<Map<String, String>> listre = new ArrayList();
      File subFiles = new File(sourcefiledname);
      if (subFiles.isDirectory()) {
         String[] strSubfiles = subFiles.list();
         strSubfiles = StringTool.arraySort(strSubfiles);
         if (fileName != null && fileName != "") {
            for(String string : strSubfiles) {
               if (string.toUpperCase().endsWith(".DMP")) {
                  int i = string.toUpperCase().lastIndexOf(fileName.toUpperCase());
                  if (i >= 0) {
                     Map<String, String> map = new HashMap();
                     map.put("filename", string);
                     listre.add(map);
                  }
               }
            }
         } else {
            for(String string : strSubfiles) {
               if (string.toUpperCase().endsWith(".DMP")) {
                  Map<String, String> map = new HashMap();
                  map.put("filename", string);
                  listre.add(map);
               }
            }
         }
      }

      return listre;
   }

   @RequestMapping({"/isMultiFileDir"})
   @ResponseBody
   public boolean isMultiFileDir(String sourcefiledname) {
      boolean directory = true;
      File subFiles = new File(sourcefiledname);
      System.out.println(sourcefiledname);
      if (subFiles.isDirectory()) {
         directory = true;
      } else {
         directory = false;
      }

      return directory;
   }

   @RequestMapping({"/querySearchRegex"})
   @ResponseBody
   public Response<List<TreeGridRegexVO>> querySearchRegex(@RequestBody SearchRegexVO searchRegexVO) {
      List<TreeGridRegexVO> result = new ArrayList();
      String rulename = "";
      String edittask = searchRegexVO.getEdittask();
      String taskid = searchRegexVO.getTaskid();
      String projectid = searchRegexVO.getProjectid();
      String discoverytype = searchRegexVO.getDiscoverytype();
      if (edittask != null && !"".equals(edittask)) {
         List<TcoreTaskFindrule> listrule = this.tdataDiscoveryService.queryFindrulelist(taskid);
         Map<String, String> maprule = new HashMap();

         for(TcoreTaskFindrule regex : listrule) {
            maprule.put(regex.getDataarea(), regex.getRulename());
         }

         List<TCoreProjectFindruleVO> list = this.searchRegexService.queryFindrule(projectid);
         if ("1".equals(discoverytype) || "3".equals(discoverytype)) {
            TCoreProjectFindruleVO tCoreProjectFindruleVO = new TCoreProjectFindruleVO();
            tCoreProjectFindruleVO.setProject_id(projectid);
            tCoreProjectFindruleVO.setDataarea("智能推荐");
            tCoreProjectFindruleVO.setDataarea_id("");
            tCoreProjectFindruleVO.setDiscoverway("");
         }

         Map<String, List<TCoreProjectFindruleVO>> map = new HashMap();

         for(TCoreProjectFindruleVO regex : list) {
            if (!map.containsKey(regex.getDataarea())) {
               map.put(regex.getDataarea(), new ArrayList());
            }

            ((List)map.get(regex.getDataarea())).add(regex);
         }

         long parentId = 1L;

         for(TCoreProjectFindruleVO findrule : list) {
            String check = "";
            if (maprule != null && maprule.get(findrule.getDataarea()) != null) {
               check = "checked='checked'";
            }

            TreeGridRegexVO vo = new TreeGridRegexVO(String.valueOf(parentId), findrule.getDataarea(), findrule.getDataarea_id(), findrule.getDiscoverway(), new ArrayList());
            vo.setCheck(check);
            long childId = 1L;
            if (findrule.getDataarea() != null && !rulename.equals(findrule.getDataarea())) {
               List<TCoreProjectFindruleVO> listNew = (List)map.get(findrule.getDataarea());
               for(TCoreProjectFindruleVO regex : listNew) {
                  if (!check.equals("") && maprule.get(findrule.getDataarea()) != null && ((String)maprule.get(findrule.getDataarea())).equals(regex.getRulename())) {
                     check = "1";
                  } else {
                     check = "0";
                  }

                  List<TCoreDataFileGroupVO> datalist = new ArrayList();
                  List<Map<String, String>> tCoreDataFileGroupList = this.searchRegexService.querydatafileById(regex.getSearchregexid(), projectid);
                  if (tCoreDataFileGroupList != null && tCoreDataFileGroupList.size() > 0) {
                     long datafile1 = 1L;

                     for(int i = 0; i < tCoreDataFileGroupList.size(); ++i) {
                        datalist.add(new TCoreDataFileGroupVO((String)((Map)tCoreDataFileGroupList.get(i)).get("searchregexid"), (String)((Map)tCoreDataFileGroupList.get(i)).get("datafileid"), (String)((Map)tCoreDataFileGroupList.get(i)).get("datafilename"), (String)((Map)tCoreDataFileGroupList.get(i)).get("rulename")));
                        ++datafile1;
                     }
                  }

                  if (regex.getRegex() != null) {
                     vo.getChildren().add(new TreeGridRegexVO(parentId + "_" + childId, regex.getRulename(), regex.getDataarea_id(), regex.getDataarea(), regex.getRegex(), regex.getRuleexample(), regex.getFlag(), regex.getDefaultrule(), check, regex.getDiscoverway(), datalist));
                     ++childId;
                  }
               }

               rulename = findrule.getDataarea();
               result.add(vo);
               ++parentId;
            }
         }
      } else {
         List<TCoreProjectFindruleVO> list = this.searchRegexService.queryFindrule(projectid);
         Map<String, List<TCoreProjectFindruleVO>> map = new HashMap();

         for(TCoreProjectFindruleVO regex : list) {
            if (!map.containsKey(regex.getDataarea())) {
               map.put(regex.getDataarea(), new ArrayList());
            }

            ((List)map.get(regex.getDataarea())).add(regex);
         }

         if ("1".equals(discoverytype) || "3".equals(discoverytype)) {
            TreeGridRegexVO vo1 = new TreeGridRegexVO(String.valueOf(0), "智能推荐", "", "", new ArrayList());
            vo1.setCheck("");
         }

         List<Map<String, String>> List = this.dataScopeService.selectRelationGrade("3", searchRegexVO.getTid(), searchRegexVO.getEditionid());
         List<String> gradelist = new ArrayList();

         for(Map<String, String> m : List) {
            gradelist.add(m.get("rule"));
         }

         long parentId = 1L;

         for(TCoreProjectFindruleVO findrule : list) {
            if (findrule.getDataarea() != null && !rulename.equals(findrule.getDataarea())) {
               TreeGridRegexVO vo = new TreeGridRegexVO(String.valueOf(parentId), findrule.getDataarea(), findrule.getDataarea_id(), findrule.getDiscoverway(), new ArrayList());
               long childId = 1L;
               List<TCoreProjectFindruleVO> listNew = (List)map.get(findrule.getDataarea());
               for(TCoreProjectFindruleVO regex : listNew) {
                  List<TCoreDataFileGroupVO> datalist = new ArrayList();
                  List<Map<String, String>> tCoreDataFileGroupList = this.searchRegexService.querydatafileById(regex.getSearchregexid(), projectid);
                  if (tCoreDataFileGroupList != null && tCoreDataFileGroupList.size() > 0) {
                     long datafile1 = 1L;

                     for(int i = 0; i < tCoreDataFileGroupList.size(); ++i) {
                        datalist.add(new TCoreDataFileGroupVO((String)((Map)tCoreDataFileGroupList.get(i)).get("searchregexid"), (String)((Map)tCoreDataFileGroupList.get(i)).get("datafileid"), (String)((Map)tCoreDataFileGroupList.get(i)).get("datafilename"), (String)((Map)tCoreDataFileGroupList.get(i)).get("rulename")));
                        ++datafile1;
                     }
                  }

                  if (regex.getRegex() != null) {
                     vo.getChildren().add(new TreeGridRegexVO(parentId + "_" + childId, regex.getRulename(), regex.getDataarea_id(), regex.getDataarea(), regex.getRegex(), regex.getRuleexample(), regex.getFlag(), regex.getDefaultrule(), regex.getDiscoverway(), datalist));
                     ++childId;
                  }
               }

               rulename = findrule.getDataarea();
               if (!"yes".equals(searchRegexVO.getHidden()) || !gradelist.contains(vo.getDataareaid())) {
                  result.add(vo);
               }

               ++parentId;
            }
         }
      }

      return RespHelper.<List<TreeGridRegexVO>>successResp(result);
   }

   @RequestMapping({"/queryMutexDataarea"})
   @ResponseBody
   public ResultVO queryMutexDataarea(HttpServletRequest request, HttpServletResponse response, String dataareaid) {
      ResultVO vo = new ResultVO();
      new ArrayList();
      List<TConsoleSearchregex> regexList = this.searchRegexService.querySearchregexByDaid(dataareaid);

      for(int i = 0; i < regexList.size(); ++i) {
         if ("02".equals(((TConsoleSearchregex)regexList.get(i)).getDiscoverway())) {
            List<TCoreDataFileGroupVO> list = this.searchRegexService.queryMutexDataareaByrule(dataareaid, ((TConsoleSearchregex)regexList.get(i)).getName());
            vo.setResult(true);
            vo.setMessage(JSON.toJSONString(list));
            return vo;
         }
      }

      List<TCoreDataFileGroupVO> var8 = this.searchRegexService.queryMutexDataarea(dataareaid);
      vo.setResult(false);
      vo.setMessage(JSON.toJSONString(var8));
      return vo;
   }

   @RequestMapping({"/queryMutexDataareaByrule"})
   @ResponseBody
   public List<TCoreDataFileGroupVO> queryMutexDataareaByrule(HttpServletRequest request, HttpServletResponse response, String dataareaid, String rulename) {
      List<TCoreDataFileGroupVO> list = this.searchRegexService.queryMutexDataareaByrule(dataareaid, rulename);
      return list;
   }

   @RequestMapping({"/queryRegexType"})
   @ResponseBody
   public List<String> queryRegexType(HttpServletRequest request, HttpServletResponse response, Model model) {
      new ArrayList();
      List<String> list = this.ruleService.queryRuleGroup();
      return list;
   }

   @RequestMapping({"/queryRegexTypeJson"})
   @ResponseBody
   public void queryRegexTypeJson(HttpServletRequest request, HttpServletResponse response, Model model) {
      PrintWriter writer = null;
      new ArrayList();
      List<TCoreMaskingRule> list = this.ruleService.queryRuleByFlag();

      try {
         request.setCharacterEncoding("utf8");
         response.setCharacterEncoding("utf8");
         response.setContentType("text/json; charset=utf-8");
         writer = response.getWriter();
         writer.print(JSON.toJSON(list));
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @RequestMapping({"/queryRegexTypeByGroupName"})
   @ResponseBody
   public void queryRegexTypeByGroupName(String groupname, HttpServletRequest request, HttpServletResponse response, Model model) {
      new ArrayList();
      PrintWriter writer = null;
      List<TCoreMaskingRule> list = this.ruleService.queryRuleByGroupName(groupname);

      try {
         request.setCharacterEncoding("utf8");
         response.setCharacterEncoding("utf8");
         response.setContentType("text/json; charset=utf-8");
         writer = response.getWriter();
         writer.print(JSON.toJSON(list));
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @RequestMapping({"/queryMaskingRules"})
   @ResponseBody
   public List<TCoreMaskingRule> queryMaskingRules(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreMaskingRule> list = this.maskingRuleService.queryValidRule();
      return list;
   }

   @ResponseBody
   @RequestMapping({"/exportToExcel"})
   public ResultVO exportToExcel(@RequestParam("sensitiveColumns[]") List<String> sensitiveColumns, String rule, HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
      String path = request.getSession().getServletContext().getRealPath("/") + "css" + File.separator + UUID.randomUUID().toString() + ".xlsx";
      if (sensitiveColumns != null && sensitiveColumns.size() > 0) {
         LinkedBlockingQueue<TreeGridSensitiveDataVO> queue = new LinkedBlockingQueue();

         for(String tableData : sensitiveColumns) {
            String[] tableColumns = tableData.split("&|;");
            String[] tableInfos = tableColumns[0].split("\\|");
            String tableName = tableInfos[0];
            String datasystemid = tableInfos[1];
            String schema = tableInfos[2];

            for(int i = 1; i < tableColumns.length; ++i) {
               String[] columnData = tableColumns[i].split("\\|", -1);

               try {
                  String remark = "";
                  if (rule != null && columnData[6].equals("")) {
                     Double r = Double.parseDouble(rule);
                     Double d = Double.parseDouble(columnData[4]);
                     if (d.compareTo(r) > -1 && d > (double)0.0F) {
                        remark = "数据重复率过高";
                     }
                  }

                  queue.put(new TreeGridSensitiveDataVO(datasystemid, schema, tableName, columnData[0], columnData[1], columnData[2], columnData[3], columnData[4], columnData[5], columnData[6], remark));
               } catch (InterruptedException e) {
                  e.printStackTrace();
               }
            }
         }

         Map<String, String> titlevalue = new LinkedHashMap();
         titlevalue.put("数据源", "datasourcename");
         titlevalue.put("所有者", "schema");
         titlevalue.put("表名", "parentname");
         titlevalue.put("列名", "name");
         titlevalue.put("取样", "totalCount");
         titlevalue.put("有效取样", "validCount");
         titlevalue.put("匹配", "matchCount");
         titlevalue.put("匹配率", "matchRate");
         titlevalue.put("敏感类型", "regexType");
         titlevalue.put("脱敏规则", "ruleName");
         titlevalue.put("备注", "remark");
         List<Integer> columnWidthList = new ArrayList();
         columnWidthList.add(2200);
         columnWidthList.add(2200);
         columnWidthList.add(1600);
         columnWidthList.add(1600);
         columnWidthList.add(1600);
         columnWidthList.add(2700);
         columnWidthList.add(1600);
         columnWidthList.add(2200);
         columnWidthList.add(2700);
         columnWidthList.add(2700);
         columnWidthList.add(4700);
         ExcelTool.generateExcel(path, queue, titlevalue, columnWidthList, (List)null);
      }

      ResultVO vo = new ResultVO(path, true);
      return vo;
   }

   @ResponseBody
   @RequestMapping({"/exportToExceltoLog"})
   public ResultVO exportToExceltoLog(String groupid, String state, HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
      String path = request.getSession().getServletContext().getRealPath("/") + "css" + File.separator + UUID.randomUUID().toString() + ".xlsx";
      LinkedBlockingQueue<TreeGridSensitiveDataVO> queue = new LinkedBlockingQueue();
      new ArrayList();

      for(TCoreSensitivetablelog tCoreSensitivetablelog : this.sensitiveColumnService.queryTCoreSensitivetablelog(groupid, state)) {
         try {
            queue.put(new TreeGridSensitiveDataVO(tCoreSensitivetablelog.getDatasourcename(), tCoreSensitivetablelog.getTschema(), tCoreSensitivetablelog.getTablename(), tCoreSensitivetablelog.getColumnname(), tCoreSensitivetablelog.getSampling(), tCoreSensitivetablelog.getEtsampling(), tCoreSensitivetablelog.getMate(), tCoreSensitivetablelog.getMateratio(), tCoreSensitivetablelog.getRegextype(), tCoreSensitivetablelog.getRuie()));
         } catch (InterruptedException e) {
            e.printStackTrace();
         }
      }

      Map<String, String> titlevalue = new LinkedHashMap();
      titlevalue.put("数据源", "datasourcename");
      titlevalue.put("所有者", "schema");
      titlevalue.put("表名", "parentname");
      titlevalue.put("列名", "name");
      titlevalue.put("取样", "totalCount");
      titlevalue.put("有效取样", "validCount");
      titlevalue.put("匹配", "matchCount");
      titlevalue.put("匹配率", "matchRate");
      titlevalue.put("敏感类型", "regexType");
      titlevalue.put("脱敏规则", "ruleName");
      List<Integer> columnWidthList = new ArrayList();
      columnWidthList.add(2200);
      columnWidthList.add(2200);
      columnWidthList.add(1600);
      columnWidthList.add(1600);
      columnWidthList.add(1600);
      columnWidthList.add(2700);
      columnWidthList.add(1600);
      columnWidthList.add(2200);
      columnWidthList.add(2700);
      columnWidthList.add(2700);
      ExcelTool.generateExcel(path, queue, titlevalue, columnWidthList, (List)null);
      ResultVO vo = new ResultVO(path, true);
      return vo;
   }

   @RequestMapping({"/downloadfile"})
   public String downloadfile(String path, HttpServletRequest request, HttpServletResponse response, Model model) {
      try {
         response.setCharacterEncoding("utf-8");
         response.setContentType("multipart/form-data");
         response.setHeader("Content-Disposition", "attachment;fileName=dataoutput.xlsx");
         InputStream inputStream = new FileInputStream(new File(path));
         OutputStream os = response.getOutputStream();
         byte[] b = new byte[2048];

         int length;
         while((length = inputStream.read(b)) > 0) {
            os.write(b, 0, length);
         }

         os.close();
         inputStream.close();
         FileTool.removeFile(path);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return null;
   }

   @RequestMapping({"/excelFileUpLoad"})
   @ResponseBody
   public String excelFileUpLoad(HttpServletRequest request, HttpServletResponse response, @RequestParam("fileUpload") MultipartFile excelFile, Model model) {
      InputStream in = null;
      new SearchinfoVO();
      SearchinfoVO searchinfoVO = (SearchinfoVO)this.redisService.get("searchinfoVO");
      String fileName = excelFile.getOriginalFilename();

      try {
         in = excelFile.getInputStream();
         Workbook wb = null;
         String fileType = fileName.substring(fileName.lastIndexOf("."));
         if (".xls".equals(fileType)) {
            wb = new HSSFWorkbook(in);
         } else if (".xlsx".equals(fileType)) {
            wb = new XSSFWorkbook(in);
         }

         Sheet sheet = wb.getSheetAt(0);
         int rowsNum = sheet.getLastRowNum();
         int num = 0;
         SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
         System.out.println("取文件时间：" + sdf.format(new Date()));
         long startTime = System.currentTimeMillis();
         List<TCoreMaskingRule> list = this.ruleService.queryMaskingRule();
         Map<String, String> ruleMap = new HashMap();

         for(TCoreMaskingRule rule : list) {
            ruleMap.put(rule.getRulename(), rule.getId());
         }

         for(int i = 1; i < rowsNum + 1; ++i) {
            Row row = sheet.getRow(i);
            if (row != null) {
               TreeGridSensitiveDataVO treeGridSensitiveDataVO = (TreeGridSensitiveDataVO)this.redisService.get(row.getCell(3).toString() + "-" + row.getCell(4).toString());

               for(int j = 0; j < treeGridSensitiveDataVO.getChildren().size(); ++j) {
                  if (((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(j)).getName().equals(row.getCell(5).toString())) {
                     ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(j)).setColumnChecked(row.getCell(12).toString().equals("是") ? "1" : "0");
                     ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(j)).setIsIntelligent(row.getCell(13).toString().equals("是") ? "1" : "0");
                     if (!row.getCell(10).toString().equals("确认非敏感字段") && row.getCell(10).toString() != "确认非敏感字段") {
                        ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(j)).setRegexType(row.getCell(10).toString());
                        ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(j)).setRuleName(row.getCell(11).toString());
                        ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(j)).setRuleId((String)ruleMap.get(row.getCell(11).toString()));
                     } else {
                        ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(j)).setRegexType(row.getCell(10).toString());
                        ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(j)).setRuleName(row.getCell(10).toString());
                        ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(j)).setRuleId("");
                     }
                     break;
                  }
               }

               String checkedStr = row.getCell(12).toString();
               if (checkedStr.equals("是") || checkedStr == "是") {
                  searchinfoVO.setSure_colum_number((long)(num++));
               }

               this.redisService.set(row.getCell(3).toString() + "-" + row.getCell(4).toString(), treeGridSensitiveDataVO);
            }
         }

         long endTime = System.currentTimeMillis();
         System.out.println("程序运行时间： " + (endTime - startTime) + "ms");
         this.redisService.set("searchinfoVO", searchinfoVO);
         return searchinfoVO.getSure_colum_number() + "";
      } catch (IOException e) {
         e.printStackTrace();
         return "FAIL";
      }
   }

   @RequestMapping({"/queryAllRegexTypeColor"})
   @ResponseBody
   public List<RegexTypeColorVO> queryAllRegexTypeColor() {
      return this.dictionaryService.queryAllRegexTypeColor();
   }

   @ResponseBody
   @RequestMapping({"/querySensitiveColumnId"})
   public ResultVO querySensitiveColumnId(String groupId, String dataSourceId, String schema, String tableName, String columnName, HttpServletRequest request, HttpServletResponse response, Model model) {
      TCoreSensitivecolumn column = this.sensitiveColumnService.querySensitiveColumn(groupId, dataSourceId, schema, tableName, columnName);
      ResultVO result = null;
      if (null == column) {
         result = new ResultVO("请先保存该字段", false);
      } else if (null != column.getRegextype() && !"".equals(column.getRegextype())) {
         result = new ResultVO(column.getId(), true);
      } else {
         result = new ResultVO("请先保存该字段的敏感类型", false);
      }

      return result;
   }

   @ResponseBody
   @RequestMapping({"/querySensitiveColumns"})
   public List<SenstiveColumnRelationVO> querySensitiveColumns(String groupId, String sensitiveColumnId, String regexType, HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.sensitiveColumnService.querySensitiveColumns(groupId, sensitiveColumnId, regexType);
   }

   @ResponseBody
   @RequestMapping({"/saveSensitiveRelation"})
   public Boolean saveSensitiveRelation(String sourceColumnId, @RequestParam(value = "targetColumnIds[]",required = false) List<String> targetColumnIds, @RequestParam(value = "deletedColumnIds[]",required = false) List<String> deletedColumnIds, HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.sensitiveColumnService.saveSensitiveRelation(sourceColumnId, targetColumnIds, deletedColumnIds);
   }

   @ResponseBody
   @RequestMapping({"/querySensitiveColumnRelations"})
   public List<TCoreSensitiverelation> querySensitiveColumnRelations(String groupId, HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.sensitiveColumnService.querySensitiveColumnRelations(groupId);
   }

   @ResponseBody
   @RequestMapping({"/exportColumnRelations"})
   public ResultVO exportColumnRelations(String groupId, HttpServletRequest request, HttpServletResponse response, Model model) throws Exception {
      List<TCoreSensitiverelation> list = this.sensitiveColumnService.querySensitiveColumnRelations(groupId);
      Map<String, TCoreSensitiverelation> columnIdMap = new HashMap();
      Map<String, List<String>> relationMap = new HashMap();
      String targetColumnIds = "";

      for(TCoreSensitiverelation relation : list) {
         List<String> currentColumnRelationList = null;
         String columnId = relation.getSsensitivecolumnid();
         String targetColumnId = relation.getTsensitivecolumnid();
         targetColumnIds = targetColumnIds + targetColumnId + ",";
         if (!columnIdMap.containsKey(columnId)) {
            columnIdMap.put(columnId, relation);
         }

         if (targetColumnIds.indexOf(columnId) == -1) {
            if (!relationMap.containsKey(columnId)) {
               currentColumnRelationList = new ArrayList();
               relationMap.put(columnId, currentColumnRelationList);
            } else {
               currentColumnRelationList = (List)relationMap.get(columnId);
            }

            currentColumnRelationList.add(targetColumnId);
         }
      }

      String path = request.getSession().getServletContext().getRealPath("/") + "css" + File.separator + UUID.randomUUID().toString() + ".xlsx";
      LinkedBlockingQueue<TCoreSensitiverelation> queue = new LinkedBlockingQueue();
      List<Integer> mergeCellArray = new ArrayList();
      int rowIndex = 1;

      for(Map.Entry<String, List<String>> entry : relationMap.entrySet()) {
         TCoreSensitiverelation column = (TCoreSensitiverelation)columnIdMap.get(entry.getKey());
         List<TCoreSensitiverelation> tempList = new ArrayList();
         tempList.add(column);
         mergeCellArray.add(rowIndex);
         List<String> listNew = (List)entry.getValue();
         for(String targetColumnId : listNew) {
            TCoreSensitiverelation targetColumn = (TCoreSensitiverelation)columnIdMap.get(targetColumnId);
            if (targetColumn != null) {
               tempList.add(targetColumn);
            }

            ++rowIndex;
         }

         mergeCellArray.add(rowIndex++);
         mergeCellArray.add(0);
         mergeCellArray.add(0);
         Collections.sort(tempList, new Comparator<TCoreSensitiverelation>() {
            public int compare(TCoreSensitiverelation r1, TCoreSensitiverelation r2) {
               if (r1 == null) {
                  return 0;
               } else if (r1.getTablename() == null) {
                  return 0;
               } else if (r2 == null) {
                  return 0;
               } else {
                  return r1.getTablename() == null ? 0 : r1.getTablename().compareTo(r2.getTablename());
               }
            }
         });
         queue.addAll(tempList);
      }

      Map<String, String> titlevalue = new LinkedHashMap();
      titlevalue.put("敏感类型", "regextype");
      titlevalue.put("数据源", "datasourcename");
      titlevalue.put("所有者", "schema");
      titlevalue.put("表名", "tablename");
      titlevalue.put("列名", "columnname");
      List<Integer> columnWidthList = new ArrayList();
      columnWidthList.add(2700);
      columnWidthList.add(2200);
      columnWidthList.add(2200);
      columnWidthList.add(1600);
      columnWidthList.add(1600);
      ExcelTool.generateExcel(path, queue, titlevalue, columnWidthList, mergeCellArray);
      ResultVO vo = new ResultVO(path, true);
      return vo;
   }

   @ResponseBody
   @RequestMapping({"/querysensitivegroup"})
   public List<TCoreSensitivegroup> querySensitiveGroup(HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.sensitiveColumnService.querySensitiveGroup();
   }

   @ResponseBody
   @RequestMapping({"/querysensitivegroupbycondition"})
   public List<TCoreSensitivegroup> querySensitiveGroup(String dataSourceId, @RequestParam("schemas[]") List<String> schemas, HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.sensitiveColumnService.querySensitiveGroup(dataSourceId, schemas);
   }

   @ResponseBody
   @RequestMapping({"/querysensitivegroupbyconditionbymysql"})
   public List<TCoreSensitivegroup> querySensitiveGroupByMysql(String dataSourceId, @RequestParam("schemas[]") List<String> schemas, HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.sensitiveColumnService.querySensitiveGroup(dataSourceId);
   }

   @RequestMapping({"/updatetoRedis"})
   @ResponseBody
   public String updatetoRedis(HttpServletRequest request, String key, String schema, String table, String coluname, String columnChecked, String ruleId, String ruleName, String regextype) {
      if (ruleName != null && ruleName.equals("确认非敏感字段")) {
         regextype = "确认非敏感字段";
         ruleId = "确认非敏感字段";
      }

      new SearchinfoVO();
      SearchinfoVO searchinfoVO = (SearchinfoVO)this.redisService.get("searchinfoVO");
      TreeGridSensitiveDataVO treeGridSensitiveDataVO = (TreeGridSensitiveDataVO)this.redisService.get(schema + "-" + table);

      for(int i = 0; i < treeGridSensitiveDataVO.getChildren().size(); ++i) {
         if (((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).getName().equals(coluname)) {
            if (columnChecked != ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).getColumnChecked()) {
               if ("1".equals(columnChecked)) {
                  searchinfoVO.setSure_colum_number(searchinfoVO.getSure_colum_number() + 1L);
               } else if ("0".equals(columnChecked)) {
                  searchinfoVO.setSure_colum_number(searchinfoVO.getSure_colum_number() - 1L);
               }

               this.redisService.set("searchinfoVO", searchinfoVO);
            }

            ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).setColumnChecked(columnChecked);
            ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).setRuleId(ruleId);
            ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).setRegexType(regextype);
            ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).setRuleName(ruleName);
            break;
         }
      }

      this.redisService.set(schema + "-" + table, treeGridSensitiveDataVO);
      return searchinfoVO.getSure_colum_number() + "";
   }

   @RequestMapping({"/updateAllToRedis"})
   @ResponseBody
   public void updateAllToRedis(HttpServletRequest request, String ruleId, String ruleName, String regexType, String checkboxtype, String schemaTable, String columnname) {
      HttpSession session = request.getSession();

      for(Object voKeyobj : this.redisService.range("sensitive:" + session.getId(), 0, -1)) {
         String voKey = (String)voKeyobj;
         new TreeGridSensitiveDataVO();
         TreeGridSensitiveDataVO treeGridSensitiveDataVO = (TreeGridSensitiveDataVO)this.redisService.get(voKey);
         if (treeGridSensitiveDataVO != null) {
            boolean isUp = true;
            if (schemaTable == null || schemaTable.equals("") || voKey.equals(schemaTable)) {
               for(int i = 0; i < treeGridSensitiveDataVO.getChildren().size(); ++i) {
                  if (!((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).getColumnChecked().equals("1")) {
                     if (columnnameLikeMethod(((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).getName(), columnname)) {
                        if (checkboxtype.equals("2")) {
                           if (((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).getRegexType() != null && !((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).getRegexType().equals("")) {
                              ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).setRuleId(ruleId);
                              ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).setRuleName(ruleName);
                              ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).setRegexType(regexType);
                           }
                        } else {
                           ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).setRuleId(ruleId);
                           ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).setRuleName(ruleName);
                           ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).setRegexType(regexType);
                        }
                     }

                     this.redisService.set(voKey, treeGridSensitiveDataVO);
                  }
               }

               String setKey = treeGridSensitiveDataVO.getSchema() + "-" + treeGridSensitiveDataVO.getName();
               this.redisService.set(setKey, treeGridSensitiveDataVO);
            }
         }
      }

   }

   @RequestMapping({"/allupdatetoRedis"})
   @ResponseBody
   public String allupdatetoRedis(HttpServletRequest request, String key, String isall, String checkboxtype, String schemaTable, String columnname) {
      HttpSession session = request.getSession();
      long sure_colum = 0L;
      Set<Object> zrange = this.redisService.range("sensitive:" + session.getId(), 0, -1);
      if (isall.equals("0")) {
         for(Object voKeyobj : zrange) {
            String voKey = (String)voKeyobj;
            new TreeGridSensitiveDataVO();
            TreeGridSensitiveDataVO treeGridSensitiveDataVO = (TreeGridSensitiveDataVO)this.redisService.get(voKey);
            if (treeGridSensitiveDataVO != null) {
               boolean isUp = true;
               if (schemaTable == null || schemaTable.equals("") || voKey.equals(schemaTable)) {
                  for(int i = 0; i < treeGridSensitiveDataVO.getChildren().size(); ++i) {
                     ++sure_colum;
                     if (!((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).getColumnChecked().equals("1")) {
                        if (columnname != null && !columnname.equals("")) {
                           String name = ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).getName();
                           if (!columnnameLikeMethod(name, columnname)) {
                              continue;
                           }
                        }

                        if (checkboxtype.equals("2")) {
                           if (((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).getRegexType() != null && !((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).getRegexType().equals("")) {
                              ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).setColumnChecked("1");
                           }
                        } else {
                           if (((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).getRegexType() == null || ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).getRegexType().equals("")) {
                              ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).setRegexType("确认非敏感字段");
                              ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).setRegexName("确认非敏感字段");
                              ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).setRuleName("确认非敏感字段");
                           }

                           ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).setColumnChecked("1");
                        }

                        this.redisService.set(voKey, treeGridSensitiveDataVO);
                     }
                  }

                  String setKey = treeGridSensitiveDataVO.getSchema() + "-" + treeGridSensitiveDataVO.getName();
                  this.redisService.set(setKey, treeGridSensitiveDataVO);
               }
            }
         }

         return sure_colum + "";
      } else {
         Iterator var19 = zrange.iterator();

         while(true) {
            TreeGridSensitiveDataVO var23;
            label81:
            while(true) {
               if (!var19.hasNext()) {
                  new SearchinfoVO();
                  SearchinfoVO var20 = (SearchinfoVO)this.redisService.get("searchinfoVO");
                  var20.setSure_colum_number(sure_colum);
                  this.redisService.set("searchinfoVO", var20);
                  return sure_colum + "";
               }

               Object voKeyobj = var19.next();
               String voKey = (String)voKeyobj;
               new TreeGridSensitiveDataVO();
               var23 = (TreeGridSensitiveDataVO)this.redisService.get(voKey);
               if (var23 == null) {
                  break;
               }

               boolean isUp = true;
               if (schemaTable == null || schemaTable.equals("") || voKey.equals(schemaTable)) {
                  int i = 0;

                  while(true) {
                     if (i >= var23.getChildren().size()) {
                        break label81;
                     }

                     if (!((TreeGridSensitiveDataVO)var23.getChildren().get(i)).getColumnChecked().equals("0")) {
                        label136: {
                           if (columnname != null && !columnname.equals("")) {
                              String name = ((TreeGridSensitiveDataVO)var23.getChildren().get(i)).getName();
                              if (!columnnameLikeMethod(name, columnname)) {
                                 break label136;
                              }
                           }

                           if (((TreeGridSensitiveDataVO)var23.getChildren().get(i)).getRegexType().equals("确认非敏感字段")) {
                              ((TreeGridSensitiveDataVO)var23.getChildren().get(i)).setRegexType("");
                              ((TreeGridSensitiveDataVO)var23.getChildren().get(i)).setRegexName("");
                              ((TreeGridSensitiveDataVO)var23.getChildren().get(i)).setRuleName("");
                           }

                           ((TreeGridSensitiveDataVO)var23.getChildren().get(i)).setColumnChecked("0");
                        }
                     }

                     ++i;
                  }
               }
            }

            String setKey = var23.getSchema() + "-" + var23.getName();
            this.redisService.set(setKey, var23);
         }
      }
   }

   @RequestMapping({"/searchsensitivedatalist"})
   public String searchSensitiveDataList(HttpServletRequest request, String schemaTable, String checkboxtype, String columnname, String group) {
      if (checkboxtype != null) {
         request.setAttribute("checkboxtype", checkboxtype);
      }

      if (schemaTable != null) {
         request.getSession().setAttribute("schemaTable", schemaTable);
      }

      if (columnname != null) {
         request.getSession().setAttribute("columnname", columnname);
      }

      if (group != null) {
         request.setAttribute("group", group);
      }

      SearchinfoVO searchinfoVO = (SearchinfoVO)this.redisService.get("searchinfoVO");
      request.setAttribute("searchinfoVO", searchinfoVO);
      return "core/searchsensitivedata/searchsensitivedatalist";
   }

   @ResponseBody
   @RequestMapping({"/showsensitivedatalist"})
   public DataGridVO<TreeGridSensitiveDataVO> showSensitiveDataList(String type, String schemaTable, String columnname, PageInfo pageInfo, int rows, int page, HttpServletRequest request, HttpServletResponse response, Model model) {
      String s = request.getSession().getId();
      if (schemaTable == null || schemaTable.equals("")) {
         schemaTable = (String)request.getSession().getAttribute("schemaTable");
      }

      if (columnname == null || columnname.equals("")) {
         columnname = (String)request.getSession().getAttribute("columnname");
      }

      DataGridVO<TreeGridSensitiveDataVO> vo = null;
      Long totol = new Long(0L);
      List<TreeGridSensitiveDataVO> list = new ArrayList();
      if (type != null && type.equals("2")) {
         Set<Object> zrange = this.redisService.range("sensitive:" + s, PageTool.getPageStart(rows, page), PageTool.getPageEnd(rows, page));
         int num = 1;

         for(Object keyobj : zrange) {
            String key = (String)keyobj;
            boolean flag = false;
            List<TreeGridSensitiveDataVO> newTreeGridSensitiveDataVO = new ArrayList();
            TreeGridSensitiveDataVO treeGridSensitiveDataVO = null;
            if (schemaTable != null && !schemaTable.equals("")) {
               if (schemaTable.equals(key)) {
                  treeGridSensitiveDataVO = (TreeGridSensitiveDataVO)this.redisService.get(key);
               }
            } else {
               treeGridSensitiveDataVO = (TreeGridSensitiveDataVO)this.redisService.get(key);
            }

            if (treeGridSensitiveDataVO != null) {
               for(int i = 0; i < treeGridSensitiveDataVO.getChildren().size(); ++i) {
                  if (((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).getRegexType() != null && !((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).getRegexType().equals("") && !((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).getRegexType().equals("确认非敏感字段")) {
                     if (columnname != null && !columnname.equals("")) {
                        if (((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).getName() != null && !((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).getName().equals("") && ((TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i)).getName().equals(columnname)) {
                           flag = true;
                           newTreeGridSensitiveDataVO.add(treeGridSensitiveDataVO.getChildren().get(i));
                        }
                     } else {
                        flag = true;
                        newTreeGridSensitiveDataVO.add(treeGridSensitiveDataVO.getChildren().get(i));
                     }
                  }
               }
            }

            if (flag) {
               treeGridSensitiveDataVO.setChildren(newTreeGridSensitiveDataVO);
               this.redisService.set("senCol-" + treeGridSensitiveDataVO.getSchema() + "-" + treeGridSensitiveDataVO.getName(), JsonTool.toJsonString(treeGridSensitiveDataVO), new Long(10800L));
               this.redisService.zAdd("senCol:" + s, "senCol-" + treeGridSensitiveDataVO.getSchema() + "-" + treeGridSensitiveDataVO.getName(), (double)(num++), new Long(10800L));
               list.add(treeGridSensitiveDataVO);
            }
         }

         totol = this.redisService.zCard("sensitive:" + s);
         vo = new DataGridVO<TreeGridSensitiveDataVO>(totol, list);
      } else {
         new TreeGridSensitiveDataVO();
         if (schemaTable != null && !schemaTable.equals("")) {
            TreeGridSensitiveDataVO var26 = (TreeGridSensitiveDataVO)this.redisService.get(schemaTable);
            if (columnname != null && !columnname.equals("")) {
               List<TreeGridSensitiveDataVO> rreeGridSensitiveDataVOList = var26.getChildren();

               for(int i = 0; i < rreeGridSensitiveDataVOList.size(); ++i) {
                  TreeGridSensitiveDataVO treeGridSensitiveDataVOChildren = (TreeGridSensitiveDataVO)rreeGridSensitiveDataVOList.get(i);
                  if (!columnnameLikeMethod(treeGridSensitiveDataVOChildren.getName(), columnname)) {
                     rreeGridSensitiveDataVOList.remove(i);
                     --i;
                  }
               }

               var26.setChildren(rreeGridSensitiveDataVOList);
            }

            if (var26.getChildren().size() != 0) {
               totol = new Long(1L);
               list.add(var26);
            }

            vo = new DataGridVO<TreeGridSensitiveDataVO>(totol, list);
         } else {
            Set<Object> zrange = this.redisService.range("sensitive:" + s, PageTool.getPageStart(rows, page), PageTool.getPageEnd(rows, page));
            totol = this.redisService.zCard("sensitive:" + s);

            for(Object schameTableobj : zrange) {
               String schameTable = (String)schameTableobj;
               TreeGridSensitiveDataVO treeGridSensitiveDataVO = (TreeGridSensitiveDataVO)this.redisService.get(schameTable);
               if (columnname != null && !columnname.equals("")) {
                  List<TreeGridSensitiveDataVO> rreeGridSensitiveDataVOList = treeGridSensitiveDataVO.getChildren();

                  for(int i = 0; i < rreeGridSensitiveDataVOList.size(); ++i) {
                     TreeGridSensitiveDataVO treeGridSensitiveDataVOChildren = (TreeGridSensitiveDataVO)rreeGridSensitiveDataVOList.get(i);
                     if (!columnnameLikeMethod(treeGridSensitiveDataVOChildren.getName(), columnname)) {
                        rreeGridSensitiveDataVOList.remove(i);
                        --i;
                     }
                  }

                  treeGridSensitiveDataVO.setChildren(rreeGridSensitiveDataVOList);
               }

               if (treeGridSensitiveDataVO.getChildren().size() != 0) {
                  list.add(treeGridSensitiveDataVO);
               }
            }

            vo = new DataGridVO<TreeGridSensitiveDataVO>(totol, list);
         }

         request.getSession().setAttribute("schemaTable", null);
         request.getSession().setAttribute("columnname", null);
      }

      request.setAttribute("schemaTable", schemaTable);
      request.setAttribute("checkboxtype", type);
      request.setAttribute("columnname", columnname);
      return vo;
   }

   @RequestMapping({"/searchBySchemaTable"})
   @ResponseBody
   public JSONArray searchBySchemaTable(HttpServletRequest request) {
      JSONArray jsonArr = JSONArray.parseArray((String)request.getSession().getAttribute("schameTable"));
      return jsonArr;
   }

   @ResponseBody
   @RequestMapping({"/getMatchValuesAndNotMatchValues"})
   public HashMap<String, List<String>> a(String schema, String tableName, String columnname, HttpServletRequest request, HttpServletResponse response, Model model) {
      String key = schema + "_m" + tableName + "_m" + columnname;
      Object obj = this.redisService.get(key);
      HashMap<String, List<String>> keyhash = (HashMap)obj;
      return keyhash;
   }

   public static Boolean columnnameLikeMethod(String name, String columnname) {
      String eColumnname = columnname.replace("%", "");
      if (columnname.contains("%")) {
         if (columnname.endsWith("%") && columnname.startsWith("%")) {
            return name.contains(eColumnname);
         }

         if (columnname.endsWith("%")) {
            return name.startsWith(eColumnname);
         }

         if (columnname.startsWith("%")) {
            return name.endsWith(eColumnname);
         }
      }

      return name.equals(eColumnname);
   }

   public static Boolean tableNameLikeMethod(String name, String columnname) {
      String eColumnname = columnname.replace("%", "");
      if (columnname.contains("%")) {
         if (columnname.endsWith("%") && columnname.startsWith("%")) {
            return name.contains(eColumnname);
         }

         if (columnname.endsWith("%")) {
            return name.startsWith(eColumnname);
         }

         if (columnname.startsWith("%")) {
            return name.endsWith(eColumnname);
         }
      }

      return name.contains(eColumnname);
   }

   @ResponseBody
   @RequestMapping({"/project"})
   public List<HashMap<String, String>> project(String schema, String tableName, String columnname, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<HashMap<String, String>> maplist = new ArrayList();

      for(TCoreProjectInfo tCoreProjectInfo : this.coreProjectService.queryAll()) {
         HashMap<String, String> map = new HashMap();
         map.put("text", tCoreProjectInfo.getProjectname());
         map.put("id", tCoreProjectInfo.getRealprojectname());
         maplist.add(map);
      }

      return maplist;
   }

   @ResponseBody
   @RequestMapping({"/queryAllInforZuoYou"})
   public List<Releasecolumn> queryAllInforZuoYou(@RequestParam Map<String, Object> parameter, HttpServletRequest request, HttpServletResponse response) {
      new HashMap();
      String projectid = (String)parameter.get("projectid");
      String state = (String)parameter.get("state");
      new ArrayList();
      List<Releasecolumn> releasecolumnleftlist = new ArrayList();
      List<Releasecolumn> releasecolumnrightlist = new ArrayList();
      if (state.equals("2")) {
         releasecolumnrightlist = (List)request.getSession().getAttribute("releasecolumnrightlist");
         return releasecolumnrightlist;
      } else if (!state.equals("1")) {
         return null;
      } else {
         HttpSession session = request.getSession();
         Set<Object> zrange = this.redisService.range("sensitive:" + session.getId(), 0, -1);
         List<String> schemas = (List)session.getAttribute("schemas");
         HashMap<String, String> map = new HashMap();

         for(String String : schemas) {
            map.put(String, String);
         }

         List<Releasecolumn> releasecolumnlist = this.sensitiveColumnService.queryTcoreReleasecolumn(schemas, projectid, projectid);
         HashMap<String, Releasecolumn> maprelease = new HashMap();
         new HashMap();

         for(Releasecolumn releasecolumn : releasecolumnlist) {
            String stc = releasecolumn.getDatasystemid() + "-" + releasecolumn.getTschema() + "-" + releasecolumn.getTablename() + "-" + releasecolumn.getColumnname();
            maprelease.put(stc, releasecolumn);
         }

         int count = zrange.size();

         for(Object tablekeyobj : zrange) {
            String tablekey = (String)tablekeyobj;
            --count;
            String tablename = tablekey.split("\\-")[1];
            String schema = tablekey.split("\\-")[0];
            new TreeGridSensitiveDataVO();
            TreeGridSensitiveDataVO treeGridSensitiveDataVO = (TreeGridSensitiveDataVO)this.redisService.get(tablekey);
            if (treeGridSensitiveDataVO != null) {
               new ArrayList();

               for(int i = 0; i < treeGridSensitiveDataVO.getChildren().size(); ++i) {
                  TreeGridSensitiveDataVO treeGridSensitiveDataVOchildren = (TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i);
                  String tablekey_c = treeGridSensitiveDataVOchildren.getDatasourceid() + "-" + tablekey + "-" + treeGridSensitiveDataVOchildren.getName();
                  Releasecolumn releasecolumn = (Releasecolumn)maprelease.get(tablekey_c);
                  if (releasecolumn == null) {
                     releasecolumn = new Releasecolumn();
                     releasecolumn.setChecked(treeGridSensitiveDataVOchildren.getColumnChecked());
                     releasecolumn.setColumnname(treeGridSensitiveDataVOchildren.getName());
                     releasecolumn.setProjectid(projectid);
                     releasecolumn.setRulename(treeGridSensitiveDataVOchildren.getRuleName());
                     releasecolumn.setTablename(tablename);
                     releasecolumn.setTid(UUID.randomUUID().toString());
                     releasecolumn.setTschema(schema);
                     releasecolumn.setDatasystemid(treeGridSensitiveDataVOchildren.getDatasourceid());
                     Releasecolumn releasecolumnnew = new Releasecolumn();
                     releasecolumnleftlist.add(releasecolumn);
                     releasecolumnrightlist.add(releasecolumnnew);
                  } else {
                     String compare_old = releasecolumn.getChecked() + releasecolumn.getRulename();
                     String compare_new = treeGridSensitiveDataVOchildren.getColumnChecked() + (treeGridSensitiveDataVOchildren.getRuleName() == null ? "" : treeGridSensitiveDataVOchildren.getRuleName());
                     if (!compare_old.equals(compare_new)) {
                        Releasecolumn releasecolumn_left = new Releasecolumn();
                        releasecolumn_left.setChecked(treeGridSensitiveDataVOchildren.getColumnChecked());
                        releasecolumn_left.setColumnname(treeGridSensitiveDataVOchildren.getName());
                        releasecolumn_left.setProjectid(projectid);
                        releasecolumn_left.setRulename(treeGridSensitiveDataVOchildren.getRuleName());
                        releasecolumn_left.setTablename(tablename);
                        releasecolumn_left.setTid(UUID.randomUUID().toString());
                        releasecolumn_left.setDatasystemid(treeGridSensitiveDataVOchildren.getDatasourceid());
                        releasecolumn_left.setTschema(schema);
                        releasecolumnleftlist.add(releasecolumn_left);
                        releasecolumnrightlist.add(releasecolumn);
                     }

                     releasecolumnlist.remove(releasecolumn);
                     maprelease.remove(tablekey_c);
                  }
               }
            }
         }

         Releasecolumn releasecolumnnew = new Releasecolumn();

         for(int i = 0; i < maprelease.entrySet().size(); ++i) {
            releasecolumnleftlist.add(releasecolumnnew);
         }

         releasecolumnrightlist.addAll(releasecolumnlist);
         request.getSession().setAttribute("releasecolumnrightlist", releasecolumnrightlist);
         return releasecolumnleftlist;
      }
   }

   @ResponseBody
   @RequestMapping({"/surerelease"})
   public String surerelease(@RequestParam Map<String, Object> parameter, HttpServletRequest request, HttpServletResponse response) {
      String projectid = (String)parameter.get("projectid");
      String addtype = (String)parameter.get("addtype");
      HttpSession session = request.getSession();
      Set<Object> zrange = this.redisService.range("sensitive:" + session.getId(), 0, -1);
      int count = zrange.size();
      StringBuilder sqlstr = new StringBuilder();
      List<String> list_column = JdbcTool.sql_insert_q(new Releasecolumn());
      String sb_sql_column = JdbcTool.sql_insert_z(list_column, projectid);
      sqlstr.append(sb_sql_column);
      if ("0".equals(addtype)) {
         this.sensitiveColumnService.deleReleasecolumnByProductId(projectid, projectid);

         for(Object tablekeyobj : zrange) {
            String tablekey = (String)tablekeyobj;
            --count;
            String tablename = tablekey.split("\\-")[1];
            String schema = tablekey.split("\\-")[0];
            new TreeGridSensitiveDataVO();
            TreeGridSensitiveDataVO tablekeyobjNew = (TreeGridSensitiveDataVO)this.redisService.get(tablekey);
            if (tablekeyobjNew != null) {
               new ArrayList();

               for(int i = 0; i < tablekeyobjNew.getChildren().size(); ++i) {
                  TreeGridSensitiveDataVO treeGridSensitiveDataVOchildren = (TreeGridSensitiveDataVO)tablekeyobjNew.getChildren().get(i);
                  Releasecolumn releasecolumn = new Releasecolumn();
                  releasecolumn.setTid(UUID.randomUUID().toString());
                  releasecolumn.setChecked(treeGridSensitiveDataVOchildren.getColumnChecked());
                  releasecolumn.setColumnname(treeGridSensitiveDataVOchildren.getName());
                  releasecolumn.setProjectid(projectid);
                  releasecolumn.setRulename(treeGridSensitiveDataVOchildren.getRegexType() == null ? "" : treeGridSensitiveDataVOchildren.getRegexType());
                  releasecolumn.setTablename(tablename);
                  releasecolumn.setDatasystemid(treeGridSensitiveDataVOchildren.getDatasourceid());
                  releasecolumn.setTschema(tablekeyobjNew.getSchema());

                  try {
                     sqlstr.append(JdbcTool.sql_insert_h(releasecolumn, list_column));
                  } catch (IllegalAccessException e) {
                     e.printStackTrace();
                  } catch (IllegalArgumentException e) {
                     e.printStackTrace();
                  } catch (InvocationTargetException e) {
                     e.printStackTrace();
                  }
               }
            }
         }

         this.sensitiveColumnService.saveReleasecolumn(sqlstr.deleteCharAt(sqlstr.length() - 1));
      } else if ("1".equals(addtype)) {
         List<String> schemas = (List)session.getAttribute("schemas");
         List<Releasecolumn> releasecolumnlist = this.sensitiveColumnService.queryTcoreReleasecolumn(schemas, projectid, projectid);
         List<Releasecolumn> releasecolumnleftlist = new ArrayList();
         HashMap<String, Releasecolumn> maprelease = new HashMap();

         for(Releasecolumn releasecolumn : releasecolumnlist) {
            String stc = releasecolumn.getDatasystemid() + "-" + releasecolumn.getTschema() + "-" + releasecolumn.getTablename() + "-" + releasecolumn.getColumnname();
            maprelease.put(stc, releasecolumn);
         }

         for(Object tablekeyobj : zrange) {
            String tablekey = (String)tablekeyobj;
            --count;
            String tablename = tablekey.split("\\-")[1];
            String schema = tablekey.split("\\-")[0];
            new TreeGridSensitiveDataVO();
            TreeGridSensitiveDataVO var68 = (TreeGridSensitiveDataVO)this.redisService.get(tablekey);
            if (var68 != null) {
               new ArrayList();

               for(int i = 0; i < var68.getChildren().size(); ++i) {
                  TreeGridSensitiveDataVO treeGridSensitiveDataVOchildren = (TreeGridSensitiveDataVO)var68.getChildren().get(i);
                  String tablekey_c = treeGridSensitiveDataVOchildren.getDatasourceid() + "-" + tablekey + "-" + treeGridSensitiveDataVOchildren.getName();
                  Releasecolumn releasecolumn = (Releasecolumn)maprelease.get(tablekey_c);
                  if (releasecolumn == null) {
                     releasecolumn = new Releasecolumn();
                     releasecolumn.setChecked(treeGridSensitiveDataVOchildren.getColumnChecked());
                     releasecolumn.setColumnname(treeGridSensitiveDataVOchildren.getName());
                     releasecolumn.setProjectid(projectid);
                     releasecolumn.setRulename(treeGridSensitiveDataVOchildren.getRegexType() == null ? "" : treeGridSensitiveDataVOchildren.getRegexType());
                     releasecolumn.setTablename(tablename);
                     releasecolumn.setTid(UUID.randomUUID().toString());
                     releasecolumn.setTschema(schema);
                     releasecolumn.setDatasystemid(treeGridSensitiveDataVOchildren.getDatasourceid());
                     releasecolumnleftlist.add(releasecolumn);

                     try {
                        sqlstr.append(JdbcTool.sql_insert_h(releasecolumn, list_column));
                     } catch (IllegalAccessException e) {
                        e.printStackTrace();
                     } catch (IllegalArgumentException e) {
                        e.printStackTrace();
                     } catch (InvocationTargetException e) {
                        e.printStackTrace();
                     }
                  }
               }
            }
         }

         this.sensitiveColumnService.saveReleasecolumn(sqlstr.deleteCharAt(sqlstr.length() - 1));
      } else if ("2".equals(addtype)) {
         List<String> schemas = (List)session.getAttribute("schemas");
         List<Releasecolumn> releasecolumnlist = this.sensitiveColumnService.queryTcoreReleasecolumn(schemas, projectid, projectid);
         List<Releasecolumn> releasecolumnleftlist = new ArrayList();
         List<Releasecolumn> releasecolumnrightlist = new ArrayList();
         HashMap<String, Releasecolumn> maprelease = new HashMap();

         for(Releasecolumn releasecolumn : releasecolumnlist) {
            String stc = releasecolumn.getDatasystemid() + "-" + releasecolumn.getTschema() + "-" + releasecolumn.getTablename() + "-" + releasecolumn.getColumnname();
            maprelease.put(stc, releasecolumn);
         }

         for(Object tablekeyobj : zrange) {
            String tablekey = (String)tablekeyobj;
            --count;
            String tablename = tablekey.split("\\-")[1];
            String schema = tablekey.split("\\-")[0];
            new TreeGridSensitiveDataVO();
            TreeGridSensitiveDataVO treeGridSensitiveDataVO = (TreeGridSensitiveDataVO)this.redisService.get(tablekey);
            if (treeGridSensitiveDataVO != null) {
               new ArrayList();

               for(int i = 0; i < treeGridSensitiveDataVO.getChildren().size(); ++i) {
                  TreeGridSensitiveDataVO treeGridSensitiveDataVOchildren = (TreeGridSensitiveDataVO)treeGridSensitiveDataVO.getChildren().get(i);
                  String tablekey_c = treeGridSensitiveDataVOchildren.getDatasourceid() + "-" + tablekey + "-" + treeGridSensitiveDataVOchildren.getName();
                  Releasecolumn releasecolumn = (Releasecolumn)maprelease.get(tablekey_c);
                  if (releasecolumn == null) {
                     releasecolumn = new Releasecolumn();
                     releasecolumn.setChecked(treeGridSensitiveDataVOchildren.getColumnChecked());
                     releasecolumn.setColumnname(treeGridSensitiveDataVOchildren.getName());
                     releasecolumn.setProjectid(projectid);
                     releasecolumn.setRulename(treeGridSensitiveDataVOchildren.getRegexType() == null ? "" : treeGridSensitiveDataVOchildren.getRegexType());
                     releasecolumn.setTablename(tablename);
                     releasecolumn.setTid(UUID.randomUUID().toString());
                     releasecolumn.setTschema(schema);
                     releasecolumn.setDatasystemid(treeGridSensitiveDataVOchildren.getDatasourceid());
                     releasecolumnleftlist.add(releasecolumn);

                     try {
                        sqlstr.append(JdbcTool.sql_insert_h(releasecolumn, list_column));
                     } catch (IllegalAccessException e) {
                        e.printStackTrace();
                     } catch (IllegalArgumentException e) {
                        e.printStackTrace();
                     } catch (InvocationTargetException e) {
                        e.printStackTrace();
                     }
                  } else {
                     String compare_old = releasecolumn.getChecked() + releasecolumn.getRulename();
                     String compare_new = treeGridSensitiveDataVOchildren.getColumnChecked() + (treeGridSensitiveDataVOchildren.getRuleName() == null ? "" : treeGridSensitiveDataVOchildren.getRuleName());
                     if (!compare_old.equals(compare_new)) {
                        Releasecolumn releasecolumn_left = new Releasecolumn();
                        releasecolumn_left.setChecked(treeGridSensitiveDataVOchildren.getColumnChecked());
                        releasecolumn_left.setColumnname(treeGridSensitiveDataVOchildren.getName());
                        releasecolumn_left.setProjectid(projectid);
                        releasecolumn.setRulename(treeGridSensitiveDataVOchildren.getRegexType() == null ? "" : treeGridSensitiveDataVOchildren.getRegexType());
                        releasecolumn_left.setTablename(tablename);
                        releasecolumn_left.setTid(releasecolumn.getTid());
                        releasecolumn_left.setTschema(schema);
                        releasecolumn_left.setDatasystemid(treeGridSensitiveDataVOchildren.getDatasourceid());
                        releasecolumnrightlist.add(releasecolumn_left);

                        try {
                           sqlstr.append(JdbcTool.sql_insert_h(releasecolumn_left, list_column));
                        } catch (IllegalAccessException e) {
                           e.printStackTrace();
                        } catch (IllegalArgumentException e) {
                           e.printStackTrace();
                        } catch (InvocationTargetException e) {
                           e.printStackTrace();
                        }
                     }
                  }
               }
            }
         }

         this.sensitiveColumnService.removeReleasecolumn(releasecolumnrightlist, projectid);
         this.sensitiveColumnService.saveReleasecolumn(sqlstr.deleteCharAt(sqlstr.length() - 1));
      }

      return "1";
   }
}
