package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleSystemSetting;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.service.core.TSystemSettingService;
import com.chenyang.nse.bussiness.tools.datatime.DateTimeTool;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/systemSetting"})
public class TSystemSettingController {
   @Autowired
   private TSystemSettingService systemSettingService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/systemSetting/systemSetting";
   }

   @RequestMapping({"/querySystemSetting"})
   @ResponseBody
   public DataGridVO<Map<String, Object>> querysystemSetting(Integer page, Integer rows) {
      PageInfo pageInfo = new PageInfo();
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<Map<String, Object>> list = this.systemSettingService.querySystemSetting(pageInfo);
      return new DataGridVO<Map<String, Object>>(pageInfo.getCount(), list);
   }

   @RequestMapping({"/updateSystemSetting"})
   @ResponseBody
   public String updateSwitchState(String id, String value) {
      TConsoleSystemSetting tss = this.systemSettingService.updateSwitchState(id, value);
      return DateTimeTool.formatDate(tss.getUpdatetime(), "");
   }
}
