package com.chenyang.nse.bussiness.controller.key;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.dao.core.key.TCoreKeyClientParamDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.key.TCoreKeyClientParam;
import com.chenyang.nse.bussiness.entity.vo.key.TCoreKeyClientParamVO;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping({"/key/client"})
public class KeyClientController {
   @Autowired
   TCoreKeyClientParamDao tCoreKeyClientParamDao;

   @GetMapping({"/showClientParams"})
   public Response showKeyParams(String projectid) {
      TCoreKeyClientParam tCoreKeyClientParam = (TCoreKeyClientParam)this.tCoreKeyClientParamDao.queryUnique(new Criterion[]{Restrictions.eq("projectid", projectid)});
      TCoreKeyClientParamVO tCoreKeyClientParamVO = new TCoreKeyClientParamVO();
      if (Objects.nonNull(tCoreKeyClientParam)) {
         BeanUtils.copyProperties(tCoreKeyClientParam, tCoreKeyClientParamVO);
      }

      return RespHelper.successResp(tCoreKeyClientParamVO);
   }

   @PostMapping({"/saveClientParams"})
   public Response saveKeyParams(@RequestBody TCoreKeyClientParamVO tCoreKeyClientParamVO) {
      String userName = CommonUtils.loginUsername();
      TCoreKeyClientParam tCoreKeyClientParam = new TCoreKeyClientParam();
      BeanUtils.copyProperties(tCoreKeyClientParamVO, tCoreKeyClientParam);
      String id = tCoreKeyClientParamVO.getId();
      if (StringUtils.isBlank(id)) {
         tCoreKeyClientParam.setId(StringTool.getTablePrimaryKey());
         tCoreKeyClientParam.setCreateuser(userName);
         tCoreKeyClientParam.setCreatetime(new Date());
         this.tCoreKeyClientParamDao.save(tCoreKeyClientParam);
      } else {
         tCoreKeyClientParam = (TCoreKeyClientParam)this.tCoreKeyClientParamDao.queryUnique(new Criterion[]{Restrictions.eq("id", id)});
         tCoreKeyClientParam.setKeylocation(tCoreKeyClientParamVO.getKeylocation());
         tCoreKeyClientParam.setEncdeclocation(tCoreKeyClientParamVO.getEncdeclocation());
         tCoreKeyClientParam.setUpdateuser(userName);
         tCoreKeyClientParam.setUpdatetime(new Date());
         this.tCoreKeyClientParamDao.update(tCoreKeyClientParam);
      }

      return RespHelper.successResp();
   }
}
