package com.chenyang.nse.bussiness.dao.table.core.encryption;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreDesensitizationStrategy;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class DesensitizationStrategyDao extends BaseDao<TCoreDesensitizationStrategy, String> {
   public List<TCoreDesensitizationStrategy> queryDesenStrategylist(String projectId, String strategyName, String remarks, String roleGroup, String state) {
      StringBuffer sqlBuffer = new StringBuffer("SELECT DISTINCT datasystem_id,strategyid,strategyname,rolegroup,remarks,createtime,createuser,state FROM T_CORE_Desensitization_Strategy WHERE projectid = '" + projectId + "'");
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sqlBuffer = new StringBuffer("SELECT DISTINCT datasystem_id as \"datasystem_id\",strategyid as \"strategyid\",strategyname as \"strategyname\",rolegroup as \"rolegroup\",remarks as \"remarks\",createtime as \"createtime\",createuser as \"createuser\",state as \"state\" FROM T_CORE_Desensitization_Strategy WHERE projectid = '" + projectId + "'");
      }

      if (StringUtils.hasText(strategyName)) {
         sqlBuffer.append(" and strategyname like '%" + strategyName + "%'");
      }

      if (StringUtils.hasText(remarks)) {
         sqlBuffer.append(" and remarks like '%" + remarks + "%'");
      }

      if (StringUtils.hasText(state)) {
         sqlBuffer.append(" and state = '" + state + "'");
      }

      sqlBuffer.append(" ORDER BY createtime DESC");
      String sql = sqlBuffer.toString();
      List<TCoreDesensitizationStrategy> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreDesensitizationStrategy.class)).getResultList();
      if (StringUtils.hasText(roleGroup)) {
         list = (List)list.stream().filter((e) -> e != null && e.getRolegroup() != null && Arrays.asList(e.getRolegroup().split(",")).contains(roleGroup)).collect(Collectors.toList());
      }

      return list;
   }

   public List<TCoreDesensitizationStrategy> queryDesenStrategyDetails(String projectId, String strategyId) {
      String sql = "SELECT id as id,strategyid,strategyname,rolegroup,remarks,projectid,datasystem_id,tschemas,names,table_field_id,dataareaid,dataareaname,ruleid,rulename,state,createuser,createtime FROM T_CORE_Desensitization_Strategy WHERE projectid = '" + projectId + "' and strategyid = '" + strategyId + "'";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "SELECT id as \"id\",strategyid as \"strategyid\",strategyname as \"strategyname\",rolegroup as \"rolegroup\",remarks as \"remarks\",projectid as \"projectid\",datasystem_id as \"datasystem_id\",tschemas as \"tschemas\",names as \"names\",table_field_id as \"table_field_id\",dataareaid as \"dataareaid\",dataareaname as \"dataareaname\",ruleid as \"ruleid\",rulename as \"rulename\",state as \"state\",createuser as \"createuser\",createtime as \"createtime\" FROM T_CORE_Desensitization_Strategy WHERE projectid = '" + projectId + "' and strategyid = '" + strategyId + "'";
      }

      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreDesensitizationStrategy.class)).getResultList();
   }
}
