package com.chenyang.nse.bussiness.entity.orm.table.base;

import com.chenyang.nse.bussiness.entity.orm.table.TInitEntity;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(
   name = "T_BASE_ROLEMENU"
)
public class TBaseRolemenu extends TInitEntity {
   private String roleid;
   private String menuid;

   public TBaseRolemenu() {
   }

   public TBaseRolemenu(String roleid, String menuid) {
      this.roleid = roleid;
      this.menuid = menuid;
   }

   public String getRoleid() {
      return this.roleid;
   }

   public void setRoleid(String roleid) {
      this.roleid = roleid;
   }

   public String getMenuid() {
      return this.menuid;
   }

   public void setMenuid(String menuid) {
      this.menuid = menuid;
   }

   public String toString() {
      return "TBaseRolemenu [roleid=" + this.roleid + ", menuid=" + this.menuid + "]";
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.menuid == null ? 0 : this.menuid.hashCode());
      result = 31 * result + (this.roleid == null ? 0 : this.roleid.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         TBaseRolemenu other = (TBaseRolemenu)obj;
         if (this.menuid == null) {
            if (other.menuid != null) {
               return false;
            }
         } else if (!this.menuid.equals(other.menuid)) {
            return false;
         }

         if (this.roleid == null) {
            if (other.roleid != null) {
               return false;
            }
         } else if (!this.roleid.equals(other.roleid)) {
            return false;
         }

         return true;
      }
   }
}
