package com.chenyang.nse.bussiness.entity.orm.table.core;

import com.chenyang.nse.bussiness.entity.orm.table.TBaseEntity;
import com.chenyang.nse.bussiness.entity.orm.table.console.engine.TConsoleEngineType;
import com.chenyang.nse.bussiness.entity.vo.engine.EnginePropertyVO;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(
   name = "T_CORE_ENGINE"
)
public class TCoreEngine extends TBaseEntity {
   private String enginename;
   private String enginetypeid;
   @Transient
   private TConsoleEngineType enginetype;
   @Transient
   private List<EnginePropertyVO> engineproperty;

   public TCoreEngine() {
   }

   public TCoreEngine(String enginename, String enginetypeid) {
      this.enginename = enginename;
      this.enginetypeid = enginetypeid;
   }

   public String getEnginename() {
      return this.enginename;
   }

   public void setEnginename(String enginename) {
      this.enginename = enginename;
   }

   public String getEnginetypeid() {
      return this.enginetypeid;
   }

   public void setEnginetypeid(String enginetypeid) {
      this.enginetypeid = enginetypeid;
   }

   public TConsoleEngineType getEnginetype() {
      return this.enginetype;
   }

   public void setEnginetype(TConsoleEngineType enginetype) {
      this.enginetype = enginetype;
   }

   public List<EnginePropertyVO> getEngineproperty() {
      return this.engineproperty;
   }

   public void setEngineproperty(List<EnginePropertyVO> engineproperty) {
      this.engineproperty = engineproperty;
   }

   public String toString() {
      return "TCoreEngine [enginename=" + this.enginename + ", enginetypeid=" + this.enginetypeid + "]";
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.enginename == null ? 0 : this.enginename.hashCode());
      result = 31 * result + (this.enginetypeid == null ? 0 : this.enginetypeid.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         TCoreEngine other = (TCoreEngine)obj;
         if (this.enginename == null) {
            if (other.enginename != null) {
               return false;
            }
         } else if (!this.enginename.equals(other.enginename)) {
            return false;
         }

         if (this.enginetypeid == null) {
            if (other.enginetypeid != null) {
               return false;
            }
         } else if (!this.enginetypeid.equals(other.enginetypeid)) {
            return false;
         }

         return true;
      }
   }
}
