package com.chenyang.nse.bussiness.job;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.table.core.TCoreLogParamDao;
import com.chenyang.nse.bussiness.tools.dataprocess.ApplicationContextProvider;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@EnableScheduling
public class LogTask {
   @Scheduled(
      cron = "0 0 23 * * ?"
   )
   public void saveLog() {
      try {
         TCoreLogParamDao tCoreLogParamDao = (TCoreLogParamDao)ApplicationContextProvider.getBean(TCoreLogParamDao.class);
         List<Map<String, Object>> logParamList = tCoreLogParamDao.selectNewReservemonth();
         new Properties();
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String todaylogpath = props.getProperty("deployPath") + "/encryption.log";
         String directoryPath = props.getProperty("oldlogpath");
         if (null != logParamList && logParamList.size() > 0) {
            int reservemonth = 0;
            if (null != ((Map)logParamList.get(0)).get("reservemonth")) {
               reservemonth = Integer.parseInt((String)((Map)logParamList.get(0)).get("reservemonth"));
            }

            int currentmonth = LocalDate.now().getMonth().getValue();
            File directory = new File(directoryPath);
            if (directory.exists() && directory.isDirectory()) {
               File[] files = directory.listFiles();

               for(File file : files) {
                  String fname = file.getName();
                  String[] filename = fname.split("-");
                  int filemonth = Integer.parseInt(filename[2]);
                  if (currentmonth - filemonth > reservemonth) {
                     file.delete();
                  }
               }
            } else {
               directory.mkdirs();
            }
         }

         Path source = Paths.get(todaylogpath);
         File file = new File(directoryPath);
         if (!file.exists()) {
            file.mkdirs();
         }

         String datestring = LocalDate.now().toString();
         Path target = Paths.get(directoryPath + "/system-" + datestring + ".log");
         Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);

         try {
            RandomAccessFile file1 = new RandomAccessFile(props.getProperty("deployPath") + "/encryption.log", "rw");
            file1.seek(0L);
            file1.setLength(0L);
            file1.close();
            System.out.println("文件清空成功！");
         } catch (Exception e) {
            e.printStackTrace();
         }
      } catch (IOException e) {
         e.printStackTrace();
      }

   }
}
