package com.chenyang.nse.bussiness.local.service.impl;

import com.chenyang.nse.bussiness.dao.table.core.scheduler.TCoreSchedulerKmLogDao;
import com.chenyang.nse.bussiness.dao.table.core.scheduler.TCoreSchedulerKmRulesDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.scheduler.TCoreSchedulerKmLog;
import com.chenyang.nse.bussiness.entity.orm.table.core.scheduler.TCoreSchedulerKmRules;
import com.chenyang.nse.bussiness.local.service.TestService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("LocalTestServiceImpl")
public class LocalTestServiceImpl implements TestService {
   private static final Logger LOGGER = LoggerFactory.getLogger(LocalTestServiceImpl.class);
   @Autowired
   private TCoreSchedulerKmRulesDao tCoreSchedulerKmRulesDao;
   @Autowired
   private TCoreSchedulerKmLogDao tCoreSchedulerKmLogDao;

   public void test() {
      TestResult result = new TestResult();
      result.success = true;
      SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      result.message.append(sdf.format(new Date()) + " INFO - 未采用连接密管系统方式，本地加解密可正常运行。");

      try {
         this.save(result);
      } catch (Exception e) {
         LOGGER.error(e.getMessage(), e);
      }

   }

   public void initSecretKey() {
   }

   private void save(TestResult result) {
      TCoreSchedulerKmLog tCoreSchedulerKmLog = new TCoreSchedulerKmLog();
      tCoreSchedulerKmLog.setId(UUID.randomUUID().toString().replace("-", ""));
      tCoreSchedulerKmLog.setCreatetime(new Date());
      tCoreSchedulerKmLog.setTestTime(new Date());
      List<TCoreSchedulerKmRules> tCoreSchedulerKmRulesList = this.tCoreSchedulerKmRulesDao.queryAll();
      if (null != tCoreSchedulerKmRulesList && tCoreSchedulerKmRulesList.size() > 0) {
         tCoreSchedulerKmLog.setRulestype(((TCoreSchedulerKmRules)tCoreSchedulerKmRulesList.get(0)).getRulestype());
         if (((TCoreSchedulerKmRules)tCoreSchedulerKmRulesList.get(0)).getHowtime() != null && !((TCoreSchedulerKmRules)tCoreSchedulerKmRulesList.get(0)).getHowtime().equals("")) {
            String[] arr1 = ((TCoreSchedulerKmRules)tCoreSchedulerKmRulesList.get(0)).getHowtime().split(",");
            StringBuilder logBuilder = new StringBuilder();

            for(int i = 0; i < arr1.length; ++i) {
               if ("1".equals(arr1[i])) {
                  logBuilder.append("周一");
               }

               if ("2".equals(arr1[i])) {
                  logBuilder.append("周二");
               }

               if ("3".equals(arr1[i])) {
                  logBuilder.append("周三");
               }

               if ("4".equals(arr1[i])) {
                  logBuilder.append("周四");
               }

               if ("5".equals(arr1[i])) {
                  logBuilder.append("周五");
               }

               if ("6".equals(arr1[i])) {
                  logBuilder.append("周六");
               }

               if ("7".equals(arr1[i])) {
                  logBuilder.append("周日");
               }
            }

            String pollingRule = "";
            if (null != logBuilder && !"".equals(logBuilder)) {
               pollingRule = logBuilder.toString();
               tCoreSchedulerKmLog.setPollingRule(pollingRule);
            }
         } else {
            tCoreSchedulerKmLog.setPollingRule("每天");
         }
      } else {
         tCoreSchedulerKmLog.setPollingRule("每天");
         tCoreSchedulerKmLog.setRulestype("0");
      }

      if (result.success) {
         tCoreSchedulerKmLog.setTestResult("1");
      } else {
         tCoreSchedulerKmLog.setTestResult("0");
      }

      if (null != result.message && !"".equals(result.message.toString())) {
         tCoreSchedulerKmLog.setTestDetail(result.message.toString());
      }

      this.tCoreSchedulerKmLogDao.save(tCoreSchedulerKmLog);
   }

   static class TestResult {
      boolean success = false;
      StringBuffer message = new StringBuffer();
   }
}
