package com.chenyang.nse.bussiness.odbc;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.string.LineEncoder;
import io.netty.handler.codec.string.LineSeparator;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.nio.charset.Charset;

public class Handler extends ChannelInitializer<SocketChannel> {
   protected void initChannel(SocketChannel socketChannel) throws Exception {
      socketChannel.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO), new ApiHandler()});
      LineSeparator separator = new LineSeparator("\n\n");
      socketChannel.pipeline().addLast(new ChannelHandler[]{new LineEncoder(separator)});
      socketChannel.pipeline().addLast(new ChannelHandler[]{new StringDecoder(Charset.forName("UTF-8"))});
   }
}
