package com.chenyang.nse.bussiness.performance_monitor.service.impl;

import com.chenyang.nse.bussiness.mybatis.mapper.PerformanceMonitorMapper;
import com.chenyang.nse.bussiness.performance_monitor.entity.PerformanceDashBoardSqlAvgBO;
import com.chenyang.nse.bussiness.performance_monitor.entity.PerformanceMonitorBase;
import com.chenyang.nse.bussiness.performance_monitor.entity.PerformanceMonitorProcess;
import com.chenyang.nse.bussiness.performance_monitor.entity.PerformanceMonitorRecord;
import com.chenyang.nse.bussiness.performance_monitor.service.PerformanceMonitorService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PerformanceMonitorServiceImpl implements PerformanceMonitorService {
   @Autowired
   PerformanceMonitorMapper performanceMonitorMapper;

   public void savePerformanceBase(PerformanceMonitorBase base) {
      this.performanceMonitorMapper.savePerformanceBase(base);
   }

   public void savePerformanceProcesses(List<PerformanceMonitorProcess> processes) {
      this.performanceMonitorMapper.savePerformanceProcesses(processes);
   }

   public List<PerformanceMonitorRecord> getRecordsByPage(int start, int end, String appName, String sql, String proxyName, String datasystemName, String startTime, String endTime, String appUser, String dbUser) {
      return this.performanceMonitorMapper.getRecordsByPage(start, end, appName, sql, proxyName, datasystemName, appUser, dbUser, startTime, endTime);
   }

   public List<PerformanceMonitorBase> getRecordsForDashBoard(String appName, String appUser, String startTime, String endTime) {
      List<PerformanceMonitorBase> recordsForDashBoard = this.performanceMonitorMapper.getRecordsForDashBoard(appName, appUser, startTime, endTime);
      return recordsForDashBoard;
   }

   public Integer getTotal(int start, int end, String appName, String sql, String proxyName, String datasystemName, String startTime, String endTime, String appUser, String dbUser) {
      return this.performanceMonitorMapper.getTotal(start, end, appName, sql, proxyName, datasystemName, appUser, dbUser, startTime, endTime);
   }

   public Map<String, List<String>> queryParams() {
      Map<String, List<String>> resultMap = new HashMap();
      resultMap.put("appNames", this.performanceMonitorMapper.getAppNameQueryParams());
      resultMap.put("proxyNames", this.performanceMonitorMapper.getDBProxyNameQueryParams());
      resultMap.put("datasystemNames", this.performanceMonitorMapper.getDatasystemNameQueryParams());
      return resultMap;
   }

   public Map<String, Integer> getAvgTimeBySql(String appUser, String appName, String startTime, String endTime) {
      List<PerformanceDashBoardSqlAvgBO> avgTimeBySql = this.performanceMonitorMapper.getAvgTimeBySql(appUser, appName, startTime, endTime);
      Map<String, Integer> countMap = new HashMap();
      Map<String, Integer> resultMap = new HashMap();
      if (avgTimeBySql != null && avgTimeBySql.size() > 0) {
         avgTimeBySql.forEach((avgByDB) -> {
            if (!resultMap.containsKey(avgByDB.getExeSql())) {
               resultMap.put(avgByDB.getExeSql(), 0);
               countMap.put(avgByDB.getExeSql(), 0);
            }

            resultMap.put(avgByDB.getExeSql(), (Integer)resultMap.get(avgByDB) + (avgByDB.getEndTimeMillis() - avgByDB.getStartTimeMillis()));
            countMap.put(avgByDB.getExeSql(), (Integer)resultMap.get(avgByDB) + 1);
         });
      }

      resultMap.forEach((sql, totalTime) -> resultMap.put(sql, totalTime / (Integer)countMap.get(sql)));
      return resultMap;
   }
}
