package com.chenyang.nse.bussiness.service.console.impl;

import com.chenyang.nse.bussiness.dao.table.console.engine.TConsoleEnginePropertyDao;
import com.chenyang.nse.bussiness.dao.table.console.engine.TConsoleEnginePropertyvalueDao;
import com.chenyang.nse.bussiness.dao.table.console.engine.TConsoleEngineTypeDao;
import com.chenyang.nse.bussiness.entity.orm.table.console.engine.TConsoleEngineProperty;
import com.chenyang.nse.bussiness.entity.orm.table.console.engine.TConsoleEnginePropertyvalue;
import com.chenyang.nse.bussiness.entity.orm.table.console.engine.TConsoleEngineType;
import com.chenyang.nse.bussiness.service.console.EngineManageService;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class EngineManageServiceImpl implements EngineManageService {
   @Autowired
   private TConsoleEngineTypeDao tConsoleEngineTypeDao;
   @Autowired
   private TConsoleEnginePropertyDao tConsoleEnginePropertyDao;
   @Autowired
   private TConsoleEnginePropertyvalueDao tTConsoleEnginePropertyvalueDao;

   public List<TConsoleEngineType> queryAllEngineType() {
      List<TConsoleEngineType> list = this.tConsoleEngineTypeDao.queryAll();
      return list;
   }

   public void removeEngineType(String id) {
      this.tConsoleEngineTypeDao.removeById(id);
      this.tConsoleEnginePropertyDao.remove(new Criterion[]{Restrictions.eq("enginetypeid", id)});
   }

   public void saveEngineType(TConsoleEngineType enginetype) {
      this.tConsoleEngineTypeDao.saveOrUpdate(enginetype);
      this.tConsoleEnginePropertyDao.remove(new Criterion[]{Restrictions.eq("enginetypeid", enginetype.getId())});

      for(TConsoleEngineProperty item : enginetype.getPropertylist()) {
         item.setEnginetypeid(enginetype.getId());
         this.tConsoleEnginePropertyDao.save(item);
      }

   }

   public List<TConsoleEngineProperty> queryEngineProperty(String enginetypeid) {
      List<TConsoleEngineProperty> list = this.tConsoleEnginePropertyDao.queryAll(new Criterion[]{Restrictions.eq("enginetypeid", enginetypeid)});
      return list;
   }

   public void saveEngineProperty(TConsoleEngineProperty engineproperty) {
      this.tConsoleEnginePropertyDao.saveOrUpdate(engineproperty);
   }

   public void removeEngineProperty(String id) {
      this.tConsoleEnginePropertyDao.removeById(id);
   }

   public List<TConsoleEnginePropertyvalue> queryEnginePropertyValue(String engineid) {
      List<TConsoleEnginePropertyvalue> list = this.tTConsoleEnginePropertyvalueDao.queryAll(new Criterion[]{Restrictions.eq("engineid", engineid)});
      return list;
   }

   public TConsoleEnginePropertyvalue queryEnginePropertyValue(String engineid, String enginepropertyid) {
      TConsoleEnginePropertyvalue value = (TConsoleEnginePropertyvalue)this.tTConsoleEnginePropertyvalueDao.queryUnique(new Criterion[]{Restrictions.eq("engineid", engineid), Restrictions.eq("enginepropertyid", enginepropertyid)});
      return value;
   }

   public void saveEnginePropertyValue(TConsoleEnginePropertyvalue enginepropertyvalue) {
      this.tTConsoleEnginePropertyvalueDao.saveOrUpdate(enginepropertyvalue);
   }

   public void removeEnginePropertyValue(String id) {
      this.tTConsoleEnginePropertyvalueDao.removeById(id);
   }

   public void removeEnginePropertyValue(String engineid, String enginepropertyid) {
      this.tTConsoleEnginePropertyvalueDao.remove(new Criterion[]{Restrictions.eq("engineid", engineid), Restrictions.eq("enginepropertyid", enginepropertyid)});
   }
}
