package com.chenyang.nse.bussiness.service.console.impl;

import com.chenyang.nse.bussiness.dao.TConsoleHelpDocumentDao;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleHelpDocument;
import com.chenyang.nse.bussiness.entity.vo.HelpDocumentVO;
import com.chenyang.nse.bussiness.service.console.TConsoleHelpDocumentService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TConsoleHelpDocumentServiceImpl implements TConsoleHelpDocumentService {
   @Autowired
   private TConsoleHelpDocumentDao tConsoleHelpDocumentDao;

   public void addHelpDocument(TConsoleHelpDocument vo) {
      this.tConsoleHelpDocumentDao.save(vo);
   }

   public void editHelpDocument(HelpDocumentVO vo) {
      String id = vo.getId();
      String content = vo.getContent();
      String menu_name = vo.getMenu_name();
      this.tConsoleHelpDocumentDao.editHelpDocument(id, content, menu_name);
   }

   public void delHelpDocument(HelpDocumentVO vo) {
      this.tConsoleHelpDocumentDao.delHelpById(vo.getId());
      this.tConsoleHelpDocumentDao.delHelpByFa_id(vo.getId());
   }

   public TConsoleHelpDocument queryHelpDocument(HelpDocumentVO vo) {
      return this.tConsoleHelpDocumentDao.queryHelpDocument(vo.getId());
   }

   public List<HelpDocumentVO> getDocumentsList() {
      List<HelpDocumentVO> list = this.tConsoleHelpDocumentDao.queryAllList();
      List<HelpDocumentVO> trees = this.buildTree(list, "");
      return trees;
   }

   private List<HelpDocumentVO> buildTree(List<HelpDocumentVO> list, String parentId) {
      List<HelpDocumentVO> trees = new ArrayList();
      if (list.size() > 0) {
         for(HelpDocumentVO entity : list) {
            String menuId = entity.getId();
            String pid = entity.getFa_id();
            if (parentId.equals(pid)) {
               List<HelpDocumentVO> menuLists = this.buildTree(list, menuId);
               entity.setChildren(menuLists);
               trees.add(entity);
            }
         }
      }

      return trees;
   }
}
