package com.chenyang.nse.bussiness.service.console.impl;

import com.alibaba.fastjson.JSON;
import com.chenyang.nse.bussiness.config.ProxyConfig;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.base.TBaseAppUserDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseDutyPersonDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseGroupDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseMenuDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseRoleDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUserDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUserMenuDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUsergroupDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUserprojectDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUserroleDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUsersysDao;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseAppUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseGroup;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseMenu;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseRole;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUsergroup;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUsermenu;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUserproject;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUserrole;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUsersys;
import com.chenyang.nse.bussiness.entity.vo.AppUserVO;
import com.chenyang.nse.bussiness.entity.vo.DutyPersonVO;
import com.chenyang.nse.bussiness.entity.vo.UserVO;
import com.chenyang.nse.bussiness.jar.util.JarClientUtil;
import com.chenyang.nse.bussiness.jar.util.JarSocketCallback;
import com.chenyang.nse.bussiness.service.console.UserService;
import com.chenyang.nse.bussiness.service.core.impl.encryption.EncryptionProxyServiceImpl;
import com.chenyang.nse.bussiness.tools.http.ClientUtil;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@Transactional
public class UserServiceImpl implements UserService {
   @Autowired
   ProxyConfig proxyConfig;
   @Autowired
   private TBaseUserDao tBaseUserDao;
   @Autowired
   private TBaseAppUserDao tBaseAppUserDao;
   @Autowired
   private TBaseUsergroupDao tBaseUsergroupDao;
   @Autowired
   private TBaseUserroleDao tBaseUserroleDao;
   @Autowired
   private TBaseUsersysDao tBaseUsersysDao;
   @Autowired
   private TBaseUserprojectDao tBaseUserprojectDao;
   @Autowired
   private TBaseRoleDao tBaseRoleDao;
   @Autowired
   private TBaseMenuDao tBaseMenuDao;
   @Autowired
   private TBaseUserMenuDao tBaseUserMenuDao;
   @Autowired
   private TBaseGroupDao tBaseGroupDao;
   @Autowired
   private TBaseDutyPersonDao tBaseDutyPersonDao;
   @Autowired
   EncryptionProxyServiceImpl encryptionProxyService;

   public int delDutyPersonById(DutyPersonVO vo) {
      return this.tBaseDutyPersonDao.delDutyPersonById(vo);
   }

   public int saveDutyPerson(DutyPersonVO vo) {
      return this.tBaseDutyPersonDao.saveDutyPerson(vo);
   }

   public List<DutyPersonVO> isExistPerson(DutyPersonVO vo) {
      return this.tBaseDutyPersonDao.isExistPerson(vo);
   }

   public int updateDutyPerson(DutyPersonVO vo) {
      return this.tBaseDutyPersonDao.updateDutyPerson(vo);
   }

   public List<DutyPersonVO> selectDutyPerson(DutyPersonVO vo) {
      return this.tBaseDutyPersonDao.selectDutyPerson(vo);
   }

   public TBaseUser login(TBaseUser user) {
      return this.tBaseUserDao.login(user);
   }

   public List<TBaseUser> query(PageInfo pageInfo) {
      pageInfo.setCount(this.tBaseUserDao.count());
      List<TBaseUser> list = this.tBaseUserDao.queryByPageInfo(pageInfo);
      return list;
   }

   public List<TBaseUser> queryAll() {
      List<TBaseUser> list = this.tBaseUserDao.queryAll(Order.desc("createtime"), new Criterion[]{Restrictions.ne("id", "1")});
      return list;
   }

   public void remove(List<String> idlist) {
      Criterion cid = Restrictions.in("id", idlist);
      this.tBaseUserDao.remove(new Criterion[]{cid});
   }

   public void removeuser(String userid) {
      Criterion cid = Restrictions.eq("id", userid);
      this.tBaseUserDao.remove(new Criterion[]{cid});
   }

   public boolean checkNameExit(String username) {
      Criterion cusername = Restrictions.eq("username", username);
      long count = this.tBaseUserDao.count(new Criterion[]{cusername});
      return count > 0L;
   }

   public void save(TBaseUser user) {
      if (StringUtils.isBlank(user.getRemark())) {
         user.setRemark("");
      }

      if (null == user.getId()) {
         user.setId(StringTool.getTablePrimaryKey());
         this.tBaseUserDao.save(user);
      } else {
         this.tBaseUserDao.saveOrUpdate(user);
      }

   }

   public void saveUserRole(TBaseUserrole userRole) {
      userRole.setId(StringTool.getTablePrimaryKey());
      this.tBaseUserroleDao.save(userRole);
   }

   public void saveUserSys(TBaseUsersys userSys) {
      List<TBaseUsersys> queryAll = this.tBaseUsersysDao.queryAll(new Criterion[]{Restrictions.eq("userid", userSys.getUserid()), Restrictions.eq("sysid", userSys.getSysid())});
      if (queryAll.size() == 0) {
         userSys.setId(StringTool.getTablePrimaryKey());
         this.tBaseUsersysDao.save(userSys);
      } else {
         TBaseUsersys tBaseUsersys = (TBaseUsersys)queryAll.get(0);
         userSys.setUserid(userSys.getUserid());
         userSys.setSysid(userSys.getSysid());
         userSys.setCrud("1");
         userSys.setUpdateuserid(userSys.getUpdateuserid());
         String id = ((TBaseUsersys)queryAll.get(0)).getId();
         userSys.setId(id);
         this.tBaseUsersysDao.update(tBaseUsersys);
      }

   }

   public void saveUserSyscrud(TBaseUsersys userSys) {
      userSys.setId(StringTool.getTablePrimaryKey());
      this.tBaseUsersysDao.save(userSys);
   }

   public void saveUserPro(TBaseUserproject userProject) {
      userProject.setId(StringTool.getTablePrimaryKey());
      this.tBaseUserprojectDao.save(userProject);
   }

   public void removeUsersysBySysId(String sysid) {
      this.tBaseUsersysDao.removeUsersysBySysId(sysid);
   }

   public void removeUsersysByUserId(String userid) {
      this.tBaseUsersysDao.removeUsersysByUserId(userid);
   }

   public void removeUsersystByUpdateuserid(String userid, String updateuserid) {
      this.tBaseUsersysDao.removeUsersysByUpdateuserid(userid, updateuserid);
   }

   public void deleteUserRoleByUserId(String userid) {
      Criterion cuserid = Restrictions.eq("userid", userid);
      this.tBaseUserroleDao.remove(new Criterion[]{cuserid});
   }

   public void deleteUserSysByUserId(String userid) {
      Criterion cuserid = Restrictions.eq("userid", userid);
      this.tBaseUsersysDao.remove(new Criterion[]{cuserid});
   }

   public List<TBaseUserrole> queryuserrolebyuserid(String userid) {
      Criterion cuserid = Restrictions.eq("userid", userid);
      List<TBaseUserrole> list = this.tBaseUserroleDao.queryAll(new Criterion[]{cuserid});
      return list;
   }

   public List<TBaseUsersys> queryusersysbyuserid(String userid) {
      Criterion cuserid = Restrictions.eq("userid", userid);
      List<TBaseUsersys> list = this.tBaseUsersysDao.queryAll(Order.desc("sysid"), new Criterion[]{cuserid});
      return list;
   }

   public List<UserVO> queryuservo(PageInfo pageInfo, Map<String, String> params) {
      String realname = "";
      if (null != params && null != params.get("realname")) {
         realname = (String)params.get("realname");
      }

      Criterion criterion1 = Restrictions.like("realname", realname, MatchMode.ANYWHERE).ignoreCase();
      String username = "";
      if (null != params && null != params.get("username")) {
         username = (String)params.get("username");
      }

      Criterion criterion2 = Restrictions.like("username", username, MatchMode.ANYWHERE).ignoreCase();
      String remark = "";
      if (null != params && null != params.get("remark")) {
         remark = (String)params.get("remark");
      }

      Criterion criterion3 = Restrictions.like("remark", remark, MatchMode.ANYWHERE).ignoreCase();
      List<UserVO> uservolist = new ArrayList();
      List<TBaseUser> userlist = this.tBaseUserDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{criterion1, criterion2, criterion3});
      if (!ObjectUtils.isEmpty(userlist)) {
         userlist.forEach((item) -> {
            UserVO userVO = new UserVO();
            BeanUtils.copyProperties(item, userVO);
            uservolist.add(userVO);
         });
      }

      List<TBaseRole> rolelist = this.tBaseRoleDao.queryAll();

      for(int j = 0; j < uservolist.size(); ++j) {
         if (((UserVO)uservolist.get(j)).getRoleid() != null) {
            String[] roleids = ((UserVO)uservolist.get(j)).getRoleid().split(",");
            String rolename = "";

            for(int i = 0; i < roleids.length; ++i) {
               for(TBaseRole tBaseRole : rolelist) {
                  if (tBaseRole.getId().equals(roleids[i])) {
                     rolename = rolename + tBaseRole.getRolename() + ",";
                     break;
                  }
               }
            }

            rolename = rolename.substring(0, rolename.length() - 1);
            ((UserVO)uservolist.get(j)).setRolename(rolename);
         }
      }

      return uservolist;
   }

   public List<AppUserVO> queryappuservo(PageInfo pageInfo, Map<String, String> params) {
      new ArrayList();
      String useridentifier = "";
      if (null != params && null != params.get("useridentifier")) {
         useridentifier = (String)params.get("useridentifier");
      }

      Criterion criterion1 = Restrictions.like("useridentifier", useridentifier, MatchMode.ANYWHERE);
      String username = "";
      if (null != params && null != params.get("username")) {
         username = (String)params.get("username");
      }

      Criterion criterion2 = Restrictions.like("username", username, MatchMode.ANYWHERE);
      String note = "";
      if (null != params && null != params.get("note")) {
         note = (String)params.get("note");
      }

      Criterion criterion5 = Restrictions.like("note", note, MatchMode.ANYWHERE).ignoreCase();
      List<TBaseAppUser> appUserList = this.tBaseAppUserDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{criterion1, criterion2, criterion5});
      String isoriginal = "";
      if (null != params && null != params.get("isoriginal") && !"".equals(((String)params.get("isoriginal")).trim()) && (null == params.get("ismask") || "".equals(((String)params.get("ismask")).trim()))) {
         isoriginal = (String)params.get("isoriginal");
         Criterion criterion3 = Restrictions.eq("isoriginal", isoriginal);
         appUserList = this.tBaseAppUserDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{criterion1, criterion2, criterion3, criterion5});
      }

      String ismask = "";
      if (null != params && null != params.get("ismask") && !"".equals(((String)params.get("ismask")).trim()) && (null == params.get("isoriginal") || "".equals(((String)params.get("isoriginal")).trim()))) {
         ismask = (String)params.get("ismask");
         Criterion criterion4 = Restrictions.eq("ismask", ismask);
         appUserList = this.tBaseAppUserDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{criterion1, criterion2, criterion4, criterion5});
      }

      if (null != params && null != params.get("ismask") && !"".equals(((String)params.get("ismask")).trim()) && null != params.get("isoriginal") && !"".equals(((String)params.get("isoriginal")).trim())) {
         appUserList = this.tBaseAppUserDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{criterion1, criterion2, criterion5, Restrictions.eq("isoriginal", (String)params.get("isoriginal")), Restrictions.eq("ismask", (String)params.get("ismask"))});
      }

      List<AppUserVO> appUserVOList = new ArrayList();
      if (!ObjectUtils.isEmpty(appUserList)) {
         appUserList.forEach((item) -> {
            AppUserVO appUserVO = new AppUserVO();
            BeanUtils.copyProperties(item, appUserVO);
            appUserVOList.add(appUserVO);
         });
      }

      return appUserVOList;
   }

   public void updateUser(String userid, Integer isenable) {
      TBaseUser user = (TBaseUser)this.tBaseUserDao.get(userid);
      user.setIsenable(isenable);
      this.tBaseUserDao.update(user);
   }

   public UserVO queryByUserid(String userid) {
      List<UserVO> userVo = this.tBaseUserDao.queryuservobyid(userid);
      List<TBaseGroup> groupList = this.tBaseGroupDao.queryGroupsByUserId(userid);
      if (userVo != null && userVo.size() != 0) {
         ((UserVO)userVo.get(0)).setGroupList(groupList);
         return (UserVO)userVo.get(0);
      } else {
         return null;
      }
   }

   public TBaseAppUser queryByAppUserid(String id) {
      TBaseAppUser tBaseUser = (TBaseAppUser)this.tBaseAppUserDao.queryUnique(new Criterion[]{Restrictions.eq("id", id)});
      return tBaseUser;
   }

   public void removeUserprojectByUserId(String userid) {
      this.tBaseUserprojectDao.removeUserprojectByUserId(userid);
   }

   public void removeUserprojectByUpdateuserid(String proid, String updateuserid) {
      this.tBaseUserprojectDao.removeUserprojectByUpdateuserid(proid, updateuserid);
   }

   public List<UserVO> queryNoProjectCrudUser(String proid) {
      return this.tBaseUserDao.querynoprojectuser(proid);
   }

   public List<UserVO> queryProjectCrudUser(String proid) {
      return this.tBaseUserDao.queryprojectuser(proid);
   }

   public void delProjectCrudUserById(String id) {
      this.tBaseUserprojectDao.removeById(id);
   }

   public List<UserVO> querySelfGiveCrudUser(String proid, String userid) {
      return this.tBaseUserDao.queryselfgivecruduser(proid, userid);
   }

   public void addProjectCrudUser(TBaseUserproject vo) {
      vo.setId(StringTool.getTablePrimaryKey());
      this.tBaseUserprojectDao.save(vo);
   }

   public void removeUserprojectByProjectid(String proid) {
      this.tBaseUserprojectDao.removeUserprojectByProjectid(proid);
   }

   public List<UserVO> querySysCrudUser(String sysid) {
      return this.tBaseUserDao.querysysuser(sysid);
   }

   public List<UserVO> querySysSelfGiveCrudUser(String sysid, String userid) {
      return this.tBaseUserDao.querysysselfgivecruduser(sysid, userid);
   }

   public List<UserVO> querynoSysCrudUser(String sysid) {
      return this.tBaseUserDao.querynosysuser(sysid);
   }

   public List<String> queryGroupByusrid(String userid) {
      List<TBaseUsergroup> queryAll = this.tBaseUsergroupDao.queryAll(new Criterion[]{Restrictions.eq("userid", userid)});
      List<String> groupidList = new ArrayList();

      for(int i = 0; i < queryAll.size(); ++i) {
         groupidList.add(((TBaseUsergroup)queryAll.get(i)).getGroupid());
      }

      return groupidList;
   }

   public UserVO initUser(String userId) {
      UserVO userVO = new UserVO();
      List<UserVO> userList = this.tBaseUserDao.queryuservobyid(userId);
      if (!ObjectUtils.isEmpty(userList)) {
         userVO = (UserVO)userList.get(0);
         List<TBaseRole> roleList = this.tBaseRoleDao.queryRolesByUserId(userId);
         List<TBaseMenu> menuList = this.tBaseMenuDao.queryMenusByUserId(userId);
         List<TBaseGroup> groupList = this.tBaseGroupDao.queryGroupsByUserIdAll(userId);
         userVO.setRolesList(roleList);
         userVO.setMenuList(menuList);
         userVO.setGroupList(groupList);
      }

      return userVO;
   }

   @Transactional
   public void addUser(UserVO userVO, HttpServletRequest request) {
      TBaseUser baseUser = new TBaseUser();
      BeanUtils.copyProperties(userVO, baseUser);
      if (StringUtils.isBlank(baseUser.getRemark())) {
         baseUser.setRemark("");
      }

      List<TBaseRole> roleList = userVO.getRolesList();
      List<TBaseMenu> menuList = userVO.getMenuList();
      List<TBaseGroup> groupList = userVO.getGroupList();
      String username = CommonUtils.loginUsername();
      if (StringUtils.isBlank(baseUser.getId())) {
         baseUser.setCreateuser(username);
         baseUser.setCreatetime(new Date());
         baseUser.setFlag("0");
         baseUser.setId(StringTool.getTablePrimaryKey());
         baseUser.setLimitnum("5");
         this.tBaseUserDao.save(baseUser);
         this.saveRoles(roleList, baseUser, username);
         this.saveMenus(menuList, baseUser, username);
         this.saveGroups(groupList, baseUser, username);
         userVO.setId(baseUser.getId());
      } else {
         TBaseUser tBaseUser = (TBaseUser)this.tBaseUserDao.queryUnique(new Criterion[]{Restrictions.eq("id", baseUser.getId())});
         tBaseUser.setLimitnum("5");
         tBaseUser.setRealname(baseUser.getRealname());
         tBaseUser.setUsername(baseUser.getUsername());
         tBaseUser.setPassword(baseUser.getPassword());
         tBaseUser.setRemark(StringUtils.isBlank(baseUser.getRemark()) ? "" : baseUser.getRemark());
         tBaseUser.setIsenable(baseUser.getIsenable());
         tBaseUser.setUpdateuser(username);
         tBaseUser.setUpdatetime(new Date());
         tBaseUser.setEmail(baseUser.getEmail());
         tBaseUser.setPlaintext(baseUser.getPlaintext());
         tBaseUser.setDesensitize(baseUser.getDesensitize());
         this.tBaseUserDao.saveOrUpdate(tBaseUser);
         this.deleteUserRole(baseUser.getId());
         this.deleteUserMenu(baseUser.getId());
         this.deleteUserGroup(baseUser.getId());
         if ("1".equals(baseUser.getId())) {
            TBaseRole tBaseRole = (TBaseRole)this.tBaseRoleDao.get("1");
            roleList.add(tBaseRole);
         }

         this.saveRoles(roleList, baseUser, username);
         this.saveMenus(menuList, baseUser, username);
         this.saveGroups(groupList, baseUser, username);
      }

   }

   @Transactional
   public void addAppUser(AppUserVO appUserVO, HttpServletRequest request) {
      TBaseAppUser baseUser = new TBaseAppUser();
      BeanUtils.copyProperties(appUserVO, baseUser);
      String username = CommonUtils.loginUsername();
      if (StringUtils.isBlank(baseUser.getId())) {
         baseUser.setCreateuser(username);
         baseUser.setCreatetime(new Date());
         baseUser.setId(StringTool.getTablePrimaryKey());
         this.tBaseAppUserDao.save(baseUser);
         appUserVO.setId(baseUser.getId());
      } else {
         TBaseAppUser tBaseUser = (TBaseAppUser)this.tBaseAppUserDao.queryUnique(new Criterion[]{Restrictions.eq("id", baseUser.getId())});
         tBaseUser.setUsername(baseUser.getUsername());
         tBaseUser.setUseridentifier(baseUser.getUseridentifier());
         tBaseUser.setIsoriginal(baseUser.getIsoriginal());
         tBaseUser.setIsmask(baseUser.getIsmask());
         tBaseUser.setNote(StringUtils.isBlank(baseUser.getNote()) ? "" : baseUser.getNote());
         tBaseUser.setUpdateuser(username);
         tBaseUser.setUpdatetime(new Date());
         this.tBaseAppUserDao.saveOrUpdate(tBaseUser);
      }

   }

   public void deleteUserRole(String userid) {
      Criterion croleid = Restrictions.in("userid", new Object[]{userid});
      this.tBaseUserroleDao.remove(new Criterion[]{croleid});
   }

   public void deleteUserMenu(String userid) {
      Criterion croleid = Restrictions.in("userid", new Object[]{userid});
      this.tBaseUserMenuDao.remove(new Criterion[]{croleid});
   }

   public void deleteUserGroup(String userid) {
      Criterion croleid = Restrictions.in("userid", new Object[]{userid});
      this.tBaseUsergroupDao.remove(new Criterion[]{croleid});
   }

   private void saveRoles(List<TBaseRole> roleList, TBaseUser baseUser, String username) {
      if (!ObjectUtils.isEmpty(roleList)) {
         roleList.forEach((item) -> {
            TBaseUserrole baseUserrole = new TBaseUserrole();
            baseUserrole.setRoleid(item.getId());
            baseUserrole.setUserid(baseUser.getId());
            baseUserrole.setCreateuser(username);
            baseUserrole.setCreatetime(new Date());
            baseUserrole.setFlag("0");
            baseUserrole.setId(StringTool.getTablePrimaryKey());
            this.tBaseUserroleDao.save(baseUserrole);
         });
      }

   }

   private void saveMenus(List<TBaseMenu> menuList, TBaseUser baseUser, String username) {
      if (!ObjectUtils.isEmpty(menuList)) {
         menuList.forEach((item) -> {
            TBaseUsermenu baseUsermenu = new TBaseUsermenu();
            baseUsermenu.setMenuid(item.getId());
            baseUsermenu.setUserid(baseUser.getId());
            baseUsermenu.setCreateuser(username);
            baseUsermenu.setCreatetime(new Date());
            baseUsermenu.setFlag("0");
            baseUsermenu.setId(StringTool.getTablePrimaryKey());
            this.tBaseUserMenuDao.save(baseUsermenu);
         });
      }

   }

   private void saveGroups(List<TBaseGroup> menuList, TBaseUser baseUser, String username) {
      if (!ObjectUtils.isEmpty(menuList)) {
         menuList.forEach((item) -> {
            TBaseUsergroup baseUsergroup = new TBaseUsergroup();
            baseUsergroup.setGroupid(item.getId());
            baseUsergroup.setUserid(baseUser.getId());
            baseUsergroup.setCreateuser(username);
            baseUsergroup.setCreatetime(new Date());
            baseUsergroup.setFlag("0");
            baseUsergroup.setId(StringTool.getTablePrimaryKey());
            this.tBaseUsergroupDao.save(baseUsergroup);
         });
      }

   }

   public void deleteUserMenuByUserid(String userid) {
      Criterion croleid = Restrictions.eq("userid", userid);
      List<TBaseUsermenu> list = this.tBaseUserMenuDao.queryAll(new Criterion[]{croleid});
      this.tBaseUserMenuDao.remove(list);
   }

   public void deleteUserRoleByUserid(String userid) {
      Criterion croleid = Restrictions.eq("userid", userid);
      List<TBaseUserrole> list = this.tBaseUserroleDao.queryAll(new Criterion[]{croleid});
      this.tBaseUserroleDao.remove(list);
   }

   public void deleteUserGroupByUserid(String userid) {
      Criterion croleid = Restrictions.eq("userid", userid);
      List<TBaseUsergroup> list = this.tBaseUsergroupDao.queryAll(new Criterion[]{croleid});
      this.tBaseUsergroupDao.remove(list);
   }

   public void remove(String id) {
      this.tBaseUserDao.removeById(id);
   }

   public void removeAppUser(String id) {
      this.tBaseAppUserDao.removeById(id);
   }

   public TBaseAppUser queryByuseridentifier(String useridentifier) {
      return this.tBaseAppUserDao.queryByuseridentifier(useridentifier);
   }

   public TBaseAppUser queryByappusername(String username) {
      return this.tBaseAppUserDao.queryByappusername(username);
   }

   public TBaseUser queryByusername(String username) {
      return this.tBaseUserDao.queryByusername(username);
   }

   public void changeGlobalOriginalConfig(Integer status, String projectId) {
      this.tBaseAppUserDao.changeGlobalOriginalStatus(status, projectId);

      for(String url : this.tBaseAppUserDao.queryProxyUrlPrefixByProjectId(projectId)) {
         (new Thread(() -> this.sendGlobalOriginalStatus2Proxy(url + "/encryptionGatewayController/receiveAppUserGlobalOriginalConfig", status))).start();
      }

   }

   public void sendGlobalOriginalStatus2Proxy(String urlPrefix, Integer status) {
      Map<String, Integer> globalOriginalConfig = new HashMap();
      globalOriginalConfig.put("globalOriginalConfig", status);
      String url = urlPrefix + this.proxyConfig.getSendGlobalOriginalConfig();
      System.out.println("向插件发送配置信息：发送地址为=====【" + url + "】，发送信息为：" + JSON.toJSONString(globalOriginalConfig));
      (new Thread(() -> ClientUtil.doPost(url, JSON.toJSONString(globalOriginalConfig), new JarSocketCallback() {
            public void isSucc() {
               JarClientUtil.log(urlPrefix.split(":")[0], Integer.parseInt(urlPrefix.split(":")[1]), "服务端发送全局配置，客户端接收成功。接收内容为【" + status + "】");
            }

            public void isFail() {
               JarClientUtil.log(urlPrefix.split(":")[0], Integer.parseInt(urlPrefix.split(":")[1]), "服务端发送全局配置，客户端成功接收失败。接收内容为【" + status + "】");
            }
         }))).start();
   }

   public Integer getGlobalOriginalConfig(String projectId) {
      return this.tBaseAppUserDao.queryGlobalOriginalStatus(projectId);
   }

   public Integer pullGlobalOriginalConfig(String projectId) {
      Integer globalOriginalConfig = this.getGlobalOriginalConfig(projectId);
      return globalOriginalConfig;
   }

   public TBaseAppUser queryByappuserid(String id) {
      return (TBaseAppUser)this.tBaseAppUserDao.get(id);
   }
}
