package com.chenyang.nse.bussiness.service.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectFile;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectVersion;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryColumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryDataResult;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreTaskFindrule;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.api.ApiInfoObjectVO;
import java.util.Date;
import java.util.List;
import java.util.Map;

public interface TdataDiscoveryService {
   TcoreDiscoveryTask queryTaskByName(String taskname, String projectid);

   TcoreDiscoveryTask queryTaskByid(String taskid);

   void saveDiscoveryTask(Map<String, Object> map, Date date, String resultid, String projectid);

   List<TcoreDiscoveryTask> queryDiscoverytasklist(PageInfo pageInfo, String projectid);

   void createsqlstr(StringBuilder sql);

   List<TcoreDiscoveryColumn> queryDiscoveryColumn(String taskid);

   List<TcoreTaskFindrule> queryFindrulelist(String taskid);

   List<TCoreProjectFile> queryFilelist(String taskid);

   List<TCoreProjectFile> queryTaskBytaskid(String taskid);

   long getExeTaskNum(String taskid);

   void updateTaskstatus(String taskid, String status, String version);

   void updateAutofindResultid(String taskid, String resultid);

   List<TCoreProjectVersion> initExcute(String taskid, String projectid);

   void delDiscoveryColumn(String taskid);

   void saveDiscoveryDataResult(TcoreDiscoveryDataResult tcoreDiscoveryDataResult);

   void delDiscoveryDataResult(String taskid);

   void saveTCoreProjectFile(TCoreProjectFile tCoreProjectFile);

   void deleteTCoreProjectFile(String taskid);

   List<String> querydir(String path);

   Map<String, Object> queryFtpdir(String url, int port, String username, String password, String path, String substring, String code);

   Map<String, Object> querySftpdir(String url, int port, String ip, String username, String password);

   List<ComboboxVO> queryfilesource(String projectid, String filetype, String userid);

   List<TcoreDiscoveryTask> queryDiscoverytasklistByProjectId(String projectid);

   String saveApiInfo(ApiInfoObjectVO apiInfoObjectVo);

   ApiInfoObjectVO selectApiInfo(String taskid);

   int releaseByTreeId(String treeid);

   int releaseAll();

   List<TCoreProjectFile> queryDiscoveryFile(String taskid);

   void queryCountRes(List<TcoreDiscoveryTask> tcoreDiscoveryTaskList);

   boolean isRepeatName(String projectid, String taskname, String taskid);
}
