package com.chenyang.nse.bussiness.service.core.dataproject;

import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleSearchregex;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectFile;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryColumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreTaskFindrule;
import com.chenyang.nse.bussiness.entity.vo.ProgressInfo;
import com.chenyang.nse.bussiness.tools.net.SFTPUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPClient;

public interface ExecuteDiscoverytaskService {
   void execute(String taskid, String projectid, String version, String userid, String username, Boolean isAssignTable, List<TcoreDiscoveryColumn> columnList);

   Map<String, String> getAllTableColumns(TCoreDatasystem datasystem, List<TcoreDiscoveryColumn> discoveryColumn, String version, List<TcoreTaskFindrule> discoveryRule, TcoreDiscoveryTask discoveryTask, List<Map<String, Object>> sensitiveRule, String projectid, String userid, boolean isautofind) throws SQLException;

   Map<String, String> getAllFileColumnsByContent(List<TCoreProjectFile> discoveryFile, String version, List<TcoreTaskFindrule> discoveryRule, TcoreDiscoveryTask discoveryTask, List<Map<String, Object>> sensitiveRule, String projectid, String userid);

   Map<String, String> getAllFileColumnsByContentUnknowstructure(List<TCoreProjectFile> discoveryFile, String version, List<TcoreTaskFindrule> discoveryRule, TcoreDiscoveryTask discoveryTask, List<Map<String, Object>> sensitiveRule, String projectid, String userid) throws Exception;

   Map<String, String> getAllCollections(TCoreDatasystem datasystem, List<TcoreDiscoveryColumn> discoveryColumn, String version, List<TcoreTaskFindrule> discoveryRule, TcoreDiscoveryTask discoveryTask, List<Map<String, Object>> sensitiveRule, String projectid, String userid) throws SQLException;

   void writeFile(String filename, String content, String url);

   void writeErroFile(String filename, String content, String url);

   String geterrorprint(Exception e);

   void writeFileRefresh(String filename, String content, String url);

   boolean delFile(String filePath);

   boolean matches(String methodName, int maxLength, String testString, int level);

   void delDiscoveryResult(String tablename);

   void delAssignTableDiscoveryResult(String tablename, String datasystemid, String schema, String ntablename);

   void delDiscoveryDataResult(String taskid);

   void onOff(List<String> list);

   Map<String, String> getLocalFile(Set<Object> dataareaSet, Map<String, String> resultmap, String path, TCoreDatasystem tCoreDatasystem, String fileSourceType, boolean isFaceRule, TcoreTaskFindrule findRuleFace, String hits, String projectid, String taskid, String rate, List<TcoreTaskFindrule> regexByContent, boolean isSelectData, List<Pattern> patternContentList, List<Map<String, Object>> sensitiveRule, int batcheSize, String monitorurl, Connection tconnection, PreparedStatement pstmt);

   Map<String, String> getSftpFile(Set<Object> dataareaSet, Map<String, String> resultmap, String path, TCoreDatasystem tCoreDatasystem, String fileSourceType, boolean isFaceRule, TcoreTaskFindrule findRuleFace, String hits, String projectid, String taskid, String rate, List<TcoreTaskFindrule> regexByContent, boolean isSelectData, List<Pattern> patternContentList, List<Map<String, Object>> sensitiveRule, int batcheSize, String monitorurl, Connection tconnection, PreparedStatement pstmt, SFTPUtil sftp, String url);

   Map<String, String> getFtpFile(Set<Object> dataareaSet, Map<String, String> resultmap, String path, TCoreDatasystem tCoreDatasystem, String fileSourceType, boolean isFaceRule, TcoreTaskFindrule findRuleFace, String hits, String projectid, String taskid, String rate, List<TcoreTaskFindrule> regexByContent, boolean isSelectData, List<Pattern> patternContentList, List<Map<String, Object>> sensitiveRule, int batcheSize, String monitorurl, Connection tconnection, PreparedStatement pstmt, FTPClient ftp, String url);

   void setYearNow();

   Map<String, String> getAlldmpTableColumnsByContent(String multiDempFile, int queren, String samplingtype, String aifind, TCoreDatasystem datasystem, List<String> schemas, long maxRowCount, double rate, List<TConsoleSearchregex> searchRegexList, ProgressInfo progressInfo, String datasystemid, String dmptype);

   Map<String, String> getAlldmpTableColumnsByContent(TCoreDatasystem datasystem, List<TCoreProjectFile> discoveryFile, String version, List<TcoreTaskFindrule> discoveryRule, TcoreDiscoveryTask discoveryTask, List<Map<String, Object>> sensitiveRule, String projectid, String userid);

   void init();
}
