package com.chenyang.nse.bussiness.service.core.impl;

import com.chenyang.nse.bussiness.dao.table.core.notice.SysLogDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.notice.SyslogInfomation;
import com.chenyang.nse.bussiness.service.core.SysLogService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SyslogServiceImpl implements SysLogService {
   @Autowired
   private SysLogDao sysLogDao;

   public SyslogInfomation initSyslog(String id) {
      return (SyslogInfomation)this.sysLogDao.queryUnique(new Criterion[]{Restrictions.eq("id", id)});
   }

   public void addSyslog(SyslogInfomation syslogInfomation) {
      String username = CommonUtils.loginUsername();
      if (StringUtils.isBlank(syslogInfomation.getId())) {
         syslogInfomation.setCreateuser(username);
         syslogInfomation.setCreatetime(new Date());
         syslogInfomation.setFlag("0");
         syslogInfomation.setId(StringTool.getTablePrimaryKey());
         this.sysLogDao.save(syslogInfomation);
      } else {
         SyslogInfomation mailInfo = (SyslogInfomation)this.sysLogDao.queryUnique(new Criterion[]{Restrictions.eq("id", syslogInfomation.getId())});
         BeanUtils.copyProperties(syslogInfomation, mailInfo);
         syslogInfomation.setFlag("0");
         mailInfo.setUpdateuser(username);
         mailInfo.setUpdatetime(new Date());
         this.sysLogDao.saveOrUpdate(mailInfo);
      }

   }

   public void remove(String id) {
      Criterion croleid = Restrictions.in("id", new Object[]{id});
      this.sysLogDao.remove(new Criterion[]{croleid});
   }

   public List<SyslogInfomation> queryAll() {
      return this.sysLogDao.queryAll();
   }
}
