package com.chenyang.nse.bussiness.service.core.impl.encryption;

import com.alibaba.fastjson.JSON;
import com.chenyang.nse.bussiness.dao.table.base.TBaseGroupDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseGroupRoleDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseRoleDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUserDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUsergroupDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUserroleDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreDataAreaDao;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreDesensitiveFieldDao;
import com.chenyang.nse.bussiness.dao.table.core.masking.TCoreDesensitizationRuleDao;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseGroup;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseGrouprole;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseRole;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUsergroup;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUserrole;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataArea;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreDesensitiveField;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreDesensitizationRule;
import com.chenyang.nse.bussiness.entity.vo.FieldDesensitiveConfigVO;
import com.chenyang.nse.bussiness.entity.vo.UserGroupVO;
import com.chenyang.nse.bussiness.service.core.FieldDesensitiveConfigService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FieldDesensitiveConfigServiceImpl implements FieldDesensitiveConfigService {
   @Autowired
   TBaseGroupDao tBaseGroupDao;
   @Autowired
   TBaseGroupRoleDao tBaseGroupRoleDao;
   @Autowired
   TBaseUsergroupDao tBaseUsergroupDao;
   @Autowired
   TBaseUserDao tBaseUserDao;
   @Autowired
   TBaseRoleDao tBaseRoleDao;
   @Autowired
   TBaseUserroleDao tBaseUserroleDao;
   @Autowired
   TCoreDesensitiveFieldDao tCoreDesensitiveFieldDao;
   @Autowired
   TCoreDataAreaDao tCoreDataAreaDao;
   @Autowired
   TCoreDesensitizationRuleDao tCoreDesensitizationRuleDao;

   public List<UserGroupVO> queryUserGroupList() {
      List<UserGroupVO> result = new ArrayList();

      for(TBaseGroup group : this.tBaseGroupDao.queryAll()) {
         UserGroupVO vo = new UserGroupVO();
         vo.setGroup(group);
         List<TBaseUser> users = this.queryUserListByGroupId(group.getId());
         vo.setUserlist(users);
         result.add(vo);
      }

      return result;
   }

   public void save(Map<String, Object> map) {
      String project_id = map.get("project_id").toString();
      String datasystem_id = map.get("datasystem_id").toString();
      String tschema = map.get("tschema").toString();
      String tname = map.get("tname").toString();

      for(FieldDesensitiveConfigVO vo : JSON.parseArray(JSON.toJSONString(map.get("list")), FieldDesensitiveConfigVO.class)) {
         TCoreDesensitiveField field = new TCoreDesensitiveField();
         field.setProject_id(project_id);
         field.setDatasystem_id(datasystem_id);
         field.setTschema(tschema);
         field.setTable_name(tname);
         field.setTable_field(vo.getFieldName());
         field.setRule_id(vo.getRuleId());
         field.setUserids(vo.getUserids());
         field.setNote(vo.getNote());
         TCoreDesensitiveField desensitiveField = (TCoreDesensitiveField)this.tCoreDesensitiveFieldDao.queryUnique(new Criterion[]{Restrictions.eq("project_id", project_id), Restrictions.eq("datasystem_id", datasystem_id), Restrictions.eq("tschema", tschema), Restrictions.eq("table_name", tname), Restrictions.eq("table_field", field.getTable_field())});
         if (desensitiveField != null) {
            this.tCoreDesensitiveFieldDao.remove(new Criterion[]{Restrictions.eq("project_id", project_id), Restrictions.eq("datasystem_id", datasystem_id), Restrictions.eq("tschema", tschema), Restrictions.eq("table_name", tname), Restrictions.eq("table_field", field.getTable_field())});
         }

         this.tCoreDesensitiveFieldDao.save(field);
      }

   }

   public List<TCoreDesensitiveField> queryFieldConfigList(String project_id, String datasystem_id, String tschema, String tname) {
      List<TCoreDesensitiveField> fieldList = this.tCoreDesensitiveFieldDao.queryAll(new Criterion[]{Restrictions.eq("project_id", project_id), Restrictions.eq("datasystem_id", datasystem_id), Restrictions.eq("tschema", tschema), Restrictions.eq("table_name", tname)});
      if (fieldList != null && fieldList.size() > 0) {
         for(TCoreDesensitiveField field : fieldList) {
            if (field.getRule_id() != null) {
               TCoreDesensitizationRule tCoreDesensitizationRule = (TCoreDesensitizationRule)this.tCoreDesensitizationRuleDao.get(field.getRule_id());
               field.setRulename(tCoreDesensitizationRule.getRulename());
               TCoreDataArea dataArea = (TCoreDataArea)this.tCoreDataAreaDao.get(tCoreDesensitizationRule.getDataarea_id());
               field.setDataarea(dataArea.getDataarea());
            }
         }

         return fieldList;
      } else {
         return new ArrayList();
      }
   }

   public List<TBaseUser> queryUserListByGroupId(String groupId) {
      List<TBaseUser> result = new ArrayList();

      for(TBaseUsergroup usergroup : this.tBaseUsergroupDao.queryAll(new Criterion[]{Restrictions.eq("groupid", groupId)})) {
         TBaseUser user = (TBaseUser)this.tBaseUserDao.queryUnique(new Criterion[]{Restrictions.eq("id", usergroup.getUserid())});
         result.add(user);
      }

      List<TBaseGrouprole> grouproles = this.tBaseGroupRoleDao.queryAll(new Criterion[]{Restrictions.eq("groupid", groupId)});
      List<TBaseRole> roleList = new ArrayList();

      for(TBaseGrouprole grouprole : grouproles) {
         TBaseRole role = (TBaseRole)this.tBaseRoleDao.queryUnique(new Criterion[]{Restrictions.eq("id", grouprole.getRoleid())});
         roleList.add(role);
      }

      for(TBaseRole tBaseRole : roleList) {
         for(TBaseUserrole roleuser : this.tBaseUserroleDao.queryAll(new Criterion[]{Restrictions.eq("roleid", tBaseRole.getId())})) {
            TBaseUser user = (TBaseUser)this.tBaseUserDao.queryUnique(new Criterion[]{Restrictions.eq("id", roleuser.getUserid())});
            result.add(user);
         }
      }

      result = (List)result.stream().distinct().collect(Collectors.toList());
      result = (List)result.stream().filter((a) -> a.getIsenable() != 0).collect(Collectors.toList());
      return result;
   }
}
