package com.chenyang.nse.bussiness.service.init.impl;

import com.chenyang.nse.bussiness.dao.table.base.TBaseGroupDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseMenuDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseMenuresourceDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseResourceDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseRoleDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseRolemenuDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUserDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUsergroupDao;
import com.chenyang.nse.bussiness.dao.table.base.TBaseUserroleDao;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleDbfieldtypeDao;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleDictionaryDao;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleDictionarytypeDao;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleSearchregexDao;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleSortDao;
import com.chenyang.nse.bussiness.dao.table.console.mapping.TConsoleDatamappingSourcefieldDao;
import com.chenyang.nse.bussiness.dao.table.console.mapping.TConsoleDatamappingTargetfieldDao;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseGroup;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseMenu;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseMenuresource;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseResource;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseRole;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseRolemenu;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUser;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUsergroup;
import com.chenyang.nse.bussiness.entity.orm.table.base.TBaseUserrole;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDbfieldtype;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionary;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionarytype;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleSearchregex;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleSort;
import com.chenyang.nse.bussiness.entity.orm.table.console.mapping.TConsoleDatamappingSourcefield;
import com.chenyang.nse.bussiness.entity.orm.table.console.mapping.TConsoleDatamappingTargetfield;
import com.chenyang.nse.bussiness.service.init.InitService;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InitServiceImpl implements InitService {
   @Autowired
   private TBaseMenuDao menuDao;
   @Autowired
   private TBaseResourceDao resourceDao;
   @Autowired
   private TBaseMenuresourceDao menuresourceDao;
   @Autowired
   private TBaseGroupDao groupDao;
   @Autowired
   private TBaseRoleDao roleDao;
   @Autowired
   private TBaseRolemenuDao rolemenuDao;
   @Autowired
   private TBaseUserDao userDao;
   @Autowired
   private TBaseUsergroupDao usergroupDao;
   @Autowired
   private TBaseUserroleDao userroleDao;
   @Autowired
   private TConsoleDbfieldtypeDao dbfieldtypeDao;
   @Autowired
   private TConsoleDictionaryDao dictionaryDao;
   @Autowired
   private TConsoleDictionarytypeDao dictionarytypeDao;
   @Autowired
   private TConsoleSearchregexDao searchregexDao;
   @Autowired
   private TConsoleSortDao sortDao;
   @Autowired
   private TConsoleDatamappingSourcefieldDao tConsoleDatamappingSourcefieldDao;
   @Autowired
   private TConsoleDatamappingTargetfieldDao tConsoleDatamappingTargetfieldDao;

   @Transactional
   public void initData() {
      FileTool ft = new FileTool();
      String path = ft.getClassRoot() + File.separator + "data" + File.separator + "init" + File.separator;
      String xml = null;
      if (this.menuDao.count() == 0L) {
         xml = path + "t_base_menu.xml";
         List<TBaseMenu> list_menu = (List)XmlTool.xmlToJava(xml, ArrayList.class);
         if (list_menu != null && list_menu.size() > 0) {
            for(TBaseMenu item : list_menu) {
               this.menuDao.save(item);
            }
         }
      }

      if (this.resourceDao.count() == 0L) {
         xml = path + "t_base_resource.xml";
         List<TBaseResource> list_resource = (List)XmlTool.xmlToJava(xml, ArrayList.class);
         if (list_resource != null && list_resource.size() > 0) {
            for(TBaseResource item : list_resource) {
               this.resourceDao.save(item);
            }
         }
      }

      if (this.menuresourceDao.count() == 0L) {
         xml = path + "t_base_menuresource.xml";
         List<TBaseMenuresource> list_menuresource = (List)XmlTool.xmlToJava(xml, ArrayList.class);
         if (list_menuresource != null && list_menuresource.size() > 0) {
            for(TBaseMenuresource item : list_menuresource) {
               this.menuresourceDao.save(item);
            }
         }
      }

      if (this.userDao.count() == 0L) {
         xml = path + "t_base_user.xml";
         List<TBaseUser> list_user = (List)XmlTool.xmlToJava(xml, ArrayList.class);
         if (list_user != null && list_user.size() > 0) {
            for(TBaseUser item : list_user) {
               this.userDao.save(item);
            }
         }
      }

      if (this.groupDao.count() == 0L) {
         xml = path + "t_base_group.xml";
         List<TBaseGroup> list_group = (List)XmlTool.xmlToJava(xml, ArrayList.class);
         if (list_group != null && list_group.size() > 0) {
            for(TBaseGroup item : list_group) {
               this.groupDao.save(item);
            }
         }
      }

      if (this.usergroupDao.count() == 0L) {
         xml = path + "t_base_usergroup.xml";
         List<TBaseUsergroup> list_usergroup = (List)XmlTool.xmlToJava(xml, ArrayList.class);
         if (list_usergroup != null && list_usergroup.size() > 0) {
            for(TBaseUsergroup item : list_usergroup) {
               this.usergroupDao.save(item);
            }
         }
      }

      if (this.roleDao.count() == 0L) {
         xml = path + "t_base_role.xml";
         List<TBaseRole> list_role = (List)XmlTool.xmlToJava(xml, ArrayList.class);
         if (list_role != null && list_role.size() > 0) {
            for(TBaseRole item : list_role) {
               this.roleDao.save(item);
            }
         }
      }

      if (this.rolemenuDao.count() == 0L) {
         xml = path + "t_base_rolemenu.xml";
         List<TBaseRolemenu> list_rolemenu = (List)XmlTool.xmlToJava(xml, ArrayList.class);
         if (list_rolemenu != null && list_rolemenu.size() > 0) {
            for(TBaseRolemenu item : list_rolemenu) {
               this.rolemenuDao.save(item);
            }
         }
      }

      if (this.userroleDao.count() == 0L) {
         xml = path + "t_base_userrole.xml";
         List<TBaseUserrole> list_userrole = (List)XmlTool.xmlToJava(xml, ArrayList.class);
         if (list_userrole != null && list_userrole.size() > 0) {
            for(TBaseUserrole item : list_userrole) {
               this.userroleDao.save(item);
            }
         }
      }

      if (this.dbfieldtypeDao.count() == 0L) {
         xml = path + "t_console_dbfieldtype.xml";
         List<TConsoleDbfieldtype> list_dbfieldtype = (List)XmlTool.xmlToJava(xml, ArrayList.class);
         if (list_dbfieldtype != null && list_dbfieldtype.size() > 0) {
            for(TConsoleDbfieldtype item : list_dbfieldtype) {
               this.dbfieldtypeDao.save(item);
            }
         }
      }

      if (this.dictionaryDao.count() == 0L) {
         xml = path + "t_console_dictionary.xml";
         List<TConsoleDictionary> list_dictionary = (List)XmlTool.xmlToJava(xml, ArrayList.class);
         if (list_dictionary != null && list_dictionary.size() > 0) {
            for(TConsoleDictionary item : list_dictionary) {
               this.dictionaryDao.save(item);
            }
         }
      }

      if (this.dictionarytypeDao.count() == 0L) {
         xml = path + "t_console_dictionarytype.xml";
         List<TConsoleDictionarytype> list_dictionarytype = (List)XmlTool.xmlToJava(xml, ArrayList.class);
         if (list_dictionarytype != null && list_dictionarytype.size() > 0) {
            for(TConsoleDictionarytype item : list_dictionarytype) {
               this.dictionarytypeDao.save(item);
            }
         }
      }

      if (this.searchregexDao.count() == 0L) {
         xml = path + "t_console_searchregex.xml";
         List<TConsoleSearchregex> list_searchregex = (List)XmlTool.xmlToJava(xml, ArrayList.class);
         if (list_searchregex != null && list_searchregex.size() > 0) {
            for(TConsoleSearchregex item : list_searchregex) {
               this.searchregexDao.save(item);
            }
         }
      }

      if (this.sortDao.count() == 0L) {
         xml = path + "t_console_sort.xml";
         List<TConsoleSort> list_sort = (List)XmlTool.xmlToJava(xml, ArrayList.class);
         if (list_sort != null && list_sort.size() > 0) {
            for(TConsoleSort item : list_sort) {
               this.sortDao.save(item);
            }
         }
      }

      if (this.tConsoleDatamappingSourcefieldDao.count() == 0L) {
         xml = path + "t_console_datamapping_sourcefield.xml";
         List<TConsoleDatamappingSourcefield> list = (List)XmlTool.xmlToJava(xml, ArrayList.class);
         if (list != null && list.size() > 0) {
            for(TConsoleDatamappingSourcefield item : list) {
               this.tConsoleDatamappingSourcefieldDao.save(item);
            }
         }
      }

      if (this.tConsoleDatamappingTargetfieldDao.count() == 0L) {
         xml = path + "t_console_datamapping_targetfield.xml";
         List<TConsoleDatamappingTargetfield> list = (List)XmlTool.xmlToJava(xml, ArrayList.class);
         if (list != null && list.size() > 0) {
            for(TConsoleDatamappingTargetfield item : list) {
               this.tConsoleDatamappingTargetfieldDao.save(item);
            }
         }
      }

   }
}
