package com.chenyang.nse.bussiness.tools.dmp;

import java.io.IOException;
import java.io.Reader;

public class DmpBufferedReader extends Reader {
   public static final int arraySize = 1000;
   private Reader reader;
   private char[] buffer = new char[1000];
   private int index = 0;
   private int count = 0;

   public DmpBufferedReader(Reader reader) {
      this.reader = reader;
   }

   private int Read() throws IOException {
      if (this.count == 0) {
         this.count = this.reader.read(this.buffer);
         this.index = 0;
      }

      if (this.count < 0) {
         return -1;
      } else {
         char ch = this.buffer[this.index];
         ++this.index;
         --this.count;
         return ch;
      }
   }

   public String ReadLine() throws IOException {
      StringBuilder stringBuilder = new StringBuilder();
      int ch = 0;

      while((ch = this.Read()) != -1) {
         if (ch == 10) {
            return stringBuilder.toString();
         }

         stringBuilder.append((char)ch);
      }

      if (stringBuilder.length() != 0) {
         return stringBuilder.toString();
      } else {
         return null;
      }
   }

   public void close() throws IOException {
      this.reader.close();
   }

   public int read(char[] cbuf, int off, int len) throws IOException {
      return 0;
   }
}
