package com.chenyang.nse.bussiness.tools.encryption.sm4fpe;

import java.util.Map;

public class SM4FPECompanyUtil {
   public static String generateKey() {
      SM4FPEBase base = new SM4FPEBase();
      return base.generateKey();
   }

   public static String encryptEcb(String hexKey, String a, String isLike, String keepfirst, String encdigit, String twoindex) throws Exception {
      Map<String, String> map = SM4FPETools.parseInput(a, keepfirst, encdigit, twoindex);
      String prefix = (String)map.get("prefix");
      String suffix = (String)map.get("suffix");
      String middle = (String)map.get("middle");
      String out = middle;
      if (SM4FPECompany.check(middle)) {
         SM4FPECompany company = new SM4FPECompany();
         out = company.encryptEcb(hexKey, middle);
         if (!SM4FPECompany.check(out)) {
            System.out.println("The encrypt result must be is companyName. result:" + out);
            out = middle;
         }
      }

      return prefix + out + suffix;
   }

   public static String decryptEcb(String hexKey, String input, String isLike, String keepfirst, String encdigit, String twoindex) throws Exception {
      Map<String, String> map = SM4FPETools.parseInput(input, keepfirst, encdigit, twoindex);
      String prefix = (String)map.get("prefix");
      String suffix = (String)map.get("suffix");
      String middle = (String)map.get("middle");
      String out = middle;
      if (SM4FPECompany.check(middle)) {
         SM4FPECompany company = new SM4FPECompany();
         out = company.decryptEcb(hexKey, middle);
         if (!SM4FPECompany.check(out)) {
            System.out.println("The encrypt result must be is companyName. result:" + out);
            out = middle;
         }
      }

      return prefix + out + suffix;
   }
}
