package com.chenyang.nse.bussiness.tools.net;

import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.springframework.stereotype.Component;

@Component
public class NetTool {
   public static boolean isPing(String ip) {
      boolean connect = false;
      Runtime runtime = Runtime.getRuntime();

      try {
         Process process = runtime.exec("ping " + ip);
         InputStream is = process.getInputStream();
         InputStreamReader isr = new InputStreamReader(is);
         BufferedReader br = new BufferedReader(isr);
         String line = null;
         StringBuffer sb = new StringBuffer();

         while((line = br.readLine()) != null) {
            sb.append(line);
         }

         is.close();
         isr.close();
         br.close();
         if (null != sb && !sb.toString().equals("")) {
            String logString = "";
            if (sb.toString().indexOf("TTL") > 0) {
               connect = true;
            } else {
               connect = false;
            }
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return connect;
   }

   public static boolean checkConnect(String ip) {
      InetAddress ad = null;
      boolean state = false;

      try {
         ad = InetAddress.getByName(ip);
         state = ad.isReachable(2000);
         return state;
      } catch (Exception e) {
         e.printStackTrace();
         return state;
      } finally {
         ;
      }
   }

   public static ResultVO isHostConnectable(String host, int port) {
      Socket socket = new Socket();
      ResultVO resultvo = new ResultVO();

      ResultVO var5;
      try {
         resultvo.setResult(true);
         socket.connect(new InetSocketAddress(host, port));
         return resultvo;
      } catch (IOException e) {
         e.printStackTrace();
         resultvo.setMessage(getExceptionSrintStackTrace(e));
         resultvo.setResult(false);
         var5 = resultvo;
      } finally {
         try {
            socket.close();
         } catch (IOException e) {
            e.printStackTrace();
            resultvo.setMessage(getExceptionSrintStackTrace(e));
            resultvo.setResult(false);
         }

      }

      return var5;
   }

   public static String getExceptionSrintStackTrace(Exception e) {
      StringWriter sw = new StringWriter();
      PrintWriter pw = new PrintWriter(sw);
      e.printStackTrace(pw);
      return sw.toString();
   }

   public static Throwable getExceptionType(Exception e) {
      return e;
   }

   public static String getExceptionMessage(Exception e) {
      return e.getMessage();
   }

   public static void main(String[] args) {
      System.out.println(isPing("192.168.1.100"));
   }
}
