package com.chenyang.nse.bussiness.tools.zip;

import cn.hutool.core.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ZipUtils {
   private static final String DEFAULT_CHARSET = "UTF-8";
   private static final int BUFFER_SIZE = 2048;

   public static void zip(String zipFileName, String sourceFolder, String zipPathName) throws Exception {
      ZipOutputStream out = null;

      try {
         File zipFile = new File(zipFileName);
         FileUtil.mkdir(zipFile.getParent());
         FileOutputStream outputStream = new FileOutputStream(zipFile);
         out = new ZipOutputStream(outputStream);
         if (StringUtils.isNotBlank(zipPathName)) {
            zipPathName = FilenameUtils.normalizeNoEndSeparator(zipPathName, true) + "/";
         } else {
            zipPathName = "";
         }

         zip(out, sourceFolder, zipPathName);
      } catch (IOException e) {
         e.printStackTrace();
         throw new Exception(e);
      } finally {
         IOUtils.closeQuietly(out);
      }

   }

   public static void zip(String zipFile, String source) throws Exception {
      File file = new File(source);
      zip(zipFile, source, file.isFile() ? "" : file.getName());
   }

   public static void zip(File zipFile, File source) throws Exception {
      zip(zipFile.getAbsolutePath(), source.getAbsolutePath());
   }

   private static void zip(ZipOutputStream zos, String file, String pathName) throws IOException {
      File file2zip = new File(file);
      if (file2zip.isFile()) {
         zos.putNextEntry(new ZipEntry(pathName + file2zip.getName()));
         IOUtils.copy(new FileInputStream(file2zip.getAbsolutePath()), zos);
         zos.flush();
         zos.closeEntry();
      } else {
         File[] files = file2zip.listFiles();
         if (ArrayUtils.isNotEmpty(files)) {
            for(File f : files) {
               if (f.isDirectory()) {
                  zip(zos, FilenameUtils.normalizeNoEndSeparator(f.getAbsolutePath(), true), FilenameUtils.normalizeNoEndSeparator(pathName + f.getName(), true) + "/");
               } else {
                  FileInputStream inputStream = new FileInputStream(f.getAbsolutePath());
                  zos.putNextEntry(new ZipEntry(pathName + f.getName()));
                  IOUtils.copy(inputStream, zos);
                  inputStream.close();
                  zos.flush();
                  zos.closeEntry();
               }
            }
         } else {
            zos.putNextEntry(new ZipEntry(pathName + "/"));
            zos.closeEntry();
         }
      }

   }

   public static void main(String[] args) throws Exception {
      String zipName = "D:\\home\\ghca\\data\\测试a.zip";
      String path = "D:\\home\\ghca\\data\\encryption";
      zip(zipName, path);
   }
}
