package com.chenyang.nse.bussiness.service.core.strategy;

import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.audit.app.AuditAppDataRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.audit.conditions.AuditApplicationConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.audit.conditions.AuditDateConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.audit.conditions.AuditDbuserConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.audit.conditions.AuditIpConditions;
import com.chenyang.nse.bussiness.entity.vo.strategy.StrategeVO;
import java.util.List;

public interface AuditAppDataRuleService {
   void saveAppRuleInfo(AuditAppDataRule appDataRule, String id);

   void saveIpConditionsInfo(AuditIpConditions ipConditions);

   void saveApplicationConditionsInfo(AuditApplicationConditions applicationConditions);

   void saveDbuserConditionsInfo(AuditDbuserConditions dbuserConditions);

   void saveDateConditionsInfo(AuditDateConditions dateConditions);

   List<AuditAppDataRule> getAppRuleInfoById(String id);

   List<AuditIpConditions> getIpConditionsInfoByRuleId(String ruleid);

   List<AuditApplicationConditions> getApplicationConditionsInfoByRuleId(String ruleid);

   List<AuditDbuserConditions> getDbuserConditionsInfoByRuleId(String ruleid);

   List<AuditDateConditions> getDateConditionsInfoByRuleId(String ruleid);

   void delAppRuleInfoById(String id);

   void delIpConditionsInfoByRuleId(String ruleid);

   void delApplicationConditionsInfoByRuleId(String ruleid);

   void delDbuserConditionsInfoByRuleId(String ruleid);

   void delDateConditionsInfoByRuleId(String ruleid);

   List<StrategeVO> queryAll();

   List<AuditAppDataRule> getAuditInfoByDatasystemid(String datasystemid);
}
