package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreEngine;
import com.chenyang.nse.bussiness.entity.orm.table.core.blobmasking.TCoreBlobMaskingTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructure;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingDetailrecord;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingFilesystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingHive;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTable;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreSyncKeyindex;
import com.chenyang.nse.bussiness.entity.param.blobmasking.TCoreBlobMaskingTaskCond;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DBTableVO;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.entity.vo.TreeGridSensitiveDataVO;
import com.chenyang.nse.bussiness.entity.vo.TreeVO;
import com.chenyang.nse.bussiness.entity.vo.blobmasking.TCoreBlobMaskingTaskVO;
import com.chenyang.nse.bussiness.entity.vo.file.TCoreFileStructurecolumnVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.TCoreMaskingFilesystemVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.TaskRecordVO;
import com.chenyang.nse.bussiness.enumeration.EdataSystem;
import com.chenyang.nse.bussiness.enumeration.EdataSystemGrade;
import com.chenyang.nse.bussiness.enumeration.EmaskingTaskType;
import com.chenyang.nse.bussiness.enumeration.datamapping.EdataMappingType;
import com.chenyang.nse.bussiness.enumeration.file.DateFormat;
import com.chenyang.nse.bussiness.service.console.DataMappingService;
import com.chenyang.nse.bussiness.service.console.SearchRegexService;
import com.chenyang.nse.bussiness.service.core.BlobMaskingTaskService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.FileSystemService;
import com.chenyang.nse.bussiness.service.core.ImportMaskingRuleService;
import com.chenyang.nse.bussiness.service.core.MaskingRuleService;
import com.chenyang.nse.bussiness.service.core.MaskingTaskService;
import com.chenyang.nse.bussiness.service.core.SchedulerService;
import com.chenyang.nse.bussiness.service.info.InfoService;
import com.chenyang.nse.bussiness.tools.datatime.DateTimeTool;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import com.chenyang.nse.bussiness.tools.string.PasswordEncryptTool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/blobmaskingtask"})
public class BlobMaskingTaskController {
   private static Logger logger = LoggerFactory.getLogger(BlobMaskingTaskController.class);
   @Autowired
   private BlobMaskingTaskService blobMaskingTaskService;
   @Autowired
   private MaskingTaskService maskingTaskService;
   @Autowired
   private ImportMaskingRuleService importMaskingRuleService;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private InfoService infoService;
   @Autowired
   private SearchRegexService searchRegexService;
   @Autowired
   private FileSystemService fileSystemService;
   @Autowired
   private MaskingRuleService maskingRuleService;
   @Autowired
   private DataMappingService dataMappingService;
   @Autowired
   private SchedulerService schedulerService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/blobmaskingtask/blobmaskingtask";
   }

   @RequestMapping({"/querytask"})
   @ResponseBody
   public DataGridVO<TCoreBlobMaskingTask> querytask(String taskname, Integer page, Integer rows, PageInfo pageInfo, HttpServletRequest request, HttpServletResponse response, Model model) {
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TCoreBlobMaskingTask> list = this.blobMaskingTaskService.queryTask(taskname, pageInfo);
      DataGridVO<TCoreBlobMaskingTask> vo = new DataGridVO<TCoreBlobMaskingTask>(pageInfo.getCount(), list);
      return vo;
   }

   @RequestMapping({"/createtask"})
   public String createtask(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/blobmaskingtask/createstep/createtask";
   }

   @RequestMapping({"/createtaskstep"})
   public String createtaskstep(String step, HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/blobmaskingtask/createstep/" + step;
   }

   @ResponseBody
   @RequestMapping({"/querymaskingengine"})
   public List<TCoreEngine> querymaskingengine(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreEngine> list = this.importMaskingRuleService.queryMaskingEngine();
      return list;
   }

   @ResponseBody
   @RequestMapping({"/testtasknameexist"})
   public ResultVO testtasknameexist(String taskname, HttpServletRequest request, HttpServletResponse response, Model model) {
      Boolean reFlg = false;
      List<TCoreBlobMaskingTask> taskLst = this.blobMaskingTaskService.queryBlobMaskingTaskByTaskName(taskname);
      if (null != taskLst && taskLst.size() > 0) {
         reFlg = true;
      }

      return new ResultVO("", reFlg);
   }

   @RequestMapping({"/querydatasystem"})
   @ResponseBody
   public List<TCoreDatasystem> querydatasystem(HttpServletRequest request, HttpServletResponse response, Model model) {
      String flag = "1";
      List<TCoreDatasystem> list = this.dataSystemService.query(flag);
      return list;
   }

   @RequestMapping({"/queryschema"})
   @ResponseBody
   public List<ComboboxVO> queryschema(String datasystemid, HttpServletRequest request, HttpServletResponse response, Model model) {
      Connection conn = this.dataSystemService.getConnectionByDataSystemId(datasystemid);
      if (conn == null) {
         return new ArrayList();
      } else {
         List<String> schema = JdbcTool.getDbSchemas(conn);
         JdbcTool.closeConnection(conn);
         List<ComboboxVO> list = new ArrayList();

         for(String str : schema) {
            ComboboxVO cv = new ComboboxVO(str);
            list.add(cv);
         }

         return list;
      }
   }

   @RequestMapping({"/querytable"})
   @ResponseBody
   public List<DBTableVO> querytable(String datasystemid, String schema) {
      List<DBTableVO> dbTableLst = this.dataSystemService.queryTablename(datasystemid, schema);
      return dbTableLst;
   }

   @RequestMapping(
      value = {"/addtask"},
      method = {RequestMethod.POST}
   )
   @ResponseBody
   public ResultVO addtask(@RequestBody TCoreBlobMaskingTaskCond tcbmtc, HttpServletRequest request) {
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      if (loginUser == null) {
         return new ResultVO("对话超时！", false);
      } else {
         tcbmtc.setUserId(loginUser.getTsysUser().getId());
         tcbmtc.setUsername(loginUser.getTsysUser().getUsername());
         ResultVO rv = null;
         rv = this.blobMaskingTaskService.saveBlobMaskingTask(tcbmtc);
         return rv;
      }
   }

   @RequestMapping({"/exerecord"})
   @ResponseBody
   public ResultVO exerecord(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      System.out.println(DateTimeTool.getSysTime("") + "=================exec Blob data start======================");
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      if (loginUser == null) {
         return new ResultVO("对话超时！", false);
      } else {
         ResultVO rv = null;
         rv = this.blobMaskingTaskService.execMaskingTask(taskid);
         System.out.println(DateTimeTool.getSysTime("") + "=================exec Blob data end======================");
         return rv;
      }
   }

   @RequestMapping(
      value = {"/setExecutionState"},
      method = {RequestMethod.POST}
   )
   @ResponseBody
   public void setExecutionState(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.blobMaskingTaskService.setExecutionState(taskid);
   }

   @RequestMapping(
      value = {"/removetask"},
      method = {RequestMethod.POST}
   )
   @ResponseBody
   public void removetask(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      this.blobMaskingTaskService.removeTask(taskid);
   }

   @RequestMapping({"/detail"})
   public String detail(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      model.addAttribute("taskid", taskid);
      return "core/blobmaskingtask/detail/maskingtaskdetail";
   }

   @RequestMapping({"/detailtype"})
   public String detailtype() {
      return "core/blobmaskingtask/detail/type/single";
   }

   @RequestMapping({"/querytaskdetail"})
   @ResponseBody
   public TCoreBlobMaskingTaskVO queryBlobTaskDetail(String taskid) {
      TCoreBlobMaskingTaskVO vo = null;
      vo = this.blobMaskingTaskService.queryBlobMaskingTaskVOByID(taskid);
      return vo;
   }

   @RequestMapping({"/querysingletable"})
   @ResponseBody
   public List<Map<String, Object>> querysingletable(String sourceid, String sourceflag, String targetid, String targetflag) {
      return this.maskingTaskService.querySingleTable(sourceid, sourceflag, targetid, targetflag);
   }

   @RequestMapping({"/datatype"})
   public String datatype(String type, String flag, HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/maskingtask/createstep/" + type + "/" + flag;
   }

   @RequestMapping({"/exerecordlog"})
   public String exerecordlog(String tasktype) {
      return "core/maskingtask/detail/type/log";
   }

   @ResponseBody
   @RequestMapping({"/queryfolder"})
   public List<Map<String, String>> queryfolder(String engineid, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<String> folder = this.infoService.queryFolderList(engineid);
      List<Map<String, String>> list = new ArrayList();

      for(String item : folder) {
         Map<String, String> map = new HashMap();
         map.put("id", item);
         map.put("text", item);
         map.put("iconCls", "icon-folder");
         list.add(map);
      }

      return list;
   }

   @ResponseBody
   @RequestMapping({"/copytable"})
   public ResultVO copytable(String sdatasystem, String sschema, String stable, String tdatasystem, String tschema, String ttable, HttpServletRequest request, HttpServletResponse response, Model model) {
      Connection sconn = this.dataSystemService.getConnectionByDataSystemId(sdatasystem);
      Connection tconn = this.dataSystemService.getConnectionByDataSystemId(tdatasystem);
      String sourcesystemtype = JdbcTool.getDataBaseType(sconn);
      String targetsystemtype = JdbcTool.getDataBaseType(tconn);
      List<Map<String, String>> mappinginfo = this.dataMappingService.getDatamappingInfo(EdataMappingType.getFlagByName(sourcesystemtype), EdataMappingType.getFlagByName(targetsystemtype));
      List<ColumnInfoVO> sourceList = JdbcTool.getColumnInfoVO(sconn, sschema, stable);
      JdbcTool.copyTable(tconn, tschema, ttable, sourceList, mappinginfo);
      JdbcTool.closeConnection(sconn);
      JdbcTool.closeConnection(tconn);
      ResultVO vo = new ResultVO(PasswordEncryptTool.generatePassword(tdatasystem + tschema + ttable), true);
      return vo;
   }

   @RequestMapping({"/copytablebyfile"})
   @ResponseBody
   public ResultVO copytablebyfile(String filestructureid, String tdatasystem, String tschema, String ttable) {
      return this.maskingTaskService.copyTableByFile(filestructureid, tdatasystem, tschema, ttable);
   }

   @ResponseBody
   @RequestMapping({"/inittree"})
   public List<TreeVO> inittree(String code, String parentid, String text, HttpServletRequest request, HttpServletResponse response, Model model) {
      if (null == code || "".equals(code)) {
         code = EdataSystemGrade.DATASYSTEM.getCode();
      }

      List<TreeVO> datasystemtree = this.dataSystemService.initTree(EdataSystem.DATASYSTEM.getFlag(), code, text, parentid, "0");
      return datasystemtree;
   }

   @RequestMapping({"/inittabledg"})
   @ResponseBody
   public DataGridVO<DBTableVO> inittabledg(String datasystemid, String schema) {
      List<DBTableVO> list = this.dataSystemService.queryTablename(datasystemid, schema);
      return new DataGridVO<DBTableVO>((long)list.size(), list);
   }

   @RequestMapping({"/querycolumninfo"})
   @ResponseBody
   public List<ColumnInfoVO> querycolumninfo(String id, String schema, String tablename, HttpServletRequest request, HttpServletResponse response, Model model) {
      String datasystemid = id.replace(tablename, "");
      TCoreDatasystem datasystem = this.dataSystemService.queryDataSystemById(datasystemid);
      if (datasystem == null) {
         return null;
      } else {
         Connection conn = this.maskingTaskService.getConnectionByDataSystemId(datasystemid);
         List<ColumnInfoVO> list = JdbcTool.getColumnInfoVO(conn, schema, tablename);

         try {
            if (conn != null) {
               conn.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

         return list;
      }
   }

   @RequestMapping({"/errorDetail"})
   @ResponseBody
   public ResultVO errorDetail(String recordid, HttpServletRequest request, HttpServletResponse response, Model model) {
      return null;
   }

   @RequestMapping({"/querytaskrecord"})
   @ResponseBody
   public List<TaskRecordVO> querytaskrecord(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TaskRecordVO> list = this.maskingTaskService.querytaskrecord(taskid);
      return list;
   }

   @RequestMapping({"/querytablerecord"})
   @ResponseBody
   public List<TCoreMaskingDetailrecord> querytablerecord(String recordid, HttpServletRequest request, HttpServletResponse response, Model model) {
      List<TCoreMaskingDetailrecord> record = this.maskingTaskService.querytablerecord(recordid);
      return record;
   }

   @ResponseBody
   @RequestMapping({"/queryallsensitivecolumns"})
   public List<TreeGridSensitiveDataVO> queryallsensitivecolumns(String groupId, HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.maskingTaskService.querySensitiveColumnsByGroupId(groupId);
   }

   @ResponseBody
   @RequestMapping({"/querysensitivegroups"})
   public List<ComboboxVO> querysensitivegroups(HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.searchRegexService.querySensitiveGroups();
   }

   @RequestMapping({"/executetask"})
   public String executetask(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      TCoreMaskingTask task = this.maskingTaskService.queryMaskingTaskById(taskid);
      if (!task.getFlag().equals(EmaskingTaskType.DB_TO_FILE.getFlag()) && !task.getFlag().equals(EmaskingTaskType.DB_TO_DB.getFlag()) && !task.getFlag().equals(EmaskingTaskType.DB_TO_HIVE.getFlag()) && !task.getFlag().equals(EmaskingTaskType.HIVE_TO_HIVE.getFlag()) && !task.getFlag().equals(EmaskingTaskType.HIVE_TO_DB.getFlag())) {
         try {
            this.infoService.executeFileTask(taskid, loginUser.getTsysUser().getId());
         } catch (Exception e) {
            e.printStackTrace();
         }
      } else {
         this.infoService.executeTask(taskid, loginUser.getTsysUser().getId());
      }

      model.addAttribute("taskid", taskid);
      model.addAttribute("engineid", task.getEngineid());
      model.addAttribute("flag", "1");
      return "core/monitor/executepubtask";
   }

   @RequestMapping({"/executepubtask"})
   public String executepubtask(String taskid, String engineid, String flag, HttpServletRequest request, HttpServletResponse response, Model model) {
      if ("1".equals(flag)) {
         model.addAttribute("taskid", taskid);
         model.addAttribute("engineid", engineid);
         return "core/monitor/monitorrun";
      } else if ("2".equals(flag)) {
         model.addAttribute("taskid", taskid);
         model.addAttribute("engineid", engineid);
         return "core/monitor/monitorimptask";
      } else if ("3".equals(flag)) {
         model.addAttribute("taskid", taskid);
         model.addAttribute("engineid", engineid);
         return "core/monitor/monitorsubtask";
      } else {
         return "";
      }
   }

   @RequestMapping({"/executefiletask"})
   public String executefiletask(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");

      try {
         this.infoService.executeFileTask(taskid, loginUser.getTsysUser().getId());
      } catch (Exception e) {
         e.printStackTrace();
      }

      model.addAttribute("taskid", taskid);
      return "core/maskingtask/complexmonitor";
   }

   @RequestMapping({"/complexmonitor"})
   public String complexmonitor(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      model.addAttribute("taskid", taskid);
      return "core/maskingtask/complexmonitor";
   }

   @RequestMapping({"/monitor"})
   public String monitor(String taskid, String recordid, HttpServletRequest request, HttpServletResponse response, Model model) {
      model.addAttribute("taskid", taskid);
      model.addAttribute("recordid", recordid);
      return "core/maskingtask/monitor";
   }

   @RequestMapping({"/querytasktype"})
   @ResponseBody
   public List<ComboboxVO> querytasktype(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<ComboboxVO> list = new ArrayList();

      for(EmaskingTaskType e : EmaskingTaskType.values()) {
         ComboboxVO c = new ComboboxVO(e.getFlag(), e.getMaskingtype());
         list.add(c);
      }

      return list;
   }

   @RequestMapping({"/queryftp"})
   @ResponseBody
   public List<TCoreDatasystem> queryftp() {
      return this.maskingTaskService.queryFTP();
   }

   @RequestMapping({"/queryfilecolumnbyid"})
   @ResponseBody
   public List<TCoreFileStructurecolumnVO> queryfilecolumnbyid(String structureid) {
      List<TCoreFileStructurecolumn> list = this.fileSystemService.queryFileStructureColumn(structureid);
      List<TCoreFileStructurecolumnVO> volist = null;

      try {
         volist = ObjectTool.listConvert(list, TCoreFileStructurecolumnVO.class);
      } catch (Exception e) {
         e.printStackTrace();
      }

      return volist;
   }

   @RequestMapping({"/querymaskingrule"})
   @ResponseBody
   public List<TCoreMaskingRule> querymaskingrule() {
      return this.maskingRuleService.queryMaskingRule();
   }

   @RequestMapping({"/structure/querygroupname"})
   @ResponseBody
   public List<ComboboxVO> querygroupname() {
      return this.fileSystemService.queryGroupname();
   }

   @RequestMapping({"/structure/querystructurebygroup"})
   @ResponseBody
   public List<TCoreFileStructure> querystructurebygroup(String groupname, String tableNamePattern) {
      return this.fileSystemService.queryStructureByGroup(groupname, tableNamePattern);
   }

   @RequestMapping({"/structure/querydateformat"})
   @ResponseBody
   public List<ComboboxVO> querydateformat(HttpServletRequest request, HttpServletResponse response, Model model) {
      List<ComboboxVO> list = new ArrayList();

      for(DateFormat df : DateFormat.values()) {
         ComboboxVO c = new ComboboxVO(df.getName());
         list.add(c);
      }

      return list;
   }

   @RequestMapping({"/topreviewlayout"})
   public String topreviewlayout(String tasktype) {
      return "core/maskingtask/createstep/step06/" + tasktype;
   }

   @RequestMapping({"/querymaskingtask"})
   @ResponseBody
   public TCoreMaskingTask querymaskingtask(String taskid, HttpServletRequest request, HttpServletResponse response, Model model) {
      return this.maskingTaskService.queryMaskingTaskByID(taskid);
   }

   @RequestMapping({"/querytaskdetailinfo"})
   @ResponseBody
   public Map<String, Object> querytaskdetailinfo(String taskid, String datadirection, String flag, String tasktype) {
      return this.maskingTaskService.queryTaskDetailInfo(taskid, datadirection, flag, tasktype);
   }

   @RequestMapping({"/querymultitable"})
   @ResponseBody
   public List<Map<String, Object>> querymultitable(String sourceid, String sourceflag) {
      return this.maskingTaskService.queryMultiTable(sourceid, sourceflag);
   }

   @RequestMapping({"/querymaskingfilesystem"})
   @ResponseBody
   public TCoreMaskingFilesystem querymaskingfilesystem(String filesystemid) {
      return this.maskingTaskService.queryMaskingFilesystemByID(filesystemid);
   }

   @RequestMapping({"/querymaskingtable"})
   @ResponseBody
   public List<TCoreMaskingTable> querymaskingtable(String taskid, String direction) {
      return this.maskingTaskService.queryMaskingTable(taskid, direction);
   }

   @RequestMapping({"/querymaskinghive"})
   @ResponseBody
   public List<TCoreMaskingHive> querymaskinghive(String taskid, String direction) {
      return this.maskingTaskService.queryMaskingHive(taskid, direction);
   }

   @RequestMapping({"/querymaskingfile"})
   @ResponseBody
   public List<TCoreMaskingFilesystemVO> querymaskingfile(String taskid, String direction) {
      return this.maskingTaskService.queryMaskingFile(taskid, direction);
   }

   @RequestMapping({"/synckeyorindex"})
   @ResponseBody
   public TCoreSyncKeyindex synckeyorindex(HttpServletRequest request, HttpServletResponse response, Model model, String taskid, String sourcename) {
      TCoreSyncKeyindex sync = this.infoService.querySync(taskid, sourcename);
      model.addAttribute("taskid", taskid);
      model.addAttribute("sourcename", sourcename);
      return sync;
   }

   @RequestMapping({"/querymultidbsourcemapping"})
   @ResponseBody
   public Map<String, Object> querymultidbsourcemapping(@RequestParam(value = "taskid",required = false) String taskid, @RequestParam(value = "tablename[]",required = false) String[] tablename) {
      return this.maskingTaskService.queryMultiDBSourceMapping(taskid, tablename);
   }

   @RequestMapping({"/querymultihivesourcemapping"})
   @ResponseBody
   public Map<String, Object> querymultihivesourcemapping(@RequestParam(value = "taskid",required = false) String taskid, @RequestParam(value = "tablename[]",required = false) String[] tablename) {
      return this.maskingTaskService.queryMultiHiveSourceMapping(taskid, tablename);
   }

   @RequestMapping({"/querymultifssourcemapping"})
   @ResponseBody
   public Map<String, Object> querymultifssourcemapping(@RequestParam Map<String, String> map) {
      return this.maskingTaskService.queryMultiFSSourceMapping(map);
   }

   @RequestMapping({"/queryMultiDbToFsStructure"})
   @ResponseBody
   public Map<String, Object> querymultidbtofsstructure(String taskid) {
      return this.maskingTaskService.queryMultiDbToFsStructure(taskid);
   }

   @RequestMapping({"/querysingledbmapping"})
   @ResponseBody
   public List<Map<String, Object>> querysingledbmapping(String taskid, String sourceflag, String targetflag) {
      return this.maskingTaskService.querySingleDbMapping(taskid, sourceflag, targetflag);
   }

   @RequestMapping({"/queryTableColumName"})
   @ResponseBody
   public Map<String, Object> queryTableColumName(@RequestParam Map<String, Object> map, String taskid, String sourceid) {
      return null;
   }

   @RequestMapping({"/inputmulti"})
   public String inputmulti(String flag, String title, String multivalue, HttpServletRequest request, HttpServletResponse response, Model model) {
      model.addAttribute("title", title);
      model.addAttribute("multivalue", multivalue);
      return "core/blobmaskingtask/createstep/step05multi/" + flag;
   }
}
