package com.chenyang.nse.bussiness.engine.infa.powercenter961.subsetdata;

import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.FLATFILE;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.SOURCE;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.SOURCEFIELD;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.TABLEATTRIBUTE;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.SourceBean;
import java.util.ArrayList;
import java.util.List;

public class ChildMappletSourceUtil {
   public List<SOURCE> getChildSource(List<SourceBean> sb) {
      List<SOURCE> so_list = new ArrayList();
      if (sb != null && sb.size() > 0) {
         for(int i = 0; i < sb.size(); ++i) {
            SOURCE source = new SOURCE();
            source.setBUSINESSNAME(((SourceBean)sb.get(i)).getBusinessname());
            if ("ORACLE".equalsIgnoreCase(((SourceBean)sb.get(i)).getDatabasetype())) {
               source.setDATABASETYPE(((SourceBean)sb.get(i)).getDatabasetype());
            } else if ("DB2".equalsIgnoreCase(((SourceBean)sb.get(i)).getDatabasetype())) {
               source.setDATABASETYPE(((SourceBean)sb.get(i)).getDatabasetype());
            } else if ("INFORMIX".equalsIgnoreCase(((SourceBean)sb.get(i)).getDatabasetype())) {
               source.setDATABASETYPE("ODBC");
            } else if ("MSSQLSERVER".equalsIgnoreCase(((SourceBean)sb.get(i)).getDatabasetype())) {
               source.setDATABASETYPE("ODBC");
            } else if ("MYSQL".equalsIgnoreCase(((SourceBean)sb.get(i)).getDatabasetype())) {
               source.setDATABASETYPE("ODBC");
            } else if ("SYBASE".equalsIgnoreCase(((SourceBean)sb.get(i)).getDatabasetype())) {
               source.setDATABASETYPE("ODBC");
            } else {
               source.setDATABASETYPE(((SourceBean)sb.get(i)).getDatabasetype());
            }

            source.setDBDNAME(((SourceBean)sb.get(i)).getDbdname());
            source.setDESCRIPTION(((SourceBean)sb.get(i)).getDescripion());
            source.setNAME(((SourceBean)sb.get(i)).getSo_name());
            source.setOBJECTVERSION("1");
            source.setOWNERNAME(((SourceBean)sb.get(i)).getSo_ownname());
            source.setVERSIONNUMBER("1");

            for(SOURCEFIELD sourcefield : getConvertTableInfoToSOURCEFIELD(((SourceBean)sb.get(i)).getCb().getKeytype(), ((SourceBean)sb.get(i)).getCb().getNameList(), ((SourceBean)sb.get(i)).getCb().getTypeList(), ((SourceBean)sb.get(i)).getCb().getLengthList(), ((SourceBean)sb.get(i)).getCb().getScalelist(), ((SourceBean)sb.get(i)).getCb().getPrecisionList(), ((SourceBean)sb.get(i)).getDatabasetype())) {
               source.getSOURCEFIELD().add(sourcefield);
            }

            so_list.add(source);
         }
      }

      return so_list;
   }

   public static List<SOURCEFIELD> getConvertTableInfoToSOURCEFIELD(List<String> keytype, List<String> nameList, List<String> typeList, List<String> lengthList, List<String> scalelist, List<String> precisionlist, String dbtype) {
      List<SOURCEFIELD> sourceFieldList = new ArrayList();
      int phyOffset = 0;
      int prePhyOffset = 0;
      int offset = 0;
      int preOffset = 0;
      if ("DB2".equalsIgnoreCase(dbtype)) {
         for(int i = 0; i < nameList.size(); ++i) {
            SOURCEFIELD sourceField = new SOURCEFIELD();
            sourceField.setBUSINESSNAME("");
            sourceField.setDESCRIPTION("");
            sourceField.setFIELDNUMBER(i + 1 + "");
            sourceField.setFIELDPROPERTY("0");
            sourceField.setFIELDTYPE("ELEMITEM");
            sourceField.setHIDDEN("NO");
            sourceField.setKEYTYPE((String)keytype.get(i));
            if ("blob".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("8000");
               sourceField.setPHYSICALLENGTH("4000");
               sourceField.setPRECISION("4000");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("Byte");
            } else if ("boolean".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("5");
               sourceField.setPHYSICALLENGTH("5");
               sourceField.setPRECISION("5");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("SmallInt");
            } else if ("byte".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("8000");
               sourceField.setPHYSICALLENGTH("4000");
               sourceField.setPRECISION("4000");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("Byte");
            } else if ("varchar".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("Varchar");
            } else if ("char".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("Char");
            } else if ("clob".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("4000");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("4000");
               sourceField.setDATATYPE("Text");
            } else if ("date".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("10");
               sourceField.setPRECISION("10");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("Date");
            } else if ("datetime".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("25");
               sourceField.setPRECISION("25");
               sourceField.setSCALE("5");
               sourceField.setDATATYPE("Datetime year to fraction(5)");
            } else if ("float".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("24");
               sourceField.setPHYSICALLENGTH("15");
               sourceField.setPRECISION("15");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("Float");
            } else if ("int8".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("20");
               sourceField.setPHYSICALLENGTH("19");
               sourceField.setPRECISION("19");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("Int8");
            } else if ("int".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("11");
               sourceField.setPHYSICALLENGTH("10");
               sourceField.setPRECISION("10");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("Integer");
            } else if ("money".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("16");
               sourceField.setPRECISION("16");
               sourceField.setSCALE("2");
               sourceField.setDATATYPE("Money");
            } else if ("nchar".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("char");
            } else if ("nvarchar".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("NVarchar");
            } else if ("lvarchar".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("varchar");
            } else if ("serial".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("11");
               sourceField.setPHYSICALLENGTH("10");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("10");
               sourceField.setDATATYPE("Serial");
            } else if ("serial8".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("20");
               sourceField.setPHYSICALLENGTH("19");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("19");
               sourceField.setDATATYPE("Int8");
            } else if ("smallfloat".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("24");
               sourceField.setPHYSICALLENGTH("7");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("7");
               sourceField.setDATATYPE("SmallFloat");
            } else if ("smallint".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("6");
               sourceField.setPHYSICALLENGTH("5");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("5");
               sourceField.setDATATYPE("SmallInt");
            } else if ("decimal".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("Decimal");
            } else if ("INTEGER".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("integer");
            } else {
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE((String)typeList.get(i));
            }

            sourceField.setLEVEL("0");
            sourceField.setNAME((String)nameList.get(i));
            if ("PRIMARY KEY".equals(keytype.get(i))) {
               sourceField.setNULLABLE("NOTNULL");
            } else {
               sourceField.setNULLABLE("NULL");
            }

            sourceField.setOCCURS("0");
            offset += preOffset;
            sourceField.setOFFSET(offset + "");
            phyOffset += prePhyOffset;
            sourceField.setPHYSICALOFFSET(phyOffset + "");
            sourceField.setPICTURETEXT("");
            sourceField.setUSAGEFLAGS("");
            sourceFieldList.add(sourceField);
         }
      } else if ("ORACLE".equalsIgnoreCase(dbtype)) {
         for(int i = 0; i < nameList.size(); ++i) {
            SOURCEFIELD sourceField = new SOURCEFIELD();
            sourceField.setBUSINESSNAME("");
            sourceField.setDESCRIPTION("");
            sourceField.setFIELDNUMBER(i + 1 + "");
            sourceField.setFIELDPROPERTY("0");
            sourceField.setFIELDTYPE("ELEMITEM");
            sourceField.setHIDDEN("NO");
            sourceField.setKEYTYPE((String)keytype.get(i));
            if ("VARCHAR2".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setPRECISION((String)lengthList.get(i));
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("varchar2");
            } else if ("NUMBER".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("24");
               sourceField.setPHYSICALLENGTH("15");
               sourceField.setPRECISION("15");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("number");
            } else if ("DATE".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("19");
               sourceField.setPRECISION("19");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("date");
            } else if ("CLOB".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("4000");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("4000");
               sourceField.setDATATYPE("clob");
            } else if ("BLOB".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("8000");
               sourceField.setPHYSICALLENGTH("4000");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("4000");
               sourceField.setDATATYPE("blob");
            } else if ("BFILE".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("8000");
               sourceField.setPHYSICALLENGTH("4000");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("4000");
               sourceField.setDATATYPE("long raw");
            } else if ("BINARY_DOUBLE".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("24");
               sourceField.setPHYSICALLENGTH("15");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("15");
               sourceField.setDATATYPE("number");
            } else if ("BINARY_FLOAT".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("24");
               sourceField.setPHYSICALLENGTH("15");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("15");
               sourceField.setDATATYPE("number");
            } else if ("CHAR".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("1");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("1");
               sourceField.setDATATYPE("char");
            } else if ("number(p,s)".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("40");
               sourceField.setPHYSICALLENGTH("38");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("38");
               sourceField.setDATATYPE("number(p,s)");
            } else if ("number(p,s)".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("40");
               sourceField.setPHYSICALLENGTH("38");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("38");
               sourceField.setDATATYPE("number(p,s)");
            } else if ("INTERVAL DAY(2) TO SECOND(6)".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("0");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("0");
               sourceField.setDATATYPE("varchar2");
            } else if ("INTERVAL YEAR(2) TO MONTH".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("0");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("0");
               sourceField.setDATATYPE("varchar2");
            } else if ("LONG".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("4000");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("4000");
               sourceField.setDATATYPE("long");
            } else if ("NCHAR".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("1");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("1");
               sourceField.setDATATYPE("varchar2");
            } else if ("NVARCHAR2".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("20");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("20");
               sourceField.setDATATYPE("varchar2");
            } else if ("NCLOB".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("0");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("0");
               sourceField.setDATATYPE("varchar2");
            } else if ("RAW".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("40");
               sourceField.setPHYSICALLENGTH("20");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("20");
               sourceField.setDATATYPE("raw");
            } else if ("ROWID".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("0");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("0");
               sourceField.setDATATYPE("varchar2");
            } else if ("TIMESTAMP(6)".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("26");
               sourceField.setSCALE("6");
               sourceField.setPRECISION("26");
               sourceField.setDATATYPE("timestamp");
            } else if ("UROWID".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("0");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("0");
               sourceField.setDATATYPE("varchar2");
            } else {
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE((String)typeList.get(i));
            }

            sourceField.setLEVEL("0");
            sourceField.setNAME((String)nameList.get(i));
            if ("PRIMARY KEY".equals(keytype.get(i))) {
               sourceField.setNULLABLE("NOTNULL");
            } else {
               sourceField.setNULLABLE("NULL");
            }

            sourceField.setOCCURS("0");
            offset += preOffset;
            sourceField.setOFFSET(offset + "");
            phyOffset += prePhyOffset;
            sourceField.setPHYSICALOFFSET(phyOffset + "");
            sourceField.setPICTURETEXT("");
            sourceField.setUSAGEFLAGS("");
            sourceFieldList.add(sourceField);
         }
      } else if ("INFORMIX".equalsIgnoreCase(dbtype)) {
         for(int i = 0; i < nameList.size(); ++i) {
            SOURCEFIELD sourceField = new SOURCEFIELD();
            sourceField.setBUSINESSNAME("");
            sourceField.setDESCRIPTION("");
            sourceField.setFIELDNUMBER(i + 1 + "");
            sourceField.setFIELDPROPERTY("0");
            sourceField.setFIELDTYPE("ELEMITEM");
            sourceField.setHIDDEN("NO");
            sourceField.setKEYTYPE((String)keytype.get(i));
            if ("blob".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION("4000");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("Byte");
               sourceField.setLENGTH("8000");
               sourceField.setPHYSICALLENGTH("8000");
            } else if ("boolean".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION("5");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("SmallInt");
               sourceField.setLENGTH("8000");
               sourceField.setPHYSICALLENGTH("8000");
            } else if ("byte".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION("4000");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("Byte");
               sourceField.setLENGTH("6");
               sourceField.setPHYSICALLENGTH("5");
            } else if ("varchar".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("Varchar");
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
            } else if ("char".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("Char");
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("100");
            } else if ("clob".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setSCALE("0");
               sourceField.setPRECISION("4000");
               sourceField.setDATATYPE("Text");
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("4000");
            } else if ("date".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION("19");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("Date");
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("19");
            } else if ("datetime".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION("25");
               sourceField.setSCALE("5");
               sourceField.setDATATYPE("Datetime year to fraction(5)");
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("25");
            } else if ("float".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION("15");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("Float");
               sourceField.setLENGTH("24");
               sourceField.setPHYSICALLENGTH("15");
            } else if ("int8".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION("19");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("Int8");
               sourceField.setLENGTH("20");
               sourceField.setPHYSICALLENGTH("19");
            } else if ("int".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION("10");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("Integer");
               sourceField.setLENGTH("11");
               sourceField.setPHYSICALLENGTH("10");
            } else if ("money".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION("16");
               sourceField.setSCALE("2");
               sourceField.setDATATYPE("Money");
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("16");
            } else if ("nchar".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("Char");
               sourceField.setLENGTH("0");
               sourceField.setPRECISION((String)lengthList.get(i));
            } else if ("nvarchar".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("NVarchar");
               sourceField.setLENGTH("0");
               sourceField.setPRECISION((String)lengthList.get(i));
            } else if ("lvarchar".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("varchar");
               sourceField.setLENGTH("0");
               sourceField.setPRECISION((String)lengthList.get(i));
            } else if ("serial".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setSCALE("0");
               sourceField.setPRECISION("10");
               sourceField.setDATATYPE("Serial");
               sourceField.setLENGTH("11");
               sourceField.setPRECISION("10");
            } else if ("serial8".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setSCALE("0");
               sourceField.setPRECISION("19");
               sourceField.setDATATYPE("Int8");
            } else if ("smallfloat".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setSCALE("0");
               sourceField.setPRECISION("7");
               sourceField.setDATATYPE("SmallFloat");
               sourceField.setLENGTH("24");
               sourceField.setPRECISION("7");
            } else if ("smallint".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setSCALE("0");
               sourceField.setPRECISION("5");
               sourceField.setDATATYPE("SmallInt");
               sourceField.setLENGTH("6");
               sourceField.setPRECISION("5");
            } else if ("decimal".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("Decimal");
               sourceField.setLENGTH("12");
               sourceField.setPRECISION("10");
            } else {
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE((String)typeList.get(i));
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
            }

            sourceField.setLEVEL("0");
            sourceField.setNAME((String)nameList.get(i));
            if ("PRIMARY KEY".equals(keytype.get(i))) {
               sourceField.setNULLABLE("NOTNULL");
            } else {
               sourceField.setNULLABLE("NULL");
            }

            sourceField.setOCCURS("0");
            offset += preOffset;
            sourceField.setOFFSET(offset + "");
            phyOffset += prePhyOffset;
            sourceField.setPHYSICALOFFSET(phyOffset + "");
            sourceField.setPICTURETEXT("");
            sourceField.setUSAGEFLAGS("");
            sourceFieldList.add(sourceField);
         }
      } else if ("MSSQLSERVER".equalsIgnoreCase(dbtype)) {
         for(int i = 0; i < nameList.size(); ++i) {
            SOURCEFIELD sourceField = new SOURCEFIELD();
            sourceField.setBUSINESSNAME("");
            sourceField.setDESCRIPTION("");
            sourceField.setFIELDNUMBER(i + 1 + "");
            sourceField.setFIELDPROPERTY("0");
            sourceField.setFIELDTYPE("ELEMITEM");
            sourceField.setHIDDEN("NO");
            sourceField.setKEYTYPE((String)keytype.get(i));
            if ("bigint".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("20");
               sourceField.setPHYSICALLENGTH("19");
               sourceField.setPRECISION("19");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("bigint");
            } else if ("binary".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("2");
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("binary");
            } else if ("bit".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("1");
               sourceField.setPHYSICALLENGTH("1");
               sourceField.setPRECISION("1");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("bit");
            } else if ("char".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("char");
            } else if ("date".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("23");
               sourceField.setSCALE("3");
               sourceField.setPRECISION("23");
               sourceField.setDATATYPE("datetime");
            } else if ("datetime".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("23");
               sourceField.setSCALE("3");
               sourceField.setPRECISION("23");
               sourceField.setDATATYPE("datetime");
            } else if ("datetime2".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("27");
               sourceField.setPRECISION("27");
               sourceField.setSCALE("7");
               sourceField.setDATATYPE("datetime2");
            } else if ("datetimeoffset".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("34");
               sourceField.setPRECISION("34");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("nvarchar");
            } else if ("decimal".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("12");
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("decimal");
            } else if ("real".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("24");
               sourceField.setPHYSICALLENGTH("7");
               sourceField.setPRECISION("7");
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setDATATYPE("real");
            } else if ("geography".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("varchar");
            } else if ("geometry".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("varchar");
            } else if ("hierarchyid".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH("892");
               sourceField.setSCALE("892");
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("varchar");
            } else if ("image".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("8000");
               sourceField.setPHYSICALLENGTH("4000");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("4000");
               sourceField.setDATATYPE("image");
            } else if ("int".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("11");
               sourceField.setPHYSICALLENGTH("10");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("10");
               sourceField.setDATATYPE("int");
            } else if ("money".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("19");
               sourceField.setSCALE("4");
               sourceField.setPRECISION("19");
               sourceField.setDATATYPE("money");
            } else if ("nchar".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("nchar");
            } else if ("ntext".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("104857600");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("104857600");
               sourceField.setDATATYPE("ntext");
            } else if ("numeric".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("7");
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("numeric");
            } else if ("nvarchar".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("nvarchar");
            } else if ("smalldatetime".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("19");
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION("19");
               sourceField.setDATATYPE("smalldatetime");
            } else if ("smallint".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("6");
               sourceField.setPHYSICALLENGTH("5");
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION("5");
               sourceField.setDATATYPE("smallint");
            } else if ("smallmoney".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("10");
               sourceField.setSCALE("4");
               sourceField.setPRECISION("10");
               sourceField.setDATATYPE("smallmoney");
            } else if ("sql_variant".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("8000");
               sourceField.setSCALE("4");
               sourceField.setPRECISION("8000");
               sourceField.setDATATYPE("varchar");
            } else if ("sysname".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("128");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("128");
               sourceField.setDATATYPE("nvarchar");
            } else if ("text".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("4000");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("4000");
               sourceField.setDATATYPE("text");
            } else if ("time".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("232");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("23");
               sourceField.setDATATYPE("datetime");
            } else if ("timestamp".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("16");
               sourceField.setPHYSICALLENGTH("8");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("8");
               sourceField.setDATATYPE("timestamp");
            } else if ("tinyint".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("4");
               sourceField.setPHYSICALLENGTH("3");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("3");
               sourceField.setDATATYPE("tinyint");
            } else if ("uniqueidentifier".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("38");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("38");
               sourceField.setDATATYPE("varchar");
            } else if ("varbinary".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("varchar");
            } else if ("varchar".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("varchar");
            } else {
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE((String)typeList.get(i));
            }

            sourceField.setLEVEL("0");
            sourceField.setNAME((String)nameList.get(i));
            if ("PRIMARY KEY".equals(keytype.get(i))) {
               sourceField.setNULLABLE("NOTNULL");
            } else {
               sourceField.setNULLABLE("NULL");
            }

            sourceField.setOCCURS("0");
            offset += preOffset;
            sourceField.setOFFSET(offset + "");
            phyOffset += prePhyOffset;
            sourceField.setPHYSICALOFFSET(phyOffset + "");
            sourceField.setPICTURETEXT("");
            sourceField.setUSAGEFLAGS("");
            sourceFieldList.add(sourceField);
         }
      } else if ("MYSQL".equalsIgnoreCase(dbtype)) {
         for(int i = 0; i < nameList.size(); ++i) {
            SOURCEFIELD sourceField = new SOURCEFIELD();
            sourceField.setBUSINESSNAME("");
            sourceField.setDESCRIPTION("");
            sourceField.setFIELDNUMBER(i + 1 + "");
            sourceField.setFIELDPROPERTY("0");
            sourceField.setFIELDTYPE("ELEMITEM");
            sourceField.setHIDDEN("NO");
            sourceField.setKEYTYPE((String)keytype.get(i));
            if ("TINYINT".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("4");
               sourceField.setPHYSICALLENGTH("3");
               sourceField.setPRECISION("3");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("tinyint");
            } else if ("SMALLINT".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("6");
               sourceField.setPHYSICALLENGTH("5");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("5");
               sourceField.setDATATYPE("smallint");
            } else if ("MEDIUMINT".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("integer");
            } else if ("INT".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("integer");
            } else if ("BIGINT".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("bigint");
            } else if ("BIT".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("1");
               sourceField.setPHYSICALLENGTH("1");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("1");
               sourceField.setDATATYPE("bit");
            } else if ("DOUBLE".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("double");
            } else if ("FLOAT".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("real");
            } else if ("DECIMAL".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("decimal");
            } else if ("CHAR".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("255");
               sourceField.setPRECISION("255");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("nchar");
            } else if ("VARCHAR".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("nvarchar");
            } else if ("DATE".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("19");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("10");
               sourceField.setDATATYPE("date");
            } else if ("TIME".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("8");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("8");
               sourceField.setDATATYPE("time");
            } else if ("YEAR".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("6");
               sourceField.setPHYSICALLENGTH("5");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("5");
               sourceField.setDATATYPE("smallint");
            } else if ("TIMESTAMP".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("29");
               sourceField.setSCALE("9");
               sourceField.setPRECISION("29");
               sourceField.setDATATYPE("timestamp");
            } else if ("DATETIME".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("29");
               sourceField.setSCALE("9");
               sourceField.setPRECISION("29");
               sourceField.setDATATYPE("timestamp");
            } else if ("TINYBLOB".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("510");
               sourceField.setPHYSICALLENGTH("255");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("255");
               sourceField.setDATATYPE("longvarbinary");
            } else if ("BLOB".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("131070");
               sourceField.setPHYSICALLENGTH("65535");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("65535");
               sourceField.setDATATYPE("longvarbinary");
            } else if ("MEDIUMBLOB".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("33554430");
               sourceField.setPHYSICALLENGTH("16777215");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("16777215");
               sourceField.setDATATYPE("longvarbinary");
            } else if ("LONGBLOB".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("4294967294");
               sourceField.setPHYSICALLENGTH("4294967295");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("4294967295");
               sourceField.setDATATYPE("longvarbinary");
            } else if ("TINYTEXT".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("255");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("255");
               sourceField.setDATATYPE("ntext");
            } else if ("TEXT".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("65535");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("65535");
               sourceField.setDATATYPE("ntext");
            } else if ("MEDIUMTEXT".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("16777215");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("16777215");
               sourceField.setDATATYPE("ntext");
            } else if ("LONGTEXT".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("4294967295");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("4294967295");
               sourceField.setDATATYPE("ntext");
            } else if ("ENUM".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("nchar");
            } else if ("SET".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("nchar");
            } else if ("BINARY".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("510");
               sourceField.setPHYSICALLENGTH("255");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("255");
               sourceField.setDATATYPE("binary");
            } else if ("VARBINARY".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("510");
               sourceField.setPHYSICALLENGTH("255");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("255");
               sourceField.setDATATYPE("varbinary");
            } else if ("POINT".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("4294967294");
               sourceField.setPHYSICALLENGTH("4294967294");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("4294967294");
               sourceField.setDATATYPE("longvarbinary");
            } else if ("LINESTRING".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("4294967294");
               sourceField.setPHYSICALLENGTH("4294967294");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("4294967294");
               sourceField.setDATATYPE("longvarbinary");
            } else if ("POLYGON".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("4294967294");
               sourceField.setPHYSICALLENGTH("4294967294");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("4294967294");
               sourceField.setDATATYPE("longvarbinary");
            } else if ("GEOMETRY".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("4294967294");
               sourceField.setPHYSICALLENGTH("4294967294");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("4294967294");
               sourceField.setDATATYPE("longvarbinary");
            } else if ("MULTIPOINT".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("4294967294");
               sourceField.setPHYSICALLENGTH("4294967294");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("4294967294");
               sourceField.setDATATYPE("longvarbinary");
            } else if ("MULTILINESTRING".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("4294967294");
               sourceField.setPHYSICALLENGTH("4294967294");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("4294967294");
               sourceField.setDATATYPE("longvarbinary");
            } else if ("MULTIPOLYGON".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("4294967294");
               sourceField.setPHYSICALLENGTH("4294967294");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("4294967294");
               sourceField.setDATATYPE("longvarbinary");
            } else if ("GEOMETRYCOLLECTION".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("4294967294");
               sourceField.setPHYSICALLENGTH("4294967294");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("4294967294");
               sourceField.setDATATYPE("longvarbinary");
            } else {
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE((String)typeList.get(i));
            }

            sourceField.setLEVEL("0");
            sourceField.setNAME((String)nameList.get(i));
            if ("PRIMARY KEY".equals(keytype.get(i))) {
               sourceField.setNULLABLE("NOTNULL");
            } else {
               sourceField.setNULLABLE("NULL");
            }

            sourceField.setOCCURS("0");
            offset += preOffset;
            sourceField.setOFFSET(offset + "");
            phyOffset += prePhyOffset;
            sourceField.setPHYSICALOFFSET(phyOffset + "");
            sourceField.setPICTURETEXT("");
            sourceField.setUSAGEFLAGS("");
            sourceFieldList.add(sourceField);
         }
      } else if ("SYBASE".equalsIgnoreCase(dbtype)) {
         for(int i = 0; i < nameList.size(); ++i) {
            SOURCEFIELD sourceField = new SOURCEFIELD();
            sourceField.setBUSINESSNAME("");
            sourceField.setDESCRIPTION("");
            sourceField.setFIELDNUMBER(i + 1 + "");
            sourceField.setFIELDPROPERTY("0");
            sourceField.setFIELDTYPE("ELEMITEM");
            sourceField.setHIDDEN("NO");
            sourceField.setKEYTYPE((String)keytype.get(i));
            if ("bigint".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("20");
               sourceField.setPHYSICALLENGTH("19");
               sourceField.setPRECISION("19");
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("bigint");
            } else if ("binary".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("binary");
            } else if ("bit".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("bit");
            } else if ("char".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("char");
            } else if ("date".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION("23");
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("23");
               sourceField.setSCALE("3");
               sourceField.setDATATYPE("datetime");
            } else if ("datetime".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION("23");
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("23");
               sourceField.setSCALE("3");
               sourceField.setDATATYPE("datetime");
            } else if ("decimal".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setDATATYPE("decimal");
            } else if ("float".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setDATATYPE("float");
            } else if ("image".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("8000");
               sourceField.setPHYSICALLENGTH("4000");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("4000");
               sourceField.setDATATYPE("decimal");
            } else if ("int".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setDATATYPE("int");
            } else if ("longsysname".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setDATATYPE("varchar");
            } else if ("varchar".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("varchar");
            } else if ("money".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("19");
               sourceField.setSCALE("4");
               sourceField.setPRECISION("19");
               sourceField.setDATATYPE("money");
            } else if ("nchar".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("nchar");
            } else if ("nvarchar".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE("0");
               sourceField.setDATATYPE("nvarchar");
            } else if ("real".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("24");
               sourceField.setPHYSICALLENGTH("7");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("7");
               sourceField.setDATATYPE("real");
            } else if ("smalldatetime".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("19");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("19");
               sourceField.setDATATYPE("smalldatetime");
            } else if ("smallint".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("6");
               sourceField.setPHYSICALLENGTH("5");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("5");
               sourceField.setDATATYPE("smallint");
            } else if ("smallmoney".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("10");
               sourceField.setSCALE("4");
               sourceField.setPRECISION("10");
               sourceField.setDATATYPE("smallmoney");
            } else if ("sysname".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("100");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("100");
               sourceField.setDATATYPE("varchar");
            } else if ("text".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("4000");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("4000");
               sourceField.setDATATYPE("text");
            } else if ("time".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("19");
               sourceField.setPHYSICALLENGTH("23");
               sourceField.setSCALE("3");
               sourceField.setPRECISION("23");
               sourceField.setDATATYPE("datetime");
            } else if ("timestamp".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setDATATYPE("varbinary");
            } else if ("tinyint".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setDATATYPE("tinyint");
            } else if ("unichar".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("200");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("200");
               sourceField.setDATATYPE("nchar");
            } else if ("unitext".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("4000");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("4000");
               sourceField.setDATATYPE("nvarchar");
            } else if ("univarchar".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("200");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("200");
               sourceField.setDATATYPE("nvarchar");
            } else if ("unsigned bigint".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setDATATYPE("bigint");
            } else if ("unsigned int".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE("int");
            } else if ("unsigned smallint".equalsIgnoreCase((String)typeList.get(i))) {
               sourceField.setLENGTH("0");
               sourceField.setPHYSICALLENGTH("5");
               sourceField.setSCALE("0");
               sourceField.setPRECISION("5");
               sourceField.setDATATYPE("smallint");
            } else {
               sourceField.setLENGTH((String)lengthList.get(i));
               sourceField.setPHYSICALLENGTH((String)lengthList.get(i));
               sourceField.setSCALE((String)scalelist.get(i));
               sourceField.setPRECISION((String)precisionlist.get(i));
               sourceField.setDATATYPE((String)typeList.get(i));
            }

            sourceField.setLEVEL("0");
            sourceField.setNAME((String)nameList.get(i));
            if ("PRIMARY KEY".equals(keytype.get(i))) {
               sourceField.setNULLABLE("NOTNULL");
            } else {
               sourceField.setNULLABLE("NULL");
            }

            sourceField.setOCCURS("0");
            offset += preOffset;
            sourceField.setOFFSET(offset + "");
            phyOffset += prePhyOffset;
            sourceField.setPHYSICALOFFSET(phyOffset + "");
            sourceField.setPICTURETEXT("");
            sourceField.setUSAGEFLAGS("");
            sourceFieldList.add(sourceField);
         }
      }

      return sourceFieldList;
   }

   public List<SOURCE> getSourceOther(List<SourceBean> sb) {
      List<SOURCE> so_list = new ArrayList();
      List<SourceBean> sblist = new ArrayList();
      if (sb != null && sb.size() > 0) {
         for(int i = 0; i < sb.size(); ++i) {
            if (i > 0) {
               sblist.add(sb.get(i));
            }
         }
      }

      if (sblist != null && sblist.size() > 0) {
         for(int i = 0; i < sblist.size(); ++i) {
            SOURCE source = new SOURCE();
            source.setBUSINESSNAME("");
            source.setDATABASETYPE("Flat File");
            source.setDBDNAME("Flat_File");
            source.setDESCRIPTION("");
            source.setNAME("source_tab_candidate" + (i + 1));
            source.setOBJECTVERSION("1");
            source.setOWNERNAME("");
            source.setVERSIONNUMBER("1");
            FLATFILE flatfile = new FLATFILE();
            flatfile.setCODEPAGE("US-ASCII");
            flatfile.setCONSECDELIMITERSASONE("NO");
            flatfile.setDELIMITED("YES");
            flatfile.setDELIMITERS(",");
            flatfile.setESCAPECHARACTER("");
            flatfile.setKEEPESCAPECHAR("NO");
            flatfile.setLINESEQUENTIAL("NO");
            flatfile.setMULTIDELIMITERSASAND("NO");
            flatfile.setNULLCHARTYPE("ASCII");
            flatfile.setNULLCHARACTER("*");
            flatfile.setPADBYTES("1");
            flatfile.setQUOTECHARACTER("NONE");
            flatfile.setREPEATABLE("NO");
            flatfile.setROWDELIMITER("0");
            flatfile.setSHIFTSENSITIVEDATA("NO");
            flatfile.setSKIPROWS("0");
            flatfile.setSTRIPTRAILINGBLANKS("NO");
            source.setFLATFILE(flatfile);
            String[] attributeStr = new String[]{"Base Table Name@", "Search Specification@", "Sort Specification@", "Datetime Format@A  19 mm/dd/yyyy hh24:mi:ss", "Thousand Separator@None", "Decimal Separator@.", "Add Currently Processed Flat File Name Port@NO"};
            String[] tmpAttr = null;
            TABLEATTRIBUTE[] attribute = new TABLEATTRIBUTE[attributeStr.length];

            for(int j = 0; j < attributeStr.length; ++j) {
               tmpAttr = attributeStr[j].split("@");
               attribute[j] = new TABLEATTRIBUTE();
               attribute[j].setNAME(tmpAttr[0]);
               if (tmpAttr.length > 1) {
                  attribute[j].setVALUE(tmpAttr[1]);
               } else {
                  attribute[j].setVALUE("");
               }

               source.getTABLEATTRIBUTE().add(attribute[j]);
            }

            int phyOffset = 0;
            int prePhyOffset = 0;
            int offset = 0;
            int preOffset = 0;

            for(int k = 0; k < ((SourceBean)sblist.get(i)).getCb().getKeytype().size(); ++k) {
               if (((String)((SourceBean)sblist.get(i)).getCb().getKeytype().get(k)).equals("FOREIGN KEY")) {
                  SOURCEFIELD sf = new SOURCEFIELD();
                  sf.setBUSINESSNAME("");
                  if (((String)((SourceBean)sblist.get(i)).getCb().getTypeList().get(k)).equals("number(p,s)")) {
                     sf.setDATATYPE("int");
                  } else {
                     sf.setDATATYPE("string");
                  }

                  sf.setDESCRIPTION("");
                  sf.setFIELDNUMBER("1");
                  sf.setFIELDPROPERTY("0");
                  sf.setFIELDTYPE("ELEMITEM");
                  sf.setHIDDEN("NO");
                  sf.setKEYTYPE("NOT A KEY");
                  sf.setLENGTH("11");
                  sf.setLEVEL("0");
                  sf.setNAME((String)((SourceBean)sblist.get(i)).getCb().getNameList().get(k) + "_sou");
                  sf.setNULLABLE("NULL");
                  sf.setOCCURS("0");
                  offset += preOffset;
                  phyOffset += prePhyOffset;
                  sf.setOFFSET(offset + "");
                  sf.setPHYSICALLENGTH("10");
                  sf.setPHYSICALOFFSET(phyOffset + "");
                  sf.setPICTURETEXT("");
                  sf.setPRECISION((String)((SourceBean)sblist.get(i)).getCb().getLengthList().get(k));
                  sf.setSCALE((String)((SourceBean)sblist.get(i)).getCb().getScalelist().get(k));
                  sf.setUSAGEFLAGS("");
                  source.getSOURCEFIELD().add(sf);
               }
            }

            so_list.add(source);
         }
      }

      return so_list;
   }

   public SOURCE getFixSource(List<String> typeList, List<String> datatypeList, List<String> namelist, List<String> lengthlist, List<String> sclaelist) {
      SOURCE source = new SOURCE();
      source.setBUSINESSNAME("");
      source.setDATABASETYPE("Flat File");
      source.setDBDNAME("Flat_File");
      source.setDESCRIPTION("");
      source.setNAME("tab_candidate");
      source.setOBJECTVERSION("1");
      source.setOWNERNAME("");
      source.setVERSIONNUMBER("1");
      FLATFILE flatfile = new FLATFILE();
      flatfile.setCODEPAGE("US-ASCII");
      flatfile.setCONSECDELIMITERSASONE("NO");
      flatfile.setDELIMITED("YES");
      flatfile.setDELIMITERS(",");
      flatfile.setESCAPECHARACTER("");
      flatfile.setKEEPESCAPECHAR("NO");
      flatfile.setLINESEQUENTIAL("NO");
      flatfile.setMULTIDELIMITERSASAND("NO");
      flatfile.setNULLCHARTYPE("ASCII");
      flatfile.setNULLCHARACTER("*");
      flatfile.setPADBYTES("1");
      flatfile.setQUOTECHARACTER("NONE");
      flatfile.setREPEATABLE("NO");
      flatfile.setROWDELIMITER("0");
      flatfile.setSHIFTSENSITIVEDATA("NO");
      flatfile.setSKIPROWS("0");
      flatfile.setSTRIPTRAILINGBLANKS("NO");
      source.setFLATFILE(flatfile);
      String[] attributeStr = new String[]{"Base Table Name@", "Search Specification@", "Sort Specification@", "Datetime Format@A  19 mm/dd/yyyy hh24:mi:ss", "Thousand Separator@None", "Decimal Separator@.", "Add Currently Processed Flat File Name Port@NO"};
      String[] tmpAttr = null;
      TABLEATTRIBUTE[] attribute = new TABLEATTRIBUTE[attributeStr.length];

      for(int i = 0; i < attributeStr.length; ++i) {
         tmpAttr = attributeStr[i].split("@");
         attribute[i] = new TABLEATTRIBUTE();
         attribute[i].setNAME(tmpAttr[0]);
         if (tmpAttr.length > 1) {
            attribute[i].setVALUE(tmpAttr[1]);
         } else {
            attribute[i].setVALUE("");
         }

         source.getTABLEATTRIBUTE().add(attribute[i]);
      }

      int phyOffset = 0;
      int prePhyOffset = 0;
      int offset = 0;
      int preOffset = 0;
      if (typeList != null && typeList.size() > 0) {
         for(int i = 0; i < typeList.size(); ++i) {
            SOURCEFIELD sf = new SOURCEFIELD();
            sf.setBUSINESSNAME("");
            sf.setDATATYPE((String)datatypeList.get(i));
            sf.setDESCRIPTION("");
            sf.setFIELDNUMBER("1");
            sf.setFIELDPROPERTY("0");
            sf.setFIELDTYPE("ELEMITEM");
            sf.setHIDDEN("NO");
            sf.setKEYTYPE("NOT A KEY");
            sf.setLENGTH("11");
            sf.setLEVEL("0");
            sf.setNAME("ID1");
            sf.setNULLABLE("NULL");
            sf.setOCCURS("0");
            offset += preOffset;
            phyOffset += prePhyOffset;
            sf.setOFFSET(offset + "");
            sf.setPHYSICALLENGTH("10");
            sf.setPHYSICALOFFSET(phyOffset + "");
            sf.setPICTURETEXT("");
            sf.setPRECISION((String)lengthlist.get(i));
            sf.setSCALE((String)sclaelist.get(i));
            sf.setUSAGEFLAGS("");
            source.getSOURCEFIELD().add(sf);
         }
      }

      return source;
   }
}
