package com.chenyang.nse.bussiness.interceptor;

import com.chenyang.nse.bussiness.annot.PassToken;
import com.chenyang.nse.bussiness.annot.PullRegister;
import com.chenyang.nse.bussiness.exception.ClientOutOfWhiteListException;
import com.chenyang.nse.bussiness.exception.TokenException;
import com.chenyang.nse.bussiness.jar.util.JarClientUtil;
import com.chenyang.nse.bussiness.service.console.UserService;
import com.chenyang.nse.bussiness.tools.token.TokenUtil;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class AuthenticationInterceptor implements HandlerInterceptor {
   @Autowired
   private UserService userService;

   public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) throws Exception {
      String token = httpServletRequest.getHeader("token");
      if (!(object instanceof HandlerMethod)) {
         return true;
      } else if (httpServletRequest.getMethod().equals("OPTIONS")) {
         return true;
      } else {
         HandlerMethod handlerMethod = (HandlerMethod)object;
         Method method = handlerMethod.getMethod();
         if (method.isAnnotationPresent(PassToken.class)) {
            PassToken passToken = (PassToken)method.getAnnotation(PassToken.class);
            if (method.isAnnotationPresent(PullRegister.class)) {
               int remotePort = Integer.parseInt((String)JarClientUtil.getRequestParamsMap(httpServletRequest).get("remotePort"));
               if (remotePort != 65536) {
                  JarClientUtil.registOrUpt(httpServletRequest);
                  if (!JarClientUtil.checkAuth(httpServletRequest)) {
                     JarClientUtil.log(httpServletRequest.getRemoteHost(), httpServletRequest.getRemotePort(), "当前客户端地址在白名单外，无法获取规则数据，已驳回请求");
                     throw new ClientOutOfWhiteListException("白名单范围外");
                  }
               }
            }

            if (passToken.required()) {
               return true;
            }
         }

         if (!httpServletRequest.getRequestURI().contains("webtools") && !httpServletRequest.getRequestURI().contains("encryptionGatewayController")) {
            if (token == null) {
               httpServletResponse.sendRedirect("/index.html");
               throw new TokenException("无token，请重新登录");
            } else {
               boolean verify = TokenUtil.verify(token);
               if (!verify) {
                  throw new TokenException("token异常，请重新登录");
               } else {
                  return true;
               }
            }
         } else {
            return true;
         }
      }
   }

   public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
   }

   public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
   }
}
