package com.chenyang.nse.bussiness.service.core.api.impl;

import com.chenyang.nse.bussiness.dao.table.core.api.ApiInfoDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.api.ApiInfo;
import com.chenyang.nse.bussiness.service.core.api.ApiInfoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ApiInfoServiceImpl implements ApiInfoService {
   @Autowired
   private ApiInfoDao apiInfoDao;

   public List<ApiInfo> queryApiInfolist() {
      List<ApiInfo> list = this.apiInfoDao.queryAll();
      return list;
   }

   public List<ApiInfo> queryApiInfoByConditon(Map<String, String> condMap) {
      Criteria criteria = this.apiInfoDao.createCriteria();
      if (condMap.containsKey("type") && StringUtils.isNotBlank((String)condMap.get("type")) && "3".equals(condMap.get("type"))) {
         if (condMap.containsKey("url") && StringUtils.isNotBlank((String)condMap.get("url"))) {
            criteria.add(Restrictions.like("url", (String)condMap.get("url") + "%"));
         }
      } else if (condMap.containsKey("url") && StringUtils.isNotBlank((String)condMap.get("url"))) {
         criteria.add(Restrictions.eq("url", condMap.get("url")));
      }

      new ArrayList();
      List<ApiInfo> apiInfolist = this.apiInfoDao.queryAll(criteria);
      return apiInfolist;
   }
}
