/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.visitor;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLBlockStatement;
import com.alibaba.druid.sql.ast.statement.SQLCheck;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateIndexStatement;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyImpl;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnique;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleDataTypeIntervalDay;
import com.alibaba.druid.sql.dialect.oracle.ast.OracleDataTypeIntervalYear;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.CycleClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.ModelClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleLobStorageClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleReturningClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleStorageClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleWithSubqueryEntry;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.PartitionExtensionClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.SampleClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.SearchClause;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleAnalytic;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleAnalyticWindowing;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleArgumentExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleBinaryDoubleExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleBinaryFloatExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleCursorExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleDatetimeExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleIntervalExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleIsOfTypeExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleIsSetExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleJsonArrayAggExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleJsonObjectExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleMethodInvokeAccessExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleMultisetExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleOuterExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleRangeExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleSysdateExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleTreatExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleXmlContentExpr;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterSessionStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterSynonymStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableDropPartition;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableModify;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableMoveTablespace;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableSplitPartition;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableTruncatePartition;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTablespaceAddDataFile;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTablespaceStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTriggerStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterViewStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCheck;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleContinueStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateDatabaseDbLinkStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateIndexStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreatePackageStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateSynonymStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateTypeStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleDeleteStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleDropDbLinkStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleExceptionStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleExecuteImmediateStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleExitStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleExplainStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleFileSpecification;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleForStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleForeignKey;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleGotoStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleLabelStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleLockTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleMultiInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OraclePipeRowStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OraclePrimaryKey;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleRaiseStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleRunStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectJoin;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectPivot;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectQueryBlock;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectRestriction;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectSubqueryTableSource;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectTableReference;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelectUnPivot;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSetTransactionStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSupplementalIdKey;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSupplementalLogGrp;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUnique;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUsingIndexClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleXmlColumnProperties;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleASTVisitor;
import com.alibaba.druid.sql.repository.SchemaRepository;
import com.alibaba.druid.sql.repository.SchemaResolveVisitor;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.druid.stat.TableStat;
import com.alibaba.druid.util.FnvHash;
import java.util.ArrayList;
import java.util.List;

public class OracleSchemaStatVisitor
extends SchemaStatVisitor
implements OracleASTVisitor {
    public OracleSchemaStatVisitor() {
        this(new ArrayList<Object>());
    }

    public OracleSchemaStatVisitor(SchemaRepository repository) {
        super(repository);
    }

    public OracleSchemaStatVisitor(List<Object> parameters) {
        super(DbType.oracle, parameters);
    }

    @Override
    protected TableStat.Column getColumn(SQLExpr expr) {
        if (expr instanceof OracleOuterExpr) {
            expr = ((OracleOuterExpr)expr).getExpr();
        }
        return super.getColumn(expr);
    }

    @Override
    public boolean visit(OracleSelectTableReference x) {
        SQLExpr expr = x.getExpr();
        TableStat stat = this.getTableStat(x);
        if (expr instanceof SQLName) {
            SQLIdentifierExpr identifierExpr;
            SQLPropertyExpr propertyExpr;
            if (((SQLName)expr).nameHashCode64() == FnvHash.Constants.DUAL) {
                return false;
            }
            if (expr instanceof SQLPropertyExpr ? this.isSubQueryOrParamOrVariant(propertyExpr = (SQLPropertyExpr)expr) : expr instanceof SQLIdentifierExpr && this.isSubQueryOrParamOrVariant(identifierExpr = (SQLIdentifierExpr)expr)) {
                return false;
            }
            TableStat.Mode mode = this.getMode();
            switch (mode) {
                case Delete: {
                    stat.incrementDeleteCount();
                    break;
                }
                case Insert: {
                    stat.incrementInsertCount();
                    break;
                }
                case Update: {
                    stat.incrementUpdateCount();
                    break;
                }
                case Select: {
                    stat.incrementSelectCount();
                    break;
                }
                case Merge: {
                    stat.incrementMergeCount();
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean visit(OracleUpdateStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        this.setMode(x, TableStat.Mode.Update);
        SQLTableSource tableSource = x.getTableSource();
        SQLExpr tableExpr = null;
        if (tableSource instanceof SQLExprTableSource) {
            tableExpr = ((SQLExprTableSource)tableSource).getExpr();
        }
        if (tableExpr instanceof SQLName) {
            TableStat stat = this.getTableStat((SQLName)tableExpr);
            stat.incrementUpdateCount();
        } else {
            tableSource.accept(this);
        }
        this.accept(x.getItems());
        this.accept(x.getWhere());
        return false;
    }

    @Override
    public boolean visit(OracleSelectQueryBlock x) {
        SQLExprTableSource into = x.getInto();
        return this.visit((SQLSelectQueryBlock)x);
    }

    @Override
    public void endVisit(OracleSelectQueryBlock x) {
        this.endVisit((SQLSelectQueryBlock)x);
    }

    @Override
    public boolean visit(SQLPropertyExpr x) {
        return "ROWNUM".equalsIgnoreCase(x.getName()) ? false : super.visit(x);
    }

    @Override
    public boolean visit(SQLIdentifierExpr x) {
        String name = x.getName();
        if ("+".equalsIgnoreCase(name)) {
            return false;
        }
        long hashCode64 = x.hashCode64();
        if (hashCode64 != FnvHash.Constants.ROWNUM && hashCode64 != FnvHash.Constants.SYSDATE && hashCode64 != FnvHash.Constants.LEVEL && hashCode64 != FnvHash.Constants.SQLCODE) {
            return hashCode64 == FnvHash.Constants.ISOPEN && x.getParent() instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)x.getParent()).getOperator() == SQLBinaryOperator.Modulus ? false : super.visit(x);
        }
        return false;
    }

    @Override
    public boolean visit(OracleSelectJoin x) {
        super.visit(x);
        return false;
    }

    @Override
    public boolean visit(OracleSelectSubqueryTableSource x) {
        this.accept(x.getSelect());
        this.accept(x.getPivot());
        this.accept(x.getFlashback());
        return false;
    }

    @Override
    public boolean visit(OracleWithSubqueryEntry x) {
        x.getSubQuery().accept(this);
        return false;
    }

    @Override
    public boolean visit(OracleMultiInsertStatement.InsertIntoClause x) {
        if (x.getTableName() instanceof SQLName) {
            TableStat stat = this.getTableStat(x.getTableName());
            stat.incrementInsertCount();
        }
        this.accept(x.getColumns());
        this.accept(x.getQuery());
        this.accept(x.getReturning());
        this.accept(x.getErrorLogging());
        return false;
    }

    @Override
    public boolean visit(OracleMultiInsertStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        x.putAttribute("_original_use_mode", (Object)this.getMode());
        this.setMode(x, TableStat.Mode.Insert);
        this.accept(x.getSubQuery());
        this.accept(x.getEntries());
        return false;
    }

    @Override
    public boolean visit(OracleMultiInsertStatement.ConditionalInsertClauseItem x) {
        SQLObject parent = x.getParent();
        if (parent instanceof OracleMultiInsertStatement.ConditionalInsertClause) {
            parent = parent.getParent();
        }
        if (parent instanceof OracleMultiInsertStatement) {
            SQLSelect sQLSelect = ((OracleMultiInsertStatement)parent).getSubQuery();
        }
        x.getWhen().accept(this);
        x.getThen().accept(this);
        return false;
    }

    @Override
    public boolean visit(OracleAlterSessionStatement x) {
        return false;
    }

    @Override
    public boolean visit(OracleLockTableStatement x) {
        this.getTableStat(x.getTable());
        return false;
    }

    @Override
    public boolean visit(OracleSysdateExpr x) {
        return false;
    }

    @Override
    public boolean visit(OracleExceptionStatement.Item x) {
        SQLExpr when = x.getWhen();
        if (when instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr ident = (SQLIdentifierExpr)when;
            if (!ident.getName().equalsIgnoreCase("OTHERS")) {
                this.visit(ident);
            }
        } else if (when != null) {
            when.accept(this);
        }
        for (SQLStatement stmt : x.getStatements()) {
            stmt.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OracleSetTransactionStatement x) {
        return false;
    }

    @Override
    public boolean visit(OracleExplainStatement x) {
        return false;
    }

    @Override
    public boolean visit(OracleAlterTableDropPartition x) {
        return false;
    }

    @Override
    public boolean visit(OracleAlterTableTruncatePartition x) {
        return false;
    }

    @Override
    public boolean visit(OracleAlterTableSplitPartition.TableSpaceItem x) {
        return false;
    }

    @Override
    public boolean visit(OracleAlterTableSplitPartition.UpdateIndexesClause x) {
        return false;
    }

    @Override
    public boolean visit(OracleAlterTableSplitPartition.NestedTablePartitionSpec x) {
        return false;
    }

    @Override
    public boolean visit(OracleAlterTableSplitPartition x) {
        return false;
    }

    @Override
    public boolean visit(OracleAlterTableModify x) {
        SQLAlterTableStatement stmt = (SQLAlterTableStatement)x.getParent();
        SQLName tableName = stmt.getName();
        for (SQLColumnDefinition column : x.getColumns()) {
            SQLName columnName = column.getName();
            this.addColumn(tableName, columnName.toString());
        }
        return false;
    }

    @Override
    public boolean visit(OracleForStatement x) {
        x.getRange().accept(this);
        this.accept(x.getStatements());
        return false;
    }

    @Override
    public boolean visit(OraclePrimaryKey x) {
        this.accept(x.getColumns());
        return false;
    }

    @Override
    public boolean visit(OracleCreateTableStatement x) {
        this.visit((SQLCreateTableStatement)x);
        if (x.getSelect() != null) {
            x.getSelect().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OracleStorageClause x) {
        return false;
    }

    @Override
    public boolean visit(OracleGotoStatement x) {
        return false;
    }

    @Override
    public boolean visit(OracleLabelStatement x) {
        return false;
    }

    @Override
    public boolean visit(OracleAlterTriggerStatement x) {
        return false;
    }

    @Override
    public boolean visit(OracleAlterSynonymStatement x) {
        return false;
    }

    @Override
    public boolean visit(OracleAlterViewStatement x) {
        return false;
    }

    @Override
    public boolean visit(OracleAlterTableMoveTablespace x) {
        return false;
    }

    @Override
    public boolean visit(OracleFileSpecification x) {
        return false;
    }

    @Override
    public boolean visit(OracleAlterTablespaceAddDataFile x) {
        return false;
    }

    @Override
    public boolean visit(OracleAlterTablespaceStatement x) {
        return false;
    }

    @Override
    public boolean visit(OracleExitStatement x) {
        return false;
    }

    @Override
    public boolean visit(OracleContinueStatement x) {
        return false;
    }

    @Override
    public boolean visit(OracleRaiseStatement x) {
        return false;
    }

    @Override
    public boolean visit(OracleCreateDatabaseDbLinkStatement x) {
        return false;
    }

    @Override
    public boolean visit(OracleDropDbLinkStatement x) {
        return false;
    }

    @Override
    public boolean visit(OracleDataTypeIntervalYear x) {
        return false;
    }

    @Override
    public boolean visit(OracleDataTypeIntervalDay x) {
        return false;
    }

    @Override
    public boolean visit(OracleUsingIndexClause x) {
        return false;
    }

    @Override
    public boolean visit(OracleLobStorageClause x) {
        return false;
    }

    @Override
    public boolean visit(OracleCreateTableStatement.Organization x) {
        return false;
    }

    @Override
    public boolean visit(OracleCreateTableStatement.OIDIndex x) {
        return false;
    }

    @Override
    public boolean visit(OracleCreatePackageStatement x) {
        if (this.repository != null && x.getParent() == null) {
            this.repository.resolve(x, new SchemaResolveVisitor.Option[0]);
        }
        for (SQLStatement stmt : x.getStatements()) {
            stmt.accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(OracleExecuteImmediateStatement x) {
        SQLExpr dynamicSql = x.getDynamicSql();
        String sql = null;
        if (dynamicSql instanceof SQLIdentifierExpr) {
            String varName = ((SQLIdentifierExpr)dynamicSql).getName();
            SQLExpr valueExpr = null;
            if (x.getParent() instanceof SQLBlockStatement) {
                SQLStatement stmt;
                List<SQLStatement> statementList = ((SQLBlockStatement)x.getParent()).getStatementList();
                int size = statementList.size();
                block0: for (int i = 0; i < size && (stmt = statementList.get(i)) != x; ++i) {
                    if (!(stmt instanceof SQLSetStatement)) continue;
                    for (SQLAssignItem item : ((SQLSetStatement)stmt).getItems()) {
                        if (!item.getTarget().equals(dynamicSql)) continue;
                        valueExpr = item.getValue();
                        continue block0;
                    }
                }
            }
            if (valueExpr != null) {
                dynamicSql = valueExpr;
            }
        }
        if (dynamicSql instanceof SQLCharExpr) {
            sql = ((SQLCharExpr)dynamicSql).getText();
        }
        if (sql != null) {
            for (SQLStatement stmt : SQLUtils.parseStatements(sql, this.dbType)) {
                stmt.accept(this);
            }
        }
        return false;
    }

    @Override
    public boolean visit(OracleCreateSynonymStatement x) {
        return false;
    }

    @Override
    public boolean visit(OracleCreateTypeStatement x) {
        return false;
    }

    @Override
    public boolean visit(OraclePipeRowStatement x) {
        return false;
    }

    @Override
    public boolean visit(OracleIsOfTypeExpr x) {
        return false;
    }

    @Override
    public boolean visit(OracleXmlColumnProperties x) {
        return false;
    }

    @Override
    public boolean visit(OracleXmlColumnProperties.OracleXMLTypeStorage x) {
        return false;
    }

    @Override
    public void endVisit(OracleAnalytic x) {
    }

    @Override
    public void endVisit(OracleAnalyticWindowing x) {
    }

    @Override
    public void endVisit(OracleDeleteStatement x) {
        this.endVisit((SQLDeleteStatement)x);
    }

    @Override
    public void endVisit(OracleIntervalExpr x) {
    }

    @Override
    public void endVisit(OracleOuterExpr x) {
    }

    @Override
    public void endVisit(OracleSelectJoin x) {
    }

    @Override
    public void endVisit(OracleSelectPivot x) {
    }

    @Override
    public void endVisit(OracleSelectPivot.Item x) {
    }

    @Override
    public void endVisit(OracleSelectRestriction.CheckOption x) {
    }

    @Override
    public void endVisit(OracleSelectRestriction.ReadOnly x) {
    }

    @Override
    public void endVisit(OracleSelectSubqueryTableSource x) {
    }

    @Override
    public void endVisit(OracleSelectUnPivot x) {
    }

    @Override
    public void endVisit(OracleUpdateStatement x) {
    }

    @Override
    public boolean visit(OracleAnalytic x) {
        return true;
    }

    @Override
    public boolean visit(OracleAnalyticWindowing x) {
        return true;
    }

    @Override
    public boolean visit(OracleDeleteStatement x) {
        return this.visit((SQLDeleteStatement)x);
    }

    @Override
    public boolean visit(OracleIntervalExpr x) {
        return true;
    }

    @Override
    public boolean visit(OracleOuterExpr x) {
        return true;
    }

    @Override
    public boolean visit(OracleSelectPivot x) {
        return true;
    }

    @Override
    public boolean visit(OracleSelectPivot.Item x) {
        return true;
    }

    @Override
    public boolean visit(OracleSelectRestriction.CheckOption x) {
        return true;
    }

    @Override
    public boolean visit(OracleSelectRestriction.ReadOnly x) {
        return true;
    }

    @Override
    public boolean visit(OracleSelectUnPivot x) {
        return true;
    }

    @Override
    public boolean visit(SampleClause x) {
        return true;
    }

    @Override
    public void endVisit(SampleClause x) {
    }

    @Override
    public void endVisit(OracleSelectTableReference x) {
    }

    @Override
    public boolean visit(PartitionExtensionClause x) {
        return true;
    }

    @Override
    public void endVisit(PartitionExtensionClause x) {
    }

    @Override
    public void endVisit(OracleWithSubqueryEntry x) {
    }

    @Override
    public boolean visit(SearchClause x) {
        return true;
    }

    @Override
    public void endVisit(SearchClause x) {
    }

    @Override
    public boolean visit(CycleClause x) {
        return true;
    }

    @Override
    public void endVisit(CycleClause x) {
    }

    @Override
    public boolean visit(OracleBinaryFloatExpr x) {
        return true;
    }

    @Override
    public void endVisit(OracleBinaryFloatExpr x) {
    }

    @Override
    public boolean visit(OracleBinaryDoubleExpr x) {
        return true;
    }

    @Override
    public void endVisit(OracleBinaryDoubleExpr x) {
    }

    @Override
    public boolean visit(OracleCursorExpr x) {
        return true;
    }

    @Override
    public void endVisit(OracleCursorExpr x) {
    }

    @Override
    public boolean visit(OracleIsSetExpr x) {
        return true;
    }

    @Override
    public void endVisit(OracleIsSetExpr x) {
    }

    @Override
    public boolean visit(ModelClause.ReturnRowsClause x) {
        return true;
    }

    @Override
    public void endVisit(ModelClause.ReturnRowsClause x) {
    }

    @Override
    public boolean visit(ModelClause.MainModelClause x) {
        return true;
    }

    @Override
    public void endVisit(ModelClause.MainModelClause x) {
    }

    @Override
    public boolean visit(ModelClause.ModelColumnClause x) {
        return true;
    }

    @Override
    public void endVisit(ModelClause.ModelColumnClause x) {
    }

    @Override
    public boolean visit(ModelClause.QueryPartitionClause x) {
        return true;
    }

    @Override
    public void endVisit(ModelClause.QueryPartitionClause x) {
    }

    @Override
    public boolean visit(ModelClause.ModelColumn x) {
        return true;
    }

    @Override
    public void endVisit(ModelClause.ModelColumn x) {
    }

    @Override
    public boolean visit(ModelClause.ModelRulesClause x) {
        return true;
    }

    @Override
    public void endVisit(ModelClause.ModelRulesClause x) {
    }

    @Override
    public boolean visit(ModelClause.CellAssignmentItem x) {
        return true;
    }

    @Override
    public void endVisit(ModelClause.CellAssignmentItem x) {
    }

    @Override
    public boolean visit(ModelClause.CellAssignment x) {
        return true;
    }

    @Override
    public void endVisit(ModelClause.CellAssignment x) {
    }

    @Override
    public boolean visit(ModelClause x) {
        return true;
    }

    @Override
    public void endVisit(ModelClause x) {
    }

    @Override
    public boolean visit(OracleReturningClause x) {
        return true;
    }

    @Override
    public void endVisit(OracleReturningClause x) {
    }

    @Override
    public boolean visit(OracleInsertStatement x) {
        return this.visit((SQLInsertStatement)x);
    }

    @Override
    public void endVisit(OracleInsertStatement x) {
        this.endVisit((SQLInsertStatement)x);
    }

    @Override
    public void endVisit(OracleMultiInsertStatement.InsertIntoClause x) {
    }

    @Override
    public void endVisit(OracleMultiInsertStatement x) {
    }

    @Override
    public boolean visit(OracleMultiInsertStatement.ConditionalInsertClause x) {
        return true;
    }

    @Override
    public void endVisit(OracleMultiInsertStatement.ConditionalInsertClause x) {
    }

    @Override
    public void endVisit(OracleMultiInsertStatement.ConditionalInsertClauseItem x) {
    }

    @Override
    public void endVisit(OracleLockTableStatement x) {
    }

    @Override
    public void endVisit(OracleAlterSessionStatement x) {
    }

    @Override
    public boolean visit(OracleDatetimeExpr x) {
        return true;
    }

    @Override
    public void endVisit(OracleDatetimeExpr x) {
    }

    @Override
    public void endVisit(OracleSysdateExpr x) {
    }

    @Override
    public boolean visit(OracleExceptionStatement x) {
        return true;
    }

    @Override
    public void endVisit(OracleExceptionStatement x) {
    }

    @Override
    public void endVisit(OracleExceptionStatement.Item x) {
    }

    @Override
    public boolean visit(OracleArgumentExpr x) {
        return true;
    }

    @Override
    public void endVisit(OracleArgumentExpr x) {
    }

    @Override
    public void endVisit(OracleSetTransactionStatement x) {
    }

    @Override
    public void endVisit(OracleExplainStatement x) {
    }

    @Override
    public void endVisit(OracleAlterTableDropPartition x) {
    }

    @Override
    public void endVisit(OracleAlterTableTruncatePartition x) {
    }

    @Override
    public void endVisit(OracleAlterTableSplitPartition.TableSpaceItem x) {
    }

    @Override
    public void endVisit(OracleAlterTableSplitPartition.UpdateIndexesClause x) {
    }

    @Override
    public void endVisit(OracleAlterTableSplitPartition.NestedTablePartitionSpec x) {
    }

    @Override
    public void endVisit(OracleAlterTableSplitPartition x) {
    }

    @Override
    public void endVisit(OracleAlterTableModify x) {
    }

    @Override
    public boolean visit(OracleCreateIndexStatement x) {
        return this.visit((SQLCreateIndexStatement)x);
    }

    @Override
    public void endVisit(OracleCreateIndexStatement x) {
        this.endVisit((SQLCreateIndexStatement)x);
    }

    @Override
    public void endVisit(OracleForStatement x) {
    }

    @Override
    public boolean visit(OracleRangeExpr x) {
        return true;
    }

    @Override
    public void endVisit(OracleRangeExpr x) {
    }

    @Override
    public void endVisit(OraclePrimaryKey x) {
    }

    @Override
    public void endVisit(OracleCreateTableStatement x) {
        this.endVisit((SQLCreateTableStatement)x);
    }

    @Override
    public void endVisit(OracleStorageClause x) {
    }

    @Override
    public void endVisit(OracleGotoStatement x) {
    }

    @Override
    public void endVisit(OracleLabelStatement x) {
    }

    @Override
    public void endVisit(OracleAlterTriggerStatement x) {
    }

    @Override
    public void endVisit(OracleAlterSynonymStatement x) {
    }

    @Override
    public void endVisit(OracleAlterViewStatement x) {
    }

    @Override
    public void endVisit(OracleAlterTableMoveTablespace x) {
    }

    @Override
    public void endVisit(OracleFileSpecification x) {
    }

    @Override
    public void endVisit(OracleAlterTablespaceAddDataFile x) {
    }

    @Override
    public void endVisit(OracleAlterTablespaceStatement x) {
    }

    @Override
    public void endVisit(OracleExitStatement x) {
    }

    @Override
    public void endVisit(OracleContinueStatement x) {
    }

    @Override
    public void endVisit(OracleRaiseStatement x) {
    }

    @Override
    public void endVisit(OracleCreateDatabaseDbLinkStatement x) {
    }

    @Override
    public void endVisit(OracleDropDbLinkStatement x) {
    }

    @Override
    public void endVisit(OracleDataTypeIntervalYear x) {
    }

    @Override
    public void endVisit(OracleDataTypeIntervalDay x) {
    }

    @Override
    public void endVisit(OracleUsingIndexClause x) {
    }

    @Override
    public void endVisit(OracleLobStorageClause x) {
    }

    @Override
    public boolean visit(OracleUnique x) {
        return this.visit((SQLUnique)x);
    }

    @Override
    public void endVisit(OracleUnique x) {
        this.endVisit((SQLUnique)x);
    }

    @Override
    public boolean visit(OracleForeignKey x) {
        return this.visit((SQLForeignKeyImpl)x);
    }

    @Override
    public void endVisit(OracleForeignKey x) {
        this.endVisit((SQLForeignKeyImpl)x);
    }

    @Override
    public boolean visit(OracleCheck x) {
        return this.visit((SQLCheck)x);
    }

    @Override
    public void endVisit(OracleCheck x) {
        this.endVisit((SQLCheck)x);
    }

    @Override
    public boolean visit(OracleSupplementalIdKey x) {
        return true;
    }

    @Override
    public void endVisit(OracleSupplementalIdKey x) {
    }

    @Override
    public boolean visit(OracleSupplementalLogGrp x) {
        return true;
    }

    @Override
    public void endVisit(OracleSupplementalLogGrp x) {
    }

    @Override
    public void endVisit(OracleCreateTableStatement.Organization x) {
    }

    @Override
    public void endVisit(OracleCreateTableStatement.OIDIndex x) {
    }

    @Override
    public void endVisit(OracleCreatePackageStatement x) {
    }

    @Override
    public void endVisit(OracleExecuteImmediateStatement x) {
    }

    @Override
    public boolean visit(OracleTreatExpr x) {
        return true;
    }

    @Override
    public void endVisit(OracleTreatExpr x) {
    }

    @Override
    public void endVisit(OracleCreateSynonymStatement x) {
    }

    @Override
    public void endVisit(OracleCreateTypeStatement x) {
    }

    @Override
    public void endVisit(OraclePipeRowStatement x) {
    }

    @Override
    public void endVisit(OracleIsOfTypeExpr x) {
    }

    @Override
    public boolean visit(OracleRunStatement x) {
        return true;
    }

    @Override
    public void endVisit(OracleRunStatement x) {
    }

    @Override
    public void endVisit(OracleXmlColumnProperties x) {
    }

    @Override
    public void endVisit(OracleXmlColumnProperties.OracleXMLTypeStorage x) {
    }

    @Override
    public boolean visit(OracleXmlContentExpr x) {
        return true;
    }

    @Override
    public void endVisit(OracleXmlContentExpr x) {
    }

    @Override
    public boolean visit(OracleMethodInvokeAccessExpr x) {
        return true;
    }

    @Override
    public void endVisit(OracleMethodInvokeAccessExpr x) {
    }

    @Override
    public boolean visit(OracleMultisetExpr x) {
        return true;
    }

    @Override
    public void endVisit(OracleMultisetExpr x) {
    }

    @Override
    public boolean visit(OracleJsonObjectExpr x) {
        return true;
    }

    @Override
    public void endVisit(OracleJsonObjectExpr x) {
    }

    @Override
    public boolean visit(OracleJsonObjectExpr.OracleJsonObjectExprItem x) {
        return true;
    }

    @Override
    public void endVisit(OracleJsonObjectExpr.OracleJsonObjectExprItem x) {
    }

    @Override
    public boolean visit(OracleJsonObjectExpr.OracleJsonObjectOnNullClause x) {
        return true;
    }

    @Override
    public void endVisit(OracleJsonObjectExpr.OracleJsonObjectOnNullClause x) {
    }

    @Override
    public boolean visit(OracleJsonObjectExpr.OracleJsonObjectReturnClause x) {
        return true;
    }

    @Override
    public void endVisit(OracleJsonObjectExpr.OracleJsonObjectReturnClause x) {
    }

    @Override
    public boolean visit(OracleJsonArrayAggExpr x) {
        return true;
    }

    @Override
    public void endVisit(OracleJsonArrayAggExpr x) {
    }

    @Override
    public boolean visit(OracleJsonArrayAggExpr.OracleJsonAggArrayOnNullClause x) {
        return true;
    }

    @Override
    public void endVisit(OracleJsonArrayAggExpr.OracleJsonAggArrayOnNullClause x) {
    }

    @Override
    public boolean visit(OracleJsonArrayAggExpr.OracleJsonAggArrayReturnClause x) {
        return true;
    }

    @Override
    public void endVisit(OracleJsonArrayAggExpr.OracleJsonAggArrayReturnClause x) {
    }
}

