/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.spark.ast.expr;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkSelectPivotBase;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkSelectTableSource;
import com.alibaba.druid.sql.dialect.spark.visitor.SparkVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.util.List;

public class SparkSQLSubqueryTableSource
extends SQLSubqueryTableSource
implements SparkSelectTableSource {
    protected SparkSelectPivotBase pivot;

    public SparkSQLSubqueryTableSource() {
    }

    public SparkSQLSubqueryTableSource(String alias) {
        super(alias);
    }

    public SparkSQLSubqueryTableSource(SQLSelect select, String alias) {
        super(alias);
        this.setSelect(select);
    }

    public SparkSQLSubqueryTableSource(SQLSelect select) {
        this.setSelect(select);
    }

    public SparkSQLSubqueryTableSource(SQLSelectQuery query) {
        this(new SQLSelect(query));
    }

    public SparkSQLSubqueryTableSource(SQLSelectQuery query, String alias) {
        this(new SQLSelect(query), alias);
    }

    @Override
    public SQLSelect getSelect() {
        return this.select;
    }

    @Override
    public void setSelect(SQLSelect x) {
        if (x != null) {
            x.setParent(this);
        }
        this.select = x;
    }

    public void cloneTo(SparkSQLSubqueryTableSource x) {
        x.alias = this.alias;
        if (this.select != null) {
            x.select = this.select.clone();
            x.select.setParent(x);
        }
        for (SQLName column : this.columns) {
            SQLName c2 = column.clone();
            c2.setParent(x);
            x.columns.add(c2);
        }
        if (this.pivot != null) {
            x.pivot = this.pivot.clone();
        }
    }

    @Override
    public SparkSQLSubqueryTableSource clone() {
        SparkSQLSubqueryTableSource x = new SparkSQLSubqueryTableSource();
        this.cloneTo(x);
        return x;
    }

    @Override
    public SQLTableSource findTableSourceWithColumn(String columnName) {
        if (this.select == null) {
            return null;
        }
        SQLSelectQueryBlock queryBlock = this.select.getFirstQueryBlock();
        if (queryBlock == null) {
            return null;
        }
        return queryBlock.findSelectItem(columnName) != null ? this : null;
    }

    @Override
    public SQLTableSource findTableSourceWithColumn(long columnNameHash, String columnName, int option) {
        if (this.select == null) {
            return null;
        }
        SQLSelectQueryBlock queryBlock = this.select.getFirstQueryBlock();
        if (queryBlock == null) {
            return null;
        }
        return queryBlock.findSelectItem(columnNameHash) != null ? this : null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            boolean eq;
            SparkSQLSubqueryTableSource that = (SparkSQLSubqueryTableSource)o;
            if (this.pivot == null && that.pivot != null) {
                return false;
            }
            if (this.pivot != null && that.pivot == null) {
                return false;
            }
            boolean bl = this.select != null ? this.select.equals(that.select) : (eq = that.select == null);
            if (this.pivot != null) {
                eq = eq && this.pivot.equals(that.pivot);
            }
            return eq;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = this.select != null ? this.select.hashCode() : 0;
        return hash += this.pivot != null ? this.pivot.hashCode() : 0;
    }

    @Override
    public List<SQLName> getColumns() {
        return this.columns;
    }

    @Override
    public void addColumn(SQLName column) {
        column.setParent(this);
        this.columns.add(column);
    }

    @Override
    public SQLColumnDefinition findColumn(long columnNameHash) {
        SQLSelectQueryBlock queryBlock = this.select.getFirstQueryBlock();
        if (queryBlock != null) {
            return queryBlock.findColumn(columnNameHash);
        }
        if (this.select.getQuery() instanceof SQLUnionQuery && ((SQLUnionQuery)this.select.getQuery()).getFirstQueryBlock() instanceof SQLSelectQueryBlock) {
            SQLSelectQueryBlock left = ((SQLUnionQuery)this.select.getQuery()).getFirstQueryBlock();
            return left.findColumn(columnNameHash);
        }
        return null;
    }

    @Override
    public SparkSelectPivotBase getPivot() {
        return this.pivot;
    }

    @Override
    public void setPivot(SparkSelectPivotBase pivot) {
        this.pivot = pivot;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        this.accept0((SparkVisitor)visitor);
    }

    @Override
    public void accept0(SparkVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.select);
            this.acceptChild((SQLASTVisitor)visitor, this.pivot);
        }
        visitor.endVisit(this);
    }
}

