/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.spark.ast.expr;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkSelectPivotBase;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkSelectTableReference;
import com.alibaba.druid.sql.dialect.spark.ast.expr.SparkSelectTableSource;
import com.alibaba.druid.sql.dialect.spark.visitor.SparkVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;

public class SparkSelectJoinTableSource
extends SQLJoinTableSource
implements SparkSelectTableSource {
    protected SparkSelectPivotBase pivot;

    public SparkSelectJoinTableSource(String alias) {
        super(alias);
    }

    public SparkSelectJoinTableSource() {
    }

    public SparkSelectJoinTableSource(SQLTableSource left, SQLJoinTableSource.JoinType joinType, SQLTableSource right, SQLExpr condition) {
        super(left, joinType, right, condition);
    }

    @Override
    public SparkSelectPivotBase getPivot() {
        return this.pivot;
    }

    @Override
    public void setPivot(SparkSelectPivotBase pivot) {
        this.pivot = pivot;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor instanceof SparkVisitor) {
            this.accept0((SparkVisitor)visitor);
        } else {
            super.accept0(visitor);
        }
    }

    @Override
    public void accept0(SparkVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.left);
            this.acceptChild((SQLASTVisitor)visitor, this.right);
            this.acceptChild((SQLASTVisitor)visitor, this.condition);
            this.acceptChild((SQLASTVisitor)visitor, this.using);
            this.acceptChild((SQLASTVisitor)visitor, this.flashback);
        }
        visitor.endVisit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            if (!super.equals(o)) {
                return false;
            }
            SparkSelectJoinTableSource that = (SparkSelectJoinTableSource)o;
            if (this.pivot != null ? !this.pivot.equals(that.pivot) : that.pivot != null) {
                return false;
            }
            return this.flashback != null ? this.flashback.equals(that.flashback) : that.flashback == null;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = this.pivot != null ? this.pivot.hashCode() : 0;
        result = 31 * result + (this.flashback != null ? this.flashback.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return SQLUtils.toSparkString(this);
    }

    @Override
    public SQLJoinTableSource clone() {
        SparkSelectJoinTableSource x = new SparkSelectJoinTableSource();
        this.cloneTo(x);
        if (this.pivot != null) {
            x.setPivot(this.pivot.clone());
        }
        if (this.flashback != null) {
            x.setFlashback(this.flashback.clone());
        }
        return x;
    }

    public void setLeft(String tableName) {
        SparkSelectTableReference tableSource = tableName != null && tableName.length() != 0 ? new SparkSelectTableReference(new SQLIdentifierExpr(tableName)) : null;
        this.setLeft(tableSource);
    }

    public void setRight(String tableName) {
        SparkSelectTableReference tableSource = tableName != null && tableName.length() != 0 ? new SparkSelectTableReference(new SQLIdentifierExpr(tableName)) : null;
        this.setRight(tableSource);
    }

    @Override
    public SQLJoinTableSource join(SQLTableSource right, SQLJoinTableSource.JoinType joinType, SQLExpr condition) {
        SparkSelectJoinTableSource joined = new SparkSelectJoinTableSource(this, joinType, right, condition);
        return joined;
    }
}

