/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.sqlserver.ast.expr;

import com.alibaba.druid.FastsqlException;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.expr.SQLCurrentOfCursorExpr;
import com.alibaba.druid.sql.dialect.sqlserver.ast.SQLServerObject;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import java.io.IOException;
import util.sqlparse.visitor.common.Objects;

public class SQLServerCurrentOfCursorExpr
extends SQLCurrentOfCursorExpr
implements SQLServerObject {
    private boolean isGlobal = false;

    public SQLServerCurrentOfCursorExpr(SQLName cursorName) {
        super(cursorName);
    }

    public SQLServerCurrentOfCursorExpr() {
    }

    @Override
    public void accept0(SQLServerASTVisitor visitor) {
        if (visitor.visit(this)) {
            this.acceptChild((SQLASTVisitor)visitor, this.getCursorName());
        }
        visitor.endVisit(this);
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        this.accept0((SQLServerASTVisitor)visitor);
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean global) {
        this.isGlobal = global;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            if (!super.equals(o)) {
                return false;
            }
            SQLServerCurrentOfCursorExpr that = (SQLServerCurrentOfCursorExpr)o;
            return this.isGlobal == that.isGlobal;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isGlobal);
    }

    @Override
    public void output(Appendable buf) {
        try {
            buf.append("CURRENT OF ");
            if (this.isGlobal()) {
                buf.append("GLOBAL ");
            }
            this.getCursorName().output(buf);
        }
        catch (IOException ex) {
            throw new FastsqlException("output error", ex);
        }
    }

    @Override
    public SQLServerCurrentOfCursorExpr clone() {
        SQLServerCurrentOfCursorExpr x = new SQLServerCurrentOfCursorExpr();
        if (this.getCursorName() != null) {
            x.setCursorName(this.getCursorName().clone());
        }
        x.setGlobal(this.isGlobal());
        return x;
    }
}

