/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.stat;

import com.alibaba.druid.proxy.jdbc.StatementExecuteType;
import com.alibaba.druid.stat.JdbcSqlStatMBean;
import com.alibaba.druid.stat.JdbcSqlStatValue;
import com.alibaba.druid.stat.JdbcStatContext;
import com.alibaba.druid.stat.JdbcStatManager;
import com.alibaba.druid.util.JMXUtils;
import com.alibaba.druid.util.JdbcSqlStatUtils;
import com.alibaba.druid.util.Utils;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import javax.management.JMException;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public final class JdbcSqlStat
implements JdbcSqlStatMBean,
Comparable<JdbcSqlStat> {
    private final String sql;
    private long sqlHash;
    private long id;
    private String dataSource;
    private long executeLastStartTime;
    private volatile long executeBatchSizeTotal;
    private volatile int executeBatchSizeMax;
    private volatile long executeSuccessCount;
    private volatile long executeSpanNanoTotal;
    private volatile long executeSpanNanoMax;
    private volatile int runningCount;
    private volatile int concurrentMax;
    private volatile long resultSetHoldTimeNano;
    private volatile long executeAndResultSetHoldTime;
    static final AtomicLongFieldUpdater<JdbcSqlStat> executeBatchSizeTotalUpdater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "executeBatchSizeTotal");
    static final AtomicIntegerFieldUpdater<JdbcSqlStat> executeBatchSizeMaxUpdater = AtomicIntegerFieldUpdater.newUpdater(JdbcSqlStat.class, "executeBatchSizeMax");
    static final AtomicLongFieldUpdater<JdbcSqlStat> executeSuccessCountUpdater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "executeSuccessCount");
    static final AtomicLongFieldUpdater<JdbcSqlStat> executeSpanNanoTotalUpdater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "executeSpanNanoTotal");
    static final AtomicLongFieldUpdater<JdbcSqlStat> executeSpanNanoMaxUpdater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "executeSpanNanoMax");
    static final AtomicIntegerFieldUpdater<JdbcSqlStat> runningCountUpdater = AtomicIntegerFieldUpdater.newUpdater(JdbcSqlStat.class, "runningCount");
    static final AtomicIntegerFieldUpdater<JdbcSqlStat> concurrentMaxUpdater = AtomicIntegerFieldUpdater.newUpdater(JdbcSqlStat.class, "concurrentMax");
    static final AtomicLongFieldUpdater<JdbcSqlStat> resultSetHoldTimeNanoUpdater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "resultSetHoldTimeNano");
    static final AtomicLongFieldUpdater<JdbcSqlStat> executeAndResultSetHoldTimeUpdater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "executeAndResultSetHoldTime");
    private String name;
    private String file;
    private String dbType;
    private volatile long executeNanoSpanMaxOccurTime;
    private volatile long executeErrorCount;
    private volatile Throwable executeErrorLast;
    private volatile long executeErrorLastTime;
    private volatile long updateCount;
    private volatile long updateCountMax;
    private volatile long fetchRowCount;
    private volatile long fetchRowCountMax;
    private volatile long inTransactionCount;
    private volatile String lastSlowParameters;
    private boolean removed = false;
    private volatile long clobOpenCount;
    private volatile long blobOpenCount;
    private volatile long readStringLength;
    private volatile long readBytesLength;
    private volatile long inputStreamOpenCount;
    private volatile long readerOpenCount;
    static final AtomicLongFieldUpdater<JdbcSqlStat> executeErrorCountUpdater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "executeErrorCount");
    static final AtomicLongFieldUpdater<JdbcSqlStat> updateCountUpdater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "updateCount");
    static final AtomicLongFieldUpdater<JdbcSqlStat> updateCountMaxUpdater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "updateCountMax");
    static final AtomicLongFieldUpdater<JdbcSqlStat> fetchRowCountUpdater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "fetchRowCount");
    static final AtomicLongFieldUpdater<JdbcSqlStat> fetchRowCountMaxUpdater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "fetchRowCountMax");
    static final AtomicLongFieldUpdater<JdbcSqlStat> inTransactionCountUpdater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "inTransactionCount");
    static final AtomicLongFieldUpdater<JdbcSqlStat> clobOpenCountUpdater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "clobOpenCount");
    static final AtomicLongFieldUpdater<JdbcSqlStat> blobOpenCountUpdater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "blobOpenCount");
    static final AtomicLongFieldUpdater<JdbcSqlStat> readStringLengthUpdater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "readStringLength");
    static final AtomicLongFieldUpdater<JdbcSqlStat> readBytesLengthUpdater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "readBytesLength");
    static final AtomicLongFieldUpdater<JdbcSqlStat> inputStreamOpenCountUpdater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "inputStreamOpenCount");
    static final AtomicLongFieldUpdater<JdbcSqlStat> readerOpenCountUpdater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "readerOpenCount");
    private volatile long histogram_0_1;
    private volatile long histogram_1_10;
    private volatile int histogram_10_100;
    private volatile int histogram_100_1000;
    private volatile int histogram_1000_10000;
    private volatile int histogram_10000_100000;
    private volatile int histogram_100000_1000000;
    private volatile int histogram_1000000_more;
    static final AtomicLongFieldUpdater<JdbcSqlStat> histogram_0_1_Updater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "histogram_0_1");
    static final AtomicLongFieldUpdater<JdbcSqlStat> histogram_1_10_Updater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "histogram_1_10");
    static final AtomicIntegerFieldUpdater<JdbcSqlStat> histogram_10_100_Updater = AtomicIntegerFieldUpdater.newUpdater(JdbcSqlStat.class, "histogram_10_100");
    static final AtomicIntegerFieldUpdater<JdbcSqlStat> histogram_100_1000_Updater = AtomicIntegerFieldUpdater.newUpdater(JdbcSqlStat.class, "histogram_100_1000");
    static final AtomicIntegerFieldUpdater<JdbcSqlStat> histogram_1000_10000_Updater = AtomicIntegerFieldUpdater.newUpdater(JdbcSqlStat.class, "histogram_1000_10000");
    static final AtomicIntegerFieldUpdater<JdbcSqlStat> histogram_10000_100000_Updater = AtomicIntegerFieldUpdater.newUpdater(JdbcSqlStat.class, "histogram_10000_100000");
    static final AtomicIntegerFieldUpdater<JdbcSqlStat> histogram_100000_1000000_Updater = AtomicIntegerFieldUpdater.newUpdater(JdbcSqlStat.class, "histogram_100000_1000000");
    static final AtomicIntegerFieldUpdater<JdbcSqlStat> histogram_1000000_more_Updater = AtomicIntegerFieldUpdater.newUpdater(JdbcSqlStat.class, "histogram_1000000_more");
    private volatile long executeAndResultHoldTime_0_1;
    private volatile long executeAndResultHoldTime_1_10;
    private volatile int executeAndResultHoldTime_10_100;
    private volatile int executeAndResultHoldTime_100_1000;
    private volatile int executeAndResultHoldTime_1000_10000;
    private volatile int executeAndResultHoldTime_10000_100000;
    private volatile int executeAndResultHoldTime_100000_1000000;
    private volatile int executeAndResultHoldTime_1000000_more;
    static final AtomicLongFieldUpdater<JdbcSqlStat> executeAndResultHoldTime_0_1_Updater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "executeAndResultHoldTime_0_1");
    static final AtomicLongFieldUpdater<JdbcSqlStat> executeAndResultHoldTime_1_10_Updater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "executeAndResultHoldTime_1_10");
    static final AtomicIntegerFieldUpdater<JdbcSqlStat> executeAndResultHoldTime_10_100_Updater = AtomicIntegerFieldUpdater.newUpdater(JdbcSqlStat.class, "executeAndResultHoldTime_10_100");
    static final AtomicIntegerFieldUpdater<JdbcSqlStat> executeAndResultHoldTime_100_1000_Updater = AtomicIntegerFieldUpdater.newUpdater(JdbcSqlStat.class, "executeAndResultHoldTime_100_1000");
    static final AtomicIntegerFieldUpdater<JdbcSqlStat> executeAndResultHoldTime_1000_10000_Updater = AtomicIntegerFieldUpdater.newUpdater(JdbcSqlStat.class, "executeAndResultHoldTime_1000_10000");
    static final AtomicIntegerFieldUpdater<JdbcSqlStat> executeAndResultHoldTime_10000_100000_Updater = AtomicIntegerFieldUpdater.newUpdater(JdbcSqlStat.class, "executeAndResultHoldTime_10000_100000");
    static final AtomicIntegerFieldUpdater<JdbcSqlStat> executeAndResultHoldTime_100000_1000000_Updater = AtomicIntegerFieldUpdater.newUpdater(JdbcSqlStat.class, "executeAndResultHoldTime_100000_1000000");
    static final AtomicIntegerFieldUpdater<JdbcSqlStat> executeAndResultHoldTime_1000000_more_Updater = AtomicIntegerFieldUpdater.newUpdater(JdbcSqlStat.class, "executeAndResultHoldTime_1000000_more");
    private volatile long fetchRowCount_0_1;
    private volatile long fetchRowCount_1_10;
    private volatile long fetchRowCount_10_100;
    private volatile int fetchRowCount_100_1000;
    private volatile int fetchRowCount_1000_10000;
    private volatile int fetchRowCount_10000_more;
    static final AtomicLongFieldUpdater<JdbcSqlStat> fetchRowCount_0_1_Updater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "fetchRowCount_0_1");
    static final AtomicLongFieldUpdater<JdbcSqlStat> fetchRowCount_1_10_Updater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "fetchRowCount_1_10");
    static final AtomicLongFieldUpdater<JdbcSqlStat> fetchRowCount_10_100_Updater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "fetchRowCount_10_100");
    static final AtomicIntegerFieldUpdater<JdbcSqlStat> fetchRowCount_100_1000_Updater = AtomicIntegerFieldUpdater.newUpdater(JdbcSqlStat.class, "fetchRowCount_100_1000");
    static final AtomicIntegerFieldUpdater<JdbcSqlStat> fetchRowCount_1000_10000_Updater = AtomicIntegerFieldUpdater.newUpdater(JdbcSqlStat.class, "fetchRowCount_1000_10000");
    static final AtomicIntegerFieldUpdater<JdbcSqlStat> fetchRowCount_10000_more_Updater = AtomicIntegerFieldUpdater.newUpdater(JdbcSqlStat.class, "fetchRowCount_10000_more");
    private volatile long updateCount_0_1;
    private volatile long updateCount_1_10;
    private volatile long updateCount_10_100;
    private volatile int updateCount_100_1000;
    private volatile int updateCount_1000_10000;
    private volatile int updateCount_10000_more;
    static final AtomicLongFieldUpdater<JdbcSqlStat> updateCount_0_1_Updater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "updateCount_0_1");
    static final AtomicLongFieldUpdater<JdbcSqlStat> updateCount_1_10_Updater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "updateCount_1_10");
    static final AtomicLongFieldUpdater<JdbcSqlStat> updateCount_10_100_Updater = AtomicLongFieldUpdater.newUpdater(JdbcSqlStat.class, "updateCount_10_100");
    static final AtomicIntegerFieldUpdater<JdbcSqlStat> updateCount_100_1000_Updater = AtomicIntegerFieldUpdater.newUpdater(JdbcSqlStat.class, "updateCount_100_1000");
    static final AtomicIntegerFieldUpdater<JdbcSqlStat> updateCount_1000_10000_Updater = AtomicIntegerFieldUpdater.newUpdater(JdbcSqlStat.class, "updateCount_1000_10000");
    static final AtomicIntegerFieldUpdater<JdbcSqlStat> updateCount_10000_more_Updater = AtomicIntegerFieldUpdater.newUpdater(JdbcSqlStat.class, "updateCount_10000_more");
    private static CompositeType COMPOSITE_TYPE = null;

    public JdbcSqlStat(String sql) {
        this.sql = sql;
    }

    public String getLastSlowParameters() {
        return this.lastSlowParameters;
    }

    public void setLastSlowParameters(String lastSlowParameters) {
        this.lastSlowParameters = lastSlowParameters;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public static final String getContextSqlName() {
        JdbcStatContext context = JdbcStatManager.getInstance().getStatContext();
        return context == null ? null : context.getName();
    }

    public static final void setContextSqlName(String val) {
        JdbcStatContext context = JdbcStatManager.getInstance().getStatContext();
        if (context == null) {
            context = JdbcStatManager.getInstance().createStatContext();
            JdbcStatManager.getInstance().setStatContext(context);
        }
        context.setName(val);
    }

    public static final String getContextSqlFile() {
        JdbcStatContext context = JdbcStatManager.getInstance().getStatContext();
        return context == null ? null : context.getFile();
    }

    public static final void setContextSqlFile(String val) {
        JdbcStatContext context = JdbcStatManager.getInstance().getStatContext();
        if (context == null) {
            context = JdbcStatManager.getInstance().createStatContext();
            JdbcStatManager.getInstance().setStatContext(context);
        }
        context.setFile(val);
    }

    public static final void setContextSql(String val) {
        JdbcStatContext context = JdbcStatManager.getInstance().getStatContext();
        if (context == null) {
            context = JdbcStatManager.getInstance().createStatContext();
            JdbcStatManager.getInstance().setStatContext(context);
        }
        context.setSql(val);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    @Override
    public void reset() {
        this.executeLastStartTime = 0L;
        executeBatchSizeTotalUpdater.set(this, 0L);
        executeBatchSizeMaxUpdater.set(this, 0);
        executeSuccessCountUpdater.set(this, 0L);
        executeSpanNanoTotalUpdater.set(this, 0L);
        executeSpanNanoMaxUpdater.set(this, 0L);
        this.executeNanoSpanMaxOccurTime = 0L;
        concurrentMaxUpdater.set(this, 0);
        executeErrorCountUpdater.set(this, 0L);
        this.executeErrorLast = null;
        this.executeErrorLastTime = 0L;
        updateCountUpdater.set(this, 0L);
        updateCountMaxUpdater.set(this, 0L);
        fetchRowCountUpdater.set(this, 0L);
        fetchRowCountMaxUpdater.set(this, 0L);
        histogram_0_1_Updater.set(this, 0L);
        histogram_1_10_Updater.set(this, 0L);
        histogram_10_100_Updater.set(this, 0);
        histogram_100_1000_Updater.set(this, 0);
        histogram_1000_10000_Updater.set(this, 0);
        histogram_10000_100000_Updater.set(this, 0);
        histogram_100000_1000000_Updater.set(this, 0);
        histogram_1000000_more_Updater.set(this, 0);
        this.lastSlowParameters = null;
        inTransactionCountUpdater.set(this, 0L);
        resultSetHoldTimeNanoUpdater.set(this, 0L);
        executeAndResultSetHoldTimeUpdater.set(this, 0L);
        fetchRowCount_0_1_Updater.set(this, 0L);
        fetchRowCount_1_10_Updater.set(this, 0L);
        fetchRowCount_10_100_Updater.set(this, 0L);
        fetchRowCount_100_1000_Updater.set(this, 0);
        fetchRowCount_1000_10000_Updater.set(this, 0);
        fetchRowCount_10000_more_Updater.set(this, 0);
        updateCount_0_1_Updater.set(this, 0L);
        updateCount_1_10_Updater.set(this, 0L);
        updateCount_10_100_Updater.set(this, 0L);
        updateCount_100_1000_Updater.set(this, 0);
        updateCount_1000_10000_Updater.set(this, 0);
        updateCount_10000_more_Updater.set(this, 0);
        executeAndResultHoldTime_0_1_Updater.set(this, 0L);
        executeAndResultHoldTime_1_10_Updater.set(this, 0L);
        executeAndResultHoldTime_10_100_Updater.set(this, 0);
        executeAndResultHoldTime_100_1000_Updater.set(this, 0);
        executeAndResultHoldTime_1000_10000_Updater.set(this, 0);
        executeAndResultHoldTime_10000_100000_Updater.set(this, 0);
        executeAndResultHoldTime_100000_1000000_Updater.set(this, 0);
        executeAndResultHoldTime_1000000_more_Updater.set(this, 0);
        blobOpenCountUpdater.set(this, 0L);
        clobOpenCountUpdater.set(this, 0L);
        readStringLengthUpdater.set(this, 0L);
        readBytesLengthUpdater.set(this, 0L);
        inputStreamOpenCountUpdater.set(this, 0L);
        readerOpenCountUpdater.set(this, 0L);
    }

    public JdbcSqlStatValue getValueAndReset() {
        return this.getValue(true);
    }

    public JdbcSqlStatValue getValue(boolean reset) {
        JdbcSqlStatValue val = new JdbcSqlStatValue();
        val.setDbType(this.dbType);
        val.setSql(this.sql);
        val.setSqlHash(this.getSqlHash());
        val.setId(this.id);
        val.setName(this.name);
        val.setFile(this.file);
        val.setExecuteLastStartTime(this.executeLastStartTime);
        if (reset) {
            this.executeLastStartTime = 0L;
        }
        val.setExecuteBatchSizeTotal(JdbcSqlStatUtils.get(this, executeBatchSizeTotalUpdater, reset));
        val.setExecuteBatchSizeMax(JdbcSqlStatUtils.get(this, executeBatchSizeMaxUpdater, reset));
        val.setExecuteSuccessCount(JdbcSqlStatUtils.get(this, executeSuccessCountUpdater, reset));
        val.setExecuteSpanNanoTotal(JdbcSqlStatUtils.get(this, executeSpanNanoTotalUpdater, reset));
        val.setExecuteSpanNanoMax(JdbcSqlStatUtils.get(this, executeSpanNanoMaxUpdater, reset));
        val.setExecuteNanoSpanMaxOccurTime(this.executeNanoSpanMaxOccurTime);
        if (reset) {
            this.executeNanoSpanMaxOccurTime = 0L;
        }
        val.setRunningCount(this.runningCount);
        val.setConcurrentMax(JdbcSqlStatUtils.get(this, concurrentMaxUpdater, reset));
        val.setExecuteErrorCount(JdbcSqlStatUtils.get(this, executeErrorCountUpdater, reset));
        val.setExecuteErrorLast(this.executeErrorLast);
        if (reset) {
            this.executeErrorLast = null;
        }
        val.setExecuteErrorLastTime(this.executeErrorLastTime);
        if (reset) {
            this.executeErrorLastTime = 0L;
        }
        val.setUpdateCount(JdbcSqlStatUtils.get(this, updateCountUpdater, reset));
        val.setUpdateCountMax(JdbcSqlStatUtils.get(this, updateCountMaxUpdater, reset));
        val.setFetchRowCount(JdbcSqlStatUtils.get(this, fetchRowCountUpdater, reset));
        val.setFetchRowCountMax(JdbcSqlStatUtils.get(this, fetchRowCountMaxUpdater, reset));
        val.histogram_0_1 = JdbcSqlStatUtils.get(this, histogram_0_1_Updater, reset);
        val.histogram_1_10 = JdbcSqlStatUtils.get(this, histogram_1_10_Updater, reset);
        val.histogram_10_100 = JdbcSqlStatUtils.get(this, histogram_10_100_Updater, reset);
        val.histogram_100_1000 = JdbcSqlStatUtils.get(this, histogram_100_1000_Updater, reset);
        val.histogram_1000_10000 = JdbcSqlStatUtils.get(this, histogram_1000_10000_Updater, reset);
        val.histogram_10000_100000 = JdbcSqlStatUtils.get(this, histogram_10000_100000_Updater, reset);
        val.histogram_100000_1000000 = JdbcSqlStatUtils.get(this, histogram_100000_1000000_Updater, reset);
        val.histogram_1000000_more = JdbcSqlStatUtils.get(this, histogram_1000000_more_Updater, reset);
        val.setLastSlowParameters(this.lastSlowParameters);
        if (reset) {
            this.lastSlowParameters = null;
        }
        val.setInTransactionCount(JdbcSqlStatUtils.get(this, inTransactionCountUpdater, reset));
        val.setResultSetHoldTimeNano(JdbcSqlStatUtils.get(this, resultSetHoldTimeNanoUpdater, reset));
        val.setExecuteAndResultSetHoldTime(JdbcSqlStatUtils.get(this, executeAndResultSetHoldTimeUpdater, reset));
        val.fetchRowCount_0_1 = JdbcSqlStatUtils.get(this, fetchRowCount_0_1_Updater, reset);
        val.fetchRowCount_1_10 = JdbcSqlStatUtils.get(this, fetchRowCount_1_10_Updater, reset);
        val.fetchRowCount_10_100 = JdbcSqlStatUtils.get(this, fetchRowCount_10_100_Updater, reset);
        val.fetchRowCount_100_1000 = JdbcSqlStatUtils.get(this, fetchRowCount_100_1000_Updater, reset);
        val.fetchRowCount_1000_10000 = JdbcSqlStatUtils.get(this, fetchRowCount_1000_10000_Updater, reset);
        val.fetchRowCount_10000_more = JdbcSqlStatUtils.get(this, fetchRowCount_10000_more_Updater, reset);
        val.updateCount_0_1 = JdbcSqlStatUtils.get(this, updateCount_0_1_Updater, reset);
        val.updateCount_1_10 = JdbcSqlStatUtils.get(this, updateCount_1_10_Updater, reset);
        val.updateCount_10_100 = JdbcSqlStatUtils.get(this, updateCount_10_100_Updater, reset);
        val.updateCount_100_1000 = JdbcSqlStatUtils.get(this, updateCount_100_1000_Updater, reset);
        val.updateCount_1000_10000 = JdbcSqlStatUtils.get(this, updateCount_1000_10000_Updater, reset);
        val.updateCount_10000_more = JdbcSqlStatUtils.get(this, updateCount_10000_more_Updater, reset);
        val.executeAndResultHoldTime_0_1 = JdbcSqlStatUtils.get(this, executeAndResultHoldTime_0_1_Updater, reset);
        val.executeAndResultHoldTime_1_10 = JdbcSqlStatUtils.get(this, executeAndResultHoldTime_1_10_Updater, reset);
        val.executeAndResultHoldTime_10_100 = JdbcSqlStatUtils.get(this, executeAndResultHoldTime_10_100_Updater, reset);
        val.executeAndResultHoldTime_100_1000 = JdbcSqlStatUtils.get(this, executeAndResultHoldTime_100_1000_Updater, reset);
        val.executeAndResultHoldTime_1000_10000 = JdbcSqlStatUtils.get(this, executeAndResultHoldTime_1000_10000_Updater, reset);
        val.executeAndResultHoldTime_10000_100000 = JdbcSqlStatUtils.get(this, executeAndResultHoldTime_10000_100000_Updater, reset);
        val.executeAndResultHoldTime_100000_1000000 = JdbcSqlStatUtils.get(this, executeAndResultHoldTime_100000_1000000_Updater, reset);
        val.executeAndResultHoldTime_1000000_more = JdbcSqlStatUtils.get(this, executeAndResultHoldTime_1000000_more_Updater, reset);
        val.setBlobOpenCount(JdbcSqlStatUtils.get(this, blobOpenCountUpdater, reset));
        val.setClobOpenCount(JdbcSqlStatUtils.get(this, clobOpenCountUpdater, reset));
        val.setReadStringLength(JdbcSqlStatUtils.get(this, readStringLengthUpdater, reset));
        val.setReadBytesLength(JdbcSqlStatUtils.get(this, readBytesLengthUpdater, reset));
        val.setInputStreamOpenCount(JdbcSqlStatUtils.get(this, inputStreamOpenCountUpdater, reset));
        val.setReaderOpenCount(JdbcSqlStatUtils.get(this, readerOpenCountUpdater, reset));
        return val;
    }

    @Override
    public long getConcurrentMax() {
        return this.concurrentMax;
    }

    @Override
    public long getRunningCount() {
        return this.runningCount;
    }

    public void addUpdateCount(int delta) {
        long max;
        if (delta > 0) {
            updateCountUpdater.addAndGet(this, delta);
        }
        while ((long)delta > (max = updateCountMaxUpdater.get(this)) && !updateCountMaxUpdater.compareAndSet(this, max, delta)) {
        }
        if (delta < 1) {
            updateCount_0_1_Updater.incrementAndGet(this);
        } else if (delta < 10) {
            updateCount_1_10_Updater.incrementAndGet(this);
        } else if (delta < 100) {
            updateCount_10_100_Updater.incrementAndGet(this);
        } else if (delta < 1000) {
            updateCount_100_1000_Updater.incrementAndGet(this);
        } else if (delta < 10000) {
            updateCount_1000_10000_Updater.incrementAndGet(this);
        } else {
            updateCount_10000_more_Updater.incrementAndGet(this);
        }
    }

    @Override
    public long getUpdateCount() {
        return this.updateCount;
    }

    public long getUpdateCountMax() {
        return this.updateCountMax;
    }

    @Override
    public long getFetchRowCount() {
        return this.fetchRowCount;
    }

    public long getFetchRowCountMax() {
        return this.fetchRowCountMax;
    }

    public long getClobOpenCount() {
        return this.clobOpenCount;
    }

    public void incrementClobOpenCount() {
        clobOpenCountUpdater.incrementAndGet(this);
    }

    public long getBlobOpenCount() {
        return this.blobOpenCount;
    }

    public void incrementBlobOpenCount() {
        blobOpenCountUpdater.incrementAndGet(this);
    }

    public long getReadStringLength() {
        return this.readStringLength;
    }

    public void addStringReadLength(long length) {
        readStringLengthUpdater.addAndGet(this, length);
    }

    public long getReadBytesLength() {
        return this.readBytesLength;
    }

    public void addReadBytesLength(long length) {
        readBytesLengthUpdater.addAndGet(this, length);
    }

    public long getReaderOpenCount() {
        return this.readerOpenCount;
    }

    public void addReaderOpenCount(int count) {
        readerOpenCountUpdater.addAndGet(this, count);
    }

    public long getInputStreamOpenCount() {
        return this.inputStreamOpenCount;
    }

    public void addInputStreamOpenCount(int count) {
        inputStreamOpenCountUpdater.addAndGet(this, count);
    }

    @Override
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    public long getSqlHash() {
        if (this.sqlHash == 0L) {
            this.sqlHash = Utils.fnv_64(this.sql);
        }
        return this.sqlHash;
    }

    @Override
    public Date getExecuteLastStartTime() {
        return this.executeLastStartTime <= 0L ? null : new Date(this.executeLastStartTime);
    }

    public void setExecuteLastStartTime(long executeLastStartTime) {
        this.executeLastStartTime = executeLastStartTime;
    }

    @Override
    public Date getExecuteNanoSpanMaxOccurTime() {
        return this.executeNanoSpanMaxOccurTime <= 0L ? null : new Date(this.executeNanoSpanMaxOccurTime);
    }

    @Override
    public Date getExecuteErrorLastTime() {
        return this.executeErrorLastTime <= 0L ? null : new Date(this.executeErrorLastTime);
    }

    public void addFetchRowCount(long delta) {
        long max;
        fetchRowCountUpdater.addAndGet(this, delta);
        while (delta > (max = fetchRowCountMaxUpdater.get(this)) && !fetchRowCountMaxUpdater.compareAndSet(this, max, delta)) {
        }
        if (delta < 1L) {
            fetchRowCount_0_1_Updater.incrementAndGet(this);
        } else if (delta < 10L) {
            fetchRowCount_1_10_Updater.incrementAndGet(this);
        } else if (delta < 100L) {
            fetchRowCount_10_100_Updater.incrementAndGet(this);
        } else if (delta < 1000L) {
            fetchRowCount_100_1000_Updater.incrementAndGet(this);
        } else if (delta < 10000L) {
            fetchRowCount_1000_10000_Updater.incrementAndGet(this);
        } else {
            fetchRowCount_10000_more_Updater.incrementAndGet(this);
        }
    }

    public void addExecuteBatchCount(long batchSize) {
        int current;
        executeBatchSizeTotalUpdater.addAndGet(this, batchSize);
        while ((long)(current = executeBatchSizeMaxUpdater.get(this)) < batchSize && !executeBatchSizeMaxUpdater.compareAndSet(this, current, (int)batchSize)) {
        }
    }

    @Override
    public long getExecuteBatchSizeTotal() {
        return this.executeBatchSizeTotal;
    }

    public void incrementExecuteSuccessCount() {
        executeSuccessCountUpdater.incrementAndGet(this);
    }

    public void incrementRunningCount() {
        int max;
        int val = runningCountUpdater.incrementAndGet(this);
        while (val > (max = concurrentMaxUpdater.get(this)) && !concurrentMaxUpdater.compareAndSet(this, max, val)) {
        }
    }

    public void decrementRunningCount() {
        runningCountUpdater.decrementAndGet(this);
    }

    public void decrementExecutingCount() {
        runningCountUpdater.decrementAndGet(this);
    }

    @Override
    public long getExecuteSuccessCount() {
        return this.executeSuccessCount;
    }

    public void addExecuteTime(StatementExecuteType executeType, boolean firstResultSet, long nanoSpan) {
        this.addExecuteTime(nanoSpan);
        if (StatementExecuteType.ExecuteQuery != executeType && !firstResultSet) {
            this.executeAndResultHoldTimeHistogramRecord(nanoSpan);
        }
    }

    private void executeAndResultHoldTimeHistogramRecord(long nanoSpan) {
        long millis = nanoSpan / 1000L / 1000L;
        if (millis < 1L) {
            executeAndResultHoldTime_0_1_Updater.incrementAndGet(this);
        } else if (millis < 10L) {
            executeAndResultHoldTime_1_10_Updater.incrementAndGet(this);
        } else if (millis < 100L) {
            executeAndResultHoldTime_10_100_Updater.incrementAndGet(this);
        } else if (millis < 1000L) {
            executeAndResultHoldTime_100_1000_Updater.incrementAndGet(this);
        } else if (millis < 10000L) {
            executeAndResultHoldTime_1000_10000_Updater.incrementAndGet(this);
        } else if (millis < 100000L) {
            executeAndResultHoldTime_10000_100000_Updater.incrementAndGet(this);
        } else if (millis < 1000000L) {
            executeAndResultHoldTime_100000_1000000_Updater.incrementAndGet(this);
        } else {
            executeAndResultHoldTime_1000000_more_Updater.incrementAndGet(this);
        }
    }

    private void histogramRecord(long nanoSpan) {
        long millis = nanoSpan / 1000L / 1000L;
        if (millis < 1L) {
            histogram_0_1_Updater.incrementAndGet(this);
        } else if (millis < 10L) {
            histogram_1_10_Updater.incrementAndGet(this);
        } else if (millis < 100L) {
            histogram_10_100_Updater.incrementAndGet(this);
        } else if (millis < 1000L) {
            histogram_100_1000_Updater.incrementAndGet(this);
        } else if (millis < 10000L) {
            histogram_1000_10000_Updater.incrementAndGet(this);
        } else if (millis < 100000L) {
            histogram_10000_100000_Updater.incrementAndGet(this);
        } else if (millis < 1000000L) {
            histogram_100000_1000000_Updater.incrementAndGet(this);
        } else {
            histogram_1000000_more_Updater.incrementAndGet(this);
        }
    }

    public void addExecuteTime(long nanoSpan) {
        long current;
        executeSpanNanoTotalUpdater.addAndGet(this, nanoSpan);
        while ((current = executeSpanNanoMaxUpdater.get(this)) < nanoSpan) {
            if (!executeSpanNanoMaxUpdater.compareAndSet(this, current, nanoSpan)) continue;
            this.executeNanoSpanMaxOccurTime = System.currentTimeMillis();
            break;
        }
        this.histogramRecord(nanoSpan);
    }

    @Override
    public long getExecuteMillisTotal() {
        return this.executeSpanNanoTotal / 1000000L;
    }

    @Override
    public long getExecuteMillisMax() {
        return this.executeSpanNanoMax / 1000000L;
    }

    @Override
    public long getErrorCount() {
        return this.executeErrorCount;
    }

    @Override
    public long getExecuteBatchSizeMax() {
        return this.executeBatchSizeMax;
    }

    public long getInTransactionCount() {
        return this.inTransactionCount;
    }

    public void incrementInTransactionCount() {
        inTransactionCountUpdater.incrementAndGet(this);
    }

    public static CompositeType getCompositeType() throws JMException {
        if (COMPOSITE_TYPE != null) {
            return COMPOSITE_TYPE;
        }
        OpenType[] indexTypes = new OpenType[]{SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.DATE, SimpleType.LONG, JMXUtils.getThrowableCompositeType(), SimpleType.LONG, SimpleType.LONG, SimpleType.DATE, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.DATE, SimpleType.STRING, SimpleType.LONG, SimpleType.STRING, new ArrayType(SimpleType.LONG, true), SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, new ArrayType(SimpleType.LONG, true), new ArrayType(SimpleType.LONG, true), new ArrayType(SimpleType.LONG, true), SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG};
        String[] indexNames = new String[]{"ID", "DataSource", "SQL", "ExecuteCount", "ErrorCount", "TotalTime", "LastTime", "MaxTimespan", "LastError", "EffectedRowCount", "FetchRowCount", "MaxTimespanOccurTime", "BatchSizeMax", "BatchSizeTotal", "ConcurrentMax", "RunningCount", "Name", "File", "LastErrorMessage", "LastErrorClass", "LastErrorStackTrace", "LastErrorTime", "DbType", "InTransactionCount", "URL", "Histogram", "LastSlowParameters", "ResultSetHoldTime", "ExecuteAndResultSetHoldTime", "FetchRowCountHistogram", "EffectedRowCountHistogram", "ExecuteAndResultHoldTimeHistogram", "EffectedRowCountMax", "FetchRowCountMax", "ClobOpenCount", "BlobOpenCount", "ReadStringLength", "ReadBytesLength", "InputStreamOpenCount", "ReaderOpenCount", "HASH"};
        COMPOSITE_TYPE = new CompositeType("SqlStatistic", "Sql Statistic", indexNames, indexNames, indexTypes);
        return COMPOSITE_TYPE;
    }

    @Override
    public long getExecuteCount() {
        return this.getErrorCount() + this.getExecuteSuccessCount();
    }

    public Map<String, Object> getData() throws JMException {
        return this.getValue(false).getData();
    }

    public long[] getHistogramValues() {
        return new long[]{this.histogram_0_1, this.histogram_1_10, this.histogram_10_100, this.histogram_100_1000, this.histogram_1000_10000, this.histogram_10000_100000, this.histogram_100000_1000000, this.histogram_1000000_more};
    }

    public long getHistogramSum() {
        long[] values = this.getHistogramValues();
        long sum = 0L;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        return sum;
    }

    public CompositeDataSupport getCompositeData() throws JMException {
        return new CompositeDataSupport(JdbcSqlStat.getCompositeType(), this.getData());
    }

    public Throwable getExecuteErrorLast() {
        return this.executeErrorLast;
    }

    public void error(Throwable error) {
        executeErrorCountUpdater.incrementAndGet(this);
        this.executeErrorLastTime = System.currentTimeMillis();
        this.executeErrorLast = error;
    }

    public long getResultSetHoldTimeMilis() {
        return this.getResultSetHoldTimeNano() / 1000000L;
    }

    public long getExecuteAndResultSetHoldTimeMilis() {
        return this.getExecuteAndResultSetHoldTimeNano() / 1000000L;
    }

    public long[] getFetchRowCountHistogramValues() {
        return new long[]{this.fetchRowCount_0_1, this.fetchRowCount_1_10, this.fetchRowCount_10_100, this.fetchRowCount_100_1000, this.fetchRowCount_1000_10000, this.fetchRowCount_10000_more};
    }

    public long[] getUpdateCountHistogramValues() {
        return new long[]{this.updateCount_0_1, this.updateCount_1_10, this.updateCount_10_100, this.updateCount_100_1000, this.updateCount_1000_10000, this.updateCount_10000_more};
    }

    public long[] getExecuteAndResultHoldTimeHistogramValues() {
        return new long[]{this.executeAndResultHoldTime_0_1, this.executeAndResultHoldTime_1_10, this.executeAndResultHoldTime_10_100, this.executeAndResultHoldTime_100_1000, this.executeAndResultHoldTime_1000_10000, this.executeAndResultHoldTime_10000_100000, this.executeAndResultHoldTime_100000_1000000, this.executeAndResultHoldTime_1000000_more};
    }

    public long getExecuteAndResultHoldTimeHistogramSum() {
        long[] values = this.getExecuteAndResultHoldTimeHistogramValues();
        long sum = 0L;
        for (int i = 0; i < values.length; ++i) {
            sum += values[i];
        }
        return sum;
    }

    public long getResultSetHoldTimeNano() {
        return this.resultSetHoldTimeNano;
    }

    public long getExecuteAndResultSetHoldTimeNano() {
        return this.executeAndResultSetHoldTime;
    }

    public void addResultSetHoldTimeNano(long nano) {
        resultSetHoldTimeNanoUpdater.addAndGet(this, nano);
    }

    public void addResultSetHoldTimeNano(long statementExecuteNano, long resultHoldTimeNano) {
        resultSetHoldTimeNanoUpdater.addAndGet(this, resultHoldTimeNano);
        executeAndResultSetHoldTimeUpdater.addAndGet(this, statementExecuteNano + resultHoldTimeNano);
        this.executeAndResultHoldTimeHistogramRecord((statementExecuteNano + resultHoldTimeNano) / 1000L / 1000L);
        updateCount_0_1_Updater.incrementAndGet(this);
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    @Override
    public int compareTo(JdbcSqlStat o) {
        if (o.sqlHash == this.sqlHash) {
            return 0;
        }
        return this.id < o.id ? -1 : 1;
    }
}

