/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.engine.common;

import com.palacesun.engine.common.ConnectionInformation;
import com.palacesun.engine.common.Loggable;
import com.palacesun.engine.common.P6LogQuery;
import com.palacesun.engine.common.StatementInformation;
import com.palacesun.engine.common.Value;
import com.palacesun.engine.logging.Category;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class ResultSetInformation
implements Loggable {
    private final StatementInformation statementInformation;
    private ResultSet resultSet;
    private String query;
    private final Map<String, Value> resultMap = new LinkedHashMap<String, Value>();
    private int currRow = -1;
    private int lastRowLogged = -1;
    private String sqlTemplate;

    public String getSqlTemplate() {
        return this.sqlTemplate;
    }

    public void setSqlTemplate(String sqlTemplate) {
        this.sqlTemplate = sqlTemplate;
    }

    public ResultSetInformation(StatementInformation statementInformation) {
        this.statementInformation = statementInformation;
        this.query = statementInformation.getStatementQuery();
    }

    public void generateLogMessage() {
        if (this.lastRowLogged != this.currRow) {
            P6LogQuery.log(Category.RESULTSET, this);
            this.lastRowLogged = this.currRow;
        }
    }

    public int getCurrRow() {
        return this.currRow;
    }

    public void incrementCurrRow() {
        ++this.currRow;
        this.resultMap.clear();
    }

    public void setColumnValue(String columnName, Object value) {
        this.resultMap.put(columnName, new Value(value));
    }

    @Override
    public String getSql() {
        return this.query;
    }

    @Override
    public String getSqlWithValues() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Value> entry : this.resultMap.entrySet()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(entry.getKey());
            sb.append(" = ");
            sb.append(entry.getValue() != null ? entry.getValue().toString() : new Value().toString());
        }
        return sb.toString();
    }

    @Override
    public String getSqlWithSafeValues() {
        return this.getSqlWithValues();
    }

    public Map<String, Value> getResultMap() {
        return Collections.unmodifiableMap(this.resultMap);
    }

    public StatementInformation getStatementInformation() {
        return this.statementInformation;
    }

    @Override
    public ConnectionInformation getConnectionInformation() {
        return this.statementInformation.getConnectionInformation();
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }
}

