/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.engine.gateway.util;

import com.palacesun.engine.gateway.EncryptionGatewayManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.Date;
import java.util.Deque;

public class GatewaySocketLogUtil {
    public static SimpleDateFormat sdf;

    public static void writeLog(String content) {
        if (GatewaySocketLogUtil.isSave()) {
            OutputStreamWriter fileWriter = null;
            BufferedWriter bufferedWriter = null;
            try {
                fileWriter = new FileWriter(System.getProperty("user.home") + "/gatewaySocketLog.txt", true);
                bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.write(GatewaySocketLogUtil.content(content));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (null != bufferedWriter) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                try {
                    if (null != fileWriter) {
                        fileWriter.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void writeLogBatch(Deque<String> contents) {
        if (GatewaySocketLogUtil.isSave()) {
            for (String content : contents) {
                OutputStreamWriter fileWriter = null;
                BufferedWriter bufferedWriter = null;
                try {
                    fileWriter = new FileWriter(System.getProperty("user.home") + "/gatewaySocketLog.txt", true);
                    bufferedWriter = new BufferedWriter(fileWriter);
                    bufferedWriter.write(content);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    try {
                        if (null != bufferedWriter) {
                            bufferedWriter.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    try {
                        if (null == fileWriter) continue;
                        fileWriter.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    public static void writeKeyCache(String content) {
        OutputStreamWriter fileWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            String path = EncryptionGatewayManager.getParameterValue("encryption.location");
            if (path != null && !"".equals(path)) {
                String pathTemp = path.replace("encryption.properties", "");
                File file = new File(pathTemp);
                if (!file.exists()) {
                    file.mkdirs();
                }
                fileWriter = new FileWriter(path, false);
                bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.write(content);
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (null != bufferedWriter) {
                    bufferedWriter.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                if (null != fileWriter) {
                    fileWriter.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void writeDigestKeyCache(String content) {
        OutputStreamWriter fileWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            String path = EncryptionGatewayManager.getParameterValue("digest.location");
            if (path != null && !"".equals(path)) {
                String pathTemp = path.replace("digest.properties", "");
                File file = new File(pathTemp);
                if (!file.exists()) {
                    file.mkdirs();
                }
                fileWriter = new FileWriter(path, false);
                bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.write(content);
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (null != bufferedWriter) {
                    bufferedWriter.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                if (null != fileWriter) {
                    fileWriter.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static String content(String content) {
        StringBuffer result = new StringBuffer("");
        result.append(sdf.format(new Date()) + " --> ");
        result.append(content);
        result.append("\r\n");
        return result.toString();
    }

    public static void writeBlankRows() {
        if (GatewaySocketLogUtil.isSave()) {
            OutputStreamWriter fileWriter = null;
            BufferedWriter bufferedWriter = null;
            try {
                fileWriter = new FileWriter(System.getProperty("user.home") + "/gatewaySocketLog.txt", true);
                bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.write("\r\n");
                bufferedWriter.write("\r\n");
                bufferedWriter.write("\r\n");
                bufferedWriter.write("\r\n");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    if (null != bufferedWriter) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                try {
                    if (null != fileWriter) {
                        fileWriter.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static boolean isSave() {
        try {
            String isSave = EncryptionGatewayManager.getParameterValue("isSave");
            return "true".equalsIgnoreCase(isSave);
        }
        catch (Exception var1) {}
        finally {
            return false;
        }
    }

    static {
        if (GatewaySocketLogUtil.isSave()) {
            InnerThread innerThread = new InnerThread();
            innerThread.start();
        }
        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    public static class InnerThread
    extends Thread {
        @Override
        public void run() {
            long timeInterval = 600000L;
            int linesToKeep = 500;
            try {
                while (true) {
                    String line;
                    Thread.sleep(timeInterval);
                    ArrayDeque<String> deque = new ArrayDeque<String>();
                    File file = new File(System.getProperty("user.home") + "/gatewaySocketLog.txt");
                    if (!file.exists()) continue;
                    FileInputStream fis = new FileInputStream(file);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fis));
                    while ((line = bufferedReader.readLine()) != null) {
                        if (deque.size() == linesToKeep) {
                            deque.pollFirst();
                        }
                        deque.offerLast(line);
                    }
                    boolean delete = false;
                    for (int i = 0; !delete && i <= 5; ++i) {
                        delete = file.delete();
                    }
                    GatewaySocketLogUtil.writeLogBatch(deque);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

