/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.engine.outage;

import com.palacesun.engine.common.ConnectionInformation;
import com.palacesun.engine.common.StatementInformation;
import com.palacesun.engine.event.SimpleJdbcEventListener;
import com.palacesun.engine.outage.P6OutageDetector;
import com.palacesun.engine.outage.P6OutageOptions;
import java.sql.SQLException;

public class OutageJdbcEventListener
extends SimpleJdbcEventListener {
    public static final OutageJdbcEventListener INSTANCE = new OutageJdbcEventListener();

    private OutageJdbcEventListener() {
    }

    @Override
    public void onBeforeCommit(ConnectionInformation connectionInformation) {
        if (P6OutageOptions.getActiveInstance().getOutageDetection()) {
            P6OutageDetector.INSTANCE.registerInvocation(this, System.nanoTime(), "commit", "", "", connectionInformation.getUrl());
        }
    }

    @Override
    public void onAfterCommit(ConnectionInformation connectionInformation, long timeElapsedNanos, SQLException e) {
        if (P6OutageOptions.getActiveInstance().getOutageDetection()) {
            P6OutageDetector.INSTANCE.unregisterInvocation(this);
        }
    }

    @Override
    public void onBeforeRollback(ConnectionInformation connectionInformation) {
        if (P6OutageOptions.getActiveInstance().getOutageDetection()) {
            P6OutageDetector.INSTANCE.registerInvocation(this, System.nanoTime(), "rollback", "", "", connectionInformation.getUrl());
        }
    }

    @Override
    public void onAfterRollback(ConnectionInformation connectionInformation, long timeElapsedNanos, SQLException e) {
        if (P6OutageOptions.getActiveInstance().getOutageDetection()) {
            P6OutageDetector.INSTANCE.unregisterInvocation(this);
        }
    }

    @Override
    public void onBeforeAnyAddBatch(StatementInformation statementInformation) {
        if (P6OutageOptions.getActiveInstance().getOutageDetection()) {
            P6OutageDetector.INSTANCE.registerInvocation(this, System.nanoTime(), "batch", statementInformation.getSqlWithValues(), statementInformation.getStatementQuery(), statementInformation.getConnectionInformation().getUrl());
        }
    }

    @Override
    public void onAfterAnyAddBatch(StatementInformation statementInformation, long timeElapsedNanos, SQLException e) {
        if (P6OutageOptions.getActiveInstance().getOutageDetection()) {
            P6OutageDetector.INSTANCE.unregisterInvocation(this);
        }
    }

    @Override
    public void onBeforeAnyExecute(StatementInformation statementInformation) {
        if (P6OutageOptions.getActiveInstance().getOutageDetection()) {
            P6OutageDetector.INSTANCE.registerInvocation(this, System.nanoTime(), "statement", statementInformation.getSqlWithValues(), statementInformation.getStatementQuery(), statementInformation.getConnectionInformation().getUrl());
        }
    }

    @Override
    public void onAfterAnyExecute(StatementInformation statementInformation, long timeElapsedNanos, SQLException e) {
        if (P6OutageOptions.getActiveInstance().getOutageDetection()) {
            P6OutageDetector.INSTANCE.unregisterInvocation(this);
        }
    }
}

