/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.engine.spy;

import com.palacesun.engine.common.ConnectionInformation;
import com.palacesun.engine.common.P6LogQuery;
import com.palacesun.engine.event.JdbcEventListener;
import com.palacesun.engine.spy.JdbcEventListenerFactory;
import com.palacesun.engine.spy.JdbcEventListenerFactoryLoader;
import com.palacesun.engine.spy.P6ModuleManager;
import com.palacesun.engine.wrapper.ConnectionWrapper;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class P6SpyDriver
implements Driver {
    private static Driver instance = new P6SpyDriver();
    private static JdbcEventListenerFactory jdbcEventListenerFactory;

    @Override
    public boolean acceptsURL(String url) {
        return url != null && url.startsWith("jdbc:p6spy:");
    }

    private String extractRealUrl(String url) {
        return this.acceptsURL(url) ? url.replace("p6spy:", "") : url;
    }

    static List<Driver> registeredDrivers() {
        ArrayList<Driver> result = new ArrayList<Driver>();
        Enumeration<Driver> driverEnumeration = DriverManager.getDrivers();
        while (driverEnumeration.hasMoreElements()) {
            result.add(driverEnumeration.nextElement());
        }
        return result;
    }

    @Override
    public Connection connect(String url, Properties properties) throws SQLException {
        Connection conn;
        if (url == null) {
            throw new SQLException("url is required");
        }
        if (!this.acceptsURL(url)) {
            return null;
        }
        Driver passThru = this.findPassthru(url);
        P6LogQuery.debug("this is " + this + " and passthru is " + passThru);
        long start = System.nanoTime();
        if (jdbcEventListenerFactory == null) {
            jdbcEventListenerFactory = JdbcEventListenerFactoryLoader.load();
        }
        JdbcEventListener jdbcEventListener = jdbcEventListenerFactory.createJdbcEventListener();
        ConnectionInformation connectionInformation = ConnectionInformation.fromDriver(passThru);
        connectionInformation.setUrl(url);
        try {
            jdbcEventListener.onBeforeGetConnection(connectionInformation);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            conn = passThru.connect(this.extractRealUrl(url), properties);
            connectionInformation.setConnection(conn);
            connectionInformation.setTimeToGetConnectionNs(System.nanoTime() - start);
            jdbcEventListener.onAfterGetConnection(connectionInformation, null);
        }
        catch (SQLException e) {
            connectionInformation.setTimeToGetConnectionNs(System.nanoTime() - start);
            jdbcEventListener.onAfterGetConnection(connectionInformation, e);
            throw e;
        }
        try {
            return ConnectionWrapper.wrap(conn, jdbcEventListener, connectionInformation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Driver findPassthru(String url) throws SQLException {
        P6ModuleManager.getInstance();
        String realUrl = this.extractRealUrl(url);
        Driver passthru = null;
        for (Driver driver : P6SpyDriver.registeredDrivers()) {
            try {
                if (!driver.acceptsURL(this.extractRealUrl(url))) continue;
                passthru = driver;
                break;
            }
            catch (SQLException sQLException) {
            }
        }
        if (passthru == null) {
            throw new SQLException("Unable to find a driver that accepts " + realUrl);
        }
        return passthru;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties properties) throws SQLException {
        return this.findPassthru(url).getPropertyInfo(url, properties);
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Feature not supported");
    }

    public static void setJdbcEventListenerFactory(JdbcEventListenerFactory jdbcEventListenerFactory) {
        P6SpyDriver.jdbcEventListenerFactory = jdbcEventListenerFactory;
    }

    static {
        try {
            DriverManager.registerDriver(instance);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Could not register P6SpyDriver with DriverManager", e);
        }
    }
}

