/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.engine.wrapper;

import com.palacesun.engine.common.ResultSetInformation;
import com.palacesun.engine.event.JdbcEventListener;
import com.palacesun.engine.wrapper.AbstractWrapper;
import com.palacesun.masking.tools.Base64;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.sql.rowset.serial.SerialClob;

public class ResultSetWrapper
extends AbstractWrapper
implements ResultSet {
    private final ResultSet delegate;
    private final ResultSetInformation resultSetInformation;
    private final JdbcEventListener eventListener;

    public static ResultSet wrap(ResultSet delegate, ResultSetInformation resultSetInformation, JdbcEventListener eventListener) throws SQLException {
        return delegate == null ? null : new ResultSetWrapper(delegate, resultSetInformation, eventListener);
    }

    public ResultSetWrapper(ResultSet delegate, ResultSetInformation resultSetInformation, JdbcEventListener eventListener) throws SQLException {
        super(delegate);
        this.delegate = delegate;
        this.resultSetInformation = resultSetInformation;
        this.eventListener = eventListener;
        eventListener.onBeforeGetResltSetDate(delegate);
        resultSetInformation.setResultSet(delegate);
    }

    public ResultSet getDelegate() {
        return this.delegate;
    }

    public ResultSetInformation getResultSetInformation() {
        return this.resultSetInformation;
    }

    @Override
    public boolean next() throws SQLException {
        boolean var5;
        SQLException e = null;
        long start = System.nanoTime();
        boolean next = false;
        try {
            this.eventListener.onBeforeResultSetNext(this.resultSetInformation);
            var5 = next = this.delegate.next();
        }
        catch (SQLException sqle) {
            e = sqle;
            throw sqle;
        }
        finally {
            this.eventListener.onAfterResultSetNext(this.resultSetInformation, System.nanoTime() - start, next, e);
        }
        return var5;
    }

    @Override
    public void close() throws SQLException {
        SQLException e = null;
        try {
            this.delegate.close();
        }
        catch (SQLException sqle) {
            e = sqle;
            throw sqle;
        }
        finally {
            this.eventListener.onAfterResultSetClose(this.resultSetInformation, e);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.delegate.wasNull();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object e = null;
        try {
            String value = this.delegate.getString(columnIndex);
            value = (String)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object e = null;
        try {
            boolean value = this.delegate.getBoolean(columnIndex);
            return value;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return true;
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Object e = null;
        try {
            byte value = this.delegate.getByte(columnIndex);
            return value;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Object e = null;
        try {
            short value = this.delegate.getShort(columnIndex);
            return value;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Object e = null;
        try {
            int value = this.delegate.getInt(columnIndex);
            return value;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Object e = null;
        try {
            long value = this.delegate.getLong(columnIndex);
            return value;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0L;
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Object e = null;
        try {
            float value = this.delegate.getFloat(columnIndex);
            return value;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0.0f;
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Object e = null;
        try {
            double value = this.delegate.getDouble(columnIndex);
            return value;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0.0;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        Object e = null;
        try {
            BigDecimal value = this.delegate.getBigDecimal(columnIndex, scale);
            return value;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return BigDecimal.ZERO;
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        Object e = null;
        try {
            byte[] value = this.delegate.getBytes(columnIndex);
            return value;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new byte[0];
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        Object e = null;
        try {
            Date value = this.delegate.getDate(columnIndex);
            return value;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Object e = null;
        try {
            Time value = this.delegate.getTime(columnIndex);
            return value;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object e = null;
        try {
            Timestamp value = this.delegate.getTimestamp(columnIndex);
            return value;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        SQLException e = null;
        try {
            InputStream value = this.delegate.getAsciiStream(columnIndex);
            value = (InputStream)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            e = sqle;
            try {
                this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, null, e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        SQLException e = null;
        try {
            InputStream value = this.delegate.getUnicodeStream(columnIndex);
            value = (InputStream)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            e = sqle;
            try {
                this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, null, e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        SQLException e = null;
        try {
            InputStream value = this.delegate.getBinaryStream(columnIndex);
            value = (InputStream)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            e = sqle;
            try {
                this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, null, e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        Object e = null;
        try {
            String value = this.delegate.getString(columnLabel);
            value = (String)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        Object e = null;
        try {
            boolean value = this.delegate.getBoolean(columnLabel);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        Object e = null;
        try {
            byte value = this.delegate.getByte(columnLabel);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        Object e = null;
        try {
            short value = this.delegate.getShort(columnLabel);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        Object e = null;
        try {
            int value = this.delegate.getInt(columnLabel);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        Object e = null;
        try {
            long value = this.delegate.getLong(columnLabel);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        Object e = null;
        try {
            float value = this.delegate.getFloat(columnLabel);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        Object e = null;
        try {
            double value = this.delegate.getDouble(columnLabel);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        Object e = null;
        try {
            BigDecimal value = this.delegate.getBigDecimal(columnLabel, scale);
            value = (BigDecimal)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        Object e = null;
        try {
            byte[] value = this.delegate.getBytes(columnLabel);
            value = (byte[])this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        Object e = null;
        try {
            Date value = this.delegate.getDate(columnLabel);
            value = (Date)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        Object e = null;
        try {
            Time value = this.delegate.getTime(columnLabel);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        Object e = null;
        try {
            Timestamp value = this.delegate.getTimestamp(columnLabel);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        Object e = null;
        try {
            InputStream value = this.delegate.getAsciiStream(columnLabel);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        Object e = null;
        try {
            InputStream value = this.delegate.getUnicodeStream(columnLabel);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        Object e = null;
        try {
            InputStream value = this.delegate.getBinaryStream(columnLabel);
            value = (InputStream)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.delegate.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.delegate.clearWarnings();
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.delegate.getCursorName();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.delegate.getMetaData();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        SQLException e = null;
        try {
            Object value = this.delegate.getObject(columnIndex);
            value = this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            e = sqle;
            try {
                this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, null, e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        Object e = null;
        try {
            Object value = this.delegate.getObject(columnLabel);
            value = this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.delegate.findColumn(columnLabel);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        SQLException e = null;
        try {
            Reader value = this.delegate.getCharacterStream(columnIndex);
            value = (Reader)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            e = sqle;
            try {
                this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, null, e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        Object e = null;
        try {
            Reader value = this.delegate.getCharacterStream(columnLabel);
            value = (Reader)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        SQLException e = null;
        try {
            BigDecimal value = this.delegate.getBigDecimal(columnIndex);
            value = (BigDecimal)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            e = sqle;
            try {
                this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, null, e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        Object e = null;
        try {
            BigDecimal value = this.delegate.getBigDecimal(columnLabel);
            value = (BigDecimal)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.delegate.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.delegate.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.delegate.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.delegate.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.delegate.beforeFirst();
    }

    @Override
    public void afterLast() throws SQLException {
        this.delegate.afterLast();
    }

    @Override
    public boolean first() throws SQLException {
        return this.delegate.first();
    }

    @Override
    public boolean last() throws SQLException {
        return this.delegate.last();
    }

    @Override
    public int getRow() throws SQLException {
        return this.delegate.getRow();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        return this.delegate.absolute(row);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return this.delegate.relative(rows);
    }

    @Override
    public boolean previous() throws SQLException {
        return this.delegate.previous();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.delegate.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.delegate.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.delegate.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.delegate.getFetchSize();
    }

    @Override
    public int getType() throws SQLException {
        return this.delegate.getType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        return this.delegate.getConcurrency();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.delegate.rowUpdated();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.delegate.rowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.delegate.rowDeleted();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.delegate.updateNull(columnIndex);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.delegate.updateBoolean(columnIndex, x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.delegate.updateByte(columnIndex, x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.delegate.updateShort(columnIndex, x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.delegate.updateInt(columnIndex, x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.delegate.updateLong(columnIndex, x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.delegate.updateFloat(columnIndex, x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.delegate.updateDouble(columnIndex, x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.delegate.updateBigDecimal(columnIndex, x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.delegate.updateString(columnIndex, x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.delegate.updateBytes(columnIndex, x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.delegate.updateDate(columnIndex, x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.delegate.updateTime(columnIndex, x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.delegate.updateTimestamp(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.delegate.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.delegate.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.delegate.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.delegate.updateObject(columnIndex, x, scaleOrLength);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.delegate.updateObject(columnIndex, x);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.delegate.updateNull(columnLabel);
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.delegate.updateBoolean(columnLabel, x);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.delegate.updateByte(columnLabel, x);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.delegate.updateShort(columnLabel, x);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.delegate.updateInt(columnLabel, x);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.delegate.updateLong(columnLabel, x);
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.delegate.updateFloat(columnLabel, x);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.delegate.updateDouble(columnLabel, x);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.delegate.updateBigDecimal(columnLabel, x);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.delegate.updateString(columnLabel, x);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.delegate.updateBytes(columnLabel, x);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.delegate.updateDate(columnLabel, x);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.delegate.updateTime(columnLabel, x);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.delegate.updateTimestamp(columnLabel, x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.delegate.updateAsciiStream(columnLabel, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.delegate.updateBinaryStream(columnLabel, x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.delegate.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.delegate.updateObject(columnLabel, x, scaleOrLength);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.delegate.updateObject(columnLabel, x);
    }

    @Override
    public void insertRow() throws SQLException {
        this.delegate.insertRow();
    }

    @Override
    public void updateRow() throws SQLException {
        this.delegate.updateRow();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.delegate.deleteRow();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.delegate.refreshRow();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.delegate.cancelRowUpdates();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.delegate.moveToInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.delegate.moveToCurrentRow();
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.delegate.getStatement();
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        SQLException e = null;
        try {
            Object value = this.delegate.getObject(columnIndex, map);
            value = this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            e = sqle;
            try {
                this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, null, e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        SQLException e = null;
        try {
            Ref value = this.delegate.getRef(columnIndex);
            value = (Ref)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            e = sqle;
            try {
                this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, null, e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        SQLException e = null;
        try {
            Blob value = this.delegate.getBlob(columnIndex);
            value = (Blob)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            e = sqle;
            try {
                this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, null, e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        SQLException e = null;
        try {
            Clob value = this.delegate.getClob(columnIndex);
            String cvalue = this.clobToString(value);
            cvalue = this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, (Object)cvalue, (SQLException)null).toString();
            return ResultSetWrapper.stringToClob(cvalue);
        }
        catch (SQLException sqle) {
            e = sqle;
            try {
                this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, null, e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clobToString(Clob clob) throws Exception {
        StringWriter writer = new StringWriter();
        try (Reader reader = null;){
            int bytesRead;
            reader = clob.getCharacterStream();
            char[] buffer = new char[1024];
            while ((bytesRead = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, bytesRead);
            }
        }
        return writer.toString();
    }

    public static Clob stringToClob(String data) throws SQLException {
        return new SerialClob(data.toCharArray());
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        SQLException e = null;
        try {
            Array value = this.delegate.getArray(columnIndex);
            value = (Array)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            e = sqle;
            try {
                this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, null, e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        Object e = null;
        try {
            Object value = this.delegate.getObject(columnLabel, map);
            value = this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        Object e = null;
        try {
            Ref value = this.delegate.getRef(columnLabel);
            value = (Ref)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        Object e = null;
        try {
            Blob value = this.delegate.getBlob(columnLabel);
            value = (Blob)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        SQLException e = null;
        try {
            Clob value = this.delegate.getClob(columnLabel);
            String cvalue = this.clobToString(value);
            cvalue = this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, (Object)cvalue, (SQLException)null).toString();
            return ResultSetWrapper.stringToClob(cvalue);
        }
        catch (SQLException sqle) {
            e = sqle;
            try {
                this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        Object e = null;
        try {
            Array value = this.delegate.getArray(columnLabel);
            value = (Array)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        SQLException e = null;
        try {
            Date value = this.delegate.getDate(columnIndex, cal);
            value = (Date)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            e = sqle;
            try {
                this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, null, e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        Object e = null;
        try {
            Date value = this.delegate.getDate(columnLabel, cal);
            value = (Date)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        SQLException e = null;
        try {
            Time value = this.delegate.getTime(columnIndex, cal);
            value = (Time)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            e = sqle;
            try {
                this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, null, e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        Object e = null;
        try {
            Time value = this.delegate.getTime(columnLabel, cal);
            value = (Time)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        SQLException e = null;
        try {
            Timestamp value = this.delegate.getTimestamp(columnIndex, cal);
            value = (Timestamp)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            e = sqle;
            try {
                this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, null, e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        Object e = null;
        try {
            Timestamp value = this.delegate.getTimestamp(columnLabel, cal);
            value = (Timestamp)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        SQLException e = null;
        try {
            URL value = this.delegate.getURL(columnIndex);
            value = (URL)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            e = sqle;
            try {
                this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, null, e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        Object e = null;
        try {
            URL value = this.delegate.getURL(columnLabel);
            value = (URL)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.delegate.updateRef(columnIndex, x);
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.delegate.updateRef(columnLabel, x);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.delegate.updateBlob(columnIndex, x);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.delegate.updateBlob(columnLabel, x);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.delegate.updateClob(columnIndex, x);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.delegate.updateClob(columnLabel, x);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.delegate.updateArray(columnIndex, x);
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.delegate.updateArray(columnLabel, x);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        SQLException e = null;
        try {
            RowId value = this.delegate.getRowId(columnIndex);
            value = (RowId)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            e = sqle;
            try {
                this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, null, e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        Object e = null;
        try {
            RowId value = this.delegate.getRowId(columnLabel);
            value = (RowId)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.delegate.updateRowId(columnIndex, x);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.delegate.updateRowId(columnLabel, x);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.delegate.getHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.delegate.isClosed();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.delegate.updateNString(columnIndex, nString);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.delegate.updateNString(columnLabel, nString);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.delegate.updateNClob(columnIndex, nClob);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.delegate.updateNClob(columnLabel, nClob);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        SQLException e = null;
        try {
            NClob value = this.delegate.getNClob(columnIndex);
            value = (NClob)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            e = sqle;
            try {
                this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, null, e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        Object e = null;
        try {
            NClob value = this.delegate.getNClob(columnLabel);
            value = (NClob)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        SQLException e = null;
        try {
            SQLXML value = this.delegate.getSQLXML(columnIndex);
            value = (SQLXML)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            e = sqle;
            try {
                this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, null, e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        Object e = null;
        try {
            SQLXML value = this.delegate.getSQLXML(columnLabel);
            value = (SQLXML)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.delegate.updateSQLXML(columnIndex, xmlObject);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.delegate.updateSQLXML(columnLabel, xmlObject);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        Object e = null;
        try {
            String value = this.delegate.getString(columnIndex);
            value = (String)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, (Object)value, (SQLException)null);
            byte[] decodedBytes = Base64.getDecoder().decode(value);
            String originalString = new String(decodedBytes, "UTF-8");
            return originalString;
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        Object e = null;
        try {
            String value = this.delegate.getNString(columnLabel);
            value = (String)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        SQLException e = null;
        try {
            Reader value = this.delegate.getNCharacterStream(columnIndex);
            value = (Reader)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            e = sqle;
            try {
                this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnIndex, null, e);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            throw sqle;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        Object e = null;
        try {
            Reader value = this.delegate.getNCharacterStream(columnLabel);
            value = (Reader)this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, (Object)value, (SQLException)null);
            return value;
        }
        catch (SQLException sqle) {
            this.eventListener.onAfterResultSetGet(this.resultSetInformation, columnLabel, null, sqle);
            throw sqle;
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.delegate.updateNCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.delegate.updateNCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.delegate.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.delegate.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.delegate.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.delegate.updateAsciiStream(columnLabel, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.delegate.updateBinaryStream(columnLabel, x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.delegate.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.delegate.updateBlob(columnIndex, inputStream, length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.delegate.updateBlob(columnLabel, inputStream, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.delegate.updateClob(columnIndex, reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.delegate.updateClob(columnLabel, reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.delegate.updateNClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.delegate.updateNClob(columnLabel, reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.delegate.updateNCharacterStream(columnIndex, x);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.delegate.updateNCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.delegate.updateAsciiStream(columnIndex, x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.delegate.updateBinaryStream(columnIndex, x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.delegate.updateCharacterStream(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.delegate.updateAsciiStream(columnLabel, x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.delegate.updateBinaryStream(columnLabel, x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.delegate.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.delegate.updateBlob(columnIndex, inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.delegate.updateBlob(columnLabel, inputStream);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.delegate.updateClob(columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.delegate.updateClob(columnLabel, reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.delegate.updateNClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.delegate.updateNClob(columnLabel, reader);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return null;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }
}

