/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.engine.wrapper;

import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.palacesun.engine.common.ResultSetInformation;
import com.palacesun.engine.common.StatementInformation;
import com.palacesun.engine.event.JdbcEventListener;
import com.palacesun.engine.gateway.EncryptionGatewayManager;
import com.palacesun.engine.gateway.GatewayContext;
import com.palacesun.engine.test.DbCache;
import com.palacesun.engine.test.TestJdbcEventListener;
import com.palacesun.engine.wrapper.AbstractWrapper;
import com.palacesun.engine.wrapper.ConnectionWrapper;
import com.palacesun.engine.wrapper.ResultSetWrapper;
import com.palacesun.masking.appuser.AppUser;
import com.palacesun.masking.log.access.AccessContext;
import com.palacesun.masking.log.access.SqlBuffer;
import com.palacesun.masking.tools.EngineUtil;
import com.palacesun.masking.tools.InsertSqlVaulesUtil;
import com.palacesun.masking.tools.ruleload.RuleLoadUtil;
import com.palacesun.masking.vo.Columninfo;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import util.SqlUtil;
import util.StringJoin;

public class StatementWrapper
extends AbstractWrapper
implements Statement {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final Statement delegate;
    protected final JdbcEventListener eventListener;
    private final StatementInformation statementInformation;
    protected SqlBuffer sqlBuffer;
    private static final String ENCRYPT_LIKE_OPEN = EncryptionGatewayManager.getParameterValue("encryption.like.open");
    private static final String ENCRYPT_SEPARATOR = EncryptionGatewayManager.getParameterValue("encryption.separator");
    public static Map<String, String> dbTypeMap = new HashMap<String, String>();

    public static Statement wrap(Statement delegate, StatementInformation statementInformation, JdbcEventListener eventListener) {
        if (delegate == null) {
            return null;
        }
        StatementWrapper wrapper = new StatementWrapper(delegate, statementInformation, eventListener);
        return wrapper;
    }

    protected StatementWrapper(Statement delegate, StatementInformation statementInformation, JdbcEventListener eventListener) {
        super(delegate);
        this.delegate = delegate;
        this.eventListener = eventListener;
        this.statementInformation = statementInformation;
        statementInformation.setStatement(delegate);
        if (statementInformation.context == null) {
            statementInformation.context = new AccessContext(statementInformation);
        }
        this.sqlBuffer = statementInformation.context.getBuffer();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        ResultSet var4;
        SQLException e = null;
        long start = System.nanoTime();
        try {
            var4 = ResultSetWrapper.wrap(this.delegate.getResultSet(), new ResultSetInformation(this.statementInformation), this.eventListener);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw sqle;
        }
        finally {
            this.eventListener.onAfterGetResultSet(this.statementInformation, System.nanoTime() - start, e);
        }
        return var4;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet var6;
        AccessContext context;
        sql = sql + " -- appUsername=" + AppUser.loginUser() + "\r\n";
        this.statementInformation.context = context = new AccessContext();
        if (DbCache.isNeedIntercept(sql, this.statementInformation) && GatewayContext.isPluginEnabled()) {
            try {
                this.statementInformation.setStatementQuery(sql);
                context.setStatementInfo(this.statementInformation);
                sql = this.encData(this.statementInformation);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new SQLException(exception);
            }
        }
        this.statementInformation.setStatementQuery(sql);
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecuteQuery(this.statementInformation, sql);
            var6 = ResultSetWrapper.wrap(this.delegate.executeQuery(sql), new ResultSetInformation(this.statementInformation), this.eventListener);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw sqle;
        }
        finally {
            this.eventListener.onAfterExecuteQuery(this.statementInformation, System.nanoTime() - start, sql, e);
        }
        return var6;
    }

    public String encData(StatementInformation statementInformation) throws Exception {
        String returnSql = "";
        SqlUtil sqlUtil = new SqlUtil();
        String sqlUser = "";
        String dbType = "";
        String urlDbType = statementInformation.getConnectionInformation().getUrl();
        String driverName = statementInformation.getConnectionInformation().getConnection().getMetaData().getDriverName();
        dbType = ConnectionWrapper.getDbType(driverName, urlDbType, dbType);
        new ArrayList();
        try {
            String url;
            Connection connection = statementInformation.getConnectionInformation().getConnection();
            String urlTemp = connection.getMetaData().getURL();
            String ip = TestJdbcEventListener.getIpAndPort(urlTemp).get("ip");
            String port = TestJdbcEventListener.getIpAndPort(urlTemp).get("port");
            String schema = "";
            if ("oracle".equals(dbType)) {
                schema = connection.getMetaData().getUserName();
            } else if (!("postgresql".equals(dbType) || "greenplum".equals(dbType) || "gauss".equals(dbType))) {
                int idx;
                String address;
                int end;
                if ("sql server".equals(dbType)) {
                    url = connection.getMetaData().getURL();
                    if (url.indexOf("applicationName") > 0) {
                        schema = url.substring(url.indexOf("applicationName") + "applicationName".length() + 1);
                        if (schema.indexOf(";") != -1) {
                            schema = schema.substring(0, schema.indexOf(";"));
                        }
                    } else {
                        schema = "dbo";
                    }
                } else if ("dm".equals(dbType)) {
                    url = connection.getMetaData().getURL();
                    if (url.toLowerCase().contains("schema=")) {
                        schema = url.substring(url.toLowerCase().indexOf("schema=") + 7);
                    } else {
                        int from = url.indexOf("://");
                        end = url.indexOf("?");
                        address = end == -1 ? url.substring(from + 3) : url.substring(from + 3, end);
                        idx = address.lastIndexOf("/");
                        schema = address.substring(idx + 1);
                    }
                } else if ("db2".equals(dbType)) {
                    Statement stmt = connection.createStatement();
                    ResultSet rs = stmt.executeQuery("SELECT CURRENT SCHEMA FROM SYSIBM.SYSDUMMY1");
                    schema = rs.next() ? rs.getString(1).trim() : connection.getMetaData().getUserName();
                    rs.close();
                    stmt.close();
                } else if ("kingbase".equals(dbType)) {
                    url = connection.getMetaData().getURL();
                    schema = url.indexOf("searchpath") > 0 ? url.substring(url.indexOf("searchpath") + 11) : (url.indexOf("currentSchema") > 0 ? url.substring(url.indexOf("currentSchema") + 14) : "public");
                } else if ("mysql".equals(dbType)) {
                    url = connection.getMetaData().getURL();
                    int from = url.indexOf("://");
                    end = url.indexOf("?");
                    address = end == -1 ? url.substring(from + 3) : url.substring(from + 3, end);
                    idx = address.lastIndexOf("/");
                    schema = address.substring(idx + 1);
                } else if ("mariadb".equals(dbType)) {
                    url = connection.getMetaData().getURL();
                    int from = url.indexOf("://");
                    end = url.indexOf("?");
                    address = end == -1 ? url.substring(from + 3) : url.substring(from + 3, end);
                    idx = address.lastIndexOf("/");
                    schema = address.substring(idx + 1);
                } else if ("hive".equals(dbType)) {
                    url = connection.getMetaData().getURL();
                    int from = url.indexOf("://");
                    end = url.indexOf("?");
                    address = end == -1 ? url.substring(from + 3) : url.substring(from + 3, end);
                    schema = address.substring((idx = address.lastIndexOf("/")) + 1);
                    if (schema.indexOf(";") > 0) {
                        schema = schema.substring(0, schema.indexOf(";"));
                    }
                } else {
                    schema = connection.getCatalog();
                }
            } else {
                url = connection.getMetaData().getURL();
                schema = url.indexOf("searchpath") > 0 ? url.substring(url.indexOf("searchpath") + 11) : (url.indexOf("currentSchema") > 0 ? url.substring(url.indexOf("currentSchema") + 14) : (url.toLowerCase().indexOf("schema=") > 0 ? url.substring(url.indexOf("schema=") + 7) : "public"));
            }
            String sqlTemp = statementInformation.getSql();
            int n = sqlTemp.indexOf("-- appUsername=");
            sqlUser = sqlTemp.substring(sqlTemp.indexOf("-- appUsername="));
            String sqlAll = sqlTemp.substring(0, n).trim();
            String[] split = sqlAll.split(";\r\n");
            for (int i = 0; i < split.length; ++i) {
                String sqlTmp;
                Map<String, Object> stringObjectMap;
                ArrayList columnList;
                String sql = split[i];
                new ArrayList();
                new ArrayList();
                HashMap<String, String> whereStringList = new HashMap<String, String>();
                List<Map<String, Object>> stringObjectMapList = ConnectionWrapper.sqlParseMap.get(sqlAll);
                if (stringObjectMapList == null || stringObjectMapList.isEmpty()) {
                    stringObjectMapList = statementInformation.sqlParse;
                }
                if (stringObjectMapList == null || stringObjectMapList.isEmpty()) {
                    stringObjectMapList = this.sortColumns(statementInformation, sql, dbType, schema);
                }
                if (((columnList = (ArrayList)(stringObjectMap = stringObjectMapList.get(i)).get("columnList")) == null || columnList.isEmpty()) && !(sqlTmp = statementInformation.getSql().toLowerCase().trim()).startsWith("delete")) {
                    RuleLoadUtil.writeLog("@@\u63d2\u4ef6@@---statementWrapper--->\u89e3\u6790\u51fa\u7684columnList\u4e3a\u7a7a-\u6570\u636e\u5e93\u7c7b\u578b\uff1a" + dbType + ":schema:" + schema);
                    return statementInformation.getSql();
                }
                List whereList = (List)stringObjectMap.get("whereList");
                Boolean encFlag = false;
                HashSet encryFieldSet = new HashSet();
                if (whereList != null && !whereList.isEmpty() && (encFlag = this.encryption(ip, port, schema, false, whereList, encryFieldSet)).booleanValue()) {
                    sql = this.encryptionWhere(statementInformation, sqlUtil, sql, dbType, schema, whereList, whereStringList);
                }
                returnSql = returnSql + sql + ";";
            }
            if (returnSql.endsWith(";")) {
                returnSql = returnSql.substring(0, returnSql.length() - 1);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            throw e1;
        }
        returnSql = returnSql.concat(" ").concat(sqlUser);
        return returnSql;
    }

    private Boolean encryption(String ip, String port, String schema, Boolean encFlag, List<Map> whereList, Set encryFieldSet) throws Exception {
        for (Map whereMap : whereList) {
            boolean ismaksing;
            String key = (String)whereMap.get("column");
            String columnName = key.contains(".") ? key.split("\\.")[2].replace("\"", "") : key.replace("\"", "");
            String tableName = key.contains(".") ? key.split("\\.")[1] : "";
            String string = schema = key.contains(".") ? key.split("\\.")[0] : schema;
            if (String.valueOf(whereMap.get("columnValue")).trim().equals("?")) break;
            String mathKey = (ip + "_" + port + "_" + schema + "_" + tableName + "_" + columnName).toLowerCase().replace("`", "").replace("\"", "");
            if (EngineUtil.encryptionMap.isEmpty()) {
                EngineUtil.keyCacheFromFile();
            }
            if (!(ismaksing = EngineUtil.encryptionMap.containsKey(mathKey))) continue;
            Boolean flag = false;
            try {
                Columninfo map = (Columninfo)EngineUtil.encryptionMap.get(mathKey);
                Object value = whereMap.get("columnValue");
                if (value != null) {
                    String type = (String)whereMap.get("type");
                    if (type.toUpperCase().equals("LIKE")) {
                        String likeValue = ((String)value).trim();
                        boolean beforeLike = false;
                        boolean afterLike = false;
                        if (!likeValue.equals("%%")) {
                            if (likeValue.startsWith("%")) {
                                likeValue = likeValue.substring(1);
                                beforeLike = true;
                            }
                            if (likeValue.endsWith("%")) {
                                likeValue = likeValue.substring(0, likeValue.length() - 1);
                                afterLike = true;
                            }
                            value = EngineUtil.exeEngine(map, null, false, likeValue, true);
                            if (afterLike) {
                                value = value.toString().replace(ENCRYPT_SEPARATOR, "");
                            }
                            if (ENCRYPT_LIKE_OPEN.equals(map.getIsLike())) {
                                if (beforeLike) {
                                    value = "%" + value;
                                }
                                if (afterLike) {
                                    value = value + "%";
                                }
                            }
                        }
                    } else {
                        value = EngineUtil.exeEngine(map, null, false, value, true);
                    }
                }
                whereMap.put("columnValue", value);
                encFlag = true;
                encryFieldSet.add(mathKey);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                throw e1;
            }
        }
        return encFlag;
    }

    private String encryptionWhere(StatementInformation statementInformation, SqlUtil sqlUtil, String sql, String dbType, String schema, List<Map> whereList, Map<String, String> whereStringList) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sql", sql);
        params.put("dbType", dbType);
        params.put("schema", schema);
        params.put("encryption", "1");
        params.put("url", statementInformation.getConnectionInformation().getConnection().getMetaData().getURL());
        for (Map entry : whereList) {
            if (entry.get("columnValue") instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)entry.get("columnValue");
                ArrayList<String> valueList = new ArrayList<String>();
                for (int v = 0; v < arrayList.size(); ++v) {
                    if (!(arrayList.get(v) instanceof SQLCharExpr)) continue;
                    valueList.add(((SQLCharExpr)arrayList.get(v)).getText());
                }
                whereStringList.put((String)entry.get("column"), StringJoin.join(valueList, ","));
                continue;
            }
            whereStringList.put((String)entry.get("column"), (String)entry.get("columnValue"));
        }
        sql = sqlUtil.pareSqlReplaceValue2(params, whereList);
        return sql;
    }

    private List<Object> getInsertSqlValueList(String sql, List<Object> valueList) {
        String lowerSql = sql.toLowerCase();
        String tempsql = "";
        if (lowerSql.contains("values")) {
            tempsql = sql.substring(lowerSql.indexOf("values") + 6);
            tempsql = tempsql.replaceFirst("\\(", "");
            if ((tempsql = tempsql.replaceFirst("[\\\\)]+$", "")).trim().endsWith(";")) {
                tempsql = tempsql.trim().substring(0, tempsql.trim().length() - 1);
            }
            valueList = InsertSqlVaulesUtil.getTableColumnValueByMatchingSingleQuotes(tempsql.split(","));
        }
        return valueList;
    }

    private List<Map<String, Object>> sortColumns(StatementInformation statementInformation, String sql, String dbType, String schema) throws SQLException {
        Map<String, Object> stringObjectMap;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sql", sql);
        params.put("dbType", dbType);
        params.put("schema", schema);
        params.put("encryption", "1");
        String url = statementInformation.getConnectionInformation().getConnection().getMetaData().getURL();
        params.put("url", url);
        SqlUtil sqlUtil = new SqlUtil();
        List<Map<String, Object>> maps = sqlUtil.parseSqlStructureEnc(params);
        if (maps != null && !maps.isEmpty() && !(stringObjectMap = maps.get(0)).isEmpty()) {
            String trim = sql.toLowerCase().trim();
            if ((trim.startsWith("insert") || trim.startsWith("update")) && trim.contains("?")) {
                ConnectionWrapper.sqlParseMap.put(sql, maps);
            } else if (trim.startsWith("select")) {
                ConnectionWrapper.sqlParseMap.put(sql, maps);
            }
            statementInformation.sqlParse = maps;
        }
        return maps;
    }

    private String getDbType(StatementInformation statementInformation, String dbType) throws Exception {
        try {
            dbType = "mysql";
            String hiveurl = statementInformation.getConnectionInformation().getUrl();
            if (hiveurl.toLowerCase().contains("hive")) {
                return "hive";
            }
            String driverName = statementInformation.getConnectionInformation().getConnection().getMetaData().getDriverName();
            if (driverName.toLowerCase().contains("mysql")) {
                dbType = "mysql";
            } else if (driverName.toLowerCase().contains("oracle")) {
                dbType = "oracle";
            } else if (driverName.toLowerCase().contains("postgresql")) {
                String url = statementInformation.getConnectionInformation().getConnection().getMetaData().getURL();
                if (url.contains("gauss")) {
                    dbType = "gauss";
                    return dbType;
                }
                if (url.contains("greenplum")) {
                    dbType = "greenplum";
                    return dbType;
                }
                dbType = "postgresql";
            } else if (driverName.toLowerCase().contains("hive")) {
                dbType = "hive";
            } else if (driverName.toLowerCase().contains("dm")) {
                dbType = "dm";
            } else if (driverName.toLowerCase().contains("ibm")) {
                dbType = "db2";
            } else if (driverName.toLowerCase().contains("sql server")) {
                dbType = "sql server";
            } else if (driverName.toLowerCase().contains("kingbase")) {
                dbType = "kingbase";
            } else if (driverName.toLowerCase().contains("vastbase")) {
                dbType = "postgresql";
            }
            return dbType;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] var5;
        SQLException e = null;
        long start = System.nanoTime();
        int[] updateCounts = null;
        try {
            this.eventListener.onBeforeExecuteBatch(this.statementInformation);
            var5 = updateCounts = this.delegate.executeBatch();
        }
        catch (SQLException sqle) {
            e = sqle;
            throw sqle;
        }
        finally {
            this.eventListener.onAfterExecuteBatch(this.statementInformation, System.nanoTime() - start, updateCounts, e);
        }
        return var5;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        boolean var6;
        AccessContext context;
        sql = sql + " -- appUsername=" + AppUser.loginUser() + "\r\n";
        this.statementInformation.context = context = new AccessContext();
        this.statementInformation.setStatementQuery(sql);
        context.setStatementInfo(this.statementInformation);
        try {
            this.statementInformation.setStatementQuery(sql);
            if (DbCache.isNeedIntercept(sql, this.statementInformation) && GatewayContext.isPluginEnabled()) {
                sql = this.encData(this.statementInformation);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException(exception);
        }
        this.statementInformation.setStatementQuery(sql);
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecute(this.statementInformation, sql);
            var6 = this.delegate.execute(sql);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw sqle;
        }
        finally {
            this.eventListener.onAfterExecute(this.statementInformation, System.nanoTime() - start, sql, e);
        }
        return var6;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean var7;
        AccessContext context;
        sql = sql + " -- appUsername=" + AppUser.loginUser() + "\r\n";
        this.statementInformation.context = context = new AccessContext();
        this.statementInformation.setStatementQuery(sql);
        context.setStatementInfo(this.statementInformation);
        try {
            if (DbCache.isNeedIntercept(sql, this.statementInformation) && GatewayContext.isPluginEnabled()) {
                sql = this.encData(this.statementInformation);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException(exception);
        }
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecute(this.statementInformation, sql);
            var7 = this.delegate.execute(sql, autoGeneratedKeys);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw sqle;
        }
        finally {
            this.eventListener.onAfterExecute(this.statementInformation, System.nanoTime() - start, sql, e);
        }
        return var7;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean var7;
        AccessContext context;
        sql = sql + " -- appUsername=" + AppUser.loginUser() + "\r\n";
        this.statementInformation.context = context = new AccessContext();
        this.statementInformation.setStatementQuery(sql);
        context.setStatementInfo(this.statementInformation);
        try {
            this.statementInformation.setStatementQuery(sql);
            if (DbCache.isNeedIntercept(sql, this.statementInformation) && GatewayContext.isPluginEnabled()) {
                sql = this.encData(this.statementInformation);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException(exception);
        }
        this.statementInformation.setStatementQuery(sql);
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecute(this.statementInformation, sql);
            var7 = this.delegate.execute(sql, columnIndexes);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw sqle;
        }
        finally {
            this.eventListener.onAfterExecute(this.statementInformation, System.nanoTime() - start, sql, e);
        }
        return var7;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean var7;
        AccessContext context;
        sql = sql + " -- appUsername=" + AppUser.loginUser() + "\r\n";
        this.statementInformation.context = context = new AccessContext();
        this.statementInformation.setStatementQuery(sql);
        context.setStatementInfo(this.statementInformation);
        try {
            this.statementInformation.setStatementQuery(sql);
            if (DbCache.isNeedIntercept(sql, this.statementInformation) && GatewayContext.isPluginEnabled()) {
                sql = this.encData(this.statementInformation);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException(exception);
        }
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecute(this.statementInformation, sql);
            var7 = this.delegate.execute(sql, columnNames);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw sqle;
        }
        finally {
            this.eventListener.onAfterExecute(this.statementInformation, System.nanoTime() - start, sql, e);
        }
        return var7;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        int var7;
        AccessContext context;
        sql = sql + " -- appUsername=" + AppUser.loginUser() + "\r\n";
        this.statementInformation.context = context = new AccessContext();
        this.statementInformation.setStatementQuery(sql);
        context.setStatementInfo(this.statementInformation);
        try {
            this.statementInformation.setStatementQuery(sql);
            if (DbCache.isNeedIntercept(sql, this.statementInformation) && GatewayContext.isPluginEnabled()) {
                sql = this.encData(this.statementInformation);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException(exception);
        }
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            this.eventListener.onBeforeExecuteUpdate(this.statementInformation, sql);
            var7 = rowCount = this.delegate.executeUpdate(sql);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw sqle;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate(this.statementInformation, System.nanoTime() - start, sql, rowCount, e);
        }
        return var7;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        int var8;
        AccessContext context;
        sql = sql + " -- appUsername=" + AppUser.loginUser() + "\r\n";
        this.statementInformation.context = context = new AccessContext();
        this.statementInformation.setStatementQuery(sql);
        context.setStatementInfo(this.statementInformation);
        try {
            this.statementInformation.setStatementQuery(sql);
            if (DbCache.isNeedIntercept(sql, this.statementInformation) && GatewayContext.isPluginEnabled()) {
                sql = this.encData(this.statementInformation);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException(exception);
        }
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            this.eventListener.onBeforeExecuteUpdate(this.statementInformation, sql);
            var8 = rowCount = this.delegate.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw sqle;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate(this.statementInformation, System.nanoTime() - start, sql, rowCount, e);
        }
        return var8;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        int var8;
        AccessContext context;
        sql = sql + " -- appUsername=" + AppUser.loginUser() + "\r\n";
        this.statementInformation.context = context = new AccessContext();
        this.statementInformation.setStatementQuery(sql);
        context.setStatementInfo(this.statementInformation);
        try {
            this.statementInformation.setStatementQuery(sql);
            if (DbCache.isNeedIntercept(sql, this.statementInformation) && GatewayContext.isPluginEnabled()) {
                sql = this.encData(this.statementInformation);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException(exception);
        }
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            this.eventListener.onBeforeExecuteUpdate(this.statementInformation, sql);
            var8 = rowCount = this.delegate.executeUpdate(sql, columnIndexes);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw sqle;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate(this.statementInformation, System.nanoTime() - start, sql, rowCount, e);
        }
        return var8;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        int var8;
        AccessContext context;
        sql = sql + " -- appUsername=" + AppUser.loginUser() + "\r\n";
        this.statementInformation.context = context = new AccessContext();
        this.statementInformation.setStatementQuery(sql);
        context.setStatementInfo(this.statementInformation);
        try {
            this.statementInformation.setStatementQuery(sql);
            if (DbCache.isNeedIntercept(sql, this.statementInformation) && GatewayContext.isPluginEnabled()) {
                sql = this.encData(this.statementInformation);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException(exception);
        }
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            this.eventListener.onBeforeExecuteUpdate(this.statementInformation, sql);
            var8 = rowCount = this.delegate.executeUpdate(sql, columnNames);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw sqle;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate(this.statementInformation, System.nanoTime() - start, sql, rowCount, e);
        }
        return var8;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        AccessContext context;
        sql = sql + " -- appUsername=" + AppUser.loginUser() + "\r\n";
        this.statementInformation.context = context = new AccessContext();
        this.statementInformation.setStatementQuery(sql);
        context.setStatementInfo(this.statementInformation);
        try {
            this.statementInformation.setStatementQuery(sql);
            if (DbCache.isNeedIntercept(sql, this.statementInformation) && GatewayContext.isPluginEnabled()) {
                sql = this.encData(this.statementInformation);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException(exception);
        }
        if (this.statementInformation.getStatementQuery() == null) {
            this.statementInformation.setStatementQuery(sql);
        } else {
            this.statementInformation.setStatementQuery(sql + LINE_SEPARATOR + this.statementInformation.getStatementQuery());
        }
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeAddBatch(this.statementInformation, sql);
            this.delegate.addBatch(sql);
        }
        catch (SQLException sqle) {
            e = sqle;
            throw sqle;
        }
        finally {
            this.eventListener.onAfterAddBatch(this.statementInformation, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public void close() throws SQLException {
        SQLException e = null;
        try {
            this.delegate.close();
        }
        catch (SQLException sqle) {
            e = sqle;
            throw sqle;
        }
        finally {
            this.eventListener.onAfterStatementClose(this.statementInformation, e);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.delegate.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.delegate.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.delegate.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.delegate.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.delegate.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.delegate.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.delegate.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.delegate.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.delegate.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.delegate.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.delegate.setCursorName(name);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.delegate.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.delegate.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.delegate.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.delegate.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.delegate.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.delegate.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.delegate.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.delegate.getResultSetType();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.delegate.clearBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.delegate.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.delegate.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.delegate.getGeneratedKeys();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.delegate.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.delegate.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.delegate.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.delegate.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return true;
    }

    public static void main(String[] args) {
        String str = "123(select)";
        System.out.println(str.substring(3, 4));
    }
}

