/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.masking.log.access;

import com.palacesun.masking.log.access.SqlBuffer;
import com.palacesun.masking.log.access.SqlValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;

public class CommonSqlBuffer
extends SqlBuffer {
    public CommonSqlBuffer(String sql) {
        super(sql);
    }

    @Override
    protected String getValue(SqlValue value, Object val) {
        if (val == null) {
            return null;
        }
        this.setPrimitiveType(value);
        if (value.primiteType == 0) {
            return "null";
        }
        if (value.primiteType >= 1 && value.primiteType <= 8) {
            return val.toString();
        }
        if (value.primiteType == 9) {
            return "'" + val.toString().replace("'", "''") + "'";
        }
        if (value.primiteType == 11) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return val.getClass().equals(java.util.Date.class) ? sdf.format((java.util.Date)val) : sdf.format((Date)val);
        }
        if (value.primiteType == 12) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
            return sdf.format((Time)val);
        }
        if (value.primiteType == 13) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format((Timestamp)val);
        }
        if (value.primiteType == 14) {
            InputStream stream = (InputStream)val;
            byte[] values = this.readValue(stream, value.length, value.longLength);
            if (value.targetType != null) {
                if (value.targetType.equals("byte[]")) {
                    return new String(values);
                }
                if (value.targetType.equals("byte[ascii]")) {
                    return new String(values);
                }
                return value.targetType.equals("byte[string]") ? new String(values, this.charset) : new String(values);
            }
            return new String(values);
        }
        if (value.primiteType == 15) {
            return this.emptyValue;
        }
        if (value.primiteType == 16) {
            return this.emptyValue;
        }
        if (value.primiteType == 17) {
            return val.toString();
        }
        if (value.primiteType == 18) {
            return "[blob]";
        }
        return value.primiteType >= 19 && value.primiteType <= 24 ? val.toString() : this.emptyValue;
    }

    private void setPrimitiveType(SqlValue val) {
        if (val.primiteType == -1 && val.value != null) {
            Object value = val.value;
            val.primiteType = value.getClass().equals(Boolean.class) ? 1 : (value.getClass().equals(Byte.class) ? 2 : (value.getClass().equals(Long.class) ? 3 : (value.getClass().equals(Integer.class) ? 4 : (value.getClass().equals(Float.class) ? 5 : (value.getClass().equals(Double.class) ? 6 : (value.getClass().equals(Short.class) ? 7 : (value.getClass().equals(BigDecimal.class) ? 8 : (value.getClass().equals(String.class) ? 9 : (value.getClass().equals(Byte[].class) ? 10 : (value.getClass().equals(Time.class) ? 12 : (value.getClass().equals(Timestamp.class) ? 13 : (value instanceof java.util.Date ? 11 : (value instanceof InputStream ? 14 : (value instanceof Reader ? 15 : (value instanceof Ref ? 16 : (value instanceof RowId ? 17 : (value instanceof NClob ? 22 : (value instanceof Blob ? 18 : (value instanceof Clob ? 19 : (value instanceof Array ? 20 : (value instanceof URL ? 21 : (value instanceof SQLXML ? 23 : 24))))))))))))))))))))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readValue(InputStream stream, Integer len, Long lLen) {
        byte[] b;
        ByteArrayOutputStream baos = null;
        try {
            byte[] var24;
            baos = new ByteArrayOutputStream();
            if (stream.markSupported()) {
                int l = stream.available();
                if (len != null) {
                    l = len;
                } else if (lLen != null) {
                    l = lLen.intValue();
                }
                stream.mark(l);
                int b2 = -1;
                while ((b2 = stream.read()) != -1) {
                    baos.write(b2);
                }
                baos.flush();
            }
            if (len != null) {
                stream.mark(len);
            }
            byte[] b2 = var24 = baos.toByteArray();
            return b2;
        }
        catch (IOException var22) {
            try {
                baos.flush();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
            b = baos.toByteArray();
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    stream.reset();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return b;
    }
}

