/*
 * Decompiled with CFR 0.152.
 */
package com.palacesun.masking.tools.sm4fpe;

import com.palacesun.masking.tools.sm4fpe.SM4FPEBase;
import com.palacesun.masking.tools.sm4fpe.SM4FPEEntity;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM4FPEAddress
extends SM4FPEBase {
    public static final int LEVEL = 2;
    static ArrayList<SM4FPEEntity> addressEntities;
    static String[] province2Chars;
    static String[] province3Chars;
    static ArrayList city2Chars;
    static String[] city3Chars;
    static String[] city4Chars;
    static char[] excludeChars;
    static char[] addressKeysChars;
    static String[] addressKeysStr;
    static ArrayList chineseList;
    static HashMap province2CharsMap;
    static HashMap province3CharsMap;
    static HashMap city2CharsMap;
    static HashMap city3CharsMap;
    static HashMap city4CharsMap;
    static HashMap chineseListMap;
    static HashMap addressKeysCharsMap;
    private static Pattern chineseAddressPattern;
    private static Pattern chineseAddressPatternFirstThree;

    @Override
    public String encryptEcb(String hexKey, String a) throws Exception {
        String out = this.encrypt(hexKey, a, addressEntities);
        return out;
    }

    @Override
    public String decryptEcb(String hexKey, String input) throws Exception {
        String out = this.decrypt(hexKey, input, addressEntities);
        return out;
    }

    public static boolean isChineseAddress(String address, int level) {
        boolean result = false;
        if ((address = address.replaceAll("[^\u4e00-\u9fa5]", "")).length() >= 6) {
            if (null == chineseAddressPatternFirstThree) {
                chineseAddressPatternFirstThree = Pattern.compile("[\\u4e00-\\u9fa5]{3}.*");
            }
            if (chineseAddressPatternFirstThree.matcher(address).matches()) {
                if (null == chineseAddressPattern) {
                    ArrayList list = SM4FPEAddress.toArrayList(province3Chars);
                    list.addAll(SM4FPEAddress.toArrayList(province2Chars));
                    list.addAll(SM4FPEAddress.toArrayList(city4Chars));
                    list.addAll(SM4FPEAddress.toArrayList(city3Chars));
                    list.addAll(city2Chars);
                    list.addAll(SM4FPEAddress.toArrayList(addressKeysChars));
                    list.addAll(SM4FPEAddress.toArrayList(excludeChars));
                    if (list.size() > 0) {
                        StringBuilder pattern = new StringBuilder();
                        for (Object str : list) {
                            String s = String.valueOf(str);
                            pattern.append(s);
                            pattern.append("|");
                        }
                        pattern.deleteCharAt(pattern.length() - 1);
                        chineseAddressPattern = Pattern.compile(pattern.toString());
                    }
                }
                Matcher matcher = chineseAddressPattern.matcher(address);
                int num = 0;
                while (matcher.find()) {
                    ++num;
                }
                if (num != 0 && num >= level) {
                    result = true;
                }
            }
        }
        return result;
    }

    public static boolean check(String input) {
        return SM4FPEAddress.isChineseAddress(input, 2);
    }

    public static ArrayList<SM4FPEEntity> getSm4FPEEntities() {
        return addressEntities;
    }

    static {
        int i;
        addressEntities = new ArrayList();
        Security.addProvider((Provider)new BouncyCastleProvider());
        province2Chars = new String[]{"\u5b89\u5fbd", "\u9999\u6e2f", "\u798f\u5efa", "\u8d35\u5dde", "\u53f0\u6e7e", "\u9655\u897f", "\u91cd\u5e86", "\u5e7f\u897f", "\u6cb3\u5317", "\u6fb3\u95e8", "\u5c71\u897f", "\u6c5f\u82cf", "\u5409\u6797", "\u6cb3\u5357", "\u56db\u5ddd", "\u5929\u6d25", "\u65b0\u7586", "\u5185\u8499", "\u5b81\u590f", "\u6d59\u6c5f", "\u7518\u8083", "\u6e56\u5357", "\u8fbd\u5b81", "\u6c5f\u897f", "\u6e56\u5317", "\u5e7f\u4e1c", "\u897f\u85cf", "\u6d77\u5357", "\u5c71\u4e1c", "\u9752\u6d77", "\u4e91\u5357"};
        province3Chars = new String[0];
        city2Chars = new ArrayList();
        city3Chars = new String[0];
        city4Chars = new String[0];
        excludeChars = new char[]{'\u7701', '\u5e02', '\u533a', '\u8def'};
        addressKeysChars = new char[]{'\u5ea7', '\u697c', '\u82d1', '\u5e97', '\u4e61', '\u53a6', '\u5c45', '\u91cc', '\u5c6f', '\u56ed', '\u9986', '\u574a', '\u573a', '\u5df7', '\u6240', '\u9053', '\u820d', '\u5ead', '\u658b', '\u6751', '\u53f7', '\u5ba4', '\u8857', '\u6761', '\u53bf', '\u5885', '\u5f04', '\u5bd3', '\u5c42', '\u5e84', '\u540c', '\u5802', '\u9662', '\u5b66'};
        StringBuilder resultBuilder = new StringBuilder();
        for (String province : province2Chars) {
            resultBuilder.append(province);
        }
        String excludeProvince = resultBuilder.toString();
        chineseList = SM4FPEAddress.excludeChars(SM4FPEAddress.toArrayList(chineseChars), excludeChars);
        chineseList = SM4FPEAddress.excludeChars(chineseList, addressKeysChars);
        chineseList = SM4FPEAddress.excludeChars(chineseList, excludeProvince.toCharArray());
        province2CharsMap = new HashMap();
        for (i = 0; i < province2Chars.length; ++i) {
            province2CharsMap.put(province2Chars[i], i);
        }
        province3CharsMap = new HashMap();
        for (i = 0; i < province3Chars.length; ++i) {
            province3CharsMap.put(province3Chars[i], i);
        }
        city2CharsMap = new HashMap();
        for (i = 0; i < city2Chars.size(); ++i) {
            city2CharsMap.put(city2Chars.get(i), i);
        }
        city3CharsMap = new HashMap();
        for (i = 0; i < city3Chars.length; ++i) {
            city3CharsMap.put(city3Chars[i], i);
        }
        city4CharsMap = new HashMap();
        for (i = 0; i < city4Chars.length; ++i) {
            city4CharsMap.put(city4Chars[i], i);
        }
        addressKeysCharsMap = new HashMap();
        for (i = 0; i < addressKeysChars.length; ++i) {
            addressKeysCharsMap.put(Character.valueOf(addressKeysChars[i]), i);
        }
        chineseListMap = new HashMap();
        for (i = 0; i < chineseList.size(); ++i) {
            chineseListMap.put(chineseList.get(i), i);
        }
        addressEntities.add(new SM4FPEEntity(0, SM4FPEAddress.toArrayList(province3Chars), province3CharsMap));
        addressEntities.add(new SM4FPEEntity(1, SM4FPEAddress.toArrayList(province2Chars), province2CharsMap));
        addressEntities.add(new SM4FPEEntity(2, SM4FPEAddress.toArrayList(city4Chars), city4CharsMap));
        addressEntities.add(new SM4FPEEntity(3, SM4FPEAddress.toArrayList(city3Chars), city3CharsMap));
        addressEntities.add(new SM4FPEEntity(4, city2Chars, city2CharsMap));
        addressEntities.add(new SM4FPEEntity(5, SM4FPEAddress.toArrayList(enCapitalChars), enCapitalCharsMap));
        addressEntities.add(new SM4FPEEntity(6, SM4FPEAddress.toArrayList(enSmallChars), enSmallCharsMap));
        addressEntities.add(new SM4FPEEntity(7, SM4FPEAddress.toArrayList(digitChars), digitCharsMap));
        addressEntities.add(new SM4FPEEntity(8, SM4FPEAddress.toArrayList(addressKeysChars), addressKeysCharsMap));
        addressEntities.add(new SM4FPEEntity(9, chineseList, chineseListMap));
        addressEntities.add(new SM4FPEEntity(10, otherChineseChars, otherChineseCharsMap));
        SM4FPEAddress.checkDuplicate(addressEntities);
    }
}

